/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.ontologyhandling;

import fr.pasteur.sysbio.rdfscape.Contextualizable;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.RDFScapeModuleInterface;
import fr.pasteur.sysbio.rdfscape.ontologyhandling.OntologyManagerLoaderPanel;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class OntologyLoaderManager
extends AbstractTableModel
implements RDFScapeModuleInterface,
Contextualizable {
    private ArrayList myOntologies = null;
    private OntologyManagerLoaderPanel myPanel = null;

    public OntologyLoaderManager() throws Exception {
        System.out.print("\tOntologyLoaderManager... ");
        if (RDFScape.getContextManager() == null) {
            throw new Exception("Cannot build OntologyLoaderManager : missing Context Manager");
        }
        RDFScape.getContextManager().addContextualizableElement(this);
        this.initialize();
        System.out.println("Ok");
    }

    public boolean initialize() {
        this.myOntologies = new ArrayList();
        this.fireTableDataChanged();
        return true;
    }

    public void reset() {
        this.initialize();
    }

    public void addURL(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("")) {
            return;
        }
        this.myOntologies.add(new OntologyItem(string));
        this.update();
    }

    public void update() {
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.myOntologies.size();
    }

    public Object getValueAt(int n, int n2) {
        if (this.myOntologies.get(n) != null) {
            if (n2 == 0) {
                return ((OntologyItem)this.myOntologies.get((int)n)).url;
            }
            if (n2 == 1) {
                OntologyItem ontologyItem = (OntologyItem)this.myOntologies.get(n);
                if (ontologyItem.message == null) {
                    return "ERROR";
                }
                if (ontologyItem.message.equals("")) {
                    return "";
                }
                return ontologyItem.message;
            }
            return "?";
        }
        return "?";
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "URL";
        }
        if (n == 1) {
            return "Status";
        }
        return "";
    }

    public Component getOntologyManagerPanel() {
        if (this.myPanel == null) {
            this.myPanel = new OntologyManagerLoaderPanel(this);
        }
        return this.myPanel;
    }

    public void deleteOntology(int n) {
        if (((OntologyItem)this.myOntologies.get(n)).canDelete()) {
            this.myOntologies.remove(n);
        }
        this.fireTableDataChanged();
    }

    public void loadOntologiesFromScratch() {
        for (OntologyItem ontologyItem : this.myOntologies) {
            System.out.println("Loading " + ontologyItem.url);
            ontologyItem.message = RDFScape.getKnowledge().addOntology(ontologyItem.url);
            int n = 0;
            try {
                n = Integer.parseInt(ontologyItem.message);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (n == 0) {
                ontologyItem.message = null;
                continue;
            }
            ontologyItem.message = "Read " + ontologyItem.message + " statements";
        }
        RDFScape.getKnowledge().touch();
        this.fireTableDataChanged();
    }

    public boolean isInValidState() {
        if (this.myOntologies.size() == 0) {
            return false;
        }
        for (OntologyItem ontologyItem : this.myOntologies) {
            if (ontologyItem.message != null) continue;
            return false;
        }
        return true;
    }

    public boolean loadFromActiveContext() {
        System.out.println("Loading ontologies");
        this.reset();
        RDFScape.getContextManager().getActiveContext().getOntologiesListFileName();
        int n = 0;
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(RDFScape.getContextManager().getActiveContext().getOntologiesListFileName()));
            while ((string = bufferedReader.readLine()) != null) {
                ++n;
                this.addURL(string.trim());
            }
        }
        catch (IOException iOException) {
            System.out.println("Unable to load ontology list file");
        }
        this.fireTableDataChanged();
        return false;
    }

    public boolean saveToContext() {
        System.out.println("Saving ontology list");
        boolean bl = false;
        try {
            FileWriter fileWriter = new FileWriter(RDFScape.getContextManager().getActiveContext().getOntologiesListFileName());
            for (OntologyItem ontologyItem : this.myOntologies) {
                fileWriter.write(ontologyItem.url + "\n");
            }
            fileWriter.close();
            return true;
        }
        catch (IOException iOException) {
            System.out.println("Unable to write ontology list to file");
            return false;
        }
    }

    public boolean canOperate() {
        return true;
    }

    public void touch() {
        this.fireTableDataChanged();
    }

    public boolean writeToContext() {
        return false;
    }

    private class OntologyItem {
        public String url = "";
        public String message = "";
        public String errorMessage = "";

        public OntologyItem(String string) {
            this.url = string;
        }

        public boolean canDelete() {
            if (this.message == null) {
                return true;
            }
            return this.message.equals("");
        }
    }
}

