/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.ontologyhandling;

import fr.pasteur.sysbio.rdfscape.ontologyhandling.OntologyLoaderManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class OntologyManagerLoaderPanel
extends JPanel {
    OntologyLoaderManager ontologyManager = null;
    JButton loadButton = null;
    JButton addOntologyButton = null;
    JButton deleteOntologyButton = null;
    JTable ontologyTable = null;

    public OntologyManagerLoaderPanel(OntologyLoaderManager ontologyLoaderManager) {
        this.ontologyManager = ontologyLoaderManager;
        this.addOntologyButton = new JButton("add");
        this.deleteOntologyButton = new JButton("delete");
        this.loadButton = new JButton("load ontologies");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.addOntologyButton, "West");
        jPanel.add((Component)this.deleteOntologyButton, "East");
        jPanel.add((Component)this.loadButton, "Center");
        this.addOntologyButton.addActionListener(new AddOntologyButtonListener());
        this.deleteOntologyButton.addActionListener(new DeleteOntologyButtonListener());
        this.loadButton.addActionListener(new LoadButtonListener());
        this.ontologyTable = new JTable(this.ontologyManager);
        JScrollPane jScrollPane = new JScrollPane(this.ontologyTable);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "South");
        TableColumn tableColumn = this.ontologyTable.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new StatusCellRenderer());
    }

    private class StatusCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public StatusCellRenderer() {
            this.setOpaque(true);
            this.setBackground(Color.WHITE);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = (String)object;
            this.setText(string);
            if (string.startsWith("Loading")) {
                this.setBackground(Color.YELLOW);
            } else if (string.startsWith("Read ")) {
                this.setBackground(Color.GREEN);
            } else if (string.startsWith("ERROR")) {
                this.setBackground(Color.RED);
            } else {
                this.setBackground(Color.WHITE);
            }
            return this;
        }
    }

    private class LoadButtonListener
    implements ActionListener {
        private LoadButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OntologyManagerLoaderPanel.this.ontologyManager.loadOntologiesFromScratch();
        }
    }

    private class DeleteOntologyButtonListener
    implements ActionListener {
        private int[] toDelete = null;

        private DeleteOntologyButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.toDelete = OntologyManagerLoaderPanel.this.ontologyTable.getSelectedRows();
            for (int i = 0; i < this.toDelete.length; ++i) {
                OntologyManagerLoaderPanel.this.ontologyManager.deleteOntology(this.toDelete[i]);
            }
        }
    }

    private class AddOntologyButtonListener
    implements ActionListener {
        private AddOntologyButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane jOptionPane = new JOptionPane();
            String string = JOptionPane.showInputDialog("Enter URL for ontology (http:// or file:// must be prefixed", (Object)"");
            OntologyManagerLoaderPanel.this.ontologyManager.addURL(string);
        }
    }
}

