/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.patterns;

import fr.pasteur.sysbio.rdfscape.Contextualizable;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.cytoscape.CytoscapeDealer;
import fr.pasteur.sysbio.rdfscape.knowledge.KnowledgeWrapper;
import fr.pasteur.sysbio.rdfscape.patterns.PatternElement;
import fr.pasteur.sysbio.rdfscape.patterns.PatternManagerPanel;
import fr.pasteur.sysbio.rdfscape.query.AbstractQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.RDQLQueryAnswerer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageInputStream;

public class PatternManager
implements Contextualizable {
    Hashtable myPatterns = null;
    PatternManagerPanel myPanel = null;

    public PatternManager() throws Exception {
        System.out.print("\tPatternManager... ");
        if (RDFScape.getContextManager() == null) {
            throw new Exception("Cannot build Pattern Manager : missing ContextManager");
        }
        System.out.println("Building Pattern Manager");
        this.myPatterns = new Hashtable();
        this.myPanel = new PatternManagerPanel(this);
        RDFScape.getContextManager().addContextualizableElement(this);
        System.out.println("Ok");
    }

    public boolean initialize() {
        return true;
    }

    public void reset() {
        Enumeration enumeration = this.myPatterns.keys();
        while (enumeration.hasMoreElements()) {
            this.myPanel.removePatternElementPanel((PatternElement)this.myPatterns.get(enumeration.nextElement()));
        }
        this.myPatterns = new Hashtable();
    }

    public boolean canOperate() {
        return true;
    }

    public PatternElement makePatternOutOfCurrentGraph(String string) {
        CytoscapeDealer cytoscapeDealer = RDFScape.getCytoscapeDealer();
        PatternElement patternElement = new PatternElement(string, this);
        this.myPatterns.put(string, patternElement);
        Image image = RDFScape.getCytoscapeDealer().getScreenshot(300, 300);
        patternElement.setMyImage(image);
        String[][] stringArray = cytoscapeDealer.getTripleWithVariablesArrayList();
        String[][] stringArray2 = cytoscapeDealer.getFilterConditionsArray();
        patternElement.addTriples(stringArray);
        patternElement.addFilterConditions(stringArray2);
        return patternElement;
    }

    public PatternManagerPanel getPatternManagerPanel() {
        if (this.myPanel == null) {
            this.myPanel = new PatternManagerPanel(this);
        }
        return this.myPanel;
    }

    public PatternElement getPatternElement(String string) {
        return (PatternElement)this.myPatterns.get(string);
    }

    public void getSnapshot(String string) {
        PatternElement patternElement = this.makePatternOutOfCurrentGraph(string);
        if (this.myPanel != null) {
            this.myPanel.addPatternElementPanel(patternElement);
        }
    }

    public void addStatementToGraph(String[] stringArray, String string) {
    }

    public void searchStatementInGraph(String[] stringArray) {
    }

    public void makeRuleOutOf(String string, AbstractQueryResultTable abstractQueryResultTable, String string2) {
        System.out.println("Adding rule...");
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (int i = 0; i < abstractQueryResultTable.getColumnCount(); ++i) {
            hashtable.put("?" + abstractQueryResultTable.getColumnName(i), new Integer(i));
            System.out.println("index :" + abstractQueryResultTable.getColumnName(i) + "->" + i);
            System.out.println(i);
        }
        int[] nArray = abstractQueryResultTable.getBiteIndexes(string2);
        System.out.println("Patterns # :" + nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            for (String string3 : hashtable.keySet()) {
                System.out.println("Subst. var " + string3);
                string = string.replaceAll("\\" + string3, (String)abstractQueryResultTable.getValueAt(nArray[i], (Integer)hashtable.get(string3)));
                System.out.println(string);
            }
        }
        System.out.println("Rule " + string);
    }

    public void makePatternOutOf(String string, AbstractQueryResultTable abstractQueryResultTable, String string2) {
        System.out.println("Adding pattern...");
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (int i = 0; i < abstractQueryResultTable.getColumnCount(); ++i) {
            hashtable.put("?" + abstractQueryResultTable.getColumnName(i), new Integer(i));
            System.out.println("index :" + abstractQueryResultTable.getColumnName(i) + "->" + i);
            System.out.println(i);
        }
        int[] nArray = abstractQueryResultTable.getBiteIndexes(string2);
        System.out.println("Patterns # :" + nArray.length);
        block1: for (int i = 0; i < nArray.length; ++i) {
            String string3 = string;
            while (string3.indexOf("(") >= 0) {
                String string4 = string3.substring(string3.indexOf("(") + 1, string3.indexOf(")"));
                string3 = string3.substring(string3.indexOf(")") + 1);
                System.out.println("current pattern: " + string4);
                System.out.println("rest: " + string3);
                String[] stringArray = string4.split("[ ]+");
                if (stringArray.length != 3) {
                    System.out.println("Not a valid pattern...");
                    continue block1;
                }
                System.out.println("+" + stringArray[0] + "+" + stringArray[1] + "+" + stringArray[2] + "+");
                String string5 = stringArray[0].trim();
                String string6 = stringArray[1].trim();
                String string7 = stringArray[2].trim();
                if (string5.indexOf("?") >= 0) {
                    if (hashtable.get(string5) != null) {
                        string5 = (String)abstractQueryResultTable.getValueAt(nArray[i], (Integer)hashtable.get(string5));
                    }
                } else if (string5.indexOf(":") >= 0) {
                    // empty if block
                }
                if (string6.indexOf("?") >= 0) {
                    if (hashtable.get(string6) != null) {
                        string6 = (String)abstractQueryResultTable.getValueAt(nArray[i], (Integer)hashtable.get(string6));
                    }
                } else if (string6.indexOf(":") >= 0) {
                    // empty if block
                }
                if (string7.indexOf("?") >= 0) {
                    if (hashtable.get(string7) != null) {
                        string7 = (String)abstractQueryResultTable.getValueAt(nArray[i], (Integer)hashtable.get(string7));
                    }
                } else if (string7.indexOf(":") >= 0) {
                    // empty if block
                }
                System.out.println("Source : " + string5);
                System.out.println("Predicate : " + string6);
                System.out.println("Object : " + string7);
            }
        }
    }

    public boolean canAddAndSearchPatterns() {
        return KnowledgeWrapper.hasRDQLSupport(RDFScape.getKnowledge());
    }

    public String makeRDQLQueryFromPattern(PatternElement patternElement) {
        int n;
        String[] stringArray = patternElement.getVariables();
        String[][] stringArray2 = patternElement.getTriples();
        Hashtable hashtable = patternElement.getFilterConditions();
        Hashtable hashtable2 = patternElement.getPreciseFilterConditions();
        String string = new String("SELECT ");
        for (n = 0; n < stringArray.length; ++n) {
            string = string + " " + stringArray[n];
        }
        string = string + "\n WHERE ";
        for (n = 0; n < stringArray2.length; ++n) {
            string = string + "(";
            for (int i = 0; i < stringArray2[n].length; ++i) {
                string = stringArray2[n][i].indexOf("?") == 0 ? string + " " + stringArray2[n][i] + " " : string + " <" + stringArray2[n][i] + "> ";
            }
            string = string + ")\n";
        }
        if (hashtable.size() > 0 || hashtable2.size() > 0) {
            for (n = 0; n < stringArray.length; ++n) {
                if (hashtable.get(stringArray[n]) != null) {
                    string = string + "AND " + stringArray[n] + " =~ /" + hashtable.get(stringArray[n]) + "/\n";
                }
                if (hashtable2.get(stringArray[n]) == null) continue;
                string = string + "AND " + stringArray[n] + " eq \"" + hashtable2.get(stringArray[n]) + "\"\n";
            }
        }
        System.out.println(string);
        return string;
    }

    public AbstractQueryResultTable searchVariable(PatternElement patternElement) {
        AbstractQueryResultTable abstractQueryResultTable = ((RDQLQueryAnswerer)((Object)RDFScape.getKnowledge())).makeRDQLQuery(this.makeRDQLQueryFromPattern(patternElement));
        RDFScape.getCytoscapeDealer().searchURIs(abstractQueryResultTable);
        return abstractQueryResultTable;
    }

    public AbstractQueryResultTable addVariable(PatternElement patternElement) {
        AbstractQueryResultTable abstractQueryResultTable = ((RDQLQueryAnswerer)((Object)RDFScape.getKnowledge())).makeRDQLQuery(this.makeRDQLQueryFromPattern(patternElement));
        RDFScape.getCytoscapeDealer().addURIs(abstractQueryResultTable);
        return abstractQueryResultTable;
    }

    public AbstractQueryResultTable searchPattern(PatternElement patternElement) {
        AbstractQueryResultTable abstractQueryResultTable = ((RDQLQueryAnswerer)((Object)RDFScape.getKnowledge())).makeRDQLQuery(this.makeRDQLQueryFromPattern(patternElement));
        abstractQueryResultTable = this.expandVariables2Pattern(abstractQueryResultTable, patternElement);
        RDFScape.getCytoscapeDealer().searchPattern(abstractQueryResultTable);
        return abstractQueryResultTable;
    }

    public AbstractQueryResultTable addPattern(PatternElement patternElement) {
        AbstractQueryResultTable abstractQueryResultTable = ((RDQLQueryAnswerer)((Object)RDFScape.getKnowledge())).makeRDQLQuery(this.makeRDQLQueryFromPattern(patternElement));
        abstractQueryResultTable = this.expandVariables2Pattern(abstractQueryResultTable, patternElement);
        RDFScape.getCytoscapeDealer().addPattern(abstractQueryResultTable);
        return abstractQueryResultTable;
    }

    public void remove(PatternElement patternElement) {
        this.myPatterns.remove(patternElement.getName());
        this.myPanel.removePatternElementPanel(patternElement);
    }

    public boolean loadFromActiveContext() {
        if (this.myPanel != null) {
            this.myPanel.removeAll();
        }
        System.out.println("Loading patterns");
        String string = RDFScape.getContextManager().getActiveContext().getPatternsDirName();
        System.out.println("From : " + string);
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String[] stringArray;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (!fileArray[i].isDirectory()) continue;
            String string2 = fileArray[i].getName();
            System.out.println("Found " + string2);
            File file2 = new File(fileArray[i].getAbsoluteFile() + "/image.jpg");
            File file3 = new File(fileArray[i].getAbsoluteFile() + "/triples");
            File file4 = new File(fileArray[i].getAbsoluteFile() + "/settings");
            File file5 = new File(fileArray[i].getAbsoluteFile() + "/functions");
            File file6 = new File(fileArray[i].getAbsoluteFile() + "/filters");
            PatternElement patternElement = new PatternElement(string2, this);
            try {
                patternElement.setMyImage(ImageIO.read(new FileImageInputStream(file2)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Unable to find pattern image file");
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                System.out.println("Unable to read pattern image file");
                iOException.printStackTrace();
            }
            String[][] stringArray2 = new String[0][3];
            try {
                object4 = new BufferedReader(new FileReader(file3));
                object3 = ((BufferedReader)object4).readLine();
                object2 = new ArrayList<String[]>();
                while (object3 != null) {
                    object = new String[3];
                    stringArray = new StringTokenizer((String)object3);
                    object[0] = stringArray.nextToken();
                    object[1] = stringArray.nextToken();
                    object[2] = stringArray.nextToken();
                    ((ArrayList)object2).add(object);
                    object3 = ((BufferedReader)object4).readLine();
                }
                patternElement.addTriples((String[][])((ArrayList)object2).toArray((T[])stringArray2));
            }
            catch (Exception exception) {
                System.out.println("Unable to read patterns");
                return false;
            }
            object4 = new ArrayList();
            object3 = new String[0][3];
            try {
                object2 = new BufferedReader(new FileReader(file6));
                object = ((BufferedReader)object2).readLine();
                while (object != null) {
                    stringArray = new String[3];
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object);
                    if (stringTokenizer.hasMoreTokens()) {
                        stringArray[0] = stringTokenizer.nextToken();
                        if (stringTokenizer.hasMoreTokens()) {
                            stringArray[1] = stringTokenizer.nextToken().replace('~', ' ');
                            if (stringTokenizer.hasMoreTokens()) {
                                stringArray[2] = stringTokenizer.nextToken();
                                ((ArrayList)object4).add(stringArray);
                                object = ((BufferedReader)object2).readLine();
                                continue;
                            }
                        }
                    }
                    break;
                }
            }
            catch (Exception exception) {
                System.out.println("Unable to read patterns");
                return false;
            }
            patternElement.addFilterConditions((String[][])((ArrayList)object4).toArray((T[])object3));
            this.myPatterns.put(string2, patternElement);
            if (this.myPanel == null) continue;
            this.myPanel.addPatternElementPanel(patternElement);
        }
        return true;
    }

    public boolean saveToContext() {
        File file;
        File file2;
        File file3;
        Object object;
        Serializable serializable;
        String string;
        String string2 = RDFScape.getContextManager().getActiveContext().getPatternsDirName();
        System.out.println("save to context " + string2);
        System.out.println("Cleaning...");
        File file4 = new File(string2);
        File[] fileArray = file4.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            string = fileArray[i].getName();
            System.out.println("Already found " + string);
            if (!this.myPatterns.keySet().contains(string) || this.myPatterns.get(string) == null) {
                System.out.println("Removing " + string);
                serializable = new File(fileArray[i].getAbsoluteFile() + "/image.jpg");
                object = new File(fileArray[i].getAbsoluteFile() + "/triples");
                file3 = new File(fileArray[i].getAbsoluteFile() + "/settings");
                file2 = new File(fileArray[i].getAbsoluteFile() + "/functions");
                file = new File(fileArray[i].getAbsoluteFile() + "/filters");
                if (((File)serializable).exists()) {
                    ((File)serializable).delete();
                }
                if (((File)object).exists()) {
                    ((File)object).delete();
                }
                if (file3.exists()) {
                    file3.delete();
                }
                if (file2.exists()) {
                    file2.delete();
                }
                if (file.exists()) {
                    file.delete();
                }
            }
            fileArray[i].delete();
        }
        Iterator iterator = this.myPatterns.keySet().iterator();
        while (iterator.hasNext()) {
            Object object2;
            Object object3;
            System.out.print("Saving pattern ");
            string = (String)iterator.next();
            System.out.println(string);
            serializable = (PatternElement)this.myPatterns.get(string);
            object = string2 + "/" + ((PatternElement)serializable).getName();
            System.out.println("to : " + (String)object);
            file3 = new File((String)object);
            file2 = new File((String)object + "/image.jpg");
            file = new File((String)object + "/triples");
            File file5 = new File((String)object + "/settings");
            File file6 = new File((String)object + "/functions");
            File file7 = new File((String)object + "/filters");
            try {
                file3.mkdir();
                file2.createNewFile();
                file.createNewFile();
                file5.createNewFile();
                file6.createNewFile();
                file7.createNewFile();
            }
            catch (Exception exception) {
                System.out.println("Unable to create a pattern file out of :");
                System.out.println((String)object + "/image.jpg");
                System.out.println((String)object + "/triples");
                System.out.println((String)object + "/settings");
                System.out.println((String)object + "/functions");
                System.out.println((String)object + "/filters");
                return false;
            }
            try {
                object3 = new FileWriter(file);
                object2 = ((PatternElement)serializable).getTriples();
                for (int i = 0; i < ((String[][])object2).length; ++i) {
                    for (int j = 0; j < object2[0].length; ++j) {
                        ((Writer)object3).write(object2[i][j] + "\t");
                    }
                    ((Writer)object3).write("\n");
                }
                ((OutputStreamWriter)object3).close();
            }
            catch (Exception exception) {
                System.out.println("Unable to write triples");
                exception.printStackTrace();
                return false;
            }
            object3 = ((PatternElement)serializable).getImage();
            object2 = new BufferedImage(((Image)object3).getWidth(null), ((Image)object3).getHeight(null), 1);
            Graphics2D graphics2D = ((BufferedImage)object2).createGraphics();
            graphics2D.setColor(Color.LIGHT_GRAY);
            graphics2D.fillRect(0, 0, ((Image)object3).getWidth(null), ((Image)object3).getHeight(null));
            graphics2D.drawImage((Image)object3, 0, 0, null);
            graphics2D.dispose();
            try {
                ImageIO.write((RenderedImage)object2, "jpg", file2);
            }
            catch (IOException iOException) {
                System.out.println("Unable to write image");
                iOException.printStackTrace();
                return false;
            }
            try {
                FileWriter fileWriter = new FileWriter(file6);
                fileWriter.close();
            }
            catch (IOException iOException) {
                System.out.println("Unable to write function");
                iOException.printStackTrace();
                return false;
            }
            try {
                FileWriter fileWriter = new FileWriter(file5);
                fileWriter.close();
            }
            catch (IOException iOException) {
                System.out.println("Unable to write settings");
                iOException.printStackTrace();
                return false;
            }
            try {
                String string3;
                String string4;
                FileWriter fileWriter = new FileWriter(file7);
                Hashtable hashtable = ((PatternElement)serializable).getFilterConditions();
                Hashtable hashtable2 = ((PatternElement)serializable).getPreciseFilterConditions();
                System.out.println("Filters " + hashtable.size());
                System.out.println("Precise " + hashtable2.size());
                Iterator iterator2 = hashtable.keySet().iterator();
                while (iterator2.hasNext()) {
                    System.out.println("A");
                    string4 = (String)iterator2.next();
                    string3 = (String)hashtable.get(string4);
                    fileWriter.write(string4 + "\t" + string3.replace(' ', '~') + "\tF\n");
                }
                iterator2 = hashtable2.keySet().iterator();
                while (iterator2.hasNext()) {
                    System.out.println("B1");
                    string4 = (String)iterator2.next();
                    System.out.println("B2");
                    string3 = (String)hashtable2.get(string4);
                    System.out.println("B3");
                    fileWriter.write(string4 + "\t" + string3.replace(' ', '~') + "\tP\n");
                    System.out.println("B4");
                }
                fileWriter.close();
            }
            catch (Exception exception) {
                System.out.println("Unable to write filters");
                exception.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private AbstractQueryResultTable expandVariables2Pattern(AbstractQueryResultTable abstractQueryResultTable, PatternElement patternElement) {
        return abstractQueryResultTable.getExpandedInPattern(patternElement);
    }
}

