/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.query;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.knowledge.KnowledgeWrapper;
import fr.pasteur.sysbio.rdfscape.patterns.PatternElement;
import fr.pasteur.sysbio.rdfscape.query.AbstractQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.GraphQueryAnswerer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Hashtable;

public class JenaQueryResultTable
extends AbstractQueryResultTable {
    private static final long serialVersionUID = 1L;
    boolean hasGraph = false;
    private ArrayList resultValues = null;
    private Hashtable resultVar = null;
    private Hashtable biteToRows = null;

    public Color getColor(int n, int n2) {
        if (this.getValueAt(n, n2) == null) {
            return Color.LIGHT_GRAY;
        }
        String string = this.getNamespace(n, n2);
        if (string == null) {
            return Color.LIGHT_GRAY;
        }
        Color color = this.commonMemory.getNamespaceColor(string);
        if (color == null) {
            System.out.println(n + "," + n2 + " -> null Color");
            return Color.LIGHT_GRAY;
        }
        return color;
    }

    public String getLabel(int n, int n2) {
        if (this.getValueAt(n, n2) == null) {
            return "?";
        }
        RDFNode rDFNode = (RDFNode)this.getValueAt(n, n2);
        if (rDFNode == null) {
            return "";
        }
        if (rDFNode.isAnon()) {
            return "BLANK: " + rDFNode.toString();
        }
        if (rDFNode.isLiteral()) {
            return ((Literal)rDFNode).getValue().toString();
        }
        if (rDFNode.isResource()) {
            String string;
            if (this.commonMemory.showRDFSLabels && KnowledgeWrapper.hasGraphAccessSupport(RDFScape.getKnowledge()) && (string = ((GraphQueryAnswerer)((Object)RDFScape.getKnowledge())).getRDFLabelForURI(this.getURI(n, n2))) != null) {
                return string;
            }
            string = this.commonMemory.getNamespacePrefix(((Resource)rDFNode).getNameSpace());
            String string2 = ((Resource)rDFNode).getLocalName();
            if (string == null) {
                return string2;
            }
            if (string.equals("")) {
                return string2;
            }
            return string + ":" + string2;
        }
        return "";
    }

    public boolean isURI(int n, int n2) {
        if (this.getValueAt(n, n2) == null) {
            return false;
        }
        RDFNode rDFNode = (RDFNode)this.getValueAt(n, n2);
        if (rDFNode != null) {
            return rDFNode.isURIResource();
        }
        return false;
    }

    public boolean isLiteral(int n, int n2) {
        if (this.getValueAt(n, n2) == null) {
            return false;
        }
        RDFNode rDFNode = (RDFNode)this.getValueAt(n, n2);
        if (rDFNode != null) {
            return rDFNode.isLiteral();
        }
        return false;
    }

    public boolean isBlank(int n, int n2) {
        if (this.getValueAt(n, n2) == null) {
            return false;
        }
        RDFNode rDFNode = (RDFNode)this.getValueAt(n, n2);
        if (rDFNode != null) {
            return rDFNode.isAnon();
        }
        return false;
    }

    public String getNamespace(int n, int n2) {
        if (this.getValueAt(n, n2) == null) {
            return "";
        }
        RDFNode rDFNode = (RDFNode)this.getValueAt(n, n2);
        if (rDFNode.isURIResource()) {
            return ((Resource)rDFNode).getNameSpace();
        }
        if (rDFNode.isLiteral()) {
            return ResourceFactory.createResource((String)((Literal)rDFNode).getDatatypeURI()).getNameSpace();
        }
        return null;
    }

    public String getID(int n, int n2) {
        if (this.getValueAt(n, n2) == null) {
            return "";
        }
        RDFNode rDFNode = (RDFNode)this.getValueAt(n, n2);
        if (rDFNode == null) {
            return null;
        }
        return rDFNode.toString();
    }

    public String getURI(int n, int n2) {
        if (this.getValueAt(n, n2) == null) {
            return "";
        }
        RDFNode rDFNode = (RDFNode)this.getValueAt(n, n2);
        if (rDFNode == null) {
            return null;
        }
        if (!rDFNode.isURIResource()) {
            return null;
        }
        return ((Resource)rDFNode).getURI();
    }

    public String getDatatypeValue(int n, int n2) {
        if (this.getValueAt(n, n2) == null) {
            return "";
        }
        RDFNode rDFNode = (RDFNode)this.getValueAt(n, n2);
        if (rDFNode == null) {
            return null;
        }
        if (!rDFNode.isLiteral()) {
            return null;
        }
        return ((Literal)rDFNode).getValue().toString();
    }

    public String getDatatypeType(int n, int n2) {
        if (this.getValueAt(n, n2) == null) {
            return "";
        }
        RDFNode rDFNode = (RDFNode)this.getValueAt(n, n2);
        if (rDFNode == null) {
            return null;
        }
        if (!rDFNode.isLiteral()) {
            return null;
        }
        RDFDatatype rDFDatatype = ((Literal)rDFNode).getDatatype();
        if (rDFDatatype != null) {
            return rDFDatatype.getURI();
        }
        return "";
    }

    public String getDatatypeLanguage(int n, int n2) {
        if (this.getValueAt(n, n2) == null) {
            return "";
        }
        RDFNode rDFNode = (RDFNode)this.getValueAt(n, n2);
        if (rDFNode == null) {
            return null;
        }
        if (!rDFNode.isLiteral()) {
            return null;
        }
        return ((Literal)rDFNode).getLanguage();
    }

    public String getLocalName(int n, int n2) {
        if (this.getValueAt(n, n2) == null) {
            return "";
        }
        RDFNode rDFNode = (RDFNode)this.getValueAt(n, n2);
        if (rDFNode == null) {
            return null;
        }
        if (!rDFNode.isURIResource()) {
            return null;
        }
        return ((Resource)rDFNode).getLocalName();
    }

    public boolean isNamespaceSelected(int n, int n2) {
        if (this.getValueAt(n, n2) == null) {
            return false;
        }
        String string = this.getNamespace(n, n2);
        if (string != null) {
            return this.commonMemory.getIsActiveFromNs(string);
        }
        return false;
    }

    public boolean hasGraph() {
        return this.hasGraph;
    }

    public boolean hasTable() {
        return !this.hasGraph;
    }

    public AbstractQueryResultTable getSubsetByRows(int[] nArray) {
        JenaQueryResultTable jenaQueryResultTable = new JenaQueryResultTable();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                System.out.println("(" + nArray[i] + "," + j + ")");
                jenaQueryResultTable.addObject(this.getValueAt(nArray[i], j), i, j);
            }
        }
        System.out.println("Dimensions " + jenaQueryResultTable.getRowCount() + " x " + jenaQueryResultTable.getColumnCount());
        return jenaQueryResultTable;
    }

    public AbstractQueryResultTable getExpandedInPattern(PatternElement patternElement) {
        int n;
        int n2;
        int n3;
        JenaQueryResultTable jenaQueryResultTable = new JenaQueryResultTable();
        String[][] stringArray = patternElement.getTriples();
        int[][] nArray = new int[stringArray.length][stringArray[0].length];
        Resource[][] resourceArray = new Resource[stringArray.length][stringArray[0].length];
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            for (n2 = 0; n2 < stringArray[n3].length; ++n2) {
                System.out.println("Eval:" + stringArray[n3][n2]);
                if (stringArray[n3][n2].indexOf("?") == 0) {
                    nArray[n3][n2] = this.getVarColumn(stringArray[n3][n2].substring(1, stringArray[n3][n2].length()));
                    continue;
                }
                resourceArray[n3][n2] = ResourceFactory.createResource((String)stringArray[n3][n2]);
                nArray[n3][n2] = -1;
            }
        }
        System.out.println("Making the pattern");
        n3 = 0;
        for (n2 = 0; n2 < this.getRowCount(); ++n2) {
            for (n = 0; n < stringArray.length; ++n) {
                for (int i = 0; i < stringArray[n].length; ++i) {
                    if (nArray[n][i] >= 0) {
                        jenaQueryResultTable.addObject(this.getValueAt(n2, nArray[n][i]), n3, i);
                        continue;
                    }
                    jenaQueryResultTable.addObject(resourceArray[n][i], n3, i);
                }
                ++n3;
            }
        }
        jenaQueryResultTable.addVar("Source", 0);
        jenaQueryResultTable.addVar("Property", 1);
        jenaQueryResultTable.addVar("Object", 2);
        System.out.println("Dump");
        for (n2 = 0; n2 < jenaQueryResultTable.getRowCount(); ++n2) {
            for (n = 0; n < jenaQueryResultTable.getColumnCount(); ++n) {
                System.out.print(jenaQueryResultTable.getLabel(n2, n) + "   ");
            }
            System.out.println();
        }
        return jenaQueryResultTable;
    }
}

