/**
 * Copyright 2006 Andrea Splendiani
 * Released under GPL license
 */

/*
 * Created on Jul 5, 2005
 * Rev 0 dirty code
 * Rev 1 code cleaning, Docs
 */
package fr.pasteur.sysbio.rdfscape;

import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;

/**
 * @author andrea@pasteur.fr
 * This class is the container of all other panels.
 * It also provides some panels for functionalities present in the RDFScape class.
 */
public class RDFScapePanel extends JFrame {
	RDFScape myRDFScapeInstance=null;
	
	/**
	 * @param rs reference to the RDFScapePlugin Object
	 */
	public RDFScapePanel(RDFScape rs) {
		super("RDFScape");
		myRDFScapeInstance=rs;
		JTabbedPane tabbedPane=new JTabbedPane();
		JTabbedPane optionTabbedPane=new JTabbedPane();
		tabbedPane.add(myRDFScapeInstance.getContextManager().getContextManagerPanel(),"Global properties");
		optionTabbedPane.add(myRDFScapeInstance.getNameSpaceManager().getNameSpaceManagerPanel(),"Name spaces");
		optionTabbedPane.add(myRDFScapeInstance.getReasonerManager().getReasonerManagerPanel(),"Resoner");
		optionTabbedPane.add(myRDFScapeInstance.getBrowserManager().getOptionPanel(),"Browser");
		optionTabbedPane.add(myRDFScapeInstance.getCytoMapper().getOptionPanel(),"CytoMapper");
		
		tabbedPane.add(optionTabbedPane,"Options");
		tabbedPane.add(myRDFScapeInstance.getOntologyManager().getOntologyManagerPanel(),"Ontologies");
		tabbedPane.add(myRDFScapeInstance.getBrowserManager().getPanel(),"Browser");
		tabbedPane.add(myRDFScapeInstance.getPatternManager().getPatternManagerPanel(),"Patterns");
		tabbedPane.add(myRDFScapeInstance.getCytoMapper().getCytoMapperPanel(),"Mapper");
		
		
		getContentPane().add(tabbedPane);
		setSize(new Dimension(700,600)); // TODO maybe should be get from a Default Object
		setVisible(true);
		
	}

	/**
	 * @param string
	 */
	public void alert(String string) {
		JOptionPane.showMessageDialog(this,string,"Namespaces",JOptionPane.WARNING_MESSAGE);
		
	}
	
	
	
	

}
