/**
 * Copyright 2006 Andrea Splendiani
 * Released under GPL license
 */

/*
 * Created on Oct 11, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package fr.pasteur.sysbio.rdfscape.browsing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/**
 * @author andrea
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class BrowserOptionPanel extends JPanel {
	BrowserManager browserManager=null;
	private JCheckBox allNamespaceConditionCheckBox=null;
	private JCheckBox collapseDatatypesCheckBox=null;
	//private JCheckBox propagateURI=null;
	//private JCheckBox ignoreBlankNodes=null;
	JCheckBox useLabelsCheckBox=null;
	JCheckBox splitPropertiesCheckBox=null;
	JList splitPropertiesList=null;
	JTextArea splitPropertyArea=null;
	//JButton addPropertyButton=null;
	//JButton delPropertyButton=null;
	//JButton commitPropertyButton=null;
	JTextArea splitPropertiesTextArea=null;
	JButton	splitPropertiesButton=null;
	/**
	 * 
	 */
	public BrowserOptionPanel(BrowserManager bm) {
		super();
		browserManager=bm;
		allNamespaceConditionCheckBox=new JCheckBox("Namespace selection in and",browserManager.isNamespaceSelectionInAnd());
		collapseDatatypesCheckBox=new JCheckBox("Treat datatypes as attributes",browserManager.isCollapseAttributesTrue());
		//propagateURI=new JCheckBox("Add URI as an attribute");
		//ignoreBlankNodes=new JCheckBox("ignore blank nodes in namespace conditions");
		
		useLabelsCheckBox=new JCheckBox("Use labels instead of URIs");
		splitPropertiesCheckBox=new JCheckBox("Treat some URI as multiple nodes");
		splitPropertiesTextArea=new JTextArea(20,60);
		JScrollPane textScrollPane=new JScrollPane(splitPropertiesTextArea);
		//textScrollPane.setSize(600,300);
		splitPropertiesButton=new JButton("Commit");
		
		allNamespaceConditionCheckBox.setToolTipText("If on, when extending a network, both properties and objects must be in selected namespaces. If off, onw of the two will suffice.");
		collapseDatatypesCheckBox.setToolTipText("If on, datatype properties will be treated as attributes in a raph representation.");
		//ignoreBlankNodes.setToolTipText("blank nodes counts as part of an unselected namespace");
		
		
		
		allNamespaceConditionCheckBox.addActionListener(new allNamespaceConditionBoxListener());
		collapseDatatypesCheckBox.addActionListener(new collapseDatatypesCheckBoxListener());
		useLabelsCheckBox.addActionListener(new useLabelsCheckBoxListener());
		//propagateURI.addActionListener(new propagateURIListener());
		splitPropertiesCheckBox.addActionListener(new splitCheckBoxListener());
		splitPropertiesButton.addActionListener(new splitPropertiesButtonListener());
		
		//splitPropertiesList=new JList();
		splitPropertyArea=new JTextArea();
		
		//addPropertyButton=new JButton("Add");
		//delPropertyButton=new JButton("Delete");
		//commitPropertyButton=new JButton("Commit");
		
		add(allNamespaceConditionCheckBox);
		add(collapseDatatypesCheckBox);
		add(useLabelsCheckBox);
		add(splitPropertiesCheckBox);
		add(textScrollPane);
		add(splitPropertiesButton);
		
		/**
		 * note: this will change when we'll read settings from a file.
		 */
		splitPropertiesButton.setEnabled(false);
		splitPropertiesTextArea.setEnabled(false);
		
		//add(propagateURI);
	}
	
	public void refreshAfterKnowledgeChange() {
		if(!browserManager.canCollapseDatatypes()) collapseDatatypesCheckBox.setEnabled(false);
		if(!browserManager.canExtend()) allNamespaceConditionCheckBox.setEnabled(false);
		if(!browserManager.canHandleLabels()) useLabelsCheckBox.setEnabled(false);
		if(!browserManager.canHandleSplit()) {
			splitPropertiesCheckBox.setEnabled(false);
			splitPropertiesTextArea.setEnabled(false);
		}
	}
	
	private class allNamespaceConditionBoxListener implements ActionListener {

		public void actionPerformed(ActionEvent arg0) {
			browserManager.setNamespaceSelectionInAnd(allNamespaceConditionCheckBox.isSelected());
			
		}
		
	}
	
	private class collapseDatatypesCheckBoxListener implements ActionListener {

		public void actionPerformed(ActionEvent arg0) {
			browserManager.setCollapseAttributes(collapseDatatypesCheckBox.isSelected());
			
		}
		
	}
	/*
	private class propagateURIListener implements ActionListener {

		public void actionPerformed(ActionEvent arg0) {
			browserManager.setPropagateURI(true);
			
		}
		
	}
	*/
	private class useLabelsCheckBoxListener implements ActionListener {

		public void actionPerformed(ActionEvent arg0) {
			browserManager.setUseLabels(useLabelsCheckBox.isSelected());
			
		}
		
	}
	private class splitCheckBoxListener implements ActionListener {

		public void actionPerformed(ActionEvent arg0) {
			splitPropertiesButton.setEnabled(splitPropertiesCheckBox.isSelected());
			splitPropertiesTextArea.setEnabled(splitPropertiesCheckBox.isSelected());
			browserManager.setEnableSplit(splitPropertiesCheckBox.isSelected());
		}
		
	}
	private class splitPropertiesButtonListener implements ActionListener {

		public void actionPerformed(ActionEvent arg0) {
			browserManager.setSplitConditions(splitPropertiesTextArea.getText());
			
		}
		
	}
	
	public void setSplitConditions(String text) {
		splitPropertiesTextArea.setText(text);
	}

	
}
