/**
 * Copyright 2006 Andrea Splendiani
 * Released under GPL license
 */

/*
 * Created on Oct 11, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package fr.pasteur.sysbio.rdfscape.browsing;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

import fr.pasteur.sysbio.rdfscape.query.AbstractQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.JenaQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.MyQueryEngine;

/**
 * @author andrea
 * This is a view for the BrowserManager component. It contains panels for 
 * the available query methods and manage user interaction with queries.
 * It also provides an interface for some other service implemented through 
 * BrowseManager
 * 
 */
public class BrowserPanel extends JPanel{
	private BrowserManager browserManager=null;	
	
	private JComboBox queryEnginesBox=null;	//list of available query engines
	private Hashtable queryEngines=null;
	
	/**
	 * These button are relative to operations on networks
	 */
	private JButton editNetworkButton=null;
	private JButton getNetworkPatternButton=null;
	private JButton newNetworkButton=null;
	
	
	
	/**
	 * These buttons are relative to operations on queries
	 */
	private JButton makeQueryButton=null;
	private JButton clearQueryButton=null;
	
	/**
	 * These elements are relative to query results
	 */
	private JButton selectAll=null;
	private JButton plotSelection=null;
	private JButton searchSelection=null;
	
	// TODO private ResultTableViewer resultTable=null;						//Table displaying results
	private ResultTableViewer resultTable=null;
	private AbstractQueryResultTable queryResult=null;				//holds the result of a query
	
	/**
	 * Support elements
	 */
	private JPanel upPanel=null;							//This Panel holds the query panel in its central position
	private JComponent currentQueryPanel=null;				//The current query panel
	private MyQueryEngine currentQueryEngine=null;			//This is the current query Engine. While related to currentQueryPanel, 
	private BrowseModeListener browseModeListener=null;		//changes browse more
	
	private JPanel northPanel=null;
	private JPanel patternPanel=null;
	private JPanel newNetworkPanel=null;
	
	
	/**
	 * Here the panel is built.
	 */
	public BrowserPanel(BrowserManager bm) {
		super();
		browserManager=bm;
		browseModeListener=new BrowseModeListener();
		
		
		/**
		 * Edit Button: set the graph as editable (var declaration) or not.
		 */
		editNetworkButton=new JButton("Make Editable");
		ActionListener editActionListener=new ActionListener () {
				public void actionPerformed(ActionEvent arg0) {
					browserManager.setEditable();
				
			}
		};
		editNetworkButton.addActionListener(editActionListener);
		
		/**
		 * Capture Pattern: get Current Pattern
		 */
		getNetworkPatternButton=new JButton("Get Pattern");
		ActionListener getSnapshotListener=new ActionListener () {
			public void actionPerformed(ActionEvent arg0) {
				String pname=JOptionPane.showInputDialog("Insert pattern name : ");
				if(pname!=null)
					browserManager.getSnapshot(pname);
			
			}
		};
		getNetworkPatternButton.addActionListener(getSnapshotListener);
		
		
		/**
		 * New network: creates a new Cytoscape Network
		 */
		
		newNetworkButton=new JButton("Create new network");
		ActionListener addNetworkListener=new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				browserManager.makeNewCytoscapePanel((String)queryEnginesBox.getSelectedItem());
				
			}
			
		};
		newNetworkButton.addActionListener(addNetworkListener);
		
		newNetworkPanel=new JPanel();
		newNetworkPanel.setBorder(new TitledBorder("Network"));
		newNetworkPanel.add(newNetworkButton);
		
		
		patternPanel=new JPanel();
		patternPanel.setBorder(new TitledBorder("Pattern definition"));
		patternPanel.add(editNetworkButton);
		patternPanel.add(getNetworkPatternButton);
		

		
		
		
		
		
		
		/**
		 * Buttons and items related to query and display results (they have listeners ouside this method)
		 */
		
		resultTable=new ResultTableViewer(); //Our results
		//resultTable=new JTable();
		makeQueryButton=new JButton("Make Query");
		clearQueryButton=new JButton("Clear Query");
		selectAll=new JButton("Select All");
		plotSelection=new JButton("Plot Selection");
		searchSelection=new JButton("Search Selection");
		makeQueryButton.addActionListener(new QueryExecListener());
		
		ActionListener selectAllListener=new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				resultTable.selectAll();
				
				
			}
			
		};
		clearQueryButton.addActionListener(new ClearButtonListener());
		selectAll.addActionListener(selectAllListener);
		plotSelection.addActionListener(new PlotSelectionListener());
		searchSelection.addActionListener(new SearchSelectionListener());

		/**
		 * Making of the panel
		 */
		
		
		
		upPanel=new JPanel();
		upPanel.setLayout(new BorderLayout());
	
		/**
		 * Note: initBrosweOptions() is not a real function. It changes global properties of this object.
		 * Hence the order in which it called within this constructors matters. It defines engineBox, and requires upPanel.
		 */
		
		
		
		
		
		northPanel=new JPanel();
		northPanel.setLayout(new GridLayout(1,3));
	
		
		
		
		JPanel midPanel=new JPanel();
		midPanel.setLayout(new GridLayout(1,5));
		midPanel.add(makeQueryButton);
		midPanel.add(clearQueryButton);
		midPanel.add(selectAll);
		midPanel.add(plotSelection);
		midPanel.add(searchSelection);
		
		upPanel.add(northPanel,BorderLayout.NORTH);
		upPanel.add(midPanel,BorderLayout.SOUTH);
		currentQueryPanel=new JPanel();
		upPanel.add(currentQueryPanel,BorderLayout.CENTER);
		
		//upPanel.add(variablePanel,BorderLayout.CENTER);
		//upPanel.add(rdqlBrowsePanel,BorderLayout.CENTER);
		setLayout(new GridLayout(2,1));
		add(upPanel);
		
		JScrollPane queryResultScrollPane=new JScrollPane(resultTable);
		queryResultScrollPane.setBorder(new TitledBorder("Results"));
		add(queryResultScrollPane);
		/**
		 * Note: initBrosweOptions() is not a real function. It changes global properties of this object.
		 * Hence the order in which it called within this constructors matters. It defines engineBox, and requires upPanel.
		 */
		initBrowseOptions();
		northPanel.add(queryEnginesBox);
		northPanel.add(newNetworkPanel);
		northPanel.add(patternPanel);
		
		
		
		
	}
	
	private void initBrowseOptions() {
		ArrayList queryItemsList=browserManager.getAvailableQueryElements();
		System.out.println("Available query engines: "+queryItemsList.size());
		queryEngines=new Hashtable();
		if(queryItemsList.size()==0) {
			System.out.println("case 0");
			String[] answer={"NO QUERY AVAILABLE"};
			queryEnginesBox=new JComboBox(answer);
			queryEnginesBox.setBorder(new TitledBorder("Browse mode"));
			queryEnginesBox.setEnabled(false);
			currentQueryEngine=null;
			if(currentQueryPanel!=null) {
				upPanel.remove(currentQueryPanel);
				currentQueryPanel=new JPanel();
				upPanel.add(currentQueryPanel,BorderLayout.CENTER);
			}
			makeQueryButton.setEnabled(false);
			clearQueryButton.setEnabled(false);
			plotSelection.setEnabled(false);
			searchSelection.setEnabled(false);
			selectAll.setEnabled(false);
			System.out.println("case 0 completed");
			return;
		}
		int i=0;
		String[] browseOptions=new String[queryItemsList.size()];
		for (Iterator iter = queryItemsList.iterator(); iter.hasNext();) {
			MyQueryEngine queryItem = (MyQueryEngine) iter.next();
			queryEngines.put(queryItem.getLabel(),queryItem);
			browseOptions[i]=queryItem.getLabel();
			i++;
		}
		queryEnginesBox=new JComboBox(browseOptions);
		queryEnginesBox.setBorder(new TitledBorder("Browse mode"));
		queryEnginesBox.addActionListener(browseModeListener);
		
		makeQueryButton.setEnabled(true);
		clearQueryButton.setEnabled(true);
		plotSelection.setEnabled(true);
		searchSelection.setEnabled(true);
		selectAll.setEnabled(true);
		//setting defaults...
		queryEnginesBox.setSelectedIndex(0);
		currentQueryEngine=(MyQueryEngine)queryEngines.get((String)queryEnginesBox.getSelectedItem());
		currentQueryPanel=currentQueryEngine.getPanel();
	}
	
	public void reset() {
		resetQuery();
		
	}
	
	public void resetQuery() {
		Enumeration tempEngines=queryEngines.elements();
		while(tempEngines.hasMoreElements()) {
			((MyQueryEngine)(tempEngines.nextElement())).reset();
		}
		resultTable.setModel(new JenaQueryResultTable());
		
	}
	
	private class BrowseModeListener implements ActionListener {
		public void actionPerformed(ActionEvent arg0) {
			System.out.println("Something changed");
			if(queryEngines==null) return;
			
			String newSelection=(String)queryEnginesBox.getSelectedItem();
			System.out.println("Changing query engine to :"+newSelection);
			if(queryEngines==null) {
				System.out.println("No query engines yet.");
				return;
			}
			MyQueryEngine newEngine=(MyQueryEngine) queryEngines.get(newSelection);
			if(currentQueryEngine==newEngine) {
				System.out.println("... I already had it as deafult. Nothing done.");
				return;
			}
			upPanel.remove(currentQueryPanel);
			currentQueryEngine=newEngine;
			currentQueryPanel=newEngine.getPanel();
			upPanel.add(currentQueryPanel,BorderLayout.CENTER);
			
			updateUI();
			validate();
		}
		
	}
	
	private class ClearButtonListener implements ActionListener {
		public void actionPerformed(ActionEvent arg0) {
			resetQuery();
			//rdqlQueryResult.display(new MyResultTable());
			
		}
		
	}
	
	private class QueryExecListener implements ActionListener {
		public void actionPerformed(ActionEvent arg0) {
			queryResult=currentQueryEngine.makeQuery();
			resultTable.setModel(queryResult);
			//resultTable=new ResultTableViewer(queryResult);
			//System.out.println("Table: "+resultTable.getSelectionModel().toString());
			/*
			resultTable.setRowSelectionAllowed(true);
			resultTable.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
			resultTable.getColumnModel().setColumnSelectionAllowed(false);
			System.out.println("Table: "+resultTable.getSelectionModel().toString());
			*/
		}
		
	}
	
	
	
	
	
	private class PlotSelectionListener implements ActionListener {
		
		String[] myNodesStringArray=null;
		public void actionPerformed(ActionEvent arg0) {
			if(queryResult==null) {
				System.out.println("No query to plot");
				return; //TODO we may also initialize an empty query insetad of this
			}
			
			if(queryResult.getRowCount()==0) {
				System.out.println("Nothing to plot at all ");
				return; //No table
			}
			//System.out.println("BrowserPanel: Mapping selection to a Cytoscape graph");
			if(queryResult.hasGraph()==true) {
				System.out.println("Graph results are unsupported yet");
			}
			if(queryResult.hasTable()==true) {
				System.out.println("I've seen you have selected "+resultTable.getSelectedRowCount()+" rows");
				browserManager.plotValuesInResultTable(queryResult.getSubsetByRows(resultTable.getSelectedRows()));
			}
			
			
		}
			
	}
private class SearchSelectionListener implements ActionListener {
		
		String[] myNodesStringArray=null;
		public void actionPerformed(ActionEvent arg0) {
			if(queryResult==null) {
				System.out.println("No query to search");
				return; //TODO we may also initialize an empty query insetad of this
			}
			
			if(queryResult.getRowCount()==0) {
				System.out.println("Nothing to search at all ");
				return; //No table
			}
			//System.out.println("BrowserPanel: Mapping selection to a Cytoscape graph");
			if(queryResult.hasGraph()==true) {
				System.out.println("Graph results are unsupported yet");
			}
			if(queryResult.hasTable()==true) {
				System.out.println("I've seen you have selected "+resultTable.getSelectedRowCount()+" rows");
				browserManager.searchValuesInResultTable(queryResult.getSubsetByRows(resultTable.getSelectedRows()));
			}
			
			
		}
			
	}
			
		
	
		public void refreshAfterEngineChange() {
			northPanel.remove(queryEnginesBox);
			northPanel.remove(newNetworkPanel);
			northPanel.remove(patternPanel);
			initBrowseOptions();
			resetQuery();
			
			northPanel.add(queryEnginesBox);
			northPanel.add(newNetworkPanel);
			northPanel.add(patternPanel);
		}
	
	
	
	
}
