/**
 * Copyright 2006 Andrea Splendiani
 * Released under GPL license
 */

/*
 * Created on Dec 7, 2005
 *
 * 
 */
package fr.pasteur.sysbio.rdfscape.context;

import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import fr.pasteur.sysbio.rdfscape.RDFScape;

/**
 * @author andrea
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ContextManagerPanel extends JPanel {
	ContextManager myContextManager=null;
	JComboBox contextList=null;
	JButton selectContextButton=null;
	JButton addContextButton=null;
	JButton delContextButton=null;
	JButton	saveContextButton=null;
	/**
	 * 
	 */
	public ContextManagerPanel(ContextManager cm) {
		super();
		myContextManager=cm;
		if(myContextManager.getAvailableContextsNames()!=null)
			contextList=new JComboBox(myContextManager.getAvailableContextsNames());
		else contextList=new JComboBox();
		selectContextButton=new JButton("Activate context");
		addContextButton=new JButton("Add context");
		delContextButton=new JButton("Delete context");
		saveContextButton=new JButton("Save current context");
		contextList.setSelectedItem(myContextManager.getActiveContextName());
		
		ActionListener selectContextListener= new ActionListener () {
			public void actionPerformed(ActionEvent arg0) {
				myContextManager.setActiveContext((String)contextList.getSelectedItem());
				myContextManager.loadActiveContext();
				
			}
			
		};
		ActionListener saveContextListener= new ActionListener () {
			public void actionPerformed(ActionEvent arg0) {
				myContextManager.saveActiveContext();
				
			}
			
		};
		
		ActionListener addContextListener=new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				String newContext=JOptionPane.showInputDialog("Context name: ");
				if(newContext!=null)
					myContextManager.addContext(newContext);
				
			}
			
		};
		
		ActionListener delContextListener=new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				String[] options={"Delete","Cancel"};
				if( JOptionPane.showOptionDialog(
						null,"Deleteing a context will delete all related information. Are you sure ?",
						"Warning",JOptionPane.DEFAULT_OPTION,JOptionPane.WARNING_MESSAGE,null,
						options,options[1]) ==0)
					if(contextList.getSelectedItem()!=null)
						myContextManager.deleteContext((String)contextList.getSelectedItem());
			}
			
		};
		//System.out.println("C");
		selectContextButton.addActionListener(selectContextListener);
		//System.out.println("1");
		addContextButton.addActionListener(addContextListener);
		//System.out.println("2");
		delContextButton.addActionListener(delContextListener);
		//System.out.println("D");
		saveContextButton.addActionListener(saveContextListener);
		
		add(contextList);
		add(selectContextButton);
		add(addContextButton);
		add(delContextButton);
		add(saveContextButton);
		
		setVisible(true);
		// TODO Auto-generated constructor stub
	}
	/**
	 * 
	 */
	public void updateContextElementsList() {
		remove(contextList);
		remove(selectContextButton);
		remove(addContextButton);
		remove(delContextButton);
		remove(saveContextButton);
		
		System.out.println("Remove");
		if(myContextManager.getAvailableContextsNames()!=null)
			contextList=new JComboBox(myContextManager.getAvailableContextsNames());
		else contextList=new JComboBox();
	
		add(contextList);
		add(selectContextButton);
		add(addContextButton);
		add(delContextButton);
		add(saveContextButton);
		validate();
	}

	
}
