/**
 * Copyright 2006 Andrea Splendiani
 * Released under GPL license
 */

/*
 * Created on Jul 7, 2005
 *
 * TODO To add proper pre-condition management
 */
package fr.pasteur.sysbio.rdfscape.cytomapper;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import com.ibm.icu.util.StringTokenizer;

import cytoscape.data.ExpressionData;
import cytoscape.data.mRNAMeasurement;
import fr.pasteur.sysbio.rdfscape.CommonMemory;
import fr.pasteur.sysbio.rdfscape.Contextualizable;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.RDFScapeModuleInterface;
import fr.pasteur.sysbio.rdfscape.context.ContextManager;
import fr.pasteur.sysbio.rdfscape.cytoscape.CytoscapeDealer;
import fr.pasteur.sysbio.rdfscape.knowledge.KnowledgeWrapper;
import fr.pasteur.sysbio.rdfscape.query.AbstractQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.RDQLQueryAnswerer;

/**
 * @author andrea
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class CytoMapper implements RDFScapeModuleInterface,Contextualizable{
	//RDFScape myRDFScapeInstance=null;
	//CommonMemory myMemory=null;
	//KnowledgeWrapper myKnowledge=null;
	//ContextManager contextManager=null;
	CytoscapeDealer cytoscapeDealer=null;
	CytoMapperPanel myPanel=null;
	CytoMapperOptionPanel myOptionPanel=null;
	CytoMapperDataPanel	myDataPanel=null;
	Hashtable mappingRuleList=null;
	MapperTable mapperTable=null;
	public int clashes=0;
	public int totalURIs=0;
	public int totalIDs=0;
	public int totalMatchedID=0;
	public int totalMatchedURI=0;
	public int multi=0;
	ExpressionData myData=null;
	double[][] dataMatrix=null;
	Hashtable geneToDataMapping=null;
	Hashtable conditionToDataMapping=null;
	
	Hashtable id2URI=null;
	Hashtable uri2ID=null;
	
	/**
	 * @throws Exception 
	 * 
	 */
	public CytoMapper() throws Exception {
		System.out.print("\tCytoMapper... ");
		mapperTable=new MapperTable();
		//myRDFScapeInstance=rs;
		if(RDFScape.getContextManager()==null) {
			throw new Exception("Unable to build CytoMapper : missing CommonMemory");
		}
		RDFScape.getContextManager().addContextualizableElement(this);
		
		initialize();
		System.out.println("Ok");
		
	}
	
	
	/* (non-Javadoc)
	 * @see fr.pasteur.sysbio.rdfscape.RDFScapeModule#initialize()
	 */
	public boolean initialize() {
		mappingRuleList=new Hashtable();
		
		geneToDataMapping=new Hashtable();
		conditionToDataMapping=new Hashtable();
		if(myOptionPanel!=null) {
			myOptionPanel.reset();
			myOptionPanel.resetAfterKnowledgeBaseChange();
		}
		resetMapping();
		return true;
	}
	
	public void resetMapping() {		
		id2URI=new Hashtable();
		uri2ID=new Hashtable();
		mapperTable.reset();
		clashes=0;
		totalURIs=0;
		totalIDs=0;
		totalMatchedID=0;
		totalMatchedURI=0;
		multi=0;
	}
	/**
	 * @return
	 */

	public Component getOptionPanel() {
		if(myOptionPanel==null) myOptionPanel=new CytoMapperOptionPanel(this);
		return myOptionPanel;
	}
	
	public CytoMapperPanel getCytoMapperPanel() {
		if(myPanel==null) myPanel=new CytoMapperPanel(this);
		return myPanel;
	}
	public CytoMapperDataPanel getCytoMapperDataPanel() {
		if(myPanel==null) myDataPanel=new CytoMapperDataPanel(this);
		return myDataPanel;
	}
	
	public void addMappingRule(MappingRule mappingRule) {
		mappingRuleList.put(mappingRule.name,mappingRule);
		myOptionPanel.refresh();
	}
	/**
	 * @param result
	 */
	public void parseAndAddMappingRule(String fullRuleText) {
		String pattern=new String();
		String name=null;
		String uriVar=null;
		String idVar=null;
		System.out.println(">"+fullRuleText);
		StringTokenizer myTokenizer=new StringTokenizer(fullRuleText);
		String token=null;
		while(myTokenizer.hasMoreTokens()) {
			token=myTokenizer.nextToken();
			if(token.equalsIgnoreCase("NAME:")) {
				name=myTokenizer.nextToken();
				
			}
			else if(token.equalsIgnoreCase("ID:")) {
				idVar=myTokenizer.nextToken();
			}
			else if(token.equalsIgnoreCase("URI:")) {
				uriVar=myTokenizer.nextToken();
			}
			else if(token.equalsIgnoreCase("PATTERN:")) {
				
				pattern=pattern.concat(myTokenizer.nextToken());
				
			}
			else pattern=pattern.concat(" "+token);
		}
		MappingRule myMappingRule=new MappingRule();
		myMappingRule.name=name;
		myMappingRule.patternText=pattern;
		myMappingRule.uriVar=uriVar;
		myMappingRule.idVar=idVar;
		if(myMappingRule.isValid()) addMappingRule(myMappingRule);
	}
	

	/**
	 * @return
	 */
	public Hashtable getGenesMapping() {
															
	    return geneToDataMapping;
		
		
		
		
	}

	/**
	 * @return
	 */
	public Hashtable getConditionMappings() {
		return conditionToDataMapping;
	}
	/**
	 * 
	 */
	public void resolve() {
		CommonMemory myMemory=RDFScape.getCommonMemory();
		resetMapping();
		for (Iterator iter = mappingRuleList.keySet().iterator(); iter.hasNext();) {
			String ruleName = (String) iter.next();
			System.out.println("rule : "+ruleName);
			MappingRule myRule=(MappingRule) mappingRuleList.get(ruleName);
			String RDQLquery="SELECT "+myRule.uriVar+" "+myRule.idVar+" \n WHERE "+
			myRule.patternText+"\n";
			String namespaceClause=new String();
			String[] namespaces=myMemory.getNamespaces();
			for (int i = 0; i < namespaces.length; i++) {
				String prefix=myMemory.getNamespacePrefix(namespaces[i]);
				if(prefix!=null) {
					if(!prefix.equalsIgnoreCase("")) {
						namespaceClause=namespaceClause+prefix+" for <"+namespaces[i]+">,\n";
					}
				}
			}
			if(namespaceClause.length()>1) {
				namespaceClause=namespaceClause.substring(0,namespaceClause.length()-2);
				RDQLquery=RDQLquery+"USING\n"+namespaceClause+"\n";
			}
			
			System.out.println(RDQLquery);
			AbstractQueryResultTable myResult=((RDQLQueryAnswerer)RDFScape.getKnowledge()).makeRDQLQuery(RDQLquery);
			
			analyze(myResult);
			mapperTable.add(myResult);
			mapperTable.fireTableDataChanged();
			
			
		}
		
	}
	private void analyze(AbstractQueryResultTable myResult) {
		for (int i = 0; i < myResult.getRowCount(); i++) {
			if(myResult.isURI(i,0) && myResult.isLiteral(i,1)) {
				String uri=myResult.getURI(i,0);
				String id=myResult.getDatatypeValue(i,1);
				HashSet myIDList=(HashSet) uri2ID.get(uri);
				if(myIDList==null) {
					myIDList=new HashSet();
					uri2ID.put(uri,myIDList);
				}
				else {
					if(!myIDList.contains(id))
						multi++;
				}
				myIDList.add(id);
				
				if(id2URI.get(id)==null) {
					id2URI.put(id,uri);
				}
				else {
					if(!((String)id2URI.get(id)).equals(uri)) {
						clashes++;
						System.out.println("Clash for:\n "+id+" "+uri+"\nVs");
						System.out.println(id+" "+(String)id2URI.get(id)+"\n");
					}
				}
			}
		}
		totalIDs=id2URI.keySet().size();
		totalURIs=uri2ID.keySet().size();
		
	}

	/**
	 * 
	 */
	public void map() {
		//myPanel.initOntology2GraphBars(uri2ID.keySet().size(),cytoscapeDealer.getNodeCount() );
		
		int[] mapResult=cytoscapeDealer.mapNodes(id2URI);
		totalMatchedID=mapResult[0];
		totalMatchedURI=mapResult[1];
		//myPanel.graphCoverage.setValue(mapResult[0]);
		//myPanel.ontologyCoverage.setValue(mapResult[1]);
		/*
		HashSet usedURIs=new HashSet();
		int mapped=0;
		for (Iterator iter = mapperTable.idToURI.keySet().iterator(); iter.hasNext();) {
			String tempID = (String) iter.next();
			ArrayList tempArray =(ArrayList) mapperTable.idToURI.get(tempID);
			if(cytoscapeDealer.mapURI(tempID,(String) tempArray.get(0))) {
				mapped++;
				for (Iterator temp = tempArray.iterator(); temp.hasNext();) {
					String element = (String) temp.next();
					usedURIs.add(element);
					
				}
				myPanel.graphCoverage.setValue(mapped);
				myPanel.ontologyCoverage.setValue(usedURIs.size());
			}
			
		}*/
		
		
	}
	/**
	 * 
	 */
	public void linkData() {
		// TODO this should change heavily!!!
		myData= cytoscapeDealer.getExpressionData();
		myPanel.initLinkBars(mapperTable.getTotalURIs(),myData.getNumberOfGenes() );
		System.out.println("I have a "+myData.getNumberOfGenes()+" x "+myData.getNumberOfConditions()+" matrix in mind");
		dataMatrix=new double[mapperTable.getTotalURIs()][myData.getNumberOfConditions()];
		int i=0;
		int j=0;
		int ontologyCovered=0;
		int dataCovered=0;
		HashSet IDs=new HashSet();
		for (Iterator iter = mapperTable.uriToID.keySet().iterator(); iter.hasNext();) {
			String tempURI = (String) iter.next();
			ArrayList tempList=(ArrayList) mapperTable.uriToID.get(tempURI);
			Vector myMeasures=myData.getMeasurements((String)(tempList.get(0)));
			if(myMeasures!=null) {
				System.out.println(tempURI+" -> "+tempList.get(0)+" #"+myMeasures.size());
				geneToDataMapping.put(tempURI,new Integer(i));
				ontologyCovered++;
				myPanel.ontologyDataCoverage.setValue(ontologyCovered);
				IDs.add((String)(tempList.get(0)));
				myPanel.dataOntologyCoverage.setValue(IDs.size());
				j=0;
				for (Iterator iterator = myMeasures.iterator(); iterator
						.hasNext();) {
					mRNAMeasurement tempMeasure = (mRNAMeasurement) iterator.next();
					dataMatrix[i][j]=tempMeasure.getRatio();
					j++;
				}
				
			}
			
			i++;
			
		}
		
		System.out.println("TEST:");
		for (int k = 0; k < dataMatrix.length; k++) {
			for (int l = 0; l < dataMatrix[k].length; l++) {
				System.out.print(dataMatrix[k][l]+"\t");
			}
			System.out.println();
		}
		
		
		
	}
	/**
	 * @return
	 */
	public double[][] getDataMatrix() {
		return dataMatrix;
	}
	
	
	
	
	/* (non-Javadoc)
	 * @see fr.pasteur.sysbio.rdfscape.RDFScapeModule#reset()
	 */
	public void reset() {
		// this is to be defined. Now it is considered as initialize()
		initialize();
		
	}
	/* (non-Javadoc)
	 * @see fr.pasteur.sysbio.rdfscape.RDFScapeModule#update()
	 */
	public void update() {
		// don-t know!!! //TODO
		
	}
	/* (non-Javadoc)
	 * @see fr.pasteur.sysbio.rdfscape.RDFScapeModule#validate()
	 */
	public boolean isInValidState() {
		
		return canOperate();
	}
	/* (non-Javadoc)
	 * @see fr.pasteur.sysbio.rdfscape.RDFScapeModule#checkPreconditions()
	 */
	public boolean canOperate() {
		// TODO must have a graph and a knowledge base, possibly data...
		return true;
	}
	/* (non-Javadoc)
	 * @see fr.pasteur.sysbio.rdfscape.RDFScapeModule#loadFromContext()
	 */
	public boolean loadFromActiveContext() {
		initialize();
		int counter = 0;
		String myFileName=RDFScape.getContextManager().getActiveContext().getDefaultMapDirName();
		File rulesDir=new File(myFileName);
		if(!rulesDir.isDirectory()) {
			System.out.println("Unable to locate mapping rules");
			return false;
		}
		try {
		  File tempMapRuleFile=null;
		  File[] mapRuleFiles=rulesDir.listFiles();
		  for (int i = 0; i < mapRuleFiles.length; i++) {
		  	System.out.println("Reading mapping rule : "+mapRuleFiles[i].getName());
		  	 Reader reader = new BufferedReader(new FileReader(mapRuleFiles[i]));
	            StringBuffer resultsBuffer = new StringBuffer();
	            char[] buffer = new char[1024];
	            for (int charsRead = 0; (charsRead = reader.read(buffer)) >= 0; )
	            {
	                resultsBuffer.append(buffer, 0, charsRead);
	            }
	            
	            String result = resultsBuffer.toString();
		  	
	            if(mapRuleFiles[i].isFile()) parseAndAddMappingRule( result);
		  }
		  
		  
		}
		catch(IOException ioe)
		{
		  System.out.println("Unable to load mapping rules");
		  return false;
		}
		return true;
		
	}
	/* (non-Javadoc)
	 * @see fr.pasteur.sysbio.rdfscape.RDFScapeModule#saveToContext()
	 */
	public boolean saveToContext() {
		System.out.println("Saving...");
		int counter = 0;
		String myFileName=RDFScape.getContextManager().getActiveContext().getDefaultMapDirName();
		File rulesDir=new File(myFileName);
		if(!rulesDir.isDirectory()) {
			System.out.println("Unable to locate mapping rules");
			return false;
		}
		File[] myFiles=rulesDir.listFiles();
		for (int i = 0; i < myFiles.length; i++) {
			myFiles[i].delete();
		}
		Enumeration ruleNames=mappingRuleList.keys();
		while(ruleNames.hasMoreElements()) {
			String tempRuleName=(String)ruleNames.nextElement();
		  	System.out.println("Going to save: "+tempRuleName);
			MappingRule tempRule=(MappingRule)mappingRuleList.get(tempRuleName);
		  	File tempMapRuleFile=new File(myFileName+"/"+tempRuleName);
		  	try {
		  		FileWriter tempWriter=new FileWriter(tempMapRuleFile);
		  		tempWriter.write("NAME: "+tempRule.getName()+"\n"+
		  				"ID: "+tempRule.getID()+"\n"+
						"URI: "+tempRule.getURI()+"\n"+
						"PATTERN: "+tempRule.getRuleString());
		  		tempWriter.close();
		  	} catch (Exception e) {
				System.out.println("Unable to save mapping rule to file "+myFileName+"/"+tempRuleName);
				return false;
		  	}
		  
		}
		  
		  
		
		return true;
	}
	

	public boolean canResolve() {
		return KnowledgeWrapper.hasRDQLSupport(RDFScape.getKnowledge());
	}

	public int getNumberOfMatchedIDs() {
		return totalMatchedID;
	}
	public int getNumberOfMatchedURIs() {
		return totalMatchedURI;
	}
	public int getNumberOfURIsToBeMatched() {
		return totalURIs;
	}
	public int getNumberOfNodesToBeMatched() {
		return cytoscapeDealer.getNodeCount();
	}
	public void touch() {
		// TODO Auto-generated method stub
		
	}
	
	
	
	
	
	
	
}
