/**
 * Copyright 2006 Andrea Splendiani
 * Released under GPL license
 */

/*
 * Created on Oct 27, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package fr.pasteur.sysbio.rdfscape.cytomapper;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Iterator;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

import fr.pasteur.sysbio.rdfscape.knowledge.KnowledgeWrapper;


/**
 * @author andrea
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class CytoMapperOptionPanel extends JPanel {
	CytoMapper cytoMapper=null;
	JPanel rulePanel=null;
	JTable myResultTable=null;
	JTabbedPane ruleTextPanels=null;
	JLabel statLabel=new JLabel();
	
	JButton addButton=null;
	JButton delButton=null;
	JButton resolveButton=null;
	JButton mergeButton=null;
	
	
	//int totalURIs=0;
	//int totalIDs=0;
	//int clashes=0;
	//int multi=0;
	/**
	 * 
	 */
	public CytoMapperOptionPanel(CytoMapper ct) {
		super();
		cytoMapper=ct;
		setLayout(new BorderLayout());
		
		JTabbedPane myTopLevelTabbedPane=new JTabbedPane();
		
		rulePanel=new JPanel(new BorderLayout());
		
		myResultTable=new JTable(cytoMapper.mapperTable);
		JScrollPane resultPanel=new JScrollPane(myResultTable);
		ruleTextPanels=new JTabbedPane();
		
		
		JPanel buttonPanel=new JPanel(new GridLayout(1,4));
		addButton=new JButton("New");
		delButton=new JButton("Del");
		resolveButton=new JButton("Resolve");
		mergeButton=new JButton("Merge");
		;
		buttonPanel.add(addButton);
		buttonPanel.add(delButton);
		
		buttonPanel.add(resolveButton);
		buttonPanel.add(mergeButton);
		
		
		rulePanel.add(ruleTextPanels,BorderLayout.CENTER);
		rulePanel.add(buttonPanel,BorderLayout.SOUTH);
		
		myTopLevelTabbedPane.add(rulePanel,"Rules");
		myTopLevelTabbedPane.add(resultPanel,"Results");
		
		ActionListener addButtonListener = new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				String name=JOptionPane.showInputDialog("Insert rule name");
				if(name==null) return;
				MappingRule myRule=new MappingRule();
				myRule.name=name;
				cytoMapper.addMappingRule(myRule);
				
			}
			
		};
		
		addButton.addActionListener(addButtonListener);
		
		ActionListener delButtonListener = new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				if(ruleTextPanels.getSelectedIndex()>=0) {
					cytoMapper.mappingRuleList.remove(ruleTextPanels.getTitleAt(ruleTextPanels.getSelectedIndex()));
					ruleTextPanels.remove(ruleTextPanels.getSelectedComponent());
				}
			}
			
		};
		delButton.addActionListener(delButtonListener);
		
		ActionListener resolveButtonListener = new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				cytoMapper.resolve();
				showStats();
			}
			
		};
		resolveButton.addActionListener(resolveButtonListener);
		
		add(myTopLevelTabbedPane,BorderLayout.CENTER);
		add(statLabel,BorderLayout.NORTH);
		showStats();
	}

	
	private void showStats() {
		remove(statLabel);
		statLabel=new JLabel("URIs: "+cytoMapper.totalURIs+"              IDs: "+cytoMapper.totalIDs+"              Conflicts: "+cytoMapper.clashes+"             Multi: "+cytoMapper.multi);
		add(statLabel,BorderLayout.NORTH);
		validate();
	}


	/**
	 * @param mappingRule
	 */
	/*
	public void addMappingRule(MappingRule mappingRule) {
		ruleTextPanels.add(mappingRule.getPanel(),mappingRule.name);
		
	}*/
	public void refresh() {
		reset();
		Enumeration myRules=cytoMapper.mappingRuleList.elements();
		while(myRules.hasMoreElements()) {
			MappingRule tempRule=(MappingRule)myRules.nextElement();
			ruleTextPanels.add(tempRule.getPanel(),tempRule.name);
		}
	}
	
	public void reset() {
	
		Component[] myComponents=ruleTextPanels.getComponents();
		for (int i = 0; i < myComponents.length; i++) {
			ruleTextPanels.remove(myComponents[i]);
		}
		
	}


	public void resetAfterKnowledgeBaseChange() {
		if(cytoMapper.canResolve()) {
			resolveButton.setEnabled(true);
		}
		else {
			resolveButton.setEnabled(false);
		}
		
	}
}
