/**
 * Copyright 2006 Andrea Splendiani
 * Released under GPL license
 */

/*
 * Created on Jul 7, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package fr.pasteur.sysbio.rdfscape.cytomapper;

import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.TitledBorder;


/**
 * @author andrea
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class CytoMapperPanel extends JPanel {
	CytoMapper cytoMapper=null;
	JButton mapButton=null;
	JButton linkDataButton=null;
	JProgressBar ontologyCoverage=null;
	JProgressBar graphCoverage=null;
	JProgressBar ontologyDataCoverage=null;
	JProgressBar dataOntologyCoverage=null;
	/**
	 * 
	 */
	public CytoMapperPanel(CytoMapper cs) {
		super();
		cytoMapper=cs;
		mapButton=new JButton("Map");
		linkDataButton=new JButton("Link data");
		linkDataButton.setEnabled(false);
		ontologyCoverage=new JProgressBar();
		graphCoverage=new JProgressBar();
		ontologyDataCoverage=new JProgressBar();
		dataOntologyCoverage=new JProgressBar();
		ontologyCoverage.setBorder(new TitledBorder("Ontology Coverage in graph"));
		graphCoverage.setBorder(new TitledBorder("Graph Coverage"));
		ontologyDataCoverage.setBorder(new TitledBorder("Ontology Coverage in data"));
		dataOntologyCoverage.setBorder(new TitledBorder("Data coverage in ontology"));
		graphCoverage.setMinimum(0);
		graphCoverage.setStringPainted(true);
		ontologyDataCoverage.setMinimum(0);
		ontologyDataCoverage.setStringPainted(true);
		ontologyCoverage.setMinimum(0);
		//ontologyCoverage.setMaximum(cytoMapper.getTotalURIs());
		ontologyCoverage.setStringPainted(true);
		dataOntologyCoverage.setStringPainted(true);
		
		add(mapButton);
		add(linkDataButton);
		add(ontologyCoverage);
		add(graphCoverage);
		add(ontologyDataCoverage);
		add(dataOntologyCoverage);
		
		ActionListener mapButtonListener=new ActionListener() {

			public void actionPerformed(ActionEvent arg0) {
				initOntology2GraphBars();
				cytoMapper.map();
				updateOntology2GraphBars();
				linkDataButton.setEnabled(true);
				
			}

			private void updateOntology2GraphBars() {
				ontologyCoverage.setValue(cytoMapper.getNumberOfMatchedURIs());
				graphCoverage.setValue(cytoMapper.getNumberOfMatchedIDs());
				
			}
			
		};
		mapButton.addActionListener(mapButtonListener);
		
		ActionListener linkButtonListener=new ActionListener() {

			public void actionPerformed(ActionEvent arg0) {
				cytoMapper.linkData();
				
				
			}
			
		};
		linkDataButton.addActionListener(linkButtonListener);
	}

	/**
	 * @param totalURIs
	 * @param nodeCount
	 */
	public void initOntology2GraphBars() {
		ontologyCoverage.setMaximum(cytoMapper.getNumberOfURIsToBeMatched());
		ontologyCoverage.setValue(0);
		graphCoverage.setMaximum(cytoMapper.getNumberOfNodesToBeMatched());
		graphCoverage.setValue(0);
		
		
	}

	/**
	 * @param totalURIs
	 * @param numberOfGenes
	 */
	public void initLinkBars(int totalURIs, int numberOfGenes) {
		ontologyDataCoverage.setValue(0);
		ontologyDataCoverage.setMaximum(totalURIs);
		dataOntologyCoverage.setValue(0);
		dataOntologyCoverage.setMaximum(numberOfGenes);
		
	}

	

}
