/**
 * Copyright 2006 Andrea Splendiani
 * Released under GPL license
 */

/*
 * Created on Jul 5, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package fr.pasteur.sysbio.rdfscape.namespacemanagement;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

import fr.pasteur.sysbio.rdfscape.CommonMemory;
import fr.pasteur.sysbio.rdfscape.DefaultSettings;



/**
 * @author andrea
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class NameSpaceManagerPanel extends JPanel{
	NamespaceManager nameSpaceManager=null;
	JTable nameSpaceTable=null;
	/**
	 * 
	 */
	public NameSpaceManagerPanel(NamespaceManager ns) {
		super();
		nameSpaceManager=ns;
		nameSpaceTable=new JTable(nameSpaceManager);
		
		JScrollPane myScrollPane=new JScrollPane(nameSpaceTable);
		setLayout(new BorderLayout());
		
		TableColumn colorColumn=nameSpaceTable.getColumnModel().getColumn(2);
		JComboBox comboBox=new JComboBox();
		comboBox.setEditable(false);
		Color[] colors=nameSpaceManager.getPossibleNameSpaceColors();
		for (int i = 0; i < colors.length; i++) {
			comboBox.addItem(colors[i]);
		}
		
		
		comboBox.setRenderer(new ColorListRenderer());
		
		colorColumn.setCellEditor(new DefaultCellEditor(comboBox));
		colorColumn.setCellRenderer(new ColorRenderer());
		
		ActionListener addListener =new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				String myNameSpace=JOptionPane.showInputDialog("Insert name space: ");
				nameSpaceManager.addNewNameSpaceToMemory(myNameSpace);
			}
			
		};
		ActionListener delListener =new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				if(nameSpaceTable.getSelectedRowCount()>1 || nameSpaceTable.getSelectedRowCount()==0) {
					JOptionPane.showMessageDialog(null,"please select only one name space");
				}
				else {
					String nameSpaceToDelete=(String) nameSpaceTable.getValueAt(nameSpaceTable.getSelectedRow(),0);
					nameSpaceManager.removeNameSpace(nameSpaceToDelete);
				}
				
			}
			
		};
		JButton addButton=new JButton("Add namespace");
		JButton delButton=new JButton("Remove namespace");
		JPanel buttonPanel=new JPanel();
		addButton.addActionListener(addListener);
		delButton.addActionListener(delListener);
		
		buttonPanel.add(addButton);
		buttonPanel.add(new JLabel("Warning"));
		buttonPanel.add(delButton);
		add(myScrollPane,BorderLayout.CENTER);
		add(buttonPanel,BorderLayout.SOUTH);
		
	}
	public class ColorRenderer extends JLabel implements TableCellRenderer {
		public ColorRenderer() {
			setOpaque(true); //MUST do this for background to show up.
		}

		public Component getTableCellRendererComponent(JTable table, Object color,
				boolean isSelected, boolean hasFocus,
				int row, int column) {
					
				setBackground((Color)nameSpaceManager.getValueAt(row,column));
			return this;

		}
	}
	class ColorListRenderer extends JLabel implements ListCellRenderer {
	     public ColorListRenderer() {
	         setOpaque(true);
	     }
	     public Component getListCellRendererComponent(
	         JList list, Object value,
	         int index, boolean isSelected, boolean cellHasFocus) {
	     		//System.out.println("Attempt at rendering..."+(Color)value);
	     		setText("choose this");
	     		setBackground((Color)value);
	     		return this;
	     }
	 }
	/**
	 * 
	 */
	
}
