/**
 * Copyright 2006 Andrea Splendiani
 * Released under GPL license
 */

/*
 * Created on Jul 5, 2005
 *
 */
package fr.pasteur.sysbio.rdfscape.ontologyhandling;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;





/**
 * @author andrea@pasteur.fr
 *
 *
 */
public class OntologyManagerLoaderPanel extends JPanel{
	OntologyLoaderManager ontologyManager=null;
	JButton loadButton=null;
	JButton addOntologyButton=null;
	JButton deleteOntologyButton=null;
	JTable ontologyTable=null;
	/**
	 * 
	 */
	public OntologyManagerLoaderPanel(OntologyLoaderManager om) {
		super();
		ontologyManager=om;
		addOntologyButton=new JButton("add");
		deleteOntologyButton=new JButton("delete");
		loadButton=new JButton("load ontologies");
		
		JPanel buttonPanel=new JPanel();
		buttonPanel.setLayout(new BorderLayout());
		buttonPanel.add(addOntologyButton,BorderLayout.WEST);
		buttonPanel.add(deleteOntologyButton,BorderLayout.EAST);
		buttonPanel.add(loadButton,BorderLayout.CENTER);
		
		addOntologyButton.addActionListener(new AddOntologyButtonListener());
		deleteOntologyButton.addActionListener(new DeleteOntologyButtonListener());
		loadButton.addActionListener(new LoadButtonListener());
		
		ontologyTable=new JTable(ontologyManager);
		JScrollPane myScroll=new JScrollPane(ontologyTable);
		
		setLayout(new BorderLayout());
		add(myScroll,BorderLayout.CENTER);
		add(buttonPanel,BorderLayout.SOUTH);
		TableColumn colorColumn=ontologyTable.getColumnModel().getColumn(1);
		colorColumn.setCellRenderer(new StatusCellRenderer());
		
	}
	
	private class AddOntologyButtonListener implements ActionListener {

		/* (non-Javadoc)
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent arg0) {
			JOptionPane myOptionPane=new JOptionPane();
			String myChoice=JOptionPane.showInputDialog("Enter URL for ontology (http:// or file:// must be prefixed","");
			ontologyManager.addURL(myChoice);
		}
		
	
		
	}
	private class DeleteOntologyButtonListener implements ActionListener {
		private int[] toDelete=null;
		/* (non-Javadoc)
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent arg0) {
			toDelete=ontologyTable.getSelectedRows();
			for (int i = 0; i < toDelete.length; i++) {
				ontologyManager.deleteOntology(toDelete[i]);
			}
			
		}
		
	}
	private class LoadButtonListener implements ActionListener {

		/* (non-Javadoc)
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent arg0) {
			ontologyManager.loadOntologiesFromScratch();
			
		}
		
		
	}
	
	private class StatusCellRenderer extends JLabel implements TableCellRenderer {
		public StatusCellRenderer() {
			setOpaque(true);
			setBackground(Color.WHITE);
		}
		/* (non-Javadoc)
		 * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
		 */
		public Component getTableCellRendererComponent(JTable arg0, Object arg1, boolean arg2, boolean arg3, int arg4, int arg5) {
			String myvalue=(String)arg1;
			setText(myvalue);
			if(myvalue.startsWith("Loading")) setBackground(Color.YELLOW);
			else if(myvalue.startsWith("Read ")) setBackground(Color.GREEN);
			else if(myvalue.startsWith("ERROR")) setBackground(Color.RED);
			else setBackground(Color.WHITE);
			
			
			return this;
		}

		
		
		
	}
	

}
