/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.analysis;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.core.analysis.Analysis;
import fr.unistra.ibmc.paradise.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.analysis.PreRequisite;
import fr.unistra.ibmc.paradise.core.features.AbstractParadiseFeatureFactoryFactory;
import fr.unistra.ibmc.paradise.core.features.ParadiseFeatureFactory;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnalysis
extends AbstractParadiseFeatureFactoryFactory
implements Analysis {
    protected Parameters parameters = new Parameters();
    protected List<PreRequisite> prerequisites = new ArrayList<PreRequisite>();
    protected List<String> categories;
    private List<ParadiseFeatureFactory> featureFactories = new ArrayList<ParadiseFeatureFactory>();
    protected List<Molecule> newMolecules = new ArrayList<Molecule>();
    protected String status = "Start of analysis";
    private boolean isCancelled;

    protected AbstractAnalysis(String description, MoleculeFactory moleculeFactory) {
        super(moleculeFactory, description);
        this.categories = new ArrayList<String>();
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public List<Molecule> getNewMolecules() {
        return new ArrayList<Molecule>(this.newMolecules);
    }

    @Override
    public MoleculeFactory getMoleculeFactory() {
        return this.moleculeFactory;
    }

    @Override
    public void addParadiseFeatureFactory(ParadiseFeatureFactory factory) {
        if (this.getParadiseFeatureFactory(factory.getClass()) == null) {
            this.featureFactories.add(factory);
        }
    }

    @Override
    public <T> T getParadiseFeatureFactory(Class<T> factoryType) {
        for (ParadiseFeatureFactory f : this.featureFactories) {
            if (!factoryType.isInstance(f)) continue;
            return factoryType.cast(f);
        }
        return null;
    }

    public void addCategory(String category) {
        this.categories.add(category);
    }

    @Override
    public String[] getCategories() {
        return this.categories.toArray(new String[0]);
    }

    public String toString() {
        return this.description;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public ArrayList<PreRequisite> getPreRequisites() {
        return new ArrayList<PreRequisite>(this.prerequisites);
    }

    @Override
    public Parameters getParameters(String name) {
        return this.parameters.getParameters(name);
    }

    protected Parameter addParameter(String name, String[] choices, String defaultValue) {
        Parameter p = new Parameter(name, choices, defaultValue);
        this.parameters.addParameter(p);
        return p;
    }

    protected Parameter addParameter(String name, String[] choices) {
        Parameter p = new Parameter(name, choices);
        this.parameters.addParameter(p);
        return p;
    }

    protected Parameter addParameter(String name, String defaultValue) {
        Parameter p = new Parameter(name, defaultValue);
        this.parameters.addParameter(p);
        return p;
    }

    protected Parameter addParameter(String name) {
        Parameter p = new Parameter(name);
        this.parameters.addParameter(p);
        return p;
    }
}

