/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.analysis;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameter
implements Serializable {
    private String name;
    private String[] choices;
    private String value;
    private boolean optional;
    private Molecule molecule;
    private ParadiseFeature feature;

    public Parameter(String name, String[] choices, String defaultChoice) {
        this(name, choices);
        this.value = defaultChoice;
    }

    public Parameter(String name, String[] choices) {
        this.name = name;
        this.choices = choices;
    }

    public Parameter(String name, String defaultChoice) {
        this(name, new String[0], defaultChoice);
    }

    public Parameter(String name) {
        this(name, new String[0]);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getChoices() {
        ArrayList<String> copy = new ArrayList<String>(this.choices.length);
        for (String c : this.choices) {
            copy.add(c);
        }
        return copy;
    }

    public void setValue(String value) {
        if (this.choices.length == 0) {
            this.value = value;
        }
        for (String choice : this.choices) {
            if (!choice.equals(value)) continue;
            this.value = value;
        }
    }

    public String getValue() {
        return this.value;
    }

    public boolean isFilled() {
        return this.value != null;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public ParadiseFeature getFeature() {
        return this.feature;
    }

    public void setFeature(ParadiseFeature feature) {
        this.feature = feature;
    }

    public Molecule getMolecule() {
        return this.molecule;
    }

    public void setMolecule(Molecule molecule) {
        this.molecule = molecule;
    }
}

