/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.features;

import fr.unistra.ibmc.paradise.ArchitectureException;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.features.AtomAtomInteraction;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;

public class CisWWInteraction
extends BaseBaseInteraction {
    private int dominant;

    protected CisWWInteraction(StructuralFeatureFactory factory, int dominantResidue, Molecule m, Location l) {
        super(factory, m, l);
        this.dominant = dominantResidue;
    }

    protected CisWWInteraction(StructuralFeatureFactory factory, Molecule m, Location l) {
        super(factory, m, l);
        this.dominant = -1;
    }

    protected CisWWInteraction(StructuralFeatureFactory factory, int dominantResidue, Molecule m1, Location l1, Molecule m2, Location l2) {
        super(factory, m1, l1, m2, l2);
        this.dominant = dominantResidue;
    }

    protected CisWWInteraction(StructuralFeatureFactory factory, Molecule m1, Location l1, Molecule m2, Location l2) {
        super(factory, m1, l1, m2, l2);
        this.dominant = -1;
    }

    public char getEdge1() {
        return 'W';
    }

    public char getEdge2() {
        return 'W';
    }

    public char getOrientation() {
        return 'C';
    }

    public int getDominant() {
        return this.dominant;
    }

    public void generateAtomAtomInteractions() {
        if (this.getAnnotations().size() == 1) {
            Molecule m = this.getAnnotations().get(0).getMolecule();
            Location l = this.getAnnotations().get(0).getLocation();
            char f = m.getResidueAt(l.getStart()).charAt(0);
            char s = m.getResidueAt(l.getEnd()).charAt(0);
            block0 : switch (f) {
                case 'A': {
                    AtomAtomInteraction aai;
                    switch (s) {
                        case 'A': {
                            if (this.getDominant() == -1) {
                                throw new ArchitectureException("This interaction is ambiguous, you must specify the dominant residue");
                            }
                            if (this.getDominant() == 1) {
                                aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N6", "N1", 'H', m, l);
                                aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N1", "C2", 'C', m, l);
                                break;
                            }
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N1", "N6", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "C2", "N1", 'C', m, l);
                            break;
                        }
                        case 'C': {
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N6", "N3", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N1", "O2", 'H', m, l);
                            break;
                        }
                        case 'G': {
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N6", "O6", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N1", "N1", 'H', m, l);
                            break;
                        }
                        case 'U': {
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N6", "O4", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N1", "N3", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "C2", "O2", 'C', m, l);
                        }
                    }
                    break;
                }
                case 'C': {
                    AtomAtomInteraction aai;
                    switch (s) {
                        case 'A': {
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N3", "N6", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O2", "N1", 'H', m, l);
                            break;
                        }
                        case 'C': {
                            if (this.getDominant() == -1) {
                                throw new ArchitectureException("This interaction is ambiguous, you must specify the dominant residue");
                            }
                            if (this.getDominant() == 1) {
                                aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N3", "N4", 'H', m, l);
                                aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O2", "N3", 'H', m, l);
                                break;
                            }
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N4", "N3", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N3", "O2", 'H', m, l);
                            break;
                        }
                        case 'G': {
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N4", "O6", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N3", "N1", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O2", "N2", 'H', m, l);
                            break;
                        }
                        case 'U': {
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N4", "O4", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N3", "N3", 'W', m, l);
                        }
                    }
                    break;
                }
                case 'G': {
                    AtomAtomInteraction aai;
                    switch (s) {
                        case 'A': {
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O6", "N6", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N1", "N1", 'H', m, l);
                            break;
                        }
                        case 'C': {
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O6", "N4", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N1", "N3", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N2", "O2", 'H', m, l);
                            break;
                        }
                        case 'G': {
                            break;
                        }
                        case 'U': {
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O6", "N3", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N1", "O2", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N2", "O2'", 'W', m, l);
                        }
                    }
                    break;
                }
                case 'U': {
                    AtomAtomInteraction aai;
                    switch (s) {
                        case 'A': {
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O4", "N6", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N3", "N1", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O2", "C2", 'C', m, l);
                            break block0;
                        }
                        case 'C': {
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O4", "N4", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N3", "N3", 'W', m, l);
                            break block0;
                        }
                        case 'G': {
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N3", "O6", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O2", "N1", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O2'", "N2", 'W', m, l);
                            break block0;
                        }
                        case 'U': {
                            if (this.getDominant() == -1) {
                                throw new ArchitectureException("This interaction is ambiguous, you must specify the dominant residue");
                            }
                            if (this.getDominant() == 1) {
                                aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O4", "N3", 'H', m, l);
                                aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N3", "O2", 'H', m, l);
                                aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O2", "O2'", 'W', m, l);
                                break block0;
                            }
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N3", "O4", 'H', m, l);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O2", "N3", 'H', m, l);
                        }
                    }
                }
            }
        }
        if (this.getAnnotations().size() == 2) {
            Molecule m1 = this.getAnnotations().get(0).getMolecule();
            Molecule m2 = this.getAnnotations().get(1).getMolecule();
            Location l1 = this.getAnnotations().get(0).getLocation();
            Location l2 = this.getAnnotations().get(1).getLocation();
            char f = m1.getResidueAt(l1.getStart()).charAt(0);
            char s = m2.getResidueAt(l2.getEnd()).charAt(0);
            block30 : switch (f) {
                case 'A': {
                    switch (s) {
                        case 'A': {
                            if (this.getDominant() == -1) {
                                throw new ArchitectureException("This interaction is ambiguous, you must specify the dominant residue");
                            }
                            if (this.getDominant() == 1) {
                                AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N6", "N1", 'H', m1, l1, m2, l2);
                                aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N1", "C2", 'C', m1, l1, m2, l2);
                                break;
                            }
                            AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N1", "N6", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "C2", "N1", 'C', m1, l1, m2, l2);
                            break;
                        }
                        case 'C': {
                            AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N6", "N3", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N1", "O2", 'H', m1, l1, m2, l2);
                            break;
                        }
                        case 'G': {
                            AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N6", "O6", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N1", "N1", 'H', m1, l1, m2, l2);
                            break;
                        }
                        case 'U': {
                            AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N6", "O4", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N1", "N3", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "C2", "O2", 'C', m1, l1, m2, l2);
                        }
                    }
                    break;
                }
                case 'C': {
                    switch (s) {
                        case 'A': {
                            AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N3", "N6", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O2", "N1", 'H', m1, l1, m2, l2);
                            break;
                        }
                        case 'C': {
                            if (this.getDominant() == -1) {
                                throw new ArchitectureException("This interaction is ambiguous, you must specify the dominant residue");
                            }
                            if (this.getDominant() == 1) {
                                AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N3", "N4", 'H', m1, l1, m2, l2);
                                aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O2", "N3", 'H', m1, l1, m2, l2);
                                break;
                            }
                            AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N4", "N3", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N3", "O2", 'H', m1, l1, m2, l2);
                            break;
                        }
                        case 'G': {
                            AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N4", "O6", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N3", "N1", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O2", "N2", 'H', m1, l1, m2, l2);
                            break;
                        }
                        case 'U': {
                            AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N4", "O4", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N3", "N3", 'W', m1, l1, m2, l2);
                        }
                    }
                    break;
                }
                case 'G': {
                    switch (s) {
                        case 'A': {
                            AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O6", "N6", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N1", "N1", 'H', m1, l1, m2, l2);
                            break;
                        }
                        case 'C': {
                            AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O6", "N4", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N1", "N3", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N2", "O2", 'H', m1, l1, m2, l2);
                            break;
                        }
                        case 'G': {
                            break;
                        }
                        case 'U': {
                            AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O6", "N3", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N1", "O2", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N2", "O2'", 'W', m1, l1, m2, l2);
                        }
                    }
                    break;
                }
                case 'U': {
                    switch (s) {
                        case 'A': {
                            AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O4", "N6", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N3", "N1", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O2", "C2", 'C', m1, l1, m2, l2);
                            break block30;
                        }
                        case 'C': {
                            AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O4", "N4", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N3", "N3", 'W', m1, l1, m2, l2);
                            break block30;
                        }
                        case 'G': {
                            AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N3", "O6", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O2", "N1", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O2'", "N2", 'W', m1, l1, m2, l2);
                            break block30;
                        }
                        case 'U': {
                            if (this.getDominant() == -1) {
                                throw new ArchitectureException("This interaction is ambiguous, you must specify the dominant residue");
                            }
                            if (this.getDominant() == 1) {
                                AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O4", "N3", 'H', m1, l1, m2, l2);
                                aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N3", "O2", 'H', m1, l1, m2, l2);
                                aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O2", "O2'", 'W', m1, l1, m2, l2);
                                break block30;
                            }
                            AtomAtomInteraction aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "N3", "O4", 'H', m1, l1, m2, l2);
                            aai = ((StructuralFeatureFactory)this.factory).createAtomAtomInteraction(this, "O2", "N3", 'H', m1, l1, m2, l2);
                        }
                    }
                }
            }
        }
    }
}

