/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.features;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.utils.Residue;

public class SingleStrand
extends StructuralDomain {
    protected SingleStrand(StructuralFeatureFactory factory, String name) {
        super(factory, name);
    }

    public int getLength() {
        return this.getFullLocation(this.getMolecules().iterator().next()).getLength();
    }

    public int get5PrimeEnd() {
        return this.getFullLocation(this.getMolecules().iterator().next()).getStart();
    }

    public int get3PrimeEnd() {
        return this.getFullLocation(this.getMolecules().iterator().next()).getEnd();
    }

    public boolean isTerminalLoop() {
        if (this.get5PrimeEnd() == 1) {
            return false;
        }
        Molecule m = this.getMolecules().iterator().next();
        if (this.get3PrimeEnd() == m.getLength()) {
            return false;
        }
        SecondaryStructure ss = this.getParentFeatures(SecondaryStructure.class).get(0);
        return ss.getPairedResidueInSecondaryInteraction(new Residue(this.get5PrimeEnd() - 1, m)).equals(new Residue(this.get3PrimeEnd() + 1, m));
    }
}

