/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.io;

import fr.unistra.ibmc.paradise.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.RNA;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.features.IdentityFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.StructuralIdentity;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.core.io.AbstractParadiseFileIO;
import fr.unistra.ibmc.paradise.core.io.FileParsingException;
import fr.unistra.ibmc.paradise.tools.component.ProgressMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StockholmFileIO
extends AbstractParadiseFileIO {
    public static final String[] suffixes = new String[]{"stk", "txt"};
    private List<StructuralAlignment> structuralAlignments;
    private IdentityFeatureFactory identityFeatureFactory;
    protected StructuralFeatureFactory structuralFeatureFactory;
    protected List<Molecule> molecules;
    protected List<SecondaryStructure> secondaryStructures;

    public StockholmFileIO(MoleculeFactory moleculeFactory) {
        super("Stockholm File parser", moleculeFactory);
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                for (String suffix : suffixes) {
                    if (!file.getName().endsWith(suffix)) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return "Stockholm files";
            }
        };
    }

    @Override
    public List<SecondaryStructure> getSecondaryStructures() {
        return this.secondaryStructures;
    }

    @Override
    public List<TertiaryStructure> getTertiaryStructures() {
        return new ArrayList<TertiaryStructure>();
    }

    @Override
    public List<Molecule> getMolecules() {
        return this.molecules;
    }

    @Override
    public List<StructuralAlignment> getStructuralAlignments() {
        return this.structuralAlignments;
    }

    @Override
    public void parseFile(File f, ProgressMonitor monitor) throws FileParsingException {
        this.structuralFeatureFactory = this.createStructuralFeatureFactory();
        this.identityFeatureFactory = this.createIdentityFeatureFactory();
        this.molecules = new ArrayList<Molecule>();
        ArrayList<String> alignedSequences = new ArrayList<String>();
        this.secondaryStructures = new ArrayList<SecondaryStructure>();
        this.structuralAlignments = new ArrayList<StructuralAlignment>();
        StructuralAlignment structuralAlignment = this.identityFeatureFactory.createStructuralAligment(new ParadiseID(), "alignment", Source.getFileAsSource(f));
        StructuralIdentity si = null;
        this.structuralAlignments.add(structuralAlignment);
        StringBuffer brackets = new StringBuffer();
        Location gapsPositions = null;
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(f));
            boolean ssConsReached = false;
            while ((line = in.readLine()) != null) {
                String[] tokens;
                if (line.startsWith("#=GC SS_cons")) {
                    ssConsReached = true;
                    tokens = line.trim().split("#=GC SS_cons");
                    brackets.append(tokens[1].trim().replace('<', '(').replace('>', ')'));
                    for (StructuralIdentity _si : structuralAlignment.getStructuralIdentities(false)) {
                        for (Molecule m : _si.getMolecules()) {
                            this.generateSecondaryStructure(f, m, (String)alignedSequences.get(this.molecules.indexOf(m)), brackets);
                            this.secondaryStructures.get(this.secondaryStructures.size() - 1).linkStructuralAlignment(structuralAlignment);
                        }
                    }
                    break;
                }
                if (line.startsWith("# STOCKHOLM") || ssConsReached || line.trim().length() == 0) continue;
                line = line.replace('.', '-');
                tokens = line.trim().split("\\s+");
                String moleculeName = tokens[0];
                String alignedSequence = tokens[1];
                gapsPositions = new Location();
                char[] characters = alignedSequence.toCharArray();
                for (int i = 0; i < characters.length; ++i) {
                    if (characters[i] != '-') continue;
                    gapsPositions.add(i + 1);
                }
                RNA molecule = this.moleculeFactory.createRNA(new ParadiseID(), moleculeName, Source.getFileAsSource(f), alignedSequence.replaceAll("-", ""));
                this.molecules.add(molecule);
                alignedSequences.add(alignedSequence);
                if (si == null) {
                    si = this.identityFeatureFactory.createStructuralIdentity(structuralAlignment, "si", molecule, new Location(1, molecule.getLength()));
                } else {
                    molecule.addFeature(si, new Location(1, molecule.getLength()));
                }
                si.addGapsLocation(molecule, gapsPositions);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FileParsingException(e);
        }
    }

    private void generateSecondaryStructure(File f, Molecule m, String alignedSequence, StringBuffer brackets) throws FileParsingException, BiologicalSymbolException {
        ArrayList<Location> helices = new ArrayList<Location>();
        ArrayList<Location> tertiaryInteractions = new ArrayList<Location>();
        ArrayList<Location> allpairs = new ArrayList<Location>();
        if (brackets.length() == alignedSequence.length()) {
            int i;
            Location locationInTheMolecule = new Location();
            Location locationInTheAlignedSequence = new Location();
            this.secondaryStructures.add(this.structuralFeatureFactory.createRNASecondaryStructure(new ParadiseID(), "SS " + f.getName(), Source.getFileAsSource(f), m, new Location(1, m.getLength())));
            int moleculePosition = 0;
            block4: for (int i2 = 0; i2 < brackets.length(); ++i2) {
                if (alignedSequence.charAt(i2) != '-') {
                    ++moleculePosition;
                }
                char c = brackets.charAt(i2);
                switch (c) {
                    case '(': {
                        locationInTheMolecule.add(moleculePosition);
                        locationInTheAlignedSequence.add(i2);
                        continue block4;
                    }
                    case ')': {
                        if (alignedSequence.charAt(locationInTheAlignedSequence.getEnd()) != '-' && alignedSequence.charAt(i2) != '-') {
                            allpairs.add(new Location(new Location(locationInTheMolecule.getEnd()), new Location(moleculePosition)));
                        }
                        locationInTheMolecule.remove(locationInTheMolecule.getEnd());
                        locationInTheAlignedSequence.remove(locationInTheAlignedSequence.getEnd());
                    }
                }
            }
            Collections.sort(allpairs, new Comparator(){

                public int compare(Object o, Object o1) {
                    return ((Location)o).getStart() - ((Location)o1).getStart();
                }
            });
            Location allSingleStrandsLocation = new Location(1, m.getLength());
            Location l = null;
            for (i = 0; i < allpairs.size() - 1; ++i) {
                Location l1 = (Location)allpairs.get(i);
                Location l2 = (Location)allpairs.get(i + 1);
                if (l1.getStart() + 1 == l2.getStart() && l1.getEnd() - 1 == l2.getEnd()) {
                    if (l == null) {
                        l = new Location(l1, l2);
                        continue;
                    }
                    l.add(l1);
                    l.add(l2);
                    continue;
                }
                if (l != null) {
                    if (l.getLength() == 2) {
                        tertiaryInteractions.add(l);
                    } else {
                        helices.add(l);
                        allSingleStrandsLocation.remove(l);
                    }
                }
                l = null;
            }
            if (l != null) {
                if (l.getLength() == 2) {
                    tertiaryInteractions.add(l);
                } else {
                    helices.add(l);
                    allSingleStrandsLocation.remove(l);
                }
            }
            i = 1;
            for (Location _l : helices) {
                this.structuralFeatureFactory.createHelix("H" + i++, this.secondaryStructures.get(this.secondaryStructures.size() - 1), m, _l);
            }
            for (Location _l : tertiaryInteractions) {
                this.structuralFeatureFactory.createBaseBaseInteraction('W', 'W', 'C', 1, this.secondaryStructures.get(this.secondaryStructures.size() - 1), m, _l);
            }
            int[] boundaries = allSingleStrandsLocation.getBoundaries();
            for (i = 0; i < boundaries.length; i += 2) {
                this.structuralFeatureFactory.createSingleStrand("SS" + (i + 1), this.secondaryStructures.get(this.secondaryStructures.size() - 1), m, new Location(boundaries[i], boundaries[i + 1]));
            }
        } else {
            throw new FileParsingException("One sequence has not the same size than its brackets");
        }
    }
}

