/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.services.analysis.ibmc.rnafold;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.analysis.AbstractAnalysis;
import fr.unistra.ibmc.paradise.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.core.analysis.NoSolutionException;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.io.CTFileIO;
import fr.unistra.ibmc.paradise.services.analysis.ibmc.rnafold.RnafoldServiceLocator;
import fr.unistra.ibmc.paradise.services.analysis.ibmc.rnafold.Rnafold_PortType;
import fr.unistra.ibmc.paradise.tools.component.DefaultProgressMonitor;
import fr.unistra.ibmc.paradise.utils.IOUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBMCRnafoldAnalysis
extends AbstractAnalysis {
    protected IBMCRnafoldAnalysis(MoleculeFactory factory) {
        super("RNAFold (ARN/IBMC Web Service)", factory);
        this.addCategory("2D prediction");
    }

    @Override
    public void run(List<Molecule> molecules, Parameters parameters) throws AnalysisException, NoSolutionException {
        try {
            RnafoldServiceLocator service = new RnafoldServiceLocator();
            Rnafold_PortType rnafold = service.getRnafold();
            this.status = "Query to the webservice";
            String result = rnafold.predict2D(">" + molecules.get(0).getName() + "\n" + molecules.get(0).printSequence());
            File rnafoldOutput = IOUtils.createTemporaryFile("rnafold");
            FileUtils.writeStringToFile((File)rnafoldOutput, (String)result);
            CTFileIO parser = new CTFileIO(this.moleculeFactory);
            parser.parseFile(rnafoldOutput, new DefaultProgressMonitor());
            molecules.get(0).removeAllSelectedFeatures();
            if (parser.getMolecules().size() != 0) {
                SecondaryStructure ss = (SecondaryStructure)parser.getMolecules().get(0).getAnnotations(SecondaryStructure.class).get(0).getFeature();
                SecondaryStructure copySS = ss.getFactory().copySecondaryStructure(Arrays.asList(molecules.get(0)), ss, false);
                copySS.setParadiseID(new ParadiseID());
                copySS.setName("Secondary Structure");
                copySS.setSource(Source.getAnalysisAsSource(this.description));
                molecules.get(0).addSelectedFeature(copySS);
            }
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
    }
}

