/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.utils;

import fr.unistra.ibmc.paradise.utils.FileFormattingException;
import fr.unistra.ibmc.paradise.utils.Parser;
import fr.unistra.ibmc.paradise.utils.ParsingException;

public class FGM {
    public static final int ATOM = 0;
    public static final int CHI = 1;
    public int type;
    public int atomNumber;
    public int residueNumber;
    public String atomName;
    public float x;
    public float y;
    public float z;
    public float chi;

    public FGM() {
    }

    public FGM(String line) throws ParsingException {
        if (line.substring(0, 5).replaceAll(" ", "").length() > 0) {
            this.atomNumber = Parser.parseInt(line.substring(0, 5).replaceAll(" ", ""));
            this.residueNumber = Parser.parseInt(line.substring(9, 11).replaceAll(" ", ""));
            this.atomName = line.substring(11, 15).replaceAll(" ", "");
            this.x = Parser.parseFloat(line.substring(18, 28).replaceAll(" ", ""));
            this.y = Parser.parseFloat(line.substring(28, 38).replaceAll(" ", ""));
            this.z = Parser.parseFloat(line.substring(38, 48).replaceAll(" ", ""));
            this.type = 0;
        } else {
            this.residueNumber = Parser.parseInt(line.substring(8, 11).replaceAll(" ", ""));
            this.chi = Parser.parseFloat(line.substring(18, 28).replaceAll(" ", ""));
            this.type = 1;
        }
    }

    private static String atomSerialNumber(int nb) {
        String ret = nb + "";
        try {
            while (ret.length() < 5) {
                ret = " " + ret;
            }
            if (ret.length() != 5) {
                throw new FileFormattingException("inapropriate string length while formatting the text");
            }
        }
        catch (FileFormattingException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static String atomName(String name) {
        String ret = name.replaceAll(" ", "");
        try {
            while (ret.length() < 5) {
                ret = ret + " ";
            }
            if (ret.length() != 5) {
                throw new FileFormattingException("inapropriate string length while formatting the text");
            }
        }
        catch (FileFormattingException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static String residueSequenceNumber(int num) {
        String ret = num + "";
        try {
            while (ret.length() < 3) {
                ret = " " + ret;
            }
            if (ret.length() != 3) {
                throw new FileFormattingException("inapropriate string length while formatting the text");
            }
        }
        catch (FileFormattingException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static String coord(float f) throws ParsingException {
        String ret = "";
        try {
            String fl = f + "";
            if (fl.indexOf("E") != -1) {
                String nb = fl.substring(0, fl.indexOf("E"));
                int mult = Parser.parseInt(fl.substring(fl.indexOf("E") + 1));
                if (mult < -3) {
                    ret = "    0.0000";
                } else if (mult > 4) {
                    ret = "99999.9999";
                    throw new FileFormattingException("in FGM.coord(" + f + ") the number exceeds 99999.9999");
                }
            } else {
                int p = fl.indexOf(".");
                if (p == -1) {
                    throw new FileFormattingException("FGM.coord(" + fl + ") : no dot in this string");
                }
                String head = fl.substring(0, ++p);
                String queue = fl.substring(p);
                if (queue.length() > 5 && Parser.parseInt(queue.charAt(5) + "") > 4) {
                    fl = f > 0.0f ? f + 1.0E-4f + "" : f - 1.0E-4f + "";
                    head = fl.substring(0, p);
                    queue = fl.substring(p);
                }
                while (queue.length() < 5) {
                    queue = queue + "0";
                }
                while (head.length() < 5) {
                    head = " " + head;
                }
                ret = head + queue.substring(0, 5);
            }
            if (ret.length() != 10) {
                throw new FileFormattingException("in FGM.coord(" + f + ") : inapropriate string length while formatting the text");
            }
        }
        catch (FileFormattingException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static int atomCode(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == 'C') {
                return 1;
            }
            if (s.charAt(i) == 'M') {
                return 1;
            }
            if (s.charAt(i) == 'N') {
                return 2;
            }
            if (s.charAt(i) == 'O') {
                return 3;
            }
            if (s.charAt(i) != 'P') continue;
            return 4;
        }
        return 0;
    }

    private static String chi(String ch) {
        String chi = ch + "    ";
        return chi.substring(0, 4);
    }

    public static String getAtomString(int nn, int nres, String atomn, double mx, double my, double mz) throws ParsingException {
        String atomNumber = FGM.atomSerialNumber(nn);
        String residueNumber = FGM.residueSequenceNumber(nres);
        String atomName = FGM.atomName(atomn);
        int atomCode = FGM.atomCode(atomn);
        String x = FGM.coord((float)mx);
        String y = FGM.coord((float)my);
        String z = FGM.coord((float)mz);
        String ret = "" + atomNumber + "   " + residueNumber + atomName + " " + atomCode + x + y + z;
        return ret;
    }

    public static String getChiString(int nres, String ch, double ator) throws ParsingException {
        String residueNumber = FGM.residueSequenceNumber(nres);
        String chi = FGM.chi(ch);
        String angle = FGM.coord((float)ator);
        String ret = "        " + residueNumber + chi + "   " + angle;
        return ret;
    }
}

