/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.utils;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JOptionPane;

public class GeneralUtils {
    public static String reverse(String s) {
        StringBuffer out = new StringBuffer();
        for (int i = s.length() - 1; i >= 0; --i) {
            out.append(s.charAt(i));
        }
        return out.toString();
    }

    public static void centerOnScreen(Window window) {
        Dimension win = window.getSize();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int newX = (screen.width - win.width) / 2;
        int newY = (screen.height - win.height) / 2;
        window.setLocation(newX, newY);
    }

    public static void rightSideOfTargetWindow(Window targetWindow, Window newWindow, int transX, int transY) {
        Point location = targetWindow.getLocationOnScreen();
        newWindow.setLocation(location.x + (int)targetWindow.getSize().getWidth() + transX, location.y + transY);
    }

    public static void leftSideOfTargetWindow(Window targetWindow, Window newWindow, int transX, int transY) {
        Point location = targetWindow.getLocationOnScreen();
        newWindow.setLocation(location.x - (int)newWindow.getSize().getWidth() + transX, location.y + transY);
    }

    public static void aboveTargetWindow(Window targetWindow, Window newWindow, int transX, int transY) {
        Point location = targetWindow.getLocationOnScreen();
        newWindow.setLocation(location.x + transX, location.y - (int)newWindow.getSize().getHeight() + transY);
    }

    public static void belowTargetWindow(Window targetWindow, Window newWindow, int transX, int transY) {
        Point location = targetWindow.getLocationOnScreen();
        newWindow.setLocation(location.x + transX, location.y + (int)targetWindow.getSize().getHeight() + transY);
    }

    public static void openBrowser(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error attempting to launch web browser:\n" + e.getLocalizedMessage());
        }
    }

    private static class CommandLineProgressBar {
        private Timer timer;

        private CommandLineProgressBar() {
        }

        private void start() {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new ProgressionTask(), 0L, 2000L);
        }

        private void stop() {
            this.timer.cancel();
        }

        private class ProgressionTask
        extends TimerTask {
            private ProgressionTask() {
            }

            public void run() {
                System.out.print(".");
            }
        }
    }
}

