/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.utils;

import fr.unistra.ibmc.paradise.Paradise;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class IOUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String fileName, InputStream in) {
        File f = new File(fileName);
        FilterOutputStream fOut = null;
        try {
            fOut = new BufferedOutputStream(new FileOutputStream(f));
            byte[] buffer = new byte[32768];
            int bytesRead = 0;
            while ((bytesRead = in.read(buffer)) != -1) {
                ((BufferedOutputStream)fOut).write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
                fOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isParadiseProject(File file) {
        return file.isDirectory() && file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String s) {
                return (Molecule.class.getSimpleName() + "s").equals(s) || (TertiaryStructure.class.getSimpleName() + "s").equals(s) || (SecondaryStructure.class.getSimpleName() + "s").equals(s) || (StructuralAlignment.class.getSimpleName() + "s").equals(s);
            }
        }).length == 4;
    }

    public static boolean containsStructuralAlignmentData(File paradiseProject) {
        if (!IOUtils.isParadiseProject(paradiseProject)) {
            return false;
        }
        return new File(paradiseProject, StructuralAlignment.class.getSimpleName() + "s").listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".rnaml");
            }
        }).length > 0;
    }

    public static boolean containsTertiaryStructureData(File paradiseProject) {
        if (!IOUtils.isParadiseProject(paradiseProject)) {
            return false;
        }
        return new File(paradiseProject, TertiaryStructure.class.getSimpleName() + "s").listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".rnaml");
            }
        }).length > 0;
    }

    public static boolean containsSecondaryStructureData(File paradiseProject) {
        if (!IOUtils.isParadiseProject(paradiseProject)) {
            return false;
        }
        return new File(paradiseProject, SecondaryStructure.class.getSimpleName() + "s").listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".rnaml");
            }
        }).length > 0;
    }

    public static void deleteDirectory(File directory) {
        IOUtils.clearDirectory(directory);
        directory.delete();
    }

    public static void clearDirectory(File directory) {
        for (File f : directory.listFiles()) {
            if (f.isDirectory()) {
                IOUtils.deleteDirectory(f);
                continue;
            }
            f.delete();
        }
    }

    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                if (children[i].equals(".svn")) continue;
                IOUtils.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static File createTemporaryFile(String fileName) throws IOException {
        File f = new File(Paradise.getTmpDirectory(), fileName + System.nanoTime());
        f.deleteOnExit();
        return f;
    }

    public static void extractArchivedFile(String destDir, File archivedFile) throws IOException {
        JarFile jar = new JarFile(archivedFile);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry file = entries.nextElement();
            File f = new File(destDir + File.separator + file.getName());
            if (file.isDirectory()) {
                f.mkdir();
                continue;
            }
            InputStream is = jar.getInputStream(file);
            FileOutputStream fos = new FileOutputStream(f);
            while (is.available() > 0) {
                fos.write(is.read());
            }
            fos.close();
            is.close();
        }
    }

    private static class CommandLineProgressBar {
        private Timer timer;

        private CommandLineProgressBar() {
        }

        private void start() {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new ProgressionTask(), 0L, 2000L);
        }

        private void stop() {
            this.timer.cancel();
        }

        private class ProgressionTask
        extends TimerTask {
            private ProgressionTask() {
            }

            public void run() {
                System.out.print(".");
            }
        }
    }
}

