/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.utils;

import fr.unistra.ibmc.paradise.Paradise;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.prefs.BackingStoreException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ParadiseConfig {
    private static Document document;

    public static void parseConfigFile() throws BackingStoreException, IOException {
        File configFile = new File(Paradise.getParadiseDirectory(), "config.xml");
        if (!configFile.exists()) {
            Element root = new Element("paradise-config");
            document = new Document(root);
            Element algorithms = new Element("algorithms");
            root.addContent((Content)algorithms);
            Element algorithm = new Element("algorithm");
            algorithm.setAttribute("name", "rnaview");
            algorithms.addContent((Content)algorithm);
            algorithm = new Element("algorithm");
            algorithm.setAttribute("name", "foldalign-2.1.0");
            algorithms.addContent((Content)algorithm);
            algorithm = new Element("algorithm");
            algorithm.setAttribute("name", "rnafold-1.7");
            algorithms.addContent((Content)algorithm);
            algorithm = new Element("algorithm");
            algorithm.setAttribute("name", "rnadistance-1.7");
            algorithms.addContent((Content)algorithm);
            algorithm = new Element("algorithm");
            algorithm.setAttribute("name", "rnaplot-1.7");
            algorithms.addContent((Content)algorithm);
            ParadiseConfig.save();
        } else {
            SAXBuilder builder = new SAXBuilder();
            try {
                document = builder.build(configFile);
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getAlgorithmsPath() {
        StringBuffer binariesPath = new StringBuffer(Paradise.getInstallPath()).append("algorithms").append(System.getProperty("file.separator"));
        String osName = System.getProperty("os.name").replaceAll(" ", "").toLowerCase();
        String osArch = System.getProperty("os.arch").replaceAll(" ", "").toLowerCase();
        return binariesPath.append(osName).append(System.getProperty("file.separator")).append(osArch).append(System.getProperty("file.separator")).toString();
    }

    public static void save() throws BackingStoreException, IOException {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        FileWriter writer = new FileWriter(new File(Paradise.getParadiseDirectory(), "config.xml"));
        outputter.output(document, (Writer)writer);
        writer.close();
    }
}

