/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructureDisplay;
import fr.unistra.ibmc.paradise.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.tools.component.ParadiseTask;
import fr.unistra.ibmc.s2s.S2S;
import fr.unistra.ibmc.s2s.SecondaryStructureNavigator;
import fr.unistra.ibmc.s2s.UserSelection;
import fr.unistra.ibmc.s2s.rnalign.features.Alignment;
import fr.unistra.ibmc.s2s.rnalign.graphics.AlignmentCanvas;
import fr.unistra.ibmc.s2s.rnalign.graphics.AlignmentView;
import fr.unistra.ibmc.s2s.rnalign.graphics.SequencesList;
import fr.unistra.ibmc.s2s.ssviewer.features.Model2D;
import fr.unistra.ibmc.s2s.ssviewer.graphics.Rna2DViewer;
import fr.unistra.ibmc.s2s.ssviewer.graphics.SecondaryCanvas;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;

public class Mediator {
    private JButton alignmentViewOptionsButton;
    private AlignmentCanvas canvas;
    private SequencesList sequencesList;
    private S2S s2s;
    private JButton redoButton;
    private JButton undoButton;
    private int horizontalStep = 25;
    private Rna2DViewer rna2dViewer;
    private SecondaryStructureNavigator secondaryStructureNavigator;
    private boolean linked = true;
    private List<UserSelection> userSelections;
    private byte selectionMode = 0;
    private Molecule linkMolecule = null;
    private int linkPosition = -1;

    public Mediator(S2S s2s) {
        this.s2s = s2s;
        this.userSelections = new ArrayList<UserSelection>();
    }

    public void addUserSelection(UserSelection selection) {
        this.userSelections.add(selection);
        this.secondaryStructureNavigator.addUserSelection(selection);
    }

    public void setPreferencesPanel(boolean areSecondaryInteractionsDisplayed, boolean areTertiaryInteractionsDisplayed, boolean isLinkedToNextView, int sequencesDisplayed) {
        this.s2s.setPreferencesPanel(areSecondaryInteractionsDisplayed, areTertiaryInteractionsDisplayed, isLinkedToNextView, sequencesDisplayed);
    }

    public SecondaryStructureNavigator getSecondaryStructureNavigator() {
        return this.secondaryStructureNavigator;
    }

    public SecondaryCanvas getSecondaryCanvas() {
        return this.rna2dViewer.getSecondaryCanvas();
    }

    public void insertNodeIntoExplorer(Object parentNode, Object newNode) {
        this.secondaryStructureNavigator.insertNode(parentNode, newNode);
    }

    public void removeNodeFromExplorer(Object parentNode, Object childNode) {
        this.secondaryStructureNavigator.removeNode(parentNode, childNode);
    }

    public void updateNodeInExplorer(Object parentNode, Object childNode) {
        this.secondaryStructureNavigator.updateNode(parentNode, childNode);
    }

    public void selectNodeInSecondaryStructureExplorer(Object o) {
        this.secondaryStructureNavigator.selectNode(o);
    }

    public void clearSession() {
        this.canvas.clearDisplay();
        this.userSelections.clear();
        this.sequencesList.clearList();
        this.rna2dViewer.clearDisplay();
        this.secondaryStructureNavigator.updateNavigator();
        System.gc();
    }

    public void setSecondaryStructureNavigator(SecondaryStructureNavigator secondaryStructureNavigator) {
        this.secondaryStructureNavigator = secondaryStructureNavigator;
    }

    public Rna2DViewer getRna2dViewer() {
        return this.rna2dViewer;
    }

    public void setRna2dViewer(Rna2DViewer rna2dViewer) {
        this.rna2dViewer = rna2dViewer;
    }

    public void setAlignmentViewOptionsButton(JButton alignmentViewOptionsButton) {
        this.alignmentViewOptionsButton = alignmentViewOptionsButton;
    }

    public JButton getAlignmentViewOptionsButton() {
        return this.alignmentViewOptionsButton;
    }

    public void setRedoButton(JButton redoButton) {
        this.redoButton = redoButton;
    }

    public void setUndoButton(JButton undoButton) {
        this.undoButton = undoButton;
    }

    public void setRedoUndoButtonsState() {
        if (this.canvas.getMainAlignment().hasMoreRedo()) {
            this.redoButton.setEnabled(true);
        } else {
            this.redoButton.setEnabled(false);
        }
        if (this.canvas.getMainAlignment().hasMoreUndo()) {
            this.undoButton.setEnabled(true);
        } else {
            this.undoButton.setEnabled(false);
        }
    }

    void setMainAlignment(final StructuralAlignment alignment, final Molecule referenceMolecule, final SecondaryStructure referenceStructure) {
        new ParadiseTask(this.s2s, this.s2s.getProgressMonitor()){

            protected Void doInBackground() throws InterruptedException {
                this.setMessage("Construction of the alignment view");
                Mediator.this.s2s.getProgressMonitor().startAnimation();
                Alignment a = new Alignment(Mediator.this.s2s, alignment, referenceMolecule, referenceStructure);
                Mediator.this.canvas.setMainAlignment(a);
                Mediator.this.s2s.getProgressMonitor().stopAnimation();
                this.finished();
                return null;
            }
        }.execute();
    }

    public void setSequencesList(SequencesList sequencesList) {
        this.sequencesList = sequencesList;
    }

    public SequencesList getSequencesList() {
        return this.sequencesList;
    }

    public void setAlignmentCanvas(AlignmentCanvas canvas) {
        this.canvas = canvas;
    }

    public AlignmentCanvas getAlignmentCanvas() {
        return this.canvas;
    }

    public void isLinked(boolean linked) {
        this.linked = linked;
    }

    public boolean isLinked() {
        return this.linked;
    }

    public AlignmentView getSelectedAlignmentView() {
        return this.getAlignmentCanvas().getSelectedView();
    }

    public Molecule getMoleculeAt(int index) {
        return this.getAlignmentCanvas().getMainAlignment().getBiologicalSequenceAt(index).getMolecule();
    }

    public S2S getS2s() {
        return this.s2s;
    }

    public void setHorizontalStep(int step) {
        this.horizontalStep = step;
    }

    public int getHorizontalStep() {
        return this.horizontalStep;
    }

    public void setRna2DViewer(Rna2DViewer rna2DViewer) {
        this.rna2dViewer = rna2DViewer;
    }

    public Model2D getCurrentModel2D() {
        return this.getSecondaryCanvas().getModel2D();
    }

    public SecondaryCanvas setModel(SecondaryStructure ss, SecondaryStructureDisplay ssd) {
        this.getSecondaryCanvas().setModel2D(ss, ssd);
        this.secondaryStructureNavigator.updateNavigator();
        this.s2s.activeSecondaryStructureNavigator();
        this.s2s.activeRna2DViewer();
        return null;
    }

    public byte getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(byte selectionMode) {
        this.selectionMode = selectionMode;
    }

    void setToBeLinked(Molecule molecule, int position) {
        this.linkMolecule = molecule;
        this.linkPosition = position;
    }

    void clearToBeLinked() {
        this.linkMolecule = null;
        this.linkPosition = -1;
    }

    public boolean isToBeLinked(Molecule molecule, int position) {
        return this.linkMolecule == molecule && this.linkPosition == position;
    }
}

