/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import fr.unistra.ibmc.paradise.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.Paradise;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.MainParadiseFeature;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.RNA;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.analysis.NoSolutionException;
import fr.unistra.ibmc.paradise.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.Helix;
import fr.unistra.ibmc.paradise.core.features.IdentityFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructureDisplay;
import fr.unistra.ibmc.paradise.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.core.io.BPSeqFileIO;
import fr.unistra.ibmc.paradise.core.io.CTFileIO;
import fr.unistra.ibmc.paradise.core.io.FastaFileIO;
import fr.unistra.ibmc.paradise.core.io.PDBFileIO;
import fr.unistra.ibmc.paradise.core.io.ParadiseFileIO;
import fr.unistra.ibmc.paradise.core.io.ParadiseProjectIO;
import fr.unistra.ibmc.paradise.core.io.StockholmFileIO;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.paradise.tools.AbstractParadiseGUITool;
import fr.unistra.ibmc.paradise.tools.AbstractParadiseToolAgent;
import fr.unistra.ibmc.paradise.tools.ParadiseTool;
import fr.unistra.ibmc.paradise.tools.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.tools.component.DefaultProgressMonitor;
import fr.unistra.ibmc.paradise.tools.component.FileParsingTask;
import fr.unistra.ibmc.paradise.tools.component.MemoryMonitor;
import fr.unistra.ibmc.paradise.tools.component.OpenFileFilter;
import fr.unistra.ibmc.paradise.tools.component.ParadiseTask;
import fr.unistra.ibmc.paradise.tools.component.ProgressMonitor;
import fr.unistra.ibmc.paradise.utils.GeneralUtils;
import fr.unistra.ibmc.paradise.utils.IOUtils;
import fr.unistra.ibmc.paradise.utils.VTextIcon;
import fr.unistra.ibmc.s2s.Mediator;
import fr.unistra.ibmc.s2s.S2SAgent;
import fr.unistra.ibmc.s2s.S2SAlignmentParser;
import fr.unistra.ibmc.s2s.S2SConfig;
import fr.unistra.ibmc.s2s.SecondaryStructureNavigator;
import fr.unistra.ibmc.s2s.SplashScreen;
import fr.unistra.ibmc.s2s.UserSelection;
import fr.unistra.ibmc.s2s.behaviours.RNAMotifRequestAnswerBehaviour;
import fr.unistra.ibmc.s2s.behaviours.SecondaryStructureDrawingRequestAnswerBehaviour;
import fr.unistra.ibmc.s2s.behaviours.SecondaryStructurePredictionBeforeStructuralAlignmentAnswerBehaviour;
import fr.unistra.ibmc.s2s.behaviours.SecondaryStructurePredictionRequestAnswerBehaviour;
import fr.unistra.ibmc.s2s.behaviours.StructuralAlignmentRequestAnswerBehaviour;
import fr.unistra.ibmc.s2s.behaviours.TertiaryStructureAnnotationRequestAnswerBehaviour;
import fr.unistra.ibmc.s2s.rnalign.features.Alignment;
import fr.unistra.ibmc.s2s.rnalign.features.BiologicalSequence;
import fr.unistra.ibmc.s2s.rnalign.features.Symbol;
import fr.unistra.ibmc.s2s.rnalign.graphics.AlignmentCanvas;
import fr.unistra.ibmc.s2s.rnalign.graphics.AlignmentView;
import fr.unistra.ibmc.s2s.rnalign.graphics.SequencesList;
import fr.unistra.ibmc.s2s.rnalign.utils.IoUtils;
import fr.unistra.ibmc.s2s.rnalign.utils.RessourcesUtils;
import fr.unistra.ibmc.s2s.ssviewer.features.BaseBaseInteraction2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Interaction2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Residue2D;
import fr.unistra.ibmc.s2s.ssviewer.graphics.Rna2DViewer;
import fr.unistra.ibmc.s2s.tertiaryviewers.ChimeraDriver;
import fr.unistra.ibmc.s2s.tertiaryviewers.PyMOLDriver;
import fr.unistra.ibmc.s2s.tertiaryviewers.TertiaryViewerDriver;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyShell;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.gui.GuiEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.application.Application;
import org.jdesktop.swingworker.SwingWorker;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.VerticalLayout;
import org.jdesktop.swingx.decorator.AlternateRowHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.noos.xing.mydoggy.DockedTypeDescriptor;
import org.noos.xing.mydoggy.PushAwayMode;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowManager;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2S
extends AbstractParadiseGUITool {
    public static final String releaseName = "S2S 2.0, Release Candidate 3";
    private Mediator mediator;
    private SequencesList sequencesList;
    private PreferencesPanel preferencesPanel;
    private Rna2DViewer rna2dViewer;
    private TertiaryViewersToolBar tertiaryViewersToolBar;
    private List<TertiaryViewerDriver> drivers;
    private GroovyShell groovyShell;
    private MessageBar messageBar;
    private PluginsMenu plugins;
    private ToolWindowManager toolWindowManager;
    private static File backup = new File(new File(S2S.getUserDirPath()), "rnalign.backup");
    private IdentityFeatureFactory identityFeatureFactory;
    public static final byte SELECT_STRUCTURAL_DOMAIN = 0;
    public static final byte SELECT_INTERACTION = 1;
    public static final byte SELECT_RESIDUE = 2;
    private ToolWindow ssExplorer;
    private ToolWindow ssViewer;

    public static boolean updateS2S() {
        try {
            URL updates = new URL("http://ftp.bioinformatics.org/pub/s2s/updates.xml");
            URLConnection urlConnection = updates.openConnection();
            urlConnection.setUseCaches(false);
            urlConnection.connect();
            InputStream stream = urlConnection.getInputStream();
            SAXBuilder sxb = new SAXBuilder();
            Document doc = sxb.build(stream);
            List versions = doc.getRootElement().getChildren("version");
            if (!versions.isEmpty()) {
                if (releaseName.equals(((Element)versions.get(0)).getChild("name").getText())) {
                    JOptionPane.showMessageDialog(null, "S2S is up to date");
                    return false;
                }
                new UpdateFrame(versions);
                return true;
            }
            JOptionPane.showMessageDialog(null, "S2S is up to date");
            return false;
        }
        catch (Exception e) {
            ErrorInfo errorInfo = new ErrorInfo("Error", "Problem during the update", null, null, (Throwable)e, Level.SEVERE, null);
            JXErrorPane.showDialog(null, (ErrorInfo)errorInfo);
            return false;
        }
    }

    public S2S(ParadiseWorkingSession workingSession) {
        super(releaseName, workingSession);
    }

    public Window getWindow() {
        return this.window;
    }

    public void activeSecondaryStructureNavigator() {
        this.ssExplorer.setActive(true);
    }

    public void activeRna2DViewer() {
        this.ssViewer.setActive(true);
    }

    @Override
    public ProgressMonitor getProgressMonitor() {
        return this.messageBar;
    }

    public void synchronize() {
        Alignment a = this.mediator.getAlignmentCanvas().getMainAlignment();
        if (a != null) {
            a.updateStructuralAlignment();
        }
    }

    public MainParadiseFeature getCurrentFeature() {
        if (this.mediator == null || this.mediator.getAlignmentCanvas() == null || this.mediator.getAlignmentCanvas().getMainAlignment() == null) {
            return null;
        }
        return this.mediator.getAlignmentCanvas().getMainAlignment().getStructuralAlignment();
    }

    public void printState(String state) {
        this.messageBar.printState(state);
    }

    public boolean isConnected() {
        return this.agent != null;
    }

    public void setS2SLastSavePath(File f) {
        Preferences prefs = Preferences.userRoot().node("S2S");
        prefs.put("S2SLastSavePath", f.getPath());
    }

    public String getS2SLastSavePath() {
        Preferences prefs = Preferences.userRoot().node("S2S");
        return prefs.get("S2SLastSavePath", "myFiles");
    }

    public void setS2SLastLoadPath(File f) {
        Preferences prefs = Preferences.userRoot().node("S2S");
        prefs.put("S2SLastLoadPath", f.getPath());
    }

    public String getS2SLastLoadPath() {
        Preferences prefs = Preferences.userRoot().node("S2S");
        return prefs.get("S2SLastLoadPath", "myFiles");
    }

    public static String getPluginsPath() {
        String path = new StringBuffer(S2S.getUserDirPath()).append("plugins").append(System.getProperty("file.separator")).toString();
        File f = new File(path);
        if (!f.exists()) {
            f.mkdir();
        }
        return path;
    }

    protected void startup() {
        this.window = new JXFrame(this.getDescription());
        JXFrame cfr_ignored_0 = (JXFrame)this.window;
        ((JXFrame)this.window).setDefaultCloseOperation(0);
        this.window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (JOptionPane.showConfirmDialog(null, "Are you sure you want to exit S2S?", "Confirm exit", 0) == 0) {
                    try {
                        S2SConfig.save();
                    }
                    catch (BackingStoreException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    System.exit(0);
                }
            }
        });
        this.groovyShell = new GroovyShell();
        MyDoggyToolWindowManager myDoggyToolWindowManager = new MyDoggyToolWindowManager();
        this.toolWindowManager = myDoggyToolWindowManager;
        this.toolWindowManager.getToolWindowManagerDescriptor().setPushAwayMode(PushAwayMode.HORIZONTAL);
        this.mediator = new Mediator(this);
        this.rna2dViewer = new Rna2DViewer(this.mediator, this.workingSession);
        ((JFrame)this.window).setTitle("S2S: Sequence TO Structure");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.messageBar = new MessageBar();
        this.sequencesList = new SequencesList(this.mediator, this.workingSession);
        this.mediator.setSequencesList(this.sequencesList);
        JScrollPane sequencesListScrollPane = new JScrollPane((Component)((Object)this.sequencesList));
        sequencesListScrollPane.getViewport().setBackground(Color.WHITE);
        sequencesListScrollPane.setPreferredSize(new Dimension(300, (int)(screenSize.getHeight() * 0.8)));
        AlignmentCanvas alignmentCanvas = new AlignmentCanvas(this.mediator, this.workingSession, (int)screenSize.getWidth(), (int)screenSize.getHeight());
        this.rna2dViewer.addSelectionListener(alignmentCanvas);
        alignmentCanvas.addSelectionListener(this.rna2dViewer);
        JScrollPane alignmentCanvasScrollPane = new JScrollPane(alignmentCanvas);
        this.preferencesPanel = new PreferencesPanel();
        JScrollPane preferencesPanelScrollPane = new JScrollPane((Component)((Object)this.preferencesPanel));
        preferencesPanelScrollPane.getViewport().setBackground(Color.WHITE);
        preferencesPanelScrollPane.setPreferredSize(new Dimension(300, (int)(screenSize.getHeight() * 0.8)));
        LWMatricesPanel lwMatricesPanel = new LWMatricesPanel();
        JScrollPane lwMatricesPanelScrollPane = new JScrollPane((Component)((Object)lwMatricesPanel));
        lwMatricesPanelScrollPane.getViewport().setBackground(Color.WHITE);
        lwMatricesPanelScrollPane.setPreferredSize(new Dimension(300, (int)(screenSize.getHeight() * 0.8)));
        ComputedAlignmentPanel computedAlignmentPanel = new ComputedAlignmentPanel();
        JScrollPane computedAlignmentPanelScrollPane = new JScrollPane((Component)((Object)computedAlignmentPanel));
        computedAlignmentPanelScrollPane.getViewport().setBackground(Color.WHITE);
        computedAlignmentPanelScrollPane.setPreferredSize(new Dimension(300, (int)(screenSize.getHeight() * 0.8)));
        SecondaryStructureNavigator navigator = new SecondaryStructureNavigator(this.mediator);
        navigator.addSelectionListener(alignmentCanvas);
        alignmentCanvas.addSelectionListener(navigator);
        navigator.addSelectionListener(this.rna2dViewer);
        this.rna2dViewer.addSelectionListener(navigator);
        JScrollPane navigatorScrollPane = new JScrollPane((Component)((Object)navigator));
        navigatorScrollPane.getViewport().setBackground(Color.WHITE);
        this.toolWindowManager.getContentManager().addContent("Alignment", "alignment", null, alignmentCanvasScrollPane);
        this.ssExplorer = this.toolWindowManager.registerToolWindow("2DExplorer", "2D Explorer", null, navigatorScrollPane, ToolWindowAnchor.LEFT);
        DockedTypeDescriptor descriptor = (DockedTypeDescriptor)this.ssExplorer.getTypeDescriptor(ToolWindowType.DOCKED);
        descriptor.setDockLength(200);
        descriptor.setPreviewEnabled(false);
        ToolWindow toolWindow = this.toolWindowManager.registerToolWindow("Sequences", "Sequences", null, sequencesListScrollPane, ToolWindowAnchor.RIGHT);
        descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        descriptor.setDockLength(300);
        descriptor.setPreviewEnabled(false);
        toolWindow = this.toolWindowManager.registerToolWindow("Preferences", "Preferences", null, preferencesPanelScrollPane, ToolWindowAnchor.RIGHT);
        descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        descriptor.setDockLength(300);
        descriptor.setPreviewEnabled(false);
        toolWindow = this.toolWindowManager.registerToolWindow("LWMatrices", "LWMatrices", null, lwMatricesPanelScrollPane, ToolWindowAnchor.RIGHT);
        descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        descriptor.setDockLength(300);
        descriptor.setPreviewEnabled(false);
        this.ssViewer = this.toolWindowManager.registerToolWindow("2DViewer", "2DViewer", null, this.rna2dViewer, ToolWindowAnchor.BOTTOM);
        descriptor = (DockedTypeDescriptor)this.ssViewer.getTypeDescriptor(ToolWindowType.DOCKED);
        descriptor.setDockLength(300);
        descriptor.setPreviewEnabled(false);
        toolWindow = this.toolWindowManager.registerToolWindow("News", "News", null, (Component)((Object)new NewsPanel()), ToolWindowAnchor.BOTTOM);
        descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        descriptor.setDockLength(50);
        descriptor.setPreviewEnabled(false);
        for (ToolWindow window : this.toolWindowManager.getToolWindows()) {
            window.setAvailable(true);
        }
        JPanel toolbars = new JPanel();
        toolbars.setLayout(new BorderLayout());
        toolbars.add((Component)new S2SToolBar(this.mediator), "North");
        toolbars.add((Component)this.rna2dViewer.getToolbar(), "Center");
        toolbars.add((Component)new TertiaryViewersToolBar(), "South");
        this.window.add((Component)toolbars, "North");
        this.window.add((Component)myDoggyToolWindowManager, "Center");
        this.window.add((Component)this.messageBar, "South");
        ((JXFrame)this.window).setJMenuBar((JMenuBar)new S2SMenu());
        this.window.pack();
        this.window.setLocation((int)((double)screenSize.width * 0.1), (int)((double)screenSize.height * 0.025));
        this.window.setVisible(true);
        this.drivers = new ArrayList<TertiaryViewerDriver>();
        if (backup.exists()) {
            if (JOptionPane.showConfirmDialog(null, "Do you want to recover your last working session?", "Previous Session Recovery", 2, 2) == 0) {
                this.workingSession.restorePreviousWorkingSession();
                this.getProgressMonitor().printMessage("Project " + this.workingSession.getCurrentParadiseProject().getName() + " opened");
                ((JFrame)this.window).setTitle(((JFrame)this.window).getTitle() + " - project " + this.workingSession.getCurrentParadiseProject().getName());
                JOptionPane.showMessageDialog(null, "Previous working session recovered");
            } else {
                backup.delete();
            }
        }
        class Backup
        extends SwingWorker
        implements ActionListener {
            private Timer timer;

            Backup() {
            }

            protected Object doInBackground() throws Exception {
                this.timer = new Timer(900000, this);
                this.timer.start();
                return null;
            }

            public void actionPerformed(ActionEvent e) {
                if (S2S.this.workingSession.getCurrentParadiseProject() != null) {
                    S2S.this.synchronize();
                    if (!backup.exists()) {
                        try {
                            backup.createNewFile();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    Object var2_3 = null;
                }
            }
        }
        new Backup().execute();
        this.identityFeatureFactory = this.createIdentityFeatureFactory();
    }

    public Mediator getMediator() {
        return this.mediator;
    }

    public AlignmentCanvas getAlignmentCanvas() {
        return this.mediator.getAlignmentCanvas();
    }

    public void residuesSelected(ParadiseTool source, Collection<Residue> residues) {
        if (source == this || !this.mediator.isLinked() || this.mediator.getAlignmentCanvas().getMainAlignment() == null) {
            return;
        }
        this.mediator.getAlignmentCanvas().clearSelectedPositions();
        for (Residue r : residues) {
            for (BiologicalSequence s : this.mediator.getAlignmentCanvas().getMainAlignment().getBiologicalSequences()) {
                if (!s.getMolecule().getParadiseID().equals(r.getMoleculeId())) continue;
                s.addSelectedPosition(r.getAbsolutePosition());
            }
        }
        if (residues.size() > 0) {
            this.mediator.getAlignmentCanvas().repaint();
        }
    }

    public void loadRNASecondaryStructure(SecondaryStructure ss) {
        SecondaryStructureDisplay display = ss.getSecondaryStructureDisplay();
        if (display == null) {
            GuiEvent ev = new GuiEvent((Object)this, 3);
            ArrayList<Molecule> molecules = new ArrayList<Molecule>();
            for (Molecule m : ss.getMolecules()) {
                if (!RNA.class.isInstance(m)) continue;
                m.removeAllSelectedFeatures();
                molecules.add(m);
                m.addSelectedFeature(ss);
            }
            ev.addParameter((Object)new SecondaryStructureDrawingRequestAnswerBehaviour(molecules, new Parameters()));
            ((AbstractParadiseToolAgent)this.agent).postGuiEvent(ev);
        } else {
            List<StructuralAlignment> alignments = ss.getLinkedStructuralAlignments();
            if (!alignments.isEmpty()) {
                StructuralAlignment al = alignments.get(0);
                Collection<Molecule> alignmentMolecules = al.getMolecules();
                for (Molecule m : ss.getMolecules()) {
                    if (!alignmentMolecules.contains(m)) continue;
                    this.mediator.setMainAlignment(al, m, ss);
                    this.mediator.setModel(ss, display);
                    break;
                }
            } else {
                ArrayList<Molecule> molecules = new ArrayList<Molecule>(ss.getMolecules());
                Molecule m = null;
                m = molecules.size() > 1 ? (Molecule)JOptionPane.showInputDialog(this.window, "Choose a molecule", "Choose a molecule", -1, null, molecules.toArray(), molecules.get(0)) : (Molecule)molecules.get(0);
                if (m != null) {
                    StructuralAlignment sa = this.identityFeatureFactory.createStructuralAligment(new ParadiseID(), "Structural Alignment", Source.getGraphicalToolAsSource(this.mediator.getS2s().getDescription()));
                    this.identityFeatureFactory.createStructuralIdentity(sa, "full molecule", m, new Location(1, m.getLength()));
                    sa.setName("Structural Alignment " + Paradise.mainFeaturesCreatedCount++);
                    ss.linkStructuralAlignment(sa);
                    this.mediator.setMainAlignment(sa, m, ss);
                }
                this.mediator.setModel(ss, display);
            }
        }
    }

    public void setPreferencesPanel(boolean areSecondaryInteractionsDisplayed, boolean areTertiaryInteractionsDisplayed, boolean isLinkedToNextView, int sequencesDisplayed) {
        this.preferencesPanel.secondaryInteractionsDisplayed.setSelected(areSecondaryInteractionsDisplayed);
        this.preferencesPanel.tertiaryInteractionsDisplayed.setSelected(areTertiaryInteractionsDisplayed);
        this.preferencesPanel.linkedToNextView.setSelected(isLinkedToNextView);
        this.preferencesPanel.spinner.setValue(sequencesDisplayed);
    }

    public static String getUserDirPath() {
        return new StringBuffer(System.getProperty("user.home")).append(System.getProperty("file.separator")).append(".s2s").append(System.getProperty("file.separator")).toString();
    }

    public FileParsingTask parseFile(File f, ParadiseFileIO parser) {
        FileParsingTask task = new FileParsingTask(this, f, parser, this.messageBar, this.workingSession);
        task.execute();
        return task;
    }

    public void save(final File paradiseProject) {
        final ArrayList<MainParadiseFeature> features = new ArrayList<MainParadiseFeature>();
        features.add(this.getCurrentFeature());
        ParadiseTask t = new ParadiseTask(this, this.messageBar){

            protected Object doInBackground() {
                try {
                    this.setMessage("Synchronize data");
                    S2S.this.synchronize();
                    this.setMessage("End of synchronization");
                    this.setMessage("Save data");
                    ParadiseProjectIO.saveWorkingSession(paradiseProject, features);
                    this.finished();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }
        };
        t.execute();
    }

    public void saveAs(File paradiseProject) {
        String name = JOptionPane.showInputDialog("Please choose a name for your alignment", (Object)this.getCurrentFeature().getName());
        if (name != null && name.length() != 0) {
            File f = this.getCurrentFeature().getAssociatedFile();
            this.getCurrentFeature().setName(name);
            ArrayList<MainParadiseFeature> features = new ArrayList<MainParadiseFeature>();
            features.add(this.getCurrentFeature());
            new ParadiseTask(this, this.messageBar){

                protected Object doInBackground() {
                    return null;
                }
            }.execute();
        } else {
            JOptionPane.showMessageDialog(null, "This name is not correct, please retry", "Error", 0);
        }
    }

    public static String getInstallPath() {
        return S2S.class.getProtectionDomain().getCodeSource().getLocation().getPath().split("s2s.jar")[0];
    }

    public static void main(String[] args) throws BackingStoreException, IOException, JDOMException {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (InstantiationException e) {
        }
        catch (ClassNotFoundException e) {
        }
        catch (UnsupportedLookAndFeelException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        S2SConfig.parseConfigFile();
        new SplashScreen();
    }

    private class SelectDatabasesFrame
    extends JFrame {
        private JXTable table;
        private Map<String, String> ncbiDatabases;

        private SelectDatabasesFrame() {
            super("Select Databases");
            this.setLayout(new BorderLayout());
            this.ncbiDatabases = new HashMap<String, String>();
            this.ncbiDatabases.put("Caenorhabditis_elegans", "Caenorhabditis Elegans");
            HashMap<String, String> ncbiDatabasesToDownload = new HashMap<String, String>(this.ncbiDatabases);
            this.table = new JXTable();
            this.table.setBackground(Color.WHITE);
            this.table.setHighlighters(new Highlighter[]{AlternateRowHighlighter.quickSilver});
            this.table.setSortable(false);
            ArrayList<String> directoriesNames = new ArrayList<String>();
            for (File dir : Paradise.getDatabasesDirectory().listFiles(new java.io.FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }
            })) {
                directoriesNames.add(dir.getName());
                ncbiDatabasesToDownload.remove(dir.getName());
            }
            Collections.sort(directoriesNames, new Comparator(){

                public int compare(Object o, Object o1) {
                    return ((String)o).compareTo((String)o1);
                }
            });
            ArrayList<String> ncbiDatabasesNames = new ArrayList<String>(this.ncbiDatabases.values());
            Collections.sort(ncbiDatabasesNames, new Comparator(){

                public int compare(Object o, Object o1) {
                    return ((String)o).compareTo((String)o1);
                }
            });
            Object[][] objects = new Object[directoriesNames.size()][3];
            for (int i = 0; i < directoriesNames.size(); ++i) {
                objects[i][0] = false;
                if (this.ncbiDatabases.keySet().contains(directoriesNames.get(i))) {
                    objects[i][1] = this.ncbiDatabases.get(i);
                    objects[i][2] = "Update";
                    continue;
                }
                objects[i][1] = directoriesNames.get(i);
                objects[i][2] = "N/A";
            }
            this.table.setModel((TableModel)new DefaultTableModel(objects, new String[]{"Search", "Database Name", "Data"}){
                Class[] types;
                boolean[] canEdit;
                {
                    super(x0, x1);
                    this.types = new Class[]{Boolean.class, String.class, String.class};
                    this.canEdit = new boolean[]{true, false, true};
                }

                public Class getColumnClass(int columnIndex) {
                    return this.types[columnIndex];
                }

                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    if (columnIndex == 0) {
                        return !"Get".equals(this.getValueAt(rowIndex, 2));
                    }
                    return this.canEdit[columnIndex];
                }
            });
            this.table.getColumn((Object)"Data").setCellRenderer(new ButtonRenderer());
            this.table.getColumn((Object)"Data").setCellEditor(new ButtonEditor(new JCheckBox()));
            this.table.getColumn((Object)"Data").setMaxWidth(150);
            this.add((Component)new JScrollPane((Component)this.table), "Center");
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.setLayout(new FlowLayout());
            JButton button = new JButton("Next Step");
            buttonsPanel.add(button);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ArrayList<String> databaseSelected = new ArrayList<String>();
                    for (int i = 0; i < SelectDatabasesFrame.this.table.getRowCount(); ++i) {
                        if (!((Boolean)SelectDatabasesFrame.this.table.getModel().getValueAt(i, 0)).booleanValue()) continue;
                        databaseSelected.add((String)SelectDatabasesFrame.this.table.getModel().getValueAt(i, 1));
                    }
                    if (databaseSelected.isEmpty()) {
                        JOptionPane.showMessageDialog(S2S.this.window, "No Database Selected!!");
                        SelectDatabasesFrame.this.setVisible(true);
                    } else {
                        RNAMotifDescrFileFrame f = new RNAMotifDescrFileFrame(databaseSelected);
                        SelectDatabasesFrame.this.dispose();
                        f.setVisible(true);
                    }
                }
            });
            button = new JButton("Cancel");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SelectDatabasesFrame.this.dispose();
                }
            });
            buttonsPanel.add(button);
            this.add((Component)buttonsPanel, "South");
            this.pack();
            GeneralUtils.centerOnScreen(this);
            this.setVisible(true);
        }

        public class ButtonEditor
        extends DefaultCellEditor {
            protected JButton button;
            private String label;
            private boolean isPushed;
            private int selectedRow;

            public ButtonEditor(JCheckBox checkBox) {
                super(checkBox);
                this.button = new JButton();
                this.button.setOpaque(true);
                this.button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ButtonEditor.this.fireEditingStopped();
                    }
                });
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                if (isSelected) {
                    this.button.setForeground(table.getSelectionForeground());
                    this.button.setBackground(table.getSelectionBackground());
                } else {
                    this.button.setForeground(table.getForeground());
                    this.button.setBackground(table.getBackground());
                }
                this.label = value == null ? "" : value.toString();
                this.button.setText(this.label);
                this.isPushed = true;
                this.selectedRow = row;
                return this.button;
            }

            public Object getCellEditorValue() {
                if (this.isPushed && !"N/A".equals(SelectDatabasesFrame.this.table.getValueAt(this.selectedRow, 2))) {
                    for (Map.Entry e : SelectDatabasesFrame.this.ncbiDatabases.entrySet()) {
                        if (!((String)e.getValue()).equals(SelectDatabasesFrame.this.table.getValueAt(this.selectedRow, 1))) continue;
                        System.out.println("ftp://ftp.ncbi.nih.gov/genomes/" + (String)e.getKey());
                        break;
                    }
                }
                this.isPushed = false;
                return new String(this.label);
            }

            public boolean stopCellEditing() {
                this.isPushed = false;
                return super.stopCellEditing();
            }

            protected void fireEditingStopped() {
                super.fireEditingStopped();
            }
        }

        public class ButtonRenderer
        extends JButton
        implements TableCellRenderer {
            public ButtonRenderer() {
                this.setOpaque(true);
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(UIManager.getColor("Button.background"));
                }
                this.setText(value == null ? "" : value.toString());
                return this;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RNAMotifDescrFileFrame
    extends JFrame {
        private JXTable table;

        private RNAMotifDescrFileFrame(final List<String> databasesSelected) {
            StructuralDomain sd;
            super("Searching Criteria");
            final SecondaryStructure ss = S2S.this.mediator.getAlignmentCanvas().getMainAlignment().getStructure2D3D().getReferenceSecondaryStructure();
            this.setLayout(new BorderLayout());
            this.table = new JXTable();
            this.table.setBackground(Color.WHITE);
            this.table.setHighlighters(new Highlighter[]{AlternateRowHighlighter.quickSilver});
            this.table.setSortable(false);
            this.add((Component)new JScrollPane((Component)this.table), "Center");
            ArrayList<StructuralDomain> domains = new ArrayList<StructuralDomain>();
            Molecule m = S2S.this.mediator.getAlignmentCanvas().getMainAlignment().getBiologicalReferenceSequence().getMolecule();
            for (int i = 1; i <= m.getLength(); i += sd.getLength()) {
                sd = ss.getEnclosingStructuralDomain(new Residue(i, m));
                if (domains.contains(sd)) continue;
                domains.add(sd);
            }
            Object[][] objects = new Object[domains.size()][3];
            for (int i = 0; i < domains.size(); ++i) {
                objects[i][0] = domains.get(i);
                objects[i][1] = ((StructuralDomain)domains.get(i)).getLength();
                objects[i][2] = ((StructuralDomain)domains.get(i)).getLength();
            }
            this.table.setModel((TableModel)new DefaultTableModel(objects, new String[]{"Structural Domain", "Min Length", "Max Length"}){
                Class[] types;
                boolean[] canEdit;
                {
                    super(x0, x1);
                    this.types = new Class[]{StructuralDomain.class, Integer.class, Integer.class};
                    this.canEdit = new boolean[]{false, true, true};
                }

                public Class getColumnClass(int columnIndex) {
                    return this.types[columnIndex];
                }

                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return this.canEdit[columnIndex];
                }
            });
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    StructuralDomain sdSelected = (StructuralDomain)RNAMotifDescrFileFrame.this.table.getModel().getValueAt(RNAMotifDescrFileFrame.this.table.getSelectedRow(), 0);
                    S2S.this.mediator.getAlignmentCanvas().structuralDomainSelected(sdSelected, false);
                    S2S.this.mediator.getRna2dViewer().structuralDomainSelected(sdSelected, false);
                    S2S.this.mediator.getSecondaryStructureNavigator().structuralDomainSelected(sdSelected, false);
                }
            });
            this.table.getColumn((Object)"Structural Domain").setCellRenderer(new TableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel label = null;
                    label = Helix.class.isInstance(o) ? new JLabel("Helix " + ((StructuralDomain)o).getName()) : new JLabel("SingleStrand " + ((StructuralDomain)o).getName());
                    label.setOpaque(true);
                    if (isSelected) {
                        label.setForeground(table.getSelectionForeground());
                        label.setBackground(table.getSelectionBackground());
                    } else {
                        label.setForeground(table.getForeground());
                        label.setBackground(table.getBackground());
                    }
                    return label;
                }
            });
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.setLayout(new FlowLayout());
            JButton button = new JButton("Search");
            buttonsPanel.add(button);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (String databaseSelected : databasesSelected) {
                        Parameters parameters = new Parameters();
                        Parameter p = new Parameter("database");
                        p.setValue(databaseSelected);
                        parameters.addParameter(p);
                        for (int i = 0; i < RNAMotifDescrFileFrame.this.table.getRowCount(); ++i) {
                            int minLength = (Integer)RNAMotifDescrFileFrame.this.table.getValueAt(i, 1);
                            int maxLength = (Integer)RNAMotifDescrFileFrame.this.table.getValueAt(i, 2);
                            minLength = minLength < 1 ? 1 : minLength;
                            maxLength = maxLength < minLength ? minLength : maxLength;
                            p = new Parameter("minlength");
                            p.setFeature((ParadiseFeature)RNAMotifDescrFileFrame.this.table.getValueAt(i, 0));
                            p.setValue("" + minLength);
                            parameters.addParameter(p);
                            p = new Parameter("maxlength");
                            p.setFeature((ParadiseFeature)RNAMotifDescrFileFrame.this.table.getValueAt(i, 0));
                            p.setValue("" + maxLength);
                            parameters.addParameter(p);
                        }
                        GuiEvent ev = new GuiEvent((Object)this, 8);
                        ArrayList<Molecule> molecules = new ArrayList<Molecule>();
                        for (Molecule m : ss.getMolecules()) {
                            m.removeAllSelectedFeatures();
                            m.addSelectedFeature(ss);
                            molecules.add(m);
                        }
                        ev.addParameter((Object)new RNAMotifRequestAnswerBehaviour(molecules, parameters));
                        ((S2SAgent)S2S.this.getAgent()).postGuiEvent(ev);
                    }
                }
            });
            button = new JButton("Cancel");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RNAMotifDescrFileFrame.this.dispose();
                }
            });
            buttonsPanel.add(button);
            this.add((Component)buttonsPanel, "South");
            this.pack();
            GeneralUtils.centerOnScreen(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateFrame
    extends JFrame {
        private JProgressBar progressBar;
        private JLabel title;
        private SwingWorker currentTask;
        private List<String> newFiles;
        private List<String> filesToDelete;

        private UpdateFrame(List<Object> versions) throws IOException {
            super("S2S Update");
            this.setDefaultCloseOperation(3);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            this.title = new JLabel("Searching first update...");
            panel.add((Component)this.title, "North");
            panel.add((Component)this.progressBar, "Center");
            panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            panel.setPreferredSize(new Dimension(400, 75));
            this.add(panel);
            this.pack();
            this.setResizable(false);
            GeneralUtils.centerOnScreen(this);
            this.setVisible(true);
            boolean foundCurrentVersion = false;
            for (int i = versions.size() - 1; i >= 0; --i) {
                File f;
                Element newVersion = (Element)versions.get(i);
                if (!foundCurrentVersion && newVersion.getChild("name").getText().equals(S2S.releaseName)) {
                    foundCurrentVersion = true;
                    continue;
                }
                if (!foundCurrentVersion) continue;
                if (newVersion.getAttribute("password") != null) {
                    String password = newVersion.getAttribute("password").getValue();
                    String userPassword = JOptionPane.showInputDialog(null, (Object)("Please enter a password to update to " + newVersion.getValue()));
                    if (userPassword == null || !password.equals(userPassword)) {
                        JOptionPane.showMessageDialog(null, "Wrong password");
                        this.dispose();
                        return;
                    }
                }
                this.newFiles = new ArrayList<String>();
                this.filesToDelete = new ArrayList<String>();
                this.setTitle("Update to " + newVersion.getChild("name").getText());
                for (Object _o : newVersion.getChild("files").getChildren("file")) {
                    Element file = (Element)_o;
                    if ("add".equals(file.getAttributeValue("action"))) {
                        this.title.setText("Add " + file.getChild("destination").getText());
                        this.updateFile(file.getChild("url").getText(), S2S.getInstallPath() + file.getChild("destination").getText().replace('/', System.getProperty("file.separator").charAt(0)));
                        continue;
                    }
                    if (!"delete".equals(file.getAttributeValue("action"))) continue;
                    this.title.setText("Delete " + file.getChild("destination").getText());
                    this.filesToDelete.add(S2S.getInstallPath() + file.getChild("destination").getText().replace('/', System.getProperty("file.separator").charAt(0)));
                }
                if (this.currentTask != null) {
                    while (!this.currentTask.isDone()) {
                    }
                }
                for (String newFile : this.newFiles) {
                    new File(newFile).delete();
                    new File(newFile + "_tmp").renameTo(new File(newFile));
                    if (!newFile.endsWith(".zip")) continue;
                    f = new File(newFile);
                    IOUtils.extractArchivedFile(f.getAbsolutePath(), f);
                }
                for (String fileToDelete : this.filesToDelete) {
                    f = new File(fileToDelete);
                    if (f.isDirectory()) {
                        IOUtils.deleteDirectory(f);
                        continue;
                    }
                    f.delete();
                }
            }
            JOptionPane.showMessageDialog(null, "S2S has been successfully updated to \"" + ((Element)versions.get(0)).getChild("name").getText() + "\"." + "\nRestart it to use the new version." + "\nRead the CHANGELOG file in the S2S directory for details about this update.");
            this.dispose();
        }

        private void updateFile(final String fileToDownload, final String destination) {
            if (this.currentTask != null) {
                while (!this.currentTask.isDone()) {
                }
            }
            this.currentTask = new SwingWorker(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void doInBackground() {
                    URLConnection connection = null;
                    InputStream is = null;
                    FileOutputStream destinationFile = null;
                    try {
                        int currentPos;
                        URL url = new URL(fileToDownload);
                        connection = url.openConnection();
                        int length = connection.getContentLength();
                        UpdateFrame.this.progressBar.setMinimum(0);
                        UpdateFrame.this.progressBar.setMaximum(length);
                        UpdateFrame.this.progressBar.setValue(0);
                        if (length == -1) {
                            throw new IOException("Empty File");
                        }
                        is = new BufferedInputStream(connection.getInputStream());
                        byte[] data = new byte[length];
                        int currentBit = 0;
                        for (currentPos = 0; currentPos < length; currentPos += currentBit) {
                            UpdateFrame.this.progressBar.setValue(currentPos);
                            currentBit = is.read(data, currentPos, data.length - currentPos);
                            if (currentBit == -1) break;
                        }
                        if (currentPos != length) {
                            throw new IOException("The file has not been recovered completely: " + currentPos + " on " + length + ")");
                        }
                        destinationFile = new FileOutputStream(destination + "_tmp");
                        destinationFile.write(data);
                        destinationFile.flush();
                        UpdateFrame.this.newFiles.add(destination);
                    }
                    catch (MalformedURLException e) {
                        System.err.println("Malformed URL : " + fileToDownload);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            is.close();
                            destinationFile.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    return null;
                }
            };
            this.currentTask.execute();
        }
    }

    private class S2SToolBar
    extends JToolBar {
        private Mediator mediator;

        S2SToolBar(final Mediator mediator) {
            this.mediator = mediator;
            int height = new ImageIcon(RessourcesUtils.getImage("plus.png")).getIconHeight();
            this.setBackground(Color.WHITE);
            this.setFloatable(false);
            JLabel toolBarName = new JLabel();
            toolBarName.setIcon(new VTextIcon(toolBarName, "AL", 2));
            this.add(toolBarName);
            this.add(Box.createHorizontalStrut(5));
            this.add(new ActionButton(null, "Create a view", new ImageIcon(RessourcesUtils.getImage("new-view.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (mediator.getAlignmentCanvas().getMainAlignment() != null) {
                        mediator.getAlignmentCanvas().addView();
                    }
                }
            }));
            this.add(new ActionButton(null, "Delete last view", new ImageIcon(RessourcesUtils.getImage("delete-view.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (mediator.getAlignmentCanvas().getAlignmentViews().size() > 0) {
                        AlignmentView lastView = mediator.getAlignmentCanvas().getAlignmentViews().get(mediator.getAlignmentCanvas().getAlignmentViews().size() - 1);
                        if (mediator.getAlignmentCanvas().getAlignmentViews().size() > 1) {
                            AlignmentView beforeLastView = mediator.getAlignmentCanvas().getAlignmentViews().get(mediator.getAlignmentCanvas().getAlignmentViews().size() - 2);
                            beforeLastView.setNextView(null);
                        }
                        mediator.getAlignmentCanvas().removeLastView();
                    }
                }
            }));
            this.add(new ActionButton(null, "Store current selection", new ImageIcon(RessourcesUtils.getImage("user.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Map<BiologicalSequence, List<Integer>> selectedPositions = mediator.getAlignmentCanvas().getSelectedPositions();
                    if (!selectedPositions.isEmpty()) {
                        String name = JOptionPane.showInputDialog(S2S.this.window, (Object)"Choose a selection name");
                        if (name == null || name.length() == 0) {
                            name = "No Name";
                        }
                        UserSelection us = new UserSelection(mediator, name);
                        for (BiologicalSequence s : mediator.getAlignmentCanvas().getMainAlignment().getBiologicalSequences()) {
                            for (Integer i : s.getSelectedPositions()) {
                                us.addResidue(new Residue(i, s.getMolecule()));
                            }
                        }
                        mediator.addUserSelection(us);
                    }
                }
            }));
            this.add(new ActionButton(null, "Clear selected positions", new ImageIcon(RessourcesUtils.getImage("unselect.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (mediator.getAlignmentCanvas().getMainAlignment() != null) {
                        mediator.getAlignmentCanvas().clearSelectedPositions();
                        mediator.getAlignmentCanvas().fireResiduesSelected(new ArrayList<Residue>(), false);
                    }
                }
            }));
            JSeparator separator = new JSeparator(1);
            separator.setBackground(Color.GRAY);
            separator.setMaximumSize(new Dimension(2, height));
            this.add(Box.createHorizontalStrut(5));
            this.add(separator);
            this.add(Box.createHorizontalStrut(5));
            this.add(new ActionButton(null, "Zoom in", new ImageIcon(RessourcesUtils.getImage("plus.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (mediator.getAlignmentCanvas() != null) {
                        mediator.getAlignmentCanvas().modifyFontSize(2);
                    }
                }
            }));
            this.add(new JLabel(new ImageIcon(RessourcesUtils.getImage("zoom.png"))));
            this.add(new ActionButton(null, "Zoom out", new ImageIcon(RessourcesUtils.getImage("minus.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (mediator.getAlignmentCanvas() != null) {
                        mediator.getAlignmentCanvas().modifyFontSize(-2);
                    }
                }
            }));
            this.add(new ActionButton(null, "Capture view in a PNG file", new ImageIcon(RessourcesUtils.getImage("capture.png")), new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                    fileChooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.getName().endsWith(".png") || file.isDirectory();
                        }

                        public String getDescription() {
                            return "PNG files";
                        }
                    });
                    if (fileChooser.showSaveDialog(S2SToolBar.this) == 0) {
                        File file = null;
                        String extension = null;
                        PrintWriter pw = null;
                        try {
                            file = fileChooser.getSelectedFile();
                            extension = IoUtils.getExtension(file);
                            if (extension.equals("png")) {
                                file.createNewFile();
                                Paradise.setWorkingDirectory(file.getAbsolutePath());
                                ImageIO.write((RenderedImage)mediator.getAlignmentCanvas().getImage(), "png", file);
                                JOptionPane.showMessageDialog(null, "Saving successful");
                            } else {
                                JOptionPane.showMessageDialog(null, "Not supported file type", "Warning", 2);
                            }
                        }
                        catch (FileNotFoundException ex) {
                            ex.printStackTrace();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        finally {
                            if (pw != null) {
                                pw.close();
                            }
                        }
                    }
                }
            }));
            ActionButton undoButton = new ActionButton(null, "Reject current alignment", new ImageIcon(RessourcesUtils.getImage("reject.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (mediator.getAlignmentCanvas() != null) {
                        mediator.getAlignmentCanvas().undo();
                        mediator.setRedoUndoButtonsState();
                    }
                }
            });
            mediator.setUndoButton(undoButton);
            ActionButton redoButton = new ActionButton(null, "Accept current alignment", new ImageIcon(RessourcesUtils.getImage("accept.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (mediator.getAlignmentCanvas() != null) {
                        mediator.getAlignmentCanvas().redo();
                        mediator.setRedoUndoButtonsState();
                    }
                }
            });
            mediator.setRedoButton(redoButton);
            JLabel l = new JLabel(new ImageIcon(RessourcesUtils.getImage("select.png")));
            l.setToolTipText("Type of RNA object to select");
            this.add(l);
            this.add(new SelectionMode(height));
            separator = new JSeparator(1);
            separator.setBackground(Color.GRAY);
            separator.setMaximumSize(new Dimension(2, height));
            this.add(Box.createHorizontalStrut(10));
            this.add(separator);
            this.add(Box.createHorizontalStrut(5));
            this.add(new Generate3DButton());
        }

        void setMediator(Mediator mediator) {
            this.mediator = mediator;
        }

        private class SelectionMode
        extends JComboBox {
            private SelectionItem[] selectionItems = new SelectionItem[]{new SelectionItem("Structural Domains", 0), new SelectionItem("Interactions", 1), new SelectionItem("Residues", 2)};

            SelectionMode(int height) {
                this.setMaximumSize(new Dimension(150, height));
                for (SelectionItem item : this.selectionItems) {
                    this.addItem(item);
                }
                this.setBackground(Color.WHITE);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        S2SToolBar.this.mediator.setSelectionMode(((SelectionItem)SelectionMode.this.getSelectedItem()).selectionMode);
                        S2SToolBar.this.mediator.getSecondaryCanvas().setState(((SelectionItem)SelectionMode.this.getSelectedItem()).selectionMode);
                    }
                });
                this.setEditable(false);
            }

            private class SelectionItem {
                private String label;
                private byte selectionMode;

                private SelectionItem(String label, byte selectionMode2) {
                    this.label = label;
                    this.selectionMode = selectionMode2;
                }

                public String toString() {
                    return this.label;
                }
            }
        }

        private class Generate3DButton
        extends JButton
        implements MouseListener {
            private Generate3DButton() {
                super(new ImageIcon(RessourcesUtils.getImage("generate3D.png")));
                this.setBackground(Color.white);
                this.setBorderPainted(false);
                this.addMouseListener(this);
                this.setToolTipText("Infer Assemble Model from Alignment");
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        new ParadiseTask(S2S.this, S2S.this.messageBar){

                            protected Void doInBackground() throws InterruptedException {
                                if (S2SToolBar.this.mediator.getAlignmentCanvas() != null && S2SToolBar.this.mediator.getAlignmentCanvas().getMainAlignment() != null) {
                                    List<TertiaryStructure> tertiaryStructures = S2SToolBar.this.mediator.getAlignmentCanvas().getMainAlignment().getReferenceStructure().getParentFeatures(TertiaryStructure.class);
                                    if (S2SToolBar.this.mediator.getSequencesList().getSelectedRows().length != 1) {
                                        JOptionPane.showMessageDialog(S2S.this.window, "Select a single sequence in the Sequences panel to use this option", "Warning", 2);
                                        return null;
                                    }
                                    int s = S2SToolBar.this.mediator.getSequencesList().getSelectedRows()[0];
                                    if (s == 0) {
                                        JOptionPane.showMessageDialog(S2S.this.window, "You cannot use this option for the reference sequence", "Warning", 2);
                                        return null;
                                    }
                                    S2S.this.getProgressMonitor().startAnimation();
                                    S2S.this.getProgressMonitor().printMessage("Assemble Model inference");
                                    Alignment alignment = S2SToolBar.this.mediator.getAlignmentCanvas().getMainAlignment();
                                    alignment.updateStructuralAlignment();
                                    int start = 0;
                                    int end = alignment.getLength() - 1;
                                    BiologicalSequence referenceBiologicalSequence = alignment.getBiologicalReferenceSequence();
                                    BiologicalSequence targetBiologicalSequence = alignment.getBiologicalSequenceAt(s);
                                    Molecule targetMolecule = targetBiologicalSequence.getMolecule();
                                    Molecule moleculeOfReference = referenceBiologicalSequence.getMolecule();
                                    StructuralFeatureFactory f = S2SToolBar.this.mediator.getS2s().createStructuralFeatureFactory();
                                    try {
                                        SecondaryStructure newSecondaryStructure = alignment.deduceNewSecondaryStructure(targetBiologicalSequence);
                                        TertiaryStructure newTertiaryStructure = f.createTertiaryStructure(new ParadiseID(), "Tertiary Structure", Source.getGraphicalToolAsSource(S2SToolBar.this.mediator.getS2s().getDescription()));
                                        if (newSecondaryStructure != null && !tertiaryStructures.isEmpty()) {
                                            TertiaryStructure referenceTertiaryStructure = tertiaryStructures.get(0);
                                            if (!tertiaryStructures.isEmpty()) {
                                                for (int i = start; i <= end; ++i) {
                                                    Residue3D referenceResidue3D;
                                                    Symbol targetSymbol = targetBiologicalSequence.getSymbol(i);
                                                    Symbol referenceSymbol = referenceBiologicalSequence.getSymbol(i);
                                                    if (targetSymbol.isGap() || referenceSymbol.isGap() || (referenceResidue3D = referenceTertiaryStructure.getResidue3DAt(referenceSymbol.getPositionInSequence(), moleculeOfReference)) == null) continue;
                                                    try {
                                                        newTertiaryStructure.getFactory().createResidue3D(newTertiaryStructure, referenceResidue3D, targetBiologicalSequence.getMolecule(), targetSymbol.getPositionInSequence());
                                                        continue;
                                                    }
                                                    catch (BiologicalSymbolException e1) {
                                                        e1.printStackTrace();
                                                    }
                                                }
                                            }
                                        }
                                        newTertiaryStructure.linkSecondaryStructure(newSecondaryStructure);
                                        JFileChooser jFileChooser = new JFileChooser(S2S.this.getS2SLastSavePath());
                                        jFileChooser.setFileHidingEnabled(true);
                                        jFileChooser.setAcceptAllFileFilterUsed(false);
                                        jFileChooser.setFileFilter(new FileFilter(){

                                            public boolean accept(File file) {
                                                return file.isDirectory() || file.getName().endsWith(".assemble");
                                            }

                                            public String getDescription() {
                                                return "Assemble models (binary data)";
                                            }
                                        });
                                        jFileChooser.setFileView(new FileView(){

                                            public Icon getIcon(File f) {
                                                if (IOUtils.isParadiseProject(f) || f.getName().endsWith(".assemble")) {
                                                    return new ImageIcon(RessourcesUtils.getImage("paradise-project.png"));
                                                }
                                                return null;
                                            }

                                            public Boolean isTraversable(File f) {
                                                return f.isDirectory() && !IOUtils.isParadiseProject(f);
                                            }
                                        });
                                        if (jFileChooser.showSaveDialog(S2S.this.window) == 0) {
                                            File saveFile = jFileChooser.getSelectedFile();
                                            S2S.this.setS2SLastSavePath(jFileChooser.getSelectedFile());
                                            File _f = new File(saveFile.getAbsolutePath() + ".assemble");
                                            saveFile.renameTo(_f);
                                            newTertiaryStructure.setAssociatedFile(_f);
                                            S2S.this.synchronize();
                                            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(_f));
                                            oos.writeObject(newTertiaryStructure);
                                            oos.flush();
                                            oos.close();
                                            JOptionPane.showMessageDialog(S2S.this.window, "Assemble Model generated successfully", "Great!!", -1);
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    S2S.this.getProgressMonitor().stopAnimation();
                                    this.finished();
                                }
                                return null;
                            }
                        }.execute();
                    }
                });
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                this.setBackground(Color.lightGray);
                this.setBorderPainted(true);
            }

            public void mouseExited(MouseEvent e) {
                this.setBackground(Color.white);
                this.setBorderPainted(false);
            }
        }
    }

    private class ActionButton
    extends JButton
    implements MouseListener {
        private ActionButton(String name, String toolTipText, Icon image, ActionListener listener) {
            super(name, image);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorderPainted(false);
            this.setBackground(Color.WHITE);
            this.addActionListener(listener);
            this.addMouseListener(this);
            this.setBorderPainted(false);
            this.setToolTipText(toolTipText);
            this.setBackground(Color.WHITE);
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.setBackground(Color.lightGray);
            this.setBorderPainted(true);
        }

        public void mouseExited(MouseEvent e) {
            this.setBackground(Color.white);
            this.setBorderPainted(false);
        }
    }

    class MessageBar
    extends JToolBar
    implements ProgressMonitor {
        private JTextField message;
        private JProgressBar progressBar;
        private MemoryMonitor memoryMonitor;
        private JLabel warning;
        private JLabel connectionStatus;
        private JLabel state;
        private Exception currentException;
        private String messageAssociatedToTheException;
        private Timer timer;
        private Icon exclamation = new ImageIcon(RessourcesUtils.getImage("exclamation.png"));
        private Icon noExclamation = new ImageIcon(RessourcesUtils.getImage("no-exclamation.png"));

        MessageBar() {
            this.setFloatable(false);
            this.setBackground(Color.white);
            this.setLayout(new BoxLayout(this, 0));
            this.timer = new Timer(500, new ActionListener(){
                private boolean b = true;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.b) {
                        MessageBar.this.warning.setIcon(MessageBar.this.exclamation);
                    } else {
                        MessageBar.this.warning.setIcon(MessageBar.this.noExclamation);
                    }
                    this.b = !this.b;
                }
            });
            this.message = new JTextField("S2S ready...");
            this.message.setBackground(Color.white);
            this.message.setEditable(false);
            this.add(this.message);
            this.add(Box.createRigidArea(new Dimension(20, 0)));
            this.progressBar = new JProgressBar(){

                public Dimension getMaximumSize() {
                    return new Dimension(150, 20);
                }

                public Dimension getMinimumSize() {
                    return this.getMaximumSize();
                }

                public Dimension getPreferredSize() {
                    return this.getMaximumSize();
                }
            };
            this.add(this.progressBar);
            this.add(Box.createRigidArea(new Dimension(20, 0)));
            this.state = new JLabel(new ImageIcon(RessourcesUtils.getImage("move-view.png")));
            this.add(this.state);
            this.warning = new JLabel(this.noExclamation);
            this.warning.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    ErrorInfo errorInfo = new ErrorInfo("Error", MessageBar.this.messageAssociatedToTheException, null, null, (Throwable)MessageBar.this.currentException, Level.SEVERE, null);
                    MessageBar.this.timer.stop();
                    MessageBar.this.warning.setIcon(null);
                    MessageBar.this.currentException = null;
                    MessageBar.this.messageAssociatedToTheException = null;
                    JXErrorPane.showDialog(null, (ErrorInfo)errorInfo);
                }
            });
            this.add(this.warning);
            if (this.currentException == null) {
                this.warning.setToolTipText("No errors");
            } else {
                this.warning.setToolTipText("Click for error details");
            }
            this.add(Box.createRigidArea(new Dimension(5, 0)));
            this.connectionStatus = new JLabel(new ImageIcon(S2S.this.isConnected() ? RessourcesUtils.getImage("connect.png") : RessourcesUtils.getImage("disconnect.png")));
            if (S2S.this.isConnected()) {
                this.connectionStatus.setToolTipText("Connected to " + S2S.this.workingSession.getPlatformAddress());
            } else {
                this.connectionStatus.setToolTipText("Not connected");
            }
            this.add(this.connectionStatus);
            this.add(Box.createRigidArea(new Dimension(20, 0)));
            this.memoryMonitor = new MemoryMonitor();
            this.add(this.memoryMonitor);
            this.memoryMonitor.start();
        }

        public void printMessage(String message) {
            this.timer.stop();
            this.warning.setIcon(null);
            this.currentException = null;
            this.messageAssociatedToTheException = null;
            this.message.setText(message);
        }

        public void printException(Exception e) {
            this.timer.stop();
            this.warning.setIcon(null);
            this.currentException = null;
            this.messageAssociatedToTheException = null;
            if (NoSolutionException.class.isInstance(e)) {
                JOptionPane.showMessageDialog(S2S.this.window, e.getMessage());
            } else {
                this.message.setText(e.getMessage());
                this.currentException = e;
                this.messageAssociatedToTheException = e.getMessage();
                this.timer.start();
            }
        }

        public void printState(String state) {
            if ("insert".equals(state)) {
                this.state.setIcon(new ImageIcon(RessourcesUtils.getImage("insert-gap.png")));
            } else if ("delete".equals(state)) {
                this.state.setIcon(new ImageIcon(RessourcesUtils.getImage("delete-gap.png")));
            } else if ("move".equals(state)) {
                this.state.setIcon(new ImageIcon(RessourcesUtils.getImage("move-gap.png")));
            } else if ("standard".equals(state)) {
                this.state.setIcon(new ImageIcon(RessourcesUtils.getImage("move-view.png")));
            } else if ("user-defined-interactions".equals(state)) {
                this.state.setIcon(new ImageIcon(RessourcesUtils.getImage("CisHSE.png")));
            }
        }

        public void startAnimation() {
            this.progressBar.setIndeterminate(true);
        }

        public void stopAnimation() {
            this.progressBar.setIndeterminate(false);
        }
    }

    private class OpenWebPageItem
    extends JMenuItem
    implements ActionListener {
        private String url;

        public OpenWebPageItem(String webPageTitle, String url) {
            super(webPageTitle);
            this.url = url;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GeneralUtils.openBrowser(this.url);
        }
    }

    private class NewsPanel
    extends JXPanel {
        private static final String feedChannel = "http://serialized-thoughts.blogspot.com/feeds/posts/default";
        private List<Post> posts = new ArrayList<Post>();
        private String lastPostID;
        private AbstractTableModel dataModel;

        private NewsPanel() {
            this.setLayout(new BorderLayout());
            this.dataModel = new AbstractTableModel(){

                public int getColumnCount() {
                    return 2;
                }

                public int getRowCount() {
                    return NewsPanel.this.posts.size();
                }

                public Object getValueAt(int row, int col) {
                    Post p = (Post)NewsPanel.this.posts.get(row);
                    switch (col) {
                        case 0: {
                            return p.title;
                        }
                        case 1: {
                            return new SimpleDateFormat("yyyy.MM.dd HH:mm").format(p.date);
                        }
                    }
                    return null;
                }

                public String getColumnName(int col) {
                    switch (col) {
                        case 0: {
                            return "Post Title";
                        }
                        case 1: {
                            return "Publication Date";
                        }
                    }
                    return "?";
                }
            };
            final JXTable table = new JXTable((TableModel)this.dataModel);
            table.setEditable(false);
            table.setSortable(false);
            table.setColumnControlVisible(false);
            table.setHighlighters(new Highlighter[]{AlternateRowHighlighter.quickSilver});
            table.getColumnModel().getColumn(1).setMinWidth(200);
            table.getColumnModel().getColumn(1).setMaxWidth(200);
            table.getColumnModel().getColumn(1).setPreferredWidth(200);
            table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseClicked(MouseEvent event) {
                    if (event.getClickCount() == 2) {
                        GeneralUtils.openBrowser(((Post)NewsPanel.this.posts.get(table.getSelectedRow())).url.toString());
                    }
                }
            });
            this.add(new JScrollPane((Component)table), "Center");
            new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    NewsPanel.this.fetchRSSChannel();
                    new Timer(1800000, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                NewsPanel.this.fetchRSSChannel();
                            }
                            catch (FeedException e) {
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                    return null;
                }
            }.execute();
        }

        private void fetchRSSChannel() throws FeedException, IOException {
            SyndFeedInput sfi = new SyndFeedInput();
            SyndFeed feed = sfi.build((Reader)new XmlReader(new URL(feedChannel)));
            if (this.lastPostID == null) {
                for (Object o : feed.getEntries()) {
                    SyndEntry entry = (SyndEntry)o;
                    Post p = new Post();
                    p.id = entry.getUri();
                    if (this.lastPostID == null) {
                        this.lastPostID = p.id;
                    }
                    p.title = entry.getTitle();
                    p.url = new URL(entry.getLink());
                    p.date = entry.getPublishedDate();
                    this.posts.add(p);
                    this.dataModel.fireTableRowsInserted(this.posts.size() - 1, this.posts.size() - 1);
                }
            } else {
                Object o;
                SyndEntry entry;
                int i = 0;
                Iterator i$ = feed.getEntries().iterator();
                while (i$.hasNext() && !this.lastPostID.equals((entry = (SyndEntry)(o = i$.next())).getUri())) {
                    Post p = new Post();
                    p.id = entry.getUri();
                    if (this.lastPostID == null) {
                        this.lastPostID = p.id;
                    }
                    p.title = entry.getTitle();
                    p.url = new URL(entry.getLink());
                    p.date = entry.getPublishedDate();
                    this.posts.add(i++, p);
                    this.dataModel.fireTableRowsInserted(i - 1, i - 1);
                }
                if (i > 0) {
                    this.lastPostID = this.posts.get(0).id;
                    S2S.this.toolWindowManager.getToolWindow("News").setFlashing(true);
                }
            }
        }

        private class Post {
            private String title;
            private String id;
            private URL url;
            private Date date;

            private Post() {
            }
        }
    }

    public class PreferencesPanel
    extends JXTaskPaneContainer {
        private JCheckBox secondaryInteractionsDisplayed;
        private JCheckBox tertiaryInteractionsDisplayed;
        private JCheckBox linkedToNextView;
        private SequencesToDisplaySpinner spinner;

        public PreferencesPanel() {
            JXTaskPane navigationPane = new JXTaskPane();
            navigationPane.setTitle("Alignment View Navigation");
            navigationPane.add((Component)((Object)new NavigatorPanel()));
            this.add(navigationPane);
            JXTaskPane viewOptions = new JXTaskPane();
            viewOptions.setTitle("Alignment View Display");
            final JTextField location = new JTextField(10);
            JButton b = new JButton("Filter");
            b.setBackground(Color.WHITE);
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (S2S.this.mediator.getSelectedAlignmentView() != null) {
                        try {
                            if (location.getText().trim().length() == 0) {
                                S2S.this.mediator.getSelectedAlignmentView().getSelectedPositionsToDrawInteractions().clear();
                            } else {
                                Location l = new Location(location.getText().trim());
                                for (int i = 0; i < S2S.this.mediator.getSelectedAlignmentView().getAlignment().getLength(); ++i) {
                                    int pos = S2S.this.mediator.getSelectedAlignmentView().getAlignment().getBiologicalReferenceSequence().getSymbol(i).getPositionInSequence();
                                    if (!l.hasPosition(i + 1) || pos == -1) continue;
                                    S2S.this.mediator.getSelectedAlignmentView().getSelectedPositionsToDrawInteractions().add(pos);
                                }
                            }
                            S2S.this.mediator.getAlignmentCanvas().repaint();
                        }
                        catch (BiologicalSymbolException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            JXPanel locationPanel = new JXPanel((LayoutManager)new GridBagLayout());
            locationPanel.add((Component)location, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
            locationPanel.add((Component)b, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 5), 0, 0));
            viewOptions.add((Component)locationPanel);
            b = new JButton("Restrict to the selection");
            b.setBackground(Color.WHITE);
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (S2S.this.mediator.getSelectedAlignmentView() != null) {
                        BiologicalSequence ref = S2S.this.mediator.getSelectedAlignmentView().getAlignment().getBiologicalReferenceSequence();
                        for (int pos : ref.getSelectedPositions()) {
                            S2S.this.mediator.getSelectedAlignmentView().getSelectedPositionsToDrawInteractions().add(pos);
                        }
                        S2S.this.mediator.getAlignmentCanvas().repaint();
                    }
                }
            });
            JXPanel selectionPanel = new JXPanel((LayoutManager)new GridBagLayout());
            selectionPanel.add((Component)b, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
            viewOptions.add((Component)selectionPanel);
            JXPanel checkBoxesPanel = new JXPanel();
            checkBoxesPanel.setLayout((LayoutManager)new VerticalLayout());
            this.secondaryInteractionsDisplayed = new JCheckBox("Secondary Interactions");
            this.secondaryInteractionsDisplayed.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (S2S.this.mediator.getSelectedAlignmentView() != null) {
                        S2S.this.mediator.getSelectedAlignmentView().setDisplaySecondaryInteractions(PreferencesPanel.this.secondaryInteractionsDisplayed.isSelected());
                    }
                }
            });
            checkBoxesPanel.add((Component)this.secondaryInteractionsDisplayed);
            this.tertiaryInteractionsDisplayed = new JCheckBox("Tertiary Interactions");
            this.tertiaryInteractionsDisplayed.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (S2S.this.mediator.getSelectedAlignmentView() != null) {
                        S2S.this.mediator.getSelectedAlignmentView().setDisplayTertiaryInteractions(PreferencesPanel.this.tertiaryInteractionsDisplayed.isSelected());
                    }
                }
            });
            checkBoxesPanel.add((Component)this.tertiaryInteractionsDisplayed);
            this.linkedToNextView = new JCheckBox("Linked to next view");
            this.linkedToNextView.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (S2S.this.mediator.getSelectedAlignmentView() != null) {
                        if (PreferencesPanel.this.linkedToNextView.isSelected()) {
                            int index = S2S.this.mediator.getAlignmentCanvas().getAlignmentViews().indexOf(S2S.this.mediator.getSelectedAlignmentView());
                            if (index <= S2S.this.mediator.getAlignmentCanvas().getAlignmentViews().size() - 2) {
                                AlignmentView nextView = S2S.this.mediator.getAlignmentCanvas().getAlignmentViews().get(index + 1);
                                S2S.this.mediator.getSelectedAlignmentView().setNextView(nextView);
                            }
                        } else {
                            S2S.this.mediator.getSelectedAlignmentView().setNextView(null);
                        }
                    }
                }
            });
            checkBoxesPanel.add((Component)this.linkedToNextView);
            viewOptions.add((Component)checkBoxesPanel);
            this.spinner = new SequencesToDisplaySpinner();
            JXPanel spinnerPanel = new JXPanel((LayoutManager)new GridBagLayout());
            spinnerPanel.add((Component)this.spinner, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
            spinnerPanel.add((Component)new JLabel("sequences displayed"), (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
            viewOptions.add((Component)spinnerPanel);
            this.add(viewOptions);
            JXTaskPane lwPanel = new JXTaskPane();
            lwPanel.setTitle("Base-Base Interactions Display");
            JXPanel allButtonsPanel = new JXPanel();
            allButtonsPanel.setLayout((LayoutManager)new VerticalLayout());
            JXPanel lwFamilyButtonsPanel = new JXPanel();
            LWFamilyButton lwFamilyButton = new LWFamilyButton("CisWCWC");
            lwFamilyButtonsPanel.add((Component)lwFamilyButton);
            lwFamilyButton = new LWFamilyButton("TransWCWC");
            lwFamilyButtonsPanel.add((Component)lwFamilyButton);
            allButtonsPanel.add((Component)lwFamilyButtonsPanel);
            lwFamilyButtonsPanel = new JXPanel();
            lwFamilyButton = new LWFamilyButton("CisSEWC");
            lwFamilyButtonsPanel.add((Component)lwFamilyButton);
            lwFamilyButton = new LWFamilyButton("TransSEWC");
            lwFamilyButtonsPanel.add((Component)lwFamilyButton);
            allButtonsPanel.add((Component)lwFamilyButtonsPanel);
            lwFamilyButtonsPanel = new JXPanel();
            lwFamilyButton = new LWFamilyButton("CisHH");
            lwFamilyButtonsPanel.add((Component)lwFamilyButton);
            lwFamilyButton = new LWFamilyButton("TransHH");
            lwFamilyButtonsPanel.add((Component)lwFamilyButton);
            allButtonsPanel.add((Component)lwFamilyButtonsPanel);
            lwFamilyButtonsPanel = new JXPanel();
            lwFamilyButton = new LWFamilyButton("CisHSE");
            lwFamilyButtonsPanel.add((Component)lwFamilyButton);
            lwFamilyButton = new LWFamilyButton("TransHSE");
            lwFamilyButtonsPanel.add((Component)lwFamilyButton);
            allButtonsPanel.add((Component)lwFamilyButtonsPanel);
            lwFamilyButtonsPanel = new JXPanel();
            lwFamilyButton = new LWFamilyButton("CisSESE");
            lwFamilyButtonsPanel.add((Component)lwFamilyButton);
            lwFamilyButton = new LWFamilyButton("TransSESE");
            lwFamilyButtonsPanel.add((Component)lwFamilyButton);
            allButtonsPanel.add((Component)lwFamilyButtonsPanel);
            lwFamilyButtonsPanel = new JXPanel();
            lwFamilyButton = new LWFamilyButton("CisHWC");
            lwFamilyButtonsPanel.add((Component)lwFamilyButton);
            lwFamilyButton = new LWFamilyButton("TransHWC");
            lwFamilyButtonsPanel.add((Component)lwFamilyButton);
            allButtonsPanel.add((Component)lwFamilyButtonsPanel);
            lwPanel.add((Component)allButtonsPanel);
            this.add(lwPanel);
        }

        private class LWFamilyButton
        extends JButton {
            private String lwFamily;
            private boolean display = true;

            private LWFamilyButton(final String lwFamily) {
                this.lwFamily = lwFamily;
                this.setIcon(new ImageIcon(RessourcesUtils.getImage(this.lwFamily + ".png")));
                this.setBackground(Color.WHITE);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        LWFamilyButton.this.display = !LWFamilyButton.this.display;
                        for (AlignmentView view : S2S.this.mediator.getAlignmentCanvas().getAlignmentViews()) {
                            try {
                                Method set = view.getClass().getMethod("setDisplay" + lwFamily, Boolean.class);
                                Method get = view.getClass().getMethod("isDisplay" + lwFamily, new Class[0]);
                                set.invoke((Object)view, LWFamilyButton.this.display);
                            }
                            catch (NoSuchMethodException e1) {
                                e1.printStackTrace();
                            }
                            catch (IllegalAccessException e1) {
                                e1.printStackTrace();
                            }
                            catch (InvocationTargetException e1) {
                                e1.printStackTrace();
                            }
                        }
                        if (S2S.this.rna2dViewer.getSecondaryCanvas() != null) {
                            if (lwFamily.equals("CisSESE")) {
                                S2S.this.rna2dViewer.getSecondaryCanvas().addFamily("CSS");
                            } else if (lwFamily.equals("TransSESE")) {
                                S2S.this.rna2dViewer.getSecondaryCanvas().addFamily("TSS");
                            } else if (lwFamily.equals("CisHWC")) {
                                S2S.this.rna2dViewer.getSecondaryCanvas().addFamily("CHW");
                                S2S.this.rna2dViewer.getSecondaryCanvas().addFamily("CWH");
                            } else if (lwFamily.equals("TransHWC")) {
                                S2S.this.rna2dViewer.getSecondaryCanvas().addFamily("THW");
                                S2S.this.rna2dViewer.getSecondaryCanvas().addFamily("TWH");
                            } else if (lwFamily.equals("CisHSE")) {
                                S2S.this.rna2dViewer.getSecondaryCanvas().addFamily("CHS");
                                S2S.this.rna2dViewer.getSecondaryCanvas().addFamily("CSH");
                            } else if (lwFamily.equals("THSE")) {
                                S2S.this.rna2dViewer.getSecondaryCanvas().addFamily("THS");
                                S2S.this.rna2dViewer.getSecondaryCanvas().addFamily("TSH");
                            } else if (lwFamily.equals("CisSEWC")) {
                                S2S.this.rna2dViewer.getSecondaryCanvas().addFamily("CSW");
                                S2S.this.rna2dViewer.getSecondaryCanvas().addFamily("CWS");
                            } else if (lwFamily.equals("TransSEWC")) {
                                S2S.this.rna2dViewer.getSecondaryCanvas().addFamily("TSW");
                                S2S.this.rna2dViewer.getSecondaryCanvas().addFamily("TWS");
                            } else if (lwFamily.equals("TransSEWC")) {
                                S2S.this.rna2dViewer.getSecondaryCanvas().addFamily("TSW");
                                S2S.this.rna2dViewer.getSecondaryCanvas().addFamily("TWS");
                            } else if (lwFamily.equals("CisWCWC")) {
                                S2S.this.rna2dViewer.getSecondaryCanvas().addFamily("CWW");
                            } else if (lwFamily.equals("TransWCWC")) {
                                S2S.this.rna2dViewer.getSecondaryCanvas().addFamily("TWW");
                            }
                        }
                        if (LWFamilyButton.this.display) {
                            LWFamilyButton.this.setIcon(new ImageIcon(RessourcesUtils.getImage(LWFamilyButton.this.lwFamily + ".png")));
                        } else {
                            LWFamilyButton.this.setIcon(new ImageIcon(RessourcesUtils.getImage(LWFamilyButton.this.lwFamily + "_hidden.png")));
                        }
                    }
                });
            }
        }

        private class SequencesToDisplaySpinner
        extends JSpinner {
            private SequencesToDisplaySpinner() {
                this.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        if (S2S.this.mediator.getSelectedAlignmentView() != null) {
                            S2S.this.mediator.getSelectedAlignmentView().setNumberOfSequencesToDisplay((Integer)SequencesToDisplaySpinner.this.getValue());
                        }
                    }
                });
            }
        }

        private class NavigatorPanel
        extends JXPanel {
            private NavigatorPanel() {
                JXPanel buttons = new JXPanel((LayoutManager)new BorderLayout());
                buttons.setBackground(Color.WHITE);
                JButton b = new JButton(new ImageIcon(RessourcesUtils.getImage("left.png")));
                b.setBackground(Color.WHITE);
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (S2S.this.mediator.getAlignmentCanvas().getSelectedView() != null) {
                            S2S.this.mediator.getAlignmentCanvas().getSelectedView().moveViewOnLeft();
                        }
                    }
                });
                buttons.add((Component)b, (Object)"West");
                b = new JButton(new ImageIcon(RessourcesUtils.getImage("up.png")));
                b.setBackground(Color.WHITE);
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (S2S.this.mediator.getAlignmentCanvas().getSelectedView() != null) {
                            S2S.this.mediator.getAlignmentCanvas().getSelectedView().setViewY(S2S.this.mediator.getAlignmentCanvas().getSelectedView().getViewY() + S2S.this.mediator.getAlignmentCanvas().getGraphicContext().getVerticalAdvance());
                        }
                    }
                });
                buttons.add((Component)b, (Object)"North");
                b = new JButton(new ImageIcon(RessourcesUtils.getImage("down.png")));
                b.setBackground(Color.WHITE);
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (S2S.this.mediator.getAlignmentCanvas().getSelectedView() != null) {
                            S2S.this.mediator.getAlignmentCanvas().getSelectedView().setViewY(S2S.this.mediator.getAlignmentCanvas().getSelectedView().getViewY() - S2S.this.mediator.getAlignmentCanvas().getGraphicContext().getVerticalAdvance());
                        }
                    }
                });
                buttons.add((Component)b, (Object)"South");
                b = new JButton(new ImageIcon(RessourcesUtils.getImage("right.png")));
                b.setBackground(Color.WHITE);
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (S2S.this.mediator.getAlignmentCanvas().getSelectedView() != null) {
                            S2S.this.mediator.getAlignmentCanvas().getSelectedView().moveViewOnRight();
                        }
                    }
                });
                buttons.add((Component)b, (Object)"East");
                buttons.setAlignmentY(0.5f);
                this.add((Component)buttons);
            }
        }
    }

    private class LWMatricesPanel
    extends JXPanel {
        public LWMatricesPanel() throws HeadlessException {
            this.setLayout((LayoutManager)new VerticalLayout(10));
            this.setBackground(Color.WHITE);
            this.add((Component)((Object)new SymetricFamilyPanel("CWW", new ImageIcon(RessourcesUtils.getImage("CisWCWC.png")))));
            this.add((Component)((Object)new SymetricFamilyPanel("TWW", new ImageIcon(RessourcesUtils.getImage("TransWCWC.png")))));
            this.add((Component)((Object)new SymetricFamilyPanel("CHH", new ImageIcon(RessourcesUtils.getImage("CisHH.png")))));
            this.add((Component)((Object)new SymetricFamilyPanel("THH", new ImageIcon(RessourcesUtils.getImage("TransHH.png")))));
            this.add((Component)((Object)new FamilyPanel("CWH", new ImageIcon(RessourcesUtils.getImage("CisHWC.png")))));
            this.add((Component)((Object)new FamilyPanel("TWH", new ImageIcon(RessourcesUtils.getImage("TransHWC.png")))));
            this.add((Component)((Object)new FamilyPanel("CHS", new ImageIcon(RessourcesUtils.getImage("CisHSE.png")))));
            this.add((Component)((Object)new FamilyPanel("THS", new ImageIcon(RessourcesUtils.getImage("TransHSE.png")))));
            this.add((Component)((Object)new FamilyPanel("CWS", new ImageIcon(RessourcesUtils.getImage("CisSEWC.png")))));
            this.add((Component)((Object)new FamilyPanel("TWS", new ImageIcon(RessourcesUtils.getImage("TransSEWC.png")))));
            this.add((Component)((Object)new SymetricFamilyPanel("CSS", new ImageIcon(RessourcesUtils.getImage("CisSESE.png")))));
            this.add((Component)((Object)new SymetricFamilyPanel("TSS", new ImageIcon(RessourcesUtils.getImage("TransSESE.png")))));
        }

        private class IsostericityFamilyButton
        extends JButton {
            private IsostericityFamilyButton button;
            private String family;

            private IsostericityFamilyButton(String base1, String family, String base2) {
                if (BaseBaseInteraction.isostericFamiliesInstances.containsKey(base1 + family + base2)) {
                    this.family = base1 + family + base2;
                } else if (BaseBaseInteraction.isostericFamiliesInstances.containsKey(base2 + family + base1)) {
                    this.family = base2 + family + base1;
                }
                if (this.family != null) {
                    this.setText(BaseBaseInteraction.isostericFamiliesInstances.get(this.family).split("-")[1]);
                }
                this.setBackground(Color.WHITE);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        String newValue;
                        if (IsostericityFamilyButton.this.family != null && (newValue = JOptionPane.showInputDialog("Enter new value", (Object)IsostericityFamilyButton.this.getText())) != null) {
                            BaseBaseInteraction.isostericFamiliesInstances.put(IsostericityFamilyButton.this.family, IsostericityFamilyButton.this.family.substring(1, IsostericityFamilyButton.this.family.length() - 1) + "-" + newValue);
                            if (IsostericityFamilyButton.this.family.matches("SS")) {
                                BaseBaseInteraction.isostericFamiliesInstances.put(IsostericityFamilyButton.this.family.replaceFirst("SS", "sS"), IsostericityFamilyButton.this.family.substring(1, IsostericityFamilyButton.this.family.length() - 1) + "-" + newValue);
                                BaseBaseInteraction.isostericFamiliesInstances.put(IsostericityFamilyButton.this.family.replaceFirst("SS", "Ss"), IsostericityFamilyButton.this.family.substring(1, IsostericityFamilyButton.this.family.length() - 1) + "-" + newValue);
                            }
                            IsostericityFamilyButton.this.setText(newValue);
                            IsostericityFamilyButton.this.revalidate();
                            if (IsostericityFamilyButton.this.button != null) {
                                IsostericityFamilyButton.this.button.setText(newValue);
                                IsostericityFamilyButton.this.button.revalidate();
                            }
                            S2S.this.getAlignmentCanvas().recalculateConservationScores();
                        }
                    }
                });
            }
        }

        private class SymetricFamilyPanel
        extends JXPanel {
            public SymetricFamilyPanel(String lwFamily, Icon icon) {
                this.setLayout(new GridLayout(5, 5));
                this.setBackground(Color.WHITE);
                JLabel f = new JLabel(icon, 0);
                f.setBackground(Color.WHITE);
                this.add(f);
                this.add(new JLabel("A", 0));
                this.add(new JLabel("C", 0));
                this.add(new JLabel("G", 0));
                this.add(new JLabel("U", 0));
                this.add(new JLabel("A", 0));
                IsostericityFamilyButton AC = new IsostericityFamilyButton("A", lwFamily, "C");
                IsostericityFamilyButton CA = new IsostericityFamilyButton("C", lwFamily, "A");
                IsostericityFamilyButton AG = new IsostericityFamilyButton("A", lwFamily, "G");
                IsostericityFamilyButton GA = new IsostericityFamilyButton("G", lwFamily, "A");
                IsostericityFamilyButton AU = new IsostericityFamilyButton("A", lwFamily, "U");
                IsostericityFamilyButton UA = new IsostericityFamilyButton("U", lwFamily, "A");
                IsostericityFamilyButton CG = new IsostericityFamilyButton("C", lwFamily, "G");
                IsostericityFamilyButton GC = new IsostericityFamilyButton("G", lwFamily, "C");
                IsostericityFamilyButton CU = new IsostericityFamilyButton("C", lwFamily, "U");
                IsostericityFamilyButton UC = new IsostericityFamilyButton("U", lwFamily, "C");
                IsostericityFamilyButton GU = new IsostericityFamilyButton("G", lwFamily, "U");
                IsostericityFamilyButton UG = new IsostericityFamilyButton("U", lwFamily, "G");
                AC.button = CA;
                CA.button = AC;
                AG.button = GA;
                GA.button = AG;
                AU.button = UA;
                UA.button = AU;
                CG.button = GC;
                GC.button = CG;
                CU.button = UC;
                UC.button = CU;
                GU.button = UG;
                UG.button = GU;
                this.add(new IsostericityFamilyButton("A", lwFamily, "A"));
                this.add(AC);
                this.add(AG);
                this.add(AU);
                this.add(new JLabel("C", 0));
                this.add(CA);
                this.add(new IsostericityFamilyButton("C", lwFamily, "C"));
                this.add(CG);
                this.add(CU);
                this.add(new JLabel("G", 0));
                this.add(GA);
                this.add(GC);
                this.add(new IsostericityFamilyButton("G", lwFamily, "G"));
                this.add(GU);
                this.add(new JLabel("U", 0));
                this.add(UA);
                this.add(UC);
                this.add(UG);
                this.add(new IsostericityFamilyButton("U", lwFamily, "U"));
            }
        }

        private class FamilyPanel
        extends JXPanel {
            public FamilyPanel(String lwFamily, Icon icon) {
                this.setLayout(new GridLayout(5, 5));
                this.setBackground(Color.WHITE);
                JLabel f = new JLabel(icon, 0);
                f.setBackground(Color.WHITE);
                this.add(f);
                this.add(new JLabel("A", 0));
                this.add(new JLabel("C", 0));
                this.add(new JLabel("G", 0));
                this.add(new JLabel("U", 0));
                this.add(new JLabel("A", 0));
                this.add(new IsostericityFamilyButton("A", lwFamily, "A"));
                this.add(new IsostericityFamilyButton("A", lwFamily, "C"));
                this.add(new IsostericityFamilyButton("A", lwFamily, "G"));
                this.add(new IsostericityFamilyButton("A", lwFamily, "U"));
                this.add(new JLabel("C", 0));
                this.add(new IsostericityFamilyButton("C", lwFamily, "A"));
                this.add(new IsostericityFamilyButton("C", lwFamily, "C"));
                this.add(new IsostericityFamilyButton("C", lwFamily, "G"));
                this.add(new IsostericityFamilyButton("C", lwFamily, "U"));
                this.add(new JLabel("G", 0));
                this.add(new IsostericityFamilyButton("G", lwFamily, "A"));
                this.add(new IsostericityFamilyButton("G", lwFamily, "C"));
                this.add(new IsostericityFamilyButton("G", lwFamily, "G"));
                this.add(new IsostericityFamilyButton("G", lwFamily, "U"));
                this.add(new JLabel("U", 0));
                this.add(new IsostericityFamilyButton("U", lwFamily, "A"));
                this.add(new IsostericityFamilyButton("U", lwFamily, "C"));
                this.add(new IsostericityFamilyButton("U", lwFamily, "G"));
                this.add(new IsostericityFamilyButton("U", lwFamily, "U"));
            }
        }
    }

    private class TertiaryViewersToolBar
    extends JToolBar {
        public static final byte PYMOL = 1;
        public static final byte VMD = 2;
        public static final byte CHIMERA = 3;

        private TertiaryViewersToolBar() {
            this.setBackground(Color.WHITE);
            this.setFloatable(false);
            JLabel toolBarName = new JLabel();
            toolBarName.setIcon(new VTextIcon(toolBarName, "3D", 2));
            this.add(toolBarName);
            this.add(Box.createHorizontalStrut(5));
            this.add(new TertiaryViewerState());
            int height = new ImageIcon(RessourcesUtils.getImage("unselect.png")).getIconHeight();
            JSeparator separator = new JSeparator(1);
            separator.setBackground(Color.GRAY);
            separator.setMaximumSize(new Dimension(1, height));
            this.add(Box.createHorizontalStrut(5));
            this.add(separator);
            this.add(Box.createHorizontalStrut(5));
            ActionButton b = new ActionButton(null, "Show All residues", new ImageIcon(RessourcesUtils.getImage("molecule.png")), new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (TertiaryViewerDriver driver : S2S.this.drivers) {
                        driver.evaluate("show all");
                    }
                }
            });
            this.add(b);
            b = new ActionButton(null, "Hide All residues", new ImageIcon(RessourcesUtils.getImage("unselect.png")), new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (TertiaryViewerDriver driver : S2S.this.drivers) {
                        driver.evaluate("hide all");
                    }
                }
            });
            this.add(b);
            separator = new JSeparator(1);
            separator.setBackground(Color.GRAY);
            separator.setMaximumSize(new Dimension(1, height));
            this.add(Box.createHorizontalStrut(5));
            this.add(separator);
            this.add(Box.createHorizontalStrut(5));
            b = new ActionButton(null, "Load tertiary structure with PyMOL", new ImageIcon(RessourcesUtils.getImage("pymol.jpg")), new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
            b.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (S2S.this.getAlignmentCanvas().getMainAlignment() != null) {
                        List<TertiaryStructure> tss = S2S.this.getAlignmentCanvas().getMainAlignment().getReferenceStructure().getParentFeatures(TertiaryStructure.class);
                        if (!tss.isEmpty()) {
                            TertiaryStructure ts = tss.get(0);
                            PyMOLDriver driver = null;
                            if (mouseEvent.isShiftDown() || S2SConfig.getPyMOLPath().length() == 0) {
                                String path = JOptionPane.showInputDialog("Enter the absolute path of your PyMOL application", (Object)S2SConfig.getPyMOLPath());
                                if (path != null && path.length() != 0) {
                                    S2SConfig.setPyMOLPath(path);
                                    driver = new PyMOLDriver(S2S.this.mediator);
                                }
                            } else {
                                driver = new PyMOLDriver(S2S.this.mediator);
                            }
                            if (driver != null) {
                                S2S.this.drivers.add(driver);
                                S2S.this.mediator.getAlignmentCanvas().addSelectionListener(driver);
                                driver.addSelectionListener(S2S.this.mediator.getAlignmentCanvas());
                                S2S.this.mediator.getRna2dViewer().addSelectionListener(driver);
                                driver.addSelectionListener(S2S.this.mediator.getRna2dViewer());
                                S2S.this.mediator.getSecondaryStructureNavigator().addSelectionListener(driver);
                                driver.addSelectionListener(S2S.this.mediator.getSecondaryStructureNavigator());
                                new LoadTertiaryStructureTask(S2S.this, ts).execute();
                            }
                        } else {
                            JOptionPane.showMessageDialog(S2S.this.window, "Your structural alignement is not linked to a tertiary structure");
                        }
                    } else {
                        JOptionPane.showMessageDialog(S2S.this.window, "No structural alignement loaded in S2S");
                    }
                }
            });
            this.add(b);
            b = new ActionButton(null, "Load tertiary structure with Chimera", new ImageIcon(RessourcesUtils.getImage("chimera.jpg")), new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
            b.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (S2S.this.getAlignmentCanvas().getMainAlignment() != null) {
                        List<TertiaryStructure> tss = S2S.this.getAlignmentCanvas().getMainAlignment().getReferenceStructure().getParentFeatures(TertiaryStructure.class);
                        if (!tss.isEmpty()) {
                            TertiaryStructure ts = tss.get(0);
                            ChimeraDriver driver = null;
                            if (mouseEvent.isShiftDown() || S2SConfig.getChimeraPath().length() == 0) {
                                String path = JOptionPane.showInputDialog("Enter the absolute path of your Chimera application", (Object)S2SConfig.getChimeraPath());
                                if (path != null && path.length() != 0) {
                                    S2SConfig.setChimeraPath(path);
                                    driver = new ChimeraDriver(S2S.this.mediator);
                                }
                            } else {
                                driver = new ChimeraDriver(S2S.this.mediator);
                            }
                            if (driver != null) {
                                S2S.this.drivers.add(driver);
                                S2S.this.mediator.getAlignmentCanvas().addSelectionListener(driver);
                                driver.addSelectionListener(S2S.this.mediator.getAlignmentCanvas());
                                S2S.this.mediator.getRna2dViewer().addSelectionListener(driver);
                                driver.addSelectionListener(S2S.this.mediator.getRna2dViewer());
                                S2S.this.mediator.getSecondaryStructureNavigator().addSelectionListener(driver);
                                driver.addSelectionListener(S2S.this.mediator.getSecondaryStructureNavigator());
                                new LoadTertiaryStructureTask(S2S.this, ts).execute();
                            }
                        } else {
                            JOptionPane.showMessageDialog(S2S.this.window, "Your structural alignement is not linked to a tertiary structure");
                        }
                    } else {
                        JOptionPane.showMessageDialog(S2S.this.window, "No structural alignement loaded in S2S");
                    }
                }
            });
            this.add(Box.createHorizontalGlue());
        }

        private class LoadTertiaryStructureTask
        extends ParadiseTask {
            private TertiaryStructure ts;

            private LoadTertiaryStructureTask(Application app, TertiaryStructure ts) {
                super(app, S2S.this.messageBar);
                this.ts = ts;
            }

            protected Void doInBackground() {
                try {
                    File tmp = File.createTempFile(this.ts.getName(), ".pdb");
                    PDBFileIO.writePDBFile(this.ts.getResidues3D(), true, tmp);
                    for (TertiaryViewerDriver driver : S2S.this.drivers) {
                        driver.loadTertiaryStructure(tmp);
                        driver.addTertiaryStructureDisplayed(this.ts);
                    }
                }
                catch (IOException e) {
                    this.finished();
                    JOptionPane.showMessageDialog(S2S.this.window, "Problem to create a temporary PDB file", "Warning", 2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.finished();
                return null;
            }
        }

        private class TertiaryViewerState
        extends JComboBox
        implements ActionListener {
            ImageIcon[] images;

            TertiaryViewerState() {
                super(new Integer[]{0, 1, 2, 3, 4});
                this.images = new ImageIcon[]{new ImageIcon(RessourcesUtils.getImage("select.png")), new ImageIcon(RessourcesUtils.getImage("center-view.png")), new ImageIcon(RessourcesUtils.getImage("zoom.png")), new ImageIcon(RessourcesUtils.getImage("show.png")), new ImageIcon(RessourcesUtils.getImage("unselect.png"))};
                this.setBackground(Color.WHITE);
                ComboBoxRenderer renderer = new ComboBoxRenderer();
                this.setRenderer(renderer);
                this.setToolTipText("Current state of the 3D viewers");
                this.addActionListener(this);
            }

            public Dimension getPreferredSize() {
                return new Dimension(42, 22);
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            public void actionPerformed(ActionEvent e) {
                for (TertiaryViewerDriver driver : S2S.this.drivers) {
                    driver.setCurrentState(this.getSelectedIndex());
                }
            }

            private class ComboBoxRenderer
            extends JLabel
            implements ListCellRenderer {
                private Font uhOhFont;

                public ComboBoxRenderer() {
                    this.setOpaque(true);
                    this.setHorizontalAlignment(0);
                    this.setVerticalAlignment(0);
                }

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    int selectedIndex = (Integer)value;
                    if (isSelected) {
                        this.setBackground(list.getSelectionBackground());
                        this.setForeground(list.getSelectionForeground());
                    } else {
                        this.setBackground(list.getBackground());
                        this.setForeground(list.getForeground());
                    }
                    ImageIcon icon = TertiaryViewerState.this.images[selectedIndex];
                    this.setIcon(icon);
                    return this;
                }

                protected void setUhOhText(String uhOhText, Font normalFont) {
                    if (this.uhOhFont == null) {
                        this.uhOhFont = normalFont.deriveFont(2);
                    }
                    this.setFont(this.uhOhFont);
                    this.setText(uhOhText);
                }
            }
        }
    }

    private class ComputedAlignmentPanel
    extends JXPanel {
        private JComboBox moleculesChoice;

        private ComputedAlignmentPanel() {
            this.setBackground(Color.WHITE);
            this.setLayout((LayoutManager)new VerticalLayout(5));
            this.moleculesChoice = new JComboBox();
            this.moleculesChoice.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    S2S.this.mediator.getAlignmentCanvas().setMoleculeToCompare(((BiologicalSequenceItem)e.getItem()).seq.getMolecule());
                    S2S.this.mediator.getAlignmentCanvas().repaint();
                }
            });
            JXPanel subPanel = new JXPanel((LayoutManager)new GridBagLayout());
            subPanel.setBackground(Color.WHITE);
            subPanel.add((Component)new JLabel("Compare"), (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 5, 0, 5), 0, 0));
            subPanel.add((Component)this.moleculesChoice, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)subPanel);
        }

        private void update() {
            this.moleculesChoice.removeAllItems();
            if (S2S.this.mediator.getAlignmentCanvas().getMainAlignment() != null) {
                for (BiologicalSequence s : S2S.this.mediator.getAlignmentCanvas().getMainAlignment().getBiologicalSequences()) {
                    this.moleculesChoice.addItem(new BiologicalSequenceItem(s));
                }
            }
        }

        private class BiologicalSequenceItem {
            private BiologicalSequence seq;

            public BiologicalSequenceItem(BiologicalSequence seq) {
                this.seq = seq;
            }

            public String toString() {
                return "S" + (S2S.this.mediator.getAlignmentCanvas().getMainAlignment().getBiologicalSequences().indexOf(this.seq) + 1);
            }
        }
    }

    private class PluginsMenu
    extends JMenu {
        private PluginsMenu() {
            super("Plugins");
            File pluginsDir = new File(S2S.getPluginsPath());
            for (File pluginDir : pluginsDir.listFiles(new java.io.FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }
            })) {
                File script = new File(pluginDir, "Plugin.groovy");
                if (!script.exists()) continue;
                try {
                    Class pluginClass = S2S.this.groovyShell.getClassLoader().parseClass(script);
                    this.add(new PluginMenuItem((GroovyObject)pluginClass.newInstance()));
                }
                catch (Exception e) {
                    ErrorInfo errorInfo = new ErrorInfo("Error", "Problem to load the plugin " + pluginDir, null, null, (Throwable)e, Level.SEVERE, null);
                    JXErrorPane.showDialog(null, (ErrorInfo)errorInfo);
                }
            }
        }

        private class PluginMenuItem
        extends JMenuItem {
            private GroovyObject plugin;

            private PluginMenuItem(final GroovyObject plugin) {
                super((String)plugin.invokeMethod("getTitle", null));
                this.setToolTipText((String)plugin.invokeMethod("getDescription", null));
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        new SwingWorker(){

                            protected Object doInBackground() {
                                try {
                                    plugin.invokeMethod("run", (Object)new Object[]{S2S.this});
                                }
                                catch (Exception e) {
                                    ErrorInfo errorInfo = new ErrorInfo("Error", "Problem to execute the plugin", null, null, (Throwable)e, Level.SEVERE, null);
                                    JXErrorPane.showDialog(null, (ErrorInfo)errorInfo);
                                }
                                return null;
                            }
                        }.execute();
                    }
                });
            }
        }
    }

    private class S2SMenu
    extends JMenuBar {
        private S2SMenu() {
            JMenu menu = null;
            JMenu submenu = null;
            JMenuItem item = null;
            this.add(new FileMenu());
            JMenu compareMenu = new JMenu("Compare with");
            JMenu algorithmsMenu = new JMenu("new alignment generated by");
            item = new JMenuItem("CARNAC");
            algorithmsMenu.add(item);
            compareMenu.add(algorithmsMenu);
            item = new JMenuItem("with an alignment in memory");
            compareMenu.add(item);
            submenu = new JMenu("Display");
            item = new JMenuItem("Quick");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    S2S.this.mediator.getAlignmentCanvas().setQuickDraw(true);
                }
            });
            submenu.add(item);
            item = new JMenuItem("Best");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    S2S.this.mediator.getAlignmentCanvas().setQuickDraw(false);
                }
            });
            submenu.add(item);
            this.add(new PluginsMenu());
            menu = new JMenu("Help");
            menu.add(new OpenWebPageItem("S2S Website", "http://bioinformatics.org/s2s/"));
            menu.add(new UpdateMenuItem());
            this.add(menu);
        }

        private class FileMenu
        extends JMenu {
            public FileMenu() {
                super("File");
                JMenu load = new JMenu("Load...");
                load.setIcon(RessourcesUtils.getIcon("open.png"));
                this.add(load);
                JMenuItem item = new JMenuItem("S2S Alignment");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (S2S.this.mediator.getAlignmentCanvas().getMainAlignment() != null && 0 != JOptionPane.showConfirmDialog(S2S.this.window, "Are you sure to remove your current Alignment?")) {
                            return;
                        }
                        if (S2S.this.mediator.getAlignmentCanvas().getMainAlignment() != null) {
                            S2S.this.mediator.clearSession();
                        }
                        JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                        fileChooser.setFileView(new FileView(){

                            public Icon getIcon(File f) {
                                if (IOUtils.isParadiseProject(f) || f.getName().endsWith(".s2s")) {
                                    return new ImageIcon(RessourcesUtils.getImage("paradise-project.png"));
                                }
                                return null;
                            }

                            public Boolean isTraversable(File f) {
                                return f.isDirectory() && !IOUtils.isParadiseProject(f);
                            }
                        });
                        fileChooser.setFileHidingEnabled(true);
                        fileChooser.setAcceptAllFileFilterUsed(false);
                        fileChooser.setFileSelectionMode(2);
                        fileChooser.setFileFilter(new FileFilter(){

                            public boolean accept(File file) {
                                return file.isDirectory() && !IOUtils.isParadiseProject(file) || file.getName().endsWith(".s2s");
                            }

                            public String getDescription() {
                                return "S2S alignments (binary data)";
                            }
                        });
                        fileChooser.setFileFilter(new FileFilter(){

                            public boolean accept(File file) {
                                return file.isDirectory() && !IOUtils.isParadiseProject(file) || IOUtils.containsStructuralAlignmentData(file);
                            }

                            public String getDescription() {
                                return "S2S alignments (textual data)";
                            }
                        });
                        if (fileChooser.showOpenDialog(null) == 0) {
                            File f = fileChooser.getSelectedFile();
                            if (f.getName().endsWith(".s2s")) {
                                Paradise.setWorkingDirectory(f.getAbsolutePath());
                                final S2SAlignmentParser parser = new S2SAlignmentParser(S2S.this.workingSession);
                                new FileParsingTask(S2S.this, f, parser, S2S.this.messageBar, S2S.this.workingSession){

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    protected void finished() {
                                        List<StructuralAlignment> alignments = parser.getStructuralAlignments();
                                        StructuralAlignment alignment = null;
                                        if (alignments.size() != 1) {
                                            Object[] names = new String[alignments.size()];
                                            for (int i = 0; i < names.length; ++i) {
                                                names[i] = alignments.get(i).getName();
                                            }
                                            String name = (String)JOptionPane.showInputDialog(S2S.this.window, "Choose an alignment", "Choose an alignment", -1, null, names, names[0]);
                                            if (name == null) return;
                                            for (StructuralAlignment al : alignments) {
                                                if (!al.getName().equals(name)) continue;
                                                alignment = al;
                                                break;
                                            }
                                        } else {
                                            alignment = alignments.get(0);
                                        }
                                        SecondaryStructure ss = alignment.getParentFeatures(SecondaryStructure.class).get(0);
                                        Collection<Molecule> molecules = alignment.getMolecules();
                                        for (Molecule m : ss.getMolecules()) {
                                            if (!molecules.contains(m)) continue;
                                            S2S.this.mediator.setMainAlignment(alignment, m, ss);
                                            S2S.this.mediator.setModel(ss, ss.getSecondaryStructureDisplay());
                                            break;
                                        }
                                        super.finished();
                                    }
                                }.execute();
                            } else {
                                Paradise.setWorkingDirectory(f.getParentFile().getAbsolutePath());
                                final ParadiseProjectIO parser = new ParadiseProjectIO(S2S.this.workingSession);
                                new FileParsingTask(S2S.this, f, parser, S2S.this.messageBar, S2S.this.workingSession){

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    protected void finished() {
                                        List<StructuralAlignment> alignments = parser.getStructuralAlignments();
                                        StructuralAlignment alignment = null;
                                        if (alignments.size() != 1) {
                                            Object[] names = new String[alignments.size()];
                                            for (int i = 0; i < names.length; ++i) {
                                                names[i] = alignments.get(i).getName();
                                            }
                                            String name = (String)JOptionPane.showInputDialog(S2S.this.window, "Choose an alignment", "Choose an alignment", -1, null, names, names[0]);
                                            if (name == null) return;
                                            for (StructuralAlignment al : alignments) {
                                                if (!al.getName().equals(name)) continue;
                                                alignment = al;
                                                break;
                                            }
                                        } else {
                                            alignment = alignments.get(0);
                                        }
                                        SecondaryStructure ss = alignment.getParentFeatures(SecondaryStructure.class).get(0);
                                        Collection<Molecule> alignmentMolecules = alignment.getMolecules();
                                        for (Molecule m : ss.getMolecules()) {
                                            if (!alignmentMolecules.contains(m)) continue;
                                            S2S.this.mediator.setMainAlignment(alignment, m, ss);
                                            S2S.this.mediator.setModel(ss, ss.getSecondaryStructureDisplay());
                                        }
                                        super.finished();
                                    }
                                }.execute();
                            }
                        }
                    }
                });
                load.add(item);
                item = new JMenuItem("RNA alignment");
                if (!S2S.this.isConnected()) {
                    item.setEnabled(false);
                    item.setToolTipText("Need RNA algorithms");
                }
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (S2S.this.mediator.getAlignmentCanvas().getMainAlignment() != null && 0 != JOptionPane.showConfirmDialog(S2S.this.window, "Are you sure to remove your current Alignment?")) {
                            return;
                        }
                        if (S2S.this.mediator.getAlignmentCanvas().getMainAlignment() != null) {
                            S2S.this.mediator.clearSession();
                        }
                        JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                        fileChooser.setFileHidingEnabled(true);
                        fileChooser.setAcceptAllFileFilterUsed(false);
                        final StockholmFileIO parser = new StockholmFileIO(S2S.this.workingSession);
                        fileChooser.setFileFilter(new OpenFileFilter(parser));
                        if (fileChooser.showOpenDialog(null) == 0) {
                            File f = fileChooser.getSelectedFile();
                            Paradise.setWorkingDirectory(f.getAbsolutePath());
                            new FileParsingTask(S2S.this, f, parser, S2S.this.messageBar, S2S.this.workingSession){

                                protected void finished() {
                                    super.finished();
                                    List<StructuralAlignment> alignments = parser.getStructuralAlignments();
                                    StructuralAlignment alignment = null;
                                    if (alignments.size() == 0) {
                                        JOptionPane.showMessageDialog(S2S.this.window, "No alignments available");
                                        return;
                                    }
                                    alignment = alignments.get(0);
                                    if (alignment != null) {
                                        S2S.this.loadRNASecondaryStructure(parser.getSecondaryStructures().get(0));
                                    }
                                }
                            }.execute();
                        }
                    }
                });
                load.add(item);
                item = new JMenuItem("RNA molecule");
                if (!S2S.this.isConnected()) {
                    item.setEnabled(false);
                    item.setToolTipText("Need RNA algorithms");
                }
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (S2S.this.mediator.getAlignmentCanvas().getMainAlignment() != null && 0 != JOptionPane.showConfirmDialog(S2S.this.window, "Are you sure to remove your current Alignment?")) {
                            return;
                        }
                        if (S2S.this.mediator.getAlignmentCanvas().getMainAlignment() != null) {
                            S2S.this.mediator.clearSession();
                        }
                        JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                        fileChooser.setFileHidingEnabled(true);
                        fileChooser.setAcceptAllFileFilterUsed(false);
                        final FastaFileIO parser = new FastaFileIO(S2S.this.workingSession);
                        fileChooser.setFileFilter(new OpenFileFilter(parser));
                        if (fileChooser.showOpenDialog(null) == 0) {
                            File f = fileChooser.getSelectedFile();
                            Paradise.setWorkingDirectory(f.getAbsolutePath());
                            new FileParsingTask(S2S.this, f, parser, S2S.this.messageBar, S2S.this.workingSession){

                                protected void finished() {
                                    super.finished();
                                    List<Molecule> molecules = parser.getMolecules();
                                    Molecule m = null;
                                    if (molecules.size() == 0) {
                                        JOptionPane.showMessageDialog(S2S.this.window, "No molecules available");
                                        return;
                                    }
                                    m = molecules.size() > 1 ? (Molecule)JOptionPane.showInputDialog(S2S.this.window, "Choose a molecule", "Choose a molecule", -1, null, molecules.toArray(), molecules.get(0)) : molecules.get(0);
                                    if (m != null) {
                                        GuiEvent ev = new GuiEvent((Object)this, 1);
                                        ArrayList<Molecule> _molecules = new ArrayList<Molecule>();
                                        _molecules.add(molecules.get(0));
                                        ev.addParameter((Object)new SecondaryStructurePredictionRequestAnswerBehaviour(_molecules, new Parameters()));
                                        ((S2SAgent)S2S.this.getAgent()).postGuiEvent(ev);
                                    }
                                }
                            }.execute();
                        }
                    }
                });
                load.add(item);
                item = new JMenuItem("RNA Secondary Structure");
                if (!S2S.this.isConnected()) {
                    item.setEnabled(false);
                    item.setToolTipText("Need RNA algorithms");
                }
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (S2S.this.mediator.getAlignmentCanvas().getMainAlignment() != null && 0 != JOptionPane.showConfirmDialog(S2S.this.window, "Are you sure to remove your current Alignment?")) {
                            return;
                        }
                        if (S2S.this.mediator.getAlignmentCanvas().getMainAlignment() != null) {
                            S2S.this.mediator.clearSession();
                        }
                        JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                        fileChooser.setFileHidingEnabled(true);
                        fileChooser.setAcceptAllFileFilterUsed(false);
                        fileChooser.setFileFilter(new OpenFileFilter(new BPSeqFileIO(S2S.this.workingSession)));
                        fileChooser.setFileFilter(new OpenFileFilter(new CTFileIO(S2S.this.workingSession)));
                        fileChooser.setFileFilter(new OpenFileFilter(new FastaFileIO(S2S.this.workingSession)));
                        if (fileChooser.showOpenDialog(null) == 0) {
                            File f = fileChooser.getSelectedFile();
                            Paradise.setWorkingDirectory(f.getAbsolutePath());
                            final ParadiseFileIO parser = ((OpenFileFilter)fileChooser.getFileFilter()).getParser();
                            new FileParsingTask(S2S.this, f, parser, S2S.this.messageBar, S2S.this.workingSession){

                                protected void finished() {
                                    if (FastaFileIO.class.isInstance(parser)) {
                                        Molecule m = parser.getMolecules().get(0);
                                        String bn = ((FastaFileIO)parser).getBracketNotation(m);
                                        if (bn != null) {
                                            GuiEvent ev = new GuiEvent((Object)this, 3);
                                            ArrayList<Molecule> molecules = new ArrayList<Molecule>();
                                            if (RNA.class.isInstance(m)) {
                                                m.removeAllSelectedFeatures();
                                                molecules.add(m);
                                            }
                                            try {
                                                File f = IOUtils.createTemporaryFile("bracketNotation");
                                                CTFileIO.writeCTFile(f, m.printSequence(), bn);
                                                CTFileIO parser2 = new CTFileIO(S2S.this.workingSession);
                                                parser2.parseFile(f, new DefaultProgressMonitor());
                                                SecondaryStructure ss = parser2.getSecondaryStructures().get(0);
                                                SecondaryStructure copySS = ss.getFactory().copySecondaryStructure(Arrays.asList(m), ss, false);
                                                m.addSelectedFeature(copySS);
                                            }
                                            catch (Exception e1) {
                                                e1.printStackTrace();
                                            }
                                            ev.addParameter((Object)new SecondaryStructureDrawingRequestAnswerBehaviour(molecules, new Parameters()));
                                            ((AbstractParadiseToolAgent)S2S.this.getAgent()).postGuiEvent(ev);
                                        } else {
                                            JOptionPane.showMessageDialog(S2S.this.window, "No Secondary Structure described in the FASTA file");
                                        }
                                    } else {
                                        S2S.this.loadRNASecondaryStructure(parser.getSecondaryStructures().get(0));
                                    }
                                }
                            }.execute();
                        }
                    }
                });
                load.add(item);
                item = new JMenuItem("RNA Tertiary Structure");
                if (!S2S.this.isConnected()) {
                    item.setEnabled(false);
                    item.setToolTipText("Need RNA algorithms");
                }
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (S2S.this.mediator.getAlignmentCanvas().getMainAlignment() != null && 0 != JOptionPane.showConfirmDialog(S2S.this.window, "Are you sure to remove your current Alignment?")) {
                            return;
                        }
                        if (S2S.this.mediator.getAlignmentCanvas().getMainAlignment() != null) {
                            S2S.this.mediator.clearSession();
                        }
                        JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                        fileChooser.setFileHidingEnabled(true);
                        fileChooser.setAcceptAllFileFilterUsed(false);
                        final PDBFileIO pdbParser = new PDBFileIO(S2S.this.workingSession);
                        fileChooser.setFileFilter(new OpenFileFilter(pdbParser));
                        if (fileChooser.showOpenDialog(null) == 0) {
                            File f = fileChooser.getSelectedFile();
                            Paradise.setWorkingDirectory(f.getAbsolutePath());
                            new FileParsingTask(S2S.this, f, pdbParser, S2S.this.messageBar, S2S.this.workingSession){

                                protected void finished() {
                                    super.finished();
                                    TertiaryStructure ts = pdbParser.getTertiaryStructures().get(0);
                                    GuiEvent ev = new GuiEvent((Object)this, 2);
                                    ArrayList<Molecule> molecules = new ArrayList<Molecule>();
                                    for (Molecule m : ts.getMolecules()) {
                                        m.removeAllSelectedFeatures();
                                        for (Residue3D r : ts.getSubFeatures(Residue3D.class, m)) {
                                            m.addSelectedFeature(r);
                                        }
                                        molecules.add(m);
                                    }
                                    ev.addParameter((Object)new TertiaryStructureAnnotationRequestAnswerBehaviour(molecules, new Parameters()));
                                    ((S2SAgent)S2S.this.getAgent()).postGuiEvent(ev);
                                }
                            }.execute();
                        }
                    }
                });
                load.add(item);
                JMenu importMenu = new JMenu("Import RNA molecules..."){

                    public void paintComponent(Graphics graphics) {
                        this.setEnabled(S2S.this.mediator.getAlignmentCanvas().getMainAlignment() != null);
                        super.paintComponent(graphics);
                    }
                };
                if (!S2S.this.isConnected()) {
                    importMenu.setEnabled(false);
                    importMenu.setToolTipText("Need RNA algorithms");
                }
                importMenu.setIcon(RessourcesUtils.getIcon("open.png"));
                this.add(importMenu);
                item = new JMenuItem("Search new candidates");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        new SelectDatabasesFrame();
                    }
                });
                item = new JMenuItem("from local files");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (S2S.this.mediator.getAlignmentCanvas() != null) {
                            JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                            fileChooser.setAcceptAllFileFilterUsed(false);
                            fileChooser.setFileHidingEnabled(true);
                            fileChooser.setFileFilter(new FileFilter(){

                                public boolean accept(File file) {
                                    if (file.isDirectory()) {
                                        return true;
                                    }
                                    for (String suffix : FastaFileIO.suffixes) {
                                        if (!file.getName().endsWith(suffix)) continue;
                                        return true;
                                    }
                                    return false;
                                }

                                public String getDescription() {
                                    return "Fasta Files";
                                }
                            });
                            fileChooser.setFileFilter(new FileFilter(){

                                public boolean accept(File file) {
                                    if (file.isDirectory()) {
                                        return true;
                                    }
                                    for (String suffix : CTFileIO.suffixes) {
                                        if (!file.getName().endsWith(suffix)) continue;
                                        return true;
                                    }
                                    return false;
                                }

                                public String getDescription() {
                                    return "Ct Files";
                                }
                            });
                            fileChooser.setFileFilter(new FileFilter(){

                                public boolean accept(File file) {
                                    if (file.isDirectory()) {
                                        return true;
                                    }
                                    for (String suffix : BPSeqFileIO.suffixes) {
                                        if (!file.getName().endsWith(suffix)) continue;
                                        return true;
                                    }
                                    return false;
                                }

                                public String getDescription() {
                                    return "BPseq Files";
                                }
                            });
                            if (fileChooser.showOpenDialog(null) == 0) {
                                final File file = fileChooser.getSelectedFile();
                                final boolean automaticAlignment = JOptionPane.showConfirmDialog(null, "Do you want to align your new sequences automatically?") == 0;
                                final StringBuffer structuralAlignmentAgentName = new StringBuffer();
                                if (automaticAlignment) {
                                    DFAgentDescription[] descriptions = S2S.this.agent.findAgents("structural alignment");
                                    if (descriptions.length > 1) {
                                        Object[] agentNames = new Object[descriptions.length];
                                        for (int i = 0; i < descriptions.length; ++i) {
                                            agentNames[i] = descriptions[i].getName().getLocalName().split("\\[at\\]")[0];
                                        }
                                        structuralAlignmentAgentName.append((String)JOptionPane.showInputDialog(null, "Please choose a service", "structural alignment", -1, null, agentNames, agentNames[0]));
                                    } else if (descriptions.length == 0) {
                                        JOptionPane.showMessageDialog(null, "No service found for the category: structural alignment");
                                    } else {
                                        structuralAlignmentAgentName.append(descriptions[0].getName().getLocalName().split("\\[at\\]")[0]);
                                    }
                                }
                                if (fileChooser.getFileFilter().getDescription().endsWith("Ct Files")) {
                                    new ParadiseTask(S2S.this.mediator.getS2s(), S2S.this.mediator.getS2s().getProgressMonitor()){

                                        protected Object doInBackground() throws Exception {
                                            CTFileIO parser = new CTFileIO(S2S.this.workingSession);
                                            parser.parseFile(file, S2S.this.mediator.getS2s().getProgressMonitor());
                                            Molecule m = parser.getMolecules().get(0);
                                            if (automaticAlignment) {
                                                GuiEvent ev = new GuiEvent((Object)this, 0);
                                                ArrayList<Molecule> molecules = new ArrayList<Molecule>();
                                                Molecule refMol = S2S.this.mediator.getAlignmentCanvas().getMainAlignment().getBiologicalReferenceSequence().getMolecule();
                                                refMol.addSelectedFeature(S2S.this.mediator.getAlignmentCanvas().getMainAlignment().getReferenceStructure());
                                                m.addSelectedFeature(parser.getSecondaryStructures().get(0));
                                                molecules.add(refMol);
                                                molecules.add(m);
                                                m.addSelectedFeature(parser.getSecondaryStructures().get(0));
                                                ev.addParameter((Object)new StructuralAlignmentRequestAnswerBehaviour(molecules, new Parameters()));
                                                ev.addParameter((Object)structuralAlignmentAgentName.toString());
                                                ((AbstractParadiseToolAgent)S2S.this.agent).postGuiEvent(ev);
                                            } else {
                                                BiologicalSequence seq = new BiologicalSequence(m);
                                                S2S.this.mediator.getAlignmentCanvas().getMainAlignment().addBiologicalSequence(seq);
                                                S2S.this.mediator.getSequencesList().addRow(seq.getMolecule());
                                                S2S.this.mediator.getAlignmentCanvas().repaint();
                                            }
                                            this.finished();
                                            return null;
                                        }
                                    }.execute();
                                } else if (fileChooser.getFileFilter().getDescription().endsWith("BPseq Files")) {
                                    new ParadiseTask(S2S.this.mediator.getS2s(), S2S.this.mediator.getS2s().getProgressMonitor()){

                                        protected Object doInBackground() throws Exception {
                                            BPSeqFileIO parser = new BPSeqFileIO(S2S.this.workingSession);
                                            parser.parseFile(file, S2S.this.mediator.getS2s().getProgressMonitor());
                                            Molecule m = parser.getMolecules().get(0);
                                            if (automaticAlignment) {
                                                GuiEvent ev = new GuiEvent((Object)this, 0);
                                                ArrayList<Molecule> molecules = new ArrayList<Molecule>();
                                                Molecule refMol = S2S.this.mediator.getAlignmentCanvas().getMainAlignment().getBiologicalReferenceSequence().getMolecule();
                                                refMol.addSelectedFeature(S2S.this.mediator.getAlignmentCanvas().getMainAlignment().getReferenceStructure());
                                                m.addSelectedFeature(parser.getSecondaryStructures().get(0));
                                                molecules.add(refMol);
                                                molecules.add(m);
                                                m.addSelectedFeature(parser.getSecondaryStructures().get(0));
                                                ev.addParameter((Object)new StructuralAlignmentRequestAnswerBehaviour(molecules, new Parameters()));
                                                ev.addParameter((Object)structuralAlignmentAgentName.toString());
                                                ((AbstractParadiseToolAgent)S2S.this.agent).postGuiEvent(ev);
                                            } else {
                                                BiologicalSequence seq = new BiologicalSequence(m);
                                                S2S.this.mediator.getAlignmentCanvas().getMainAlignment().addBiologicalSequence(seq);
                                                S2S.this.mediator.getSequencesList().addRow(seq.getMolecule());
                                                S2S.this.mediator.getAlignmentCanvas().repaint();
                                            }
                                            this.finished();
                                            return null;
                                        }
                                    }.execute();
                                } else if (fileChooser.getFileFilter().getDescription().endsWith("Fasta Files")) {
                                    new ParadiseTask(S2S.this.mediator.getS2s(), S2S.this.mediator.getS2s().getProgressMonitor()){

                                        protected Object doInBackground() throws Exception {
                                            S2S.this.messageBar.startAnimation();
                                            FastaFileIO parser = new FastaFileIO(S2S.this.workingSession);
                                            parser.parseFile(file, S2S.this.mediator.getS2s().getProgressMonitor());
                                            if (automaticAlignment) {
                                                DFAgentDescription[] descriptions = S2S.this.agent.findAgents("2D prediction");
                                                String agentName = null;
                                                if (descriptions.length > 1) {
                                                    Object[] agentNames = new Object[descriptions.length];
                                                    for (int i = 0; i < descriptions.length; ++i) {
                                                        agentNames[i] = descriptions[i].getName().getLocalName().split("\\[at\\]")[0];
                                                    }
                                                    this.monitor.stopAnimation();
                                                    agentName = (String)JOptionPane.showInputDialog(null, "Please choose a service", "2D prediction", -1, null, agentNames, agentNames[0]);
                                                } else if (descriptions.length == 0) {
                                                    JOptionPane.showMessageDialog(null, "No service found for the category: 2D prediction");
                                                    this.monitor.stopAnimation();
                                                } else {
                                                    agentName = descriptions[0].getName().getLocalName().split("\\[at\\]")[0];
                                                }
                                                for (Molecule m : parser.getMolecules()) {
                                                    GuiEvent ev = new GuiEvent((Object)this, 1);
                                                    ArrayList<Molecule> molecules = new ArrayList<Molecule>();
                                                    molecules.add(m);
                                                    ev.addParameter((Object)new SecondaryStructurePredictionBeforeStructuralAlignmentAnswerBehaviour(molecules, new Parameters(), structuralAlignmentAgentName.toString()));
                                                    ev.addParameter((Object)agentName);
                                                    ((AbstractParadiseToolAgent)S2S.this.agent).postGuiEvent(ev);
                                                }
                                            } else {
                                                for (Molecule m : parser.getMolecules()) {
                                                    BiologicalSequence seq = new BiologicalSequence(m);
                                                    S2S.this.mediator.getAlignmentCanvas().getMainAlignment().addBiologicalSequence(seq);
                                                    S2S.this.mediator.getSequencesList().addRow(seq.getMolecule());
                                                    S2S.this.mediator.getAlignmentCanvas().repaint();
                                                }
                                            }
                                            this.finished();
                                            return null;
                                        }
                                    }.execute();
                                }
                            }
                        }
                    }
                });
                importMenu.add(item);
                item = new JMenuItem("Save Alignment"){

                    public void paintComponent(Graphics graphics) {
                        this.setEnabled(S2S.this.getCurrentFeature() != null && S2S.this.getCurrentFeature().getAssociatedFile() != null);
                        super.paintComponent(graphics);
                    }
                };
                item.setIcon(RessourcesUtils.getIcon("saveas.png"));
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        final File saveFile = S2S.this.mediator.getAlignmentCanvas().getMainAlignment().getStructuralAlignment().getAssociatedFile();
                        new ParadiseTask(S2S.this, S2S.this.messageBar){

                            protected Object doInBackground() {
                                try {
                                    S2S.this.messageBar.startAnimation();
                                    S2S.this.synchronize();
                                    if (saveFile.getName().endsWith(".rnaml")) {
                                        ParadiseProjectIO.saveWorkingSession(saveFile.getParentFile().getParentFile(), Arrays.asList(S2S.this.mediator.getAlignmentCanvas().getMainAlignment().getStructuralAlignment()));
                                        S2S.this.setS2SLastSavePath(saveFile.getParentFile().getParentFile().getParentFile());
                                    } else if (saveFile.getName().endsWith(".assemble")) {
                                        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(saveFile));
                                        oos.writeObject(S2S.this.mediator.getAlignmentCanvas().getMainAlignment().getStructuralAlignment());
                                        oos.flush();
                                        oos.close();
                                        S2S.this.setS2SLastSavePath(saveFile.getParentFile());
                                    }
                                    this.monitor.printMessage("Saving successful");
                                }
                                catch (Exception e) {
                                    this.monitor.printException(e);
                                }
                                this.finished();
                                return null;
                            }
                        }.execute();
                    }
                });
                this.add(item);
                item = new JMenuItem("Save Alignment As..."){

                    public void paintComponent(Graphics graphics) {
                        this.setEnabled(S2S.this.getCurrentFeature() != null);
                        super.paintComponent(graphics);
                    }
                };
                item.setIcon(RessourcesUtils.getIcon("saveas.png"));
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        JFileChooser fileChooser = new JFileChooser(S2S.this.getS2SLastSavePath());
                        fileChooser.setFileView(new FileView(){

                            public Icon getIcon(File f) {
                                if (IOUtils.isParadiseProject(f)) {
                                    return new ImageIcon(RessourcesUtils.getImage("paradise-project.png"));
                                }
                                if (f.getName().endsWith(".s2s")) {
                                    return new ImageIcon(RessourcesUtils.getImage("paradise-project.png"));
                                }
                                return null;
                            }

                            public Boolean isTraversable(File f) {
                                return f.isDirectory() && !IOUtils.isParadiseProject(f);
                            }
                        });
                        fileChooser.setFileHidingEnabled(true);
                        fileChooser.setAcceptAllFileFilterUsed(false);
                        fileChooser.setFileSelectionMode(2);
                        fileChooser.setFileFilter(new FileFilter(){

                            public boolean accept(File file) {
                                return file.isDirectory() && !IOUtils.isParadiseProject(file) || file.getName().endsWith(".s2s");
                            }

                            public String getDescription() {
                                return "S2S alignments (binary data)";
                            }
                        });
                        fileChooser.setFileFilter(new FileFilter(){

                            public boolean accept(File file) {
                                return file.isDirectory() && !IOUtils.isParadiseProject(file) || IOUtils.containsStructuralAlignmentData(file);
                            }

                            public String getDescription() {
                                return "S2S alignments (textual data)";
                            }
                        });
                        if (fileChooser.showSaveDialog(S2S.this.window) == 0) {
                            final File saveFile = fileChooser.getSelectedFile();
                            new ParadiseTask(S2S.this, S2S.this.messageBar){

                                protected Object doInBackground() {
                                    try {
                                        S2S.this.messageBar.startAnimation();
                                        S2S.this.synchronize();
                                        if (saveFile.getName().endsWith(".s2s")) {
                                            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(saveFile));
                                            oos.writeObject(S2S.this.mediator.getAlignmentCanvas().getMainAlignment().getStructuralAlignment());
                                            oos.flush();
                                            oos.close();
                                            S2S.this.mediator.getAlignmentCanvas().getMainAlignment().getStructuralAlignment().setAssociatedFile(saveFile);
                                            S2S.this.setS2SLastSavePath(saveFile.getParentFile());
                                        } else {
                                            ParadiseProjectIO.saveWorkingSession(saveFile, Arrays.asList(S2S.this.mediator.getAlignmentCanvas().getMainAlignment().getStructuralAlignment()));
                                            S2S.this.setS2SLastSavePath(saveFile.getParentFile());
                                        }
                                        this.monitor.printMessage("Saving successful");
                                    }
                                    catch (Exception e) {
                                        this.monitor.printException(e);
                                    }
                                    this.finished();
                                    return null;
                                }
                            }.execute();
                        }
                    }
                });
                this.add(item);
                JMenu exportMenu = new JMenu("Export..."){

                    public void paintComponent(Graphics graphics) {
                        this.setEnabled(S2S.this.getCurrentFeature() != null);
                        super.paintComponent(graphics);
                    }
                };
                exportMenu.setIcon(RessourcesUtils.getIcon("saveas.png"));
                this.add(exportMenu);
                item = new JMenuItem("Alignment as FASTA file"){

                    public void paintComponent(Graphics graphics) {
                        this.setEnabled(S2S.this.getCurrentFeature() != null);
                        super.paintComponent(graphics);
                    }
                };
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        final JFileChooser saveFile = new JFileChooser(S2S.this.getS2SLastSavePath());
                        saveFile.setAcceptAllFileFilterUsed(false);
                        saveFile.setFileHidingEnabled(true);
                        saveFile.setFileFilter(new FileFilter(){

                            public boolean accept(File file) {
                                if (file.isDirectory()) {
                                    return true;
                                }
                                for (String suffix : FastaFileIO.suffixes) {
                                    if (!file.getName().endsWith(suffix)) continue;
                                    return true;
                                }
                                return false;
                            }

                            public String getDescription() {
                                return "FASTA files";
                            }
                        });
                        if (saveFile.showSaveDialog(S2S.this.window) == 0) {
                            S2S.this.setS2SLastSavePath(saveFile.getSelectedFile());
                            new ParadiseTask(S2S.this, S2S.this.messageBar){

                                protected Object doInBackground() {
                                    try {
                                        S2S.this.messageBar.startAnimation();
                                        S2S.this.synchronize();
                                        ArrayList<String> names = new ArrayList<String>();
                                        ArrayList<String> sequences = new ArrayList<String>();
                                        for (BiologicalSequence s : S2S.this.mediator.getAlignmentCanvas().getMainAlignment().getBiologicalSequences()) {
                                            names.add(s.getMolecule().getName());
                                            sequences.add(s.getSequence());
                                        }
                                        FastaFileIO.exportMoleculesAsFastaFile(saveFile.getSelectedFile(), names, sequences);
                                        this.monitor.printMessage("Export successful");
                                    }
                                    catch (Exception e) {
                                        this.monitor.printException(e);
                                    }
                                    return null;
                                }
                            }.execute();
                        }
                    }
                });
                exportMenu.add(item);
                item = new JMenuItem("2D Model as CT file"){

                    public void paintComponent(Graphics graphics) {
                        this.setEnabled(S2S.this.getCurrentFeature() != null);
                        super.paintComponent(graphics);
                    }
                };
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                        fileChooser.setAcceptAllFileFilterUsed(false);
                        fileChooser.setFileHidingEnabled(true);
                        fileChooser.setFileFilter(new FileFilter(){

                            public boolean accept(File file) {
                                if (file.isDirectory()) {
                                    return true;
                                }
                                for (String suffix : CTFileIO.suffixes) {
                                    if (!file.getName().endsWith(suffix)) continue;
                                    return true;
                                }
                                return false;
                            }

                            public String getDescription() {
                                return "CT files";
                            }
                        });
                        if (fileChooser.showSaveDialog(null) == 0) {
                            final File file = fileChooser.getSelectedFile();
                            new ParadiseTask(S2S.this, S2S.this.messageBar){

                                protected Object doInBackground() {
                                    try {
                                        S2S.this.messageBar.startAnimation();
                                        if (!file.exists()) {
                                            file.createNewFile();
                                        }
                                        ArrayList<Residue> residues = new ArrayList<Residue>();
                                        HashSet<BaseBaseInteraction> interactions = new HashSet<BaseBaseInteraction>();
                                        for (Residue2D r2D : S2S.this.mediator.getRna2dViewer().getSecondaryCanvas().getModel2D().getResidues()) {
                                            residues.add(r2D.getResidue2DFeature().getResidues().iterator().next());
                                            for (Interaction2D interaction : r2D.getInteractions()) {
                                                if (!BaseBaseInteraction2D.class.isInstance(interaction) || !((BaseBaseInteraction2D)interaction).getBaseBaseInteractionFeature().isSecondaryInteraction()) continue;
                                                interactions.add(((BaseBaseInteraction2D)interaction).getBaseBaseInteractionFeature());
                                            }
                                        }
                                        Collections.sort(residues, new Comparator(){

                                            public int compare(Object o1, Object o2) {
                                                return ((Residue)o1).getAbsolutePosition() - ((Residue)o2).getAbsolutePosition();
                                            }
                                        });
                                        CTFileIO.writeCTFile(residues, new ArrayList<BaseBaseInteraction>(interactions), file);
                                        this.monitor.printMessage("Export successful");
                                    }
                                    catch (Exception e) {
                                        this.monitor.printException(e);
                                    }
                                    this.finished();
                                    return null;
                                }
                            }.execute();
                        }
                    }
                });
                exportMenu.add(item);
                item = new JMenuItem("2D Model as SVG file"){

                    public void paintComponent(Graphics graphics) {
                        this.setEnabled(S2S.this.getCurrentFeature() != null);
                        super.paintComponent(graphics);
                    }
                };
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                        fileChooser.setAcceptAllFileFilterUsed(false);
                        fileChooser.setFileHidingEnabled(true);
                        fileChooser.setFileFilter(new FileFilter(){

                            public boolean accept(File file) {
                                return file.isDirectory() || file.getName().endsWith("svg");
                            }

                            public String getDescription() {
                                return "SVG files";
                            }
                        });
                        if (fileChooser.showSaveDialog(null) == 0) {
                            final File file = fileChooser.getSelectedFile();
                            new ParadiseTask(S2S.this, S2S.this.messageBar){

                                protected Object doInBackground() {
                                    try {
                                        S2S.this.messageBar.startAnimation();
                                        if (!file.exists()) {
                                            file.createNewFile();
                                        }
                                        PrintWriter pw = new PrintWriter(file);
                                        pw.print(S2S.this.mediator.getRna2dViewer().getSecondaryCanvas().toSVG());
                                        pw.close();
                                        this.monitor.printMessage("Export successful");
                                    }
                                    catch (Exception e) {
                                        this.monitor.printException(e);
                                    }
                                    this.finished();
                                    return null;
                                }
                            }.execute();
                        }
                    }
                });
                exportMenu.add(item);
                JMenu selectionMenu = new JMenu("Selection..."){

                    public void paintComponent(Graphics graphics) {
                        this.setEnabled(S2S.this.getCurrentFeature() != null);
                        super.paintComponent(graphics);
                    }
                };
                exportMenu.add(selectionMenu);
                item = new JMenuItem("Alignment Selection as FASTA file"){

                    public void paintComponent(Graphics graphics) {
                        this.setEnabled(S2S.this.getCurrentFeature() != null);
                        super.paintComponent(graphics);
                    }
                };
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        final JFileChooser saveFile = new JFileChooser(S2S.this.getS2SLastSavePath());
                        saveFile.setAcceptAllFileFilterUsed(false);
                        saveFile.setFileHidingEnabled(true);
                        saveFile.setFileFilter(new FileFilter(){

                            public boolean accept(File file) {
                                if (file.isDirectory()) {
                                    return true;
                                }
                                for (String suffix : FastaFileIO.suffixes) {
                                    if (!file.getName().endsWith(suffix)) continue;
                                    return true;
                                }
                                return false;
                            }

                            public String getDescription() {
                                return "Fasta files";
                            }
                        });
                        if (saveFile.showSaveDialog(S2S.this.window) == 0) {
                            S2S.this.setS2SLastSavePath(saveFile.getSelectedFile());
                            new ParadiseTask(S2S.this, S2S.this.messageBar){

                                protected Object doInBackground() {
                                    try {
                                        S2S.this.messageBar.startAnimation();
                                        S2S.this.synchronize();
                                        ArrayList<String> names = new ArrayList<String>();
                                        ArrayList<String> sequences = new ArrayList<String>();
                                        int start = -1;
                                        int currentPosition = -1;
                                        StringBuffer sequence = null;
                                        String currentName = null;
                                        for (BiologicalSequence s : S2S.this.mediator.getAlignmentCanvas().getMainAlignment().getBiologicalSequences()) {
                                            for (int i = 0; i < s.size(); ++i) {
                                                Symbol symbol = s.getSymbol(i);
                                                int positionInSequence = symbol.getPositionInSequence();
                                                if (!s.isSelectedPosition(positionInSequence)) continue;
                                                if (positionInSequence - 1 != currentPosition) {
                                                    if (sequence != null) {
                                                        names.add(currentName + " (" + start + "-" + currentPosition + ")");
                                                        sequences.add(sequence.toString());
                                                    }
                                                    currentName = s.getMolecule().getName();
                                                    currentPosition = positionInSequence;
                                                    start = positionInSequence;
                                                    sequence = new StringBuffer();
                                                    sequence.append(symbol.getSymbol());
                                                    continue;
                                                }
                                                sequence.append(symbol.getSymbol());
                                                currentPosition = positionInSequence;
                                            }
                                        }
                                        if (sequence != null) {
                                            names.add(currentName + " (" + start + "-" + currentPosition + ")");
                                            sequences.add(sequence.toString());
                                        }
                                        FastaFileIO.exportMoleculesAsFastaFile(saveFile.getSelectedFile(), names, sequences);
                                        this.monitor.printMessage("Export successful");
                                    }
                                    catch (Exception e) {
                                        this.monitor.printException(e);
                                    }
                                    return null;
                                }
                            }.execute();
                        }
                    }
                });
                selectionMenu.add(item);
                item = new JMenuItem("2D Model Selection as CT file"){

                    public void paintComponent(Graphics graphics) {
                        this.setEnabled(S2S.this.getCurrentFeature() != null);
                        super.paintComponent(graphics);
                    }
                };
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                        fileChooser.setAcceptAllFileFilterUsed(false);
                        fileChooser.setFileHidingEnabled(true);
                        fileChooser.setFileFilter(new FileFilter(){

                            public boolean accept(File file) {
                                if (file.isDirectory()) {
                                    return true;
                                }
                                for (String suffix : CTFileIO.suffixes) {
                                    if (!file.getName().endsWith(suffix)) continue;
                                    return true;
                                }
                                return false;
                            }

                            public String getDescription() {
                                return "CT files";
                            }
                        });
                        if (fileChooser.showSaveDialog(null) == 0) {
                            final File file = fileChooser.getSelectedFile();
                            new ParadiseTask(S2S.this, S2S.this.messageBar){

                                protected Object doInBackground() {
                                    try {
                                        S2S.this.messageBar.startAnimation();
                                        if (!file.exists()) {
                                            file.createNewFile();
                                        }
                                        ArrayList<Residue> residues = new ArrayList<Residue>();
                                        HashSet<BaseBaseInteraction> interactions = new HashSet<BaseBaseInteraction>();
                                        for (Residue2D r2D : S2S.this.mediator.getRna2dViewer().getSecondaryCanvas().getCurrentResidues()) {
                                            residues.add(r2D.getResidue2DFeature().getResidues().iterator().next());
                                            for (Interaction2D interaction : r2D.getInteractions()) {
                                                if (!BaseBaseInteraction2D.class.isInstance(interaction) || !((BaseBaseInteraction2D)interaction).getBaseBaseInteractionFeature().isSecondaryInteraction()) continue;
                                                interactions.add(((BaseBaseInteraction2D)interaction).getBaseBaseInteractionFeature());
                                            }
                                        }
                                        Collections.sort(residues, new Comparator(){

                                            public int compare(Object o1, Object o2) {
                                                return ((Residue)o1).getAbsolutePosition() - ((Residue)o2).getAbsolutePosition();
                                            }
                                        });
                                        CTFileIO.writeCTFile(residues, new ArrayList<BaseBaseInteraction>(interactions), file);
                                        this.monitor.printMessage("Export successful");
                                    }
                                    catch (Exception e) {
                                        this.monitor.printException(e);
                                    }
                                    this.finished();
                                    return null;
                                }
                            }.execute();
                        }
                    }
                });
                selectionMenu.add(item);
                item = new JMenuItem("Quit");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (JOptionPane.showConfirmDialog(null, "Are you sure you want to exit S2S?", "Confirm exit", 0) == 0) {
                            try {
                                S2SConfig.save();
                                backup.delete();
                            }
                            catch (BackingStoreException e1) {
                                e1.printStackTrace();
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                            System.exit(0);
                        }
                    }
                });
                this.add(item);
            }
        }

        private class UpdateMenuItem
        extends JMenuItem
        implements ActionListener {
            private UpdateMenuItem() {
                super("Update S2S");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                new SwingWorker(){

                    protected Object doInBackground() throws Exception {
                        S2S.updateS2S();
                        return null;
                    }
                }.execute();
            }
        }
    }
}

