/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.core.io.AbstractParadiseFileIO;
import fr.unistra.ibmc.paradise.core.io.FileParsingException;
import fr.unistra.ibmc.paradise.tools.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.tools.component.ProgressMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2SAlignmentParser
extends AbstractParadiseFileIO {
    private List<Molecule> molecules;
    private StructuralAlignment alignment;

    public S2SAlignmentParser(MoleculeFactory moleculeFactory) {
        super("S2S structural alignement parser", moleculeFactory);
    }

    @Override
    public List<Molecule> getMolecules() {
        return this.molecules;
    }

    @Override
    public List<StructuralAlignment> getStructuralAlignments() {
        return Arrays.asList(this.alignment);
    }

    @Override
    public List<SecondaryStructure> getSecondaryStructures() {
        return new ArrayList<SecondaryStructure>();
    }

    @Override
    public List<TertiaryStructure> getTertiaryStructures() {
        return new ArrayList<TertiaryStructure>();
    }

    @Override
    public void parseFile(File f, ProgressMonitor monitor) throws FileParsingException, InterruptedException {
        this.molecules = new ArrayList<Molecule>();
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
            Object o = ois.readObject();
            if (StructuralAlignment.class.isInstance(o)) {
                this.alignment = (StructuralAlignment)o;
                this.molecules.addAll(this.alignment.getMolecules());
                ((ParadiseWorkingSession)this.moleculeFactory).addAllMolecules(this.molecules);
            }
            ois.close();
        }
        catch (Exception e) {
            throw new FileParsingException(e);
        }
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith("s2s");
            }

            public String getDescription() {
                return "S2S alignments";
            }
        };
    }
}

