/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s;

import fr.unistra.ibmc.s2s.S2S;
import fr.unistra.ibmc.s2s.rnalign.graphics.AlignmentCanvas;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class S2SConfig {
    private static Document document;

    public static void parseConfigFile() throws BackingStoreException, IOException {
        File configFile;
        File s2sUserDir = new File(S2S.getUserDirPath());
        if (!s2sUserDir.exists()) {
            s2sUserDir.mkdir();
        }
        if (!(configFile = new File(s2sUserDir, "config.xml")).exists()) {
            Element root = new Element("s2s-config");
            root.setAttribute("version", "S2S 2.0, Release Candidate 3");
            document = new Document(root);
            root.addContent((Content)new Element("platform-addresses"));
            Element externalViewers = new Element("external-viewers");
            externalViewers.addContent((Content)new Element("pymol-path"));
            externalViewers.addContent((Content)new Element("chimera-path"));
            externalViewers.addContent((Content)new Element("vmd-path"));
            root.addContent((Content)externalViewers);
            S2SConfig.save();
        } else {
            SAXBuilder builder = new SAXBuilder();
            try {
                document = builder.build(configFile);
                if (document.getRootElement().getAttribute("version") == null) {
                    configFile.delete();
                    Element root = new Element("s2s-config");
                    root.setAttribute("version", "S2S 2.0, Release Candidate 3");
                    document = new Document(root);
                    root.addContent((Content)new Element("platform-addresses"));
                    Element externalViewers = new Element("external-viewers");
                    externalViewers.addContent((Content)new Element("pymol-path"));
                    externalViewers.addContent((Content)new Element("chimera-path"));
                    externalViewers.addContent((Content)new Element("vmd-path"));
                    root.addContent((Content)externalViewers);
                    S2SConfig.save();
                } else {
                    Element colors = document.getRootElement().getChild("colors");
                    if (colors != null) {
                        for (Object o : colors.getChildren("color")) {
                            Element color = (Element)o;
                            String[] value = color.getAttributeValue("value").split(" ");
                            String target = color.getAttributeValue("target");
                            if ("secondary-interactions".equals(target)) {
                                AlignmentCanvas.SecondaryInteraction_Color = new Color(Integer.parseInt(value[0]), Integer.parseInt(value[1]), Integer.parseInt(value[2]));
                            } else if ("tertiary-interactions".equals(target)) {
                                AlignmentCanvas.TertiaryInteraction_Color = new Color(Integer.parseInt(value[0]), Integer.parseInt(value[1]), Integer.parseInt(value[2]));
                            } else if ("adenine".equals(target)) {
                                AlignmentCanvas.A_Color = new Color(Integer.parseInt(value[0]), Integer.parseInt(value[1]), Integer.parseInt(value[2]));
                            } else if ("uracil".equals(target)) {
                                AlignmentCanvas.U_Color = new Color(Integer.parseInt(value[0]), Integer.parseInt(value[1]), Integer.parseInt(value[2]));
                            } else if ("guanine".equals(target)) {
                                AlignmentCanvas.G_Color = new Color(Integer.parseInt(value[0]), Integer.parseInt(value[1]), Integer.parseInt(value[2]));
                            }
                            if (!"cytosine".equals(target)) continue;
                            AlignmentCanvas.C_Color = new Color(Integer.parseInt(value[0]), Integer.parseInt(value[1]), Integer.parseInt(value[2]));
                        }
                    }
                }
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveUserColors() {
        Element colors = document.getRootElement().getChild("colors");
        if (colors == null) {
            colors = new Element("colors");
            document.getRootElement().addContent((Content)colors);
        } else {
            colors.removeChildren("color");
        }
        Element color = new Element("color");
        colors.addContent((Content)color);
        color.setAttribute("target", "secondary-interactions");
        color.setAttribute("value", AlignmentCanvas.SecondaryInteraction_Color.getRed() + " " + AlignmentCanvas.SecondaryInteraction_Color.getGreen() + " " + AlignmentCanvas.SecondaryInteraction_Color.getBlue());
        color = new Element("color");
        colors.addContent((Content)color);
        color.setAttribute("target", "tertiary-interactions");
        color.setAttribute("value", AlignmentCanvas.TertiaryInteraction_Color.getRed() + " " + AlignmentCanvas.TertiaryInteraction_Color.getGreen() + " " + AlignmentCanvas.TertiaryInteraction_Color.getBlue());
        color = new Element("color");
        colors.addContent((Content)color);
        color.setAttribute("target", "adenine");
        color.setAttribute("value", AlignmentCanvas.A_Color.getRed() + " " + AlignmentCanvas.A_Color.getGreen() + " " + AlignmentCanvas.A_Color.getBlue());
        color = new Element("color");
        colors.addContent((Content)color);
        color.setAttribute("target", "uracil");
        color.setAttribute("value", AlignmentCanvas.U_Color.getRed() + " " + AlignmentCanvas.U_Color.getGreen() + " " + AlignmentCanvas.U_Color.getBlue());
        color = new Element("color");
        colors.addContent((Content)color);
        color.setAttribute("target", "guanine");
        color.setAttribute("value", AlignmentCanvas.G_Color.getRed() + " " + AlignmentCanvas.G_Color.getGreen() + " " + AlignmentCanvas.G_Color.getBlue());
        color = new Element("color");
        colors.addContent((Content)color);
        color.setAttribute("target", "cytosine");
        color.setAttribute("value", AlignmentCanvas.C_Color.getRed() + " " + AlignmentCanvas.C_Color.getGreen() + " " + AlignmentCanvas.C_Color.getBlue());
    }

    public static String[] getPlatformAddresses() {
        ArrayList<String> adresses = new ArrayList<String>();
        for (Object o : document.getRootElement().getChild("platform-addresses").getChildren()) {
            adresses.add(((Element)o).getText());
        }
        adresses.add("localhost");
        return adresses.toArray(new String[0]);
    }

    public static void addPlatformAddress(String address) {
        Element e = new Element("platform-address");
        e.setText(address);
        document.getRootElement().getChild("platform-addresses").addContent((Content)e);
    }

    public static void setPyMOLPath(String path) {
        document.getRootElement().getChild("external-viewers").getChild("pymol-path").setText(path);
    }

    public static String getPyMOLPath() {
        return document.getRootElement().getChild("external-viewers").getChild("pymol-path").getValue();
    }

    public static void setChimeraPath(String path) {
        document.getRootElement().getChild("external-viewers").getChild("chimera-path").setText(path);
    }

    public static String getChimeraPath() {
        return document.getRootElement().getChild("external-viewers").getChild("chimera-path").getValue();
    }

    public static void setVMDPath(String path) {
        document.getRootElement().getChild("external-viewers").getChild("vmd-path").setText(path);
    }

    public static String getVMDPath() {
        return document.getRootElement().getChild("external-viewers").getChild("vmd-path").getValue();
    }

    public static void save() throws BackingStoreException, IOException {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        FileWriter writer = new FileWriter(new File(new StringBuffer(S2S.getUserDirPath()).append("config.xml").toString()));
        outputter.output(document, (Writer)writer);
        writer.close();
    }
}

