/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s;

import fr.unistra.ibmc.paradise.services.ParadisePlatform;
import fr.unistra.ibmc.paradise.tools.ConnectionException;
import fr.unistra.ibmc.paradise.tools.IncompatibilityException;
import fr.unistra.ibmc.paradise.tools.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.utils.GeneralUtils;
import fr.unistra.ibmc.s2s.S2SAgent;
import fr.unistra.ibmc.s2s.S2SConfig;
import fr.unistra.ibmc.s2s.rnalign.utils.RessourcesUtils;
import jade.wrapper.ControllerException;
import jade.wrapper.StaleProxyException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.UnknownHostException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jdesktop.swingworker.SwingWorker;

public class SplashScreen
extends JFrame {
    private JLabel label;

    public SplashScreen() {
        this.repaint();
        this.setUndecorated(true);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        ImageIcon icon = new ImageIcon(RessourcesUtils.getImage("logo.png"));
        this.add((Component)new JLabel(icon), "North");
        final JComboBox<String> addressField = new JComboBox<String>(S2SConfig.getPlatformAddresses());
        addressField.addItem("Register new address...");
        addressField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String newAddress;
                if ("Register new address...".equals(((JComboBox)event.getSource()).getSelectedItem()) && (newAddress = JOptionPane.showInputDialog("Please enter the new address")) != null && newAddress.length() != 0) {
                    S2SConfig.addPlatformAddress(newAddress);
                    addressField.removeAllItems();
                    for (String address : S2SConfig.getPlatformAddresses()) {
                        addressField.addItem(address);
                    }
                    addressField.addItem("Register new address...");
                    addressField.setSelectedItem(newAddress);
                }
            }
        });
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBackground(Color.WHITE);
        final JButton okButton = new JButton("Connect");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                final String platformAddress = (String)addressField.getSelectedItem();
                okButton.setEnabled(false);
                addressField.setEnabled(false);
                new SwingWorker(){

                    protected Object doInBackground() {
                        try {
                            if (!platformAddress.equals("localhost")) {
                                SplashScreen.this.label.setText("Try to connect to " + platformAddress);
                                SplashScreen.this.label.setText("GUI started...");
                                new S2SAgent(new ParadiseWorkingSession(platformAddress));
                            } else {
                                SplashScreen.this.label.setText("Platform started...");
                                ParadisePlatform.launchParadisePlatform();
                                SplashScreen.this.label.setText("GUI started...");
                                new S2SAgent(new ParadiseWorkingSession(platformAddress));
                            }
                            SplashScreen.this.dispose();
                        }
                        catch (StaleProxyException e) {
                            addressField.setEnabled(true);
                            okButton.setEnabled(true);
                            JOptionPane.showMessageDialog(null, "Problem to connect to " + platformAddress);
                        }
                        catch (UnknownHostException e) {
                            addressField.setEnabled(true);
                            okButton.setEnabled(true);
                            JOptionPane.showMessageDialog(null, "Problem to connect to " + platformAddress);
                        }
                        catch (ConnectionException e) {
                            addressField.setEnabled(true);
                            okButton.setEnabled(true);
                            JOptionPane.showMessageDialog(null, "Problem to connect to " + platformAddress);
                        }
                        catch (ControllerException e) {
                            addressField.setEnabled(true);
                            okButton.setEnabled(true);
                            JOptionPane.showMessageDialog(null, "Problem to connect to " + platformAddress);
                        }
                        catch (IncompatibilityException e) {
                            addressField.setEnabled(true);
                            okButton.setEnabled(true);
                            JOptionPane.showMessageDialog(null, "The " + platformAddress + " platform is incompatible with your S2S application.");
                            this.done();
                        }
                        return null;
                    }
                }.execute();
            }
        });
        buttonsPanel.add(addressField);
        buttonsPanel.add(okButton);
        this.add((Component)buttonsPanel, "Center");
        this.label = new JLabel("S2S 2.0, Release Candidate 3");
        JPanel labelPanel = new JPanel(new FlowLayout(1));
        labelPanel.setBackground(Color.WHITE);
        labelPanel.add(this.label);
        this.add((Component)labelPanel, "South");
        this.pack();
        GeneralUtils.centerOnScreen(this);
        this.setVisible(true);
        this.toFront();
    }

    public void updateText(String message) {
        this.label.setText(message);
    }
}

