/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.behaviours;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.tools.AbstractParadiseToolAgent;
import fr.unistra.ibmc.paradise.tools.AnswerBehaviour;
import fr.unistra.ibmc.paradise.tools.ParadiseToolAgent;
import fr.unistra.ibmc.s2s.S2S;
import fr.unistra.ibmc.s2s.behaviours.StructuralAlignmentRequestAnswerBehaviour;
import jade.gui.GuiEvent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.lang.acl.UnreadableException;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RNAMotifRequestAnswerBehaviour
extends AnswerBehaviour {
    public RNAMotifRequestAnswerBehaviour(ArrayList<Molecule> selectedMolecules, Parameters selectedParameters) {
        super(selectedMolecules, selectedParameters);
    }

    public void action() {
        ACLMessage message = this.myAgent.receive(MessageTemplate.MatchConversationId((String)("" + this.conversationId)));
        if (message != null && message.getPerformative() == 11) {
            try {
                for (Molecule m : (ArrayList)message.getContentObject()) {
                    S2S s2s = (S2S)((ParadiseToolAgent)this.myAgent).getParadiseTool();
                    s2s.getWorkingSession().addAllMolecules(Arrays.asList(m));
                    SecondaryStructure ss = m.getSelectedFeatures(SecondaryStructure.class).get(0);
                    ss.getFactory().copySecondaryStructure(s2s.getWorkingSession().getMolecules(), ss, false);
                    GuiEvent ev = new GuiEvent((Object)this, 0);
                    ArrayList<Molecule> molecules = new ArrayList<Molecule>();
                    Molecule referenceMolecule = s2s.getMediator().getAlignmentCanvas().getMainAlignment().getBiologicalReferenceSequence().getMolecule();
                    SecondaryStructure refSS = s2s.getMediator().getAlignmentCanvas().getMainAlignment().getStructure2D3D().getReferenceSecondaryStructure();
                    referenceMolecule.removeAllSelectedFeatures();
                    referenceMolecule.addSelectedFeature(refSS);
                    molecules.add(referenceMolecule);
                    m.removeAllSelectedFeatures();
                    m.addSelectedFeature(ss);
                    molecules.add(m);
                    ev.addParameter((Object)new StructuralAlignmentRequestAnswerBehaviour(molecules, new Parameters()));
                    ((AbstractParadiseToolAgent)this.myAgent).postGuiEvent(ev);
                }
            }
            catch (Exception e) {
                this.monitor.printException(e);
            }
            this.monitor.stopAnimation();
            this.done = true;
        } else if (message != null && message.getPerformative() == 7) {
            this.monitor.printMessage(message.getContent());
        } else if (message != null && message.getPerformative() == 6) {
            try {
                this.monitor.printException((Exception)message.getContentObject());
            }
            catch (UnreadableException e) {
                e.printStackTrace();
            }
            this.monitor.stopAnimation();
            this.done = true;
        }
    }
}

