/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.behaviours;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.tools.AbstractParadiseToolAgent;
import fr.unistra.ibmc.paradise.tools.AnswerBehaviour;
import fr.unistra.ibmc.paradise.tools.ParadiseToolAgent;
import fr.unistra.ibmc.s2s.S2S;
import fr.unistra.ibmc.s2s.behaviours.StructuralAlignmentRequestAnswerBehaviour;
import jade.gui.GuiEvent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.lang.acl.UnreadableException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecondaryStructurePredictionBeforeStructuralAlignmentAnswerBehaviour
extends AnswerBehaviour {
    private String structuralAlignmentAgentName;

    public SecondaryStructurePredictionBeforeStructuralAlignmentAnswerBehaviour(ArrayList<Molecule> selectedMolecules, Parameters selectedParameters, String structuralAlignmentAgentName) {
        super(selectedMolecules, selectedParameters);
        this.structuralAlignmentAgentName = structuralAlignmentAgentName;
    }

    public void action() {
        ACLMessage message = this.myAgent.receive(MessageTemplate.MatchConversationId((String)("" + this.conversationId)));
        if (message != null && message.getPerformative() == 11) {
            try {
                S2S s2s = (S2S)((ParadiseToolAgent)this.myAgent).getParadiseTool();
                SecondaryStructure ss = ((Molecule)((ArrayList)message.getContentObject()).get(0)).getSelectedFeatures(SecondaryStructure.class).get(0);
                SecondaryStructure copySS = ss.getFactory().copySecondaryStructure(this.selectedMolecules, ss, false);
                copySS.setName("Secondary Structure");
                this.monitor.printMessage("End of Analysis");
                GuiEvent ev = new GuiEvent((Object)this, 0);
                ArrayList<Molecule> molecules = new ArrayList<Molecule>();
                Molecule refMol = s2s.getMediator().getAlignmentCanvas().getMainAlignment().getBiologicalReferenceSequence().getMolecule();
                refMol.addSelectedFeature(s2s.getAlignmentCanvas().getMainAlignment().getReferenceStructure());
                ((Molecule)this.selectedMolecules.get(0)).addSelectedFeature(copySS);
                molecules.add(refMol);
                molecules.add((Molecule)this.selectedMolecules.get(0));
                ev.addParameter((Object)new StructuralAlignmentRequestAnswerBehaviour(molecules, new Parameters()));
                ev.addParameter((Object)this.structuralAlignmentAgentName);
                ((AbstractParadiseToolAgent)this.myAgent).postGuiEvent(ev);
            }
            catch (Exception e) {
                this.monitor.printException(e);
            }
            this.done = true;
        } else if (message != null && message.getPerformative() == 7) {
            this.monitor.printMessage(message.getContent());
        } else if (message != null && message.getPerformative() == 6) {
            try {
                this.monitor.printException((Exception)message.getContentObject());
            }
            catch (UnreadableException e) {
                e.printStackTrace();
            }
            this.monitor.stopAnimation();
            this.done = true;
        }
    }
}

