/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.rnalign.features;

import fr.unistra.ibmc.paradise.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.Helix;
import fr.unistra.ibmc.paradise.core.features.IdentityFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.RNASecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.StructuralIdentity;
import fr.unistra.ibmc.s2s.Mediator;
import fr.unistra.ibmc.s2s.S2S;
import fr.unistra.ibmc.s2s.rnalign.features.BiologicalSequence;
import fr.unistra.ibmc.s2s.rnalign.features.Step;
import fr.unistra.ibmc.s2s.rnalign.features.StructuralSymbol;
import fr.unistra.ibmc.s2s.rnalign.features.Structure2D3D;
import fr.unistra.ibmc.s2s.rnalign.features.Symbol;
import fr.unistra.ibmc.s2s.rnalign.features.SymbolSequence;
import fr.unistra.ibmc.s2s.rnalign.graphics.GraphicContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.swingworker.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Alignment {
    public static final byte ISOSTERICITY_MATRICES_CONSERVATION = 0;
    public static final byte LW_FAMILIES_CONSERVATION = 1;
    private SequenceMeter sequenceMeter;
    private Structure2D3D structure2D3D;
    private List<BiologicalSequence> biologicalSequences;
    private StructuralAlignment alignment;
    private List<Step> steps;
    private static int MAXIMUM_STEPS = 300;
    private int steps_cursor = -1;
    private Mediator mediator;

    public Alignment(final S2S s2s, StructuralAlignment alignment, Molecule referenceMolecule, SecondaryStructure referenceStructure) {
        this.alignment = alignment;
        this.mediator = s2s.getMediator();
        this.mediator.getSequencesList().clearList();
        this.steps = new ArrayList<Step>();
        final List<StructuralIdentity> identities = this.alignment.getStructuralIdentities(true);
        final List<Molecule> molecules = alignment.getSortedMolecules();
        this.sequenceMeter = new SequenceMeter(alignment.getLength());
        this.biologicalSequences = new ArrayList<BiologicalSequence>(molecules.size());
        this.biologicalSequences.add(new BiologicalSequence(identities, referenceMolecule));
        this.mediator.getSequencesList().addRow(referenceMolecule);
        this.mediator.getSequencesList().revalidate();
        molecules.remove(referenceMolecule);
        this.structure2D3D = new Structure2D3D(this.biologicalSequences.get(0), referenceStructure);
        new SwingWorker(){

            protected Object doInBackground() {
                try {
                    for (Molecule m : molecules) {
                        Alignment.this.biologicalSequences.add(new BiologicalSequence(identities, m));
                        Alignment.this.mediator.getSequencesList().addRow(m);
                        s2s.getAlignmentCanvas().repaint();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        }.execute();
    }

    public void setReferenceMolecule(BiologicalSequence referenceMolecule, SecondaryStructure referenceSecondaryStructure) {
        this.biologicalSequences.remove(referenceMolecule);
        this.biologicalSequences.add(0, referenceMolecule);
        this.structure2D3D = new Structure2D3D(referenceMolecule, referenceSecondaryStructure);
    }

    public boolean hasMoreUndo() {
        return this.steps_cursor >= 0;
    }

    public boolean hasMoreRedo() {
        return this.steps_cursor < this.steps.size() - 1;
    }

    public void addStep(Step step) {
        if (this.steps_cursor == MAXIMUM_STEPS) {
            this.steps.remove(0);
        } else if (this.steps_cursor == -1) {
            this.steps.clear();
        } else {
            for (int i = this.steps_cursor + 1; i <= this.steps.size() - 1; ++i) {
                this.steps.remove(i);
            }
        }
        this.steps.add(step);
        this.steps_cursor = this.steps.size() - 1;
        this.mediator.setRedoUndoButtonsState();
    }

    public void undo(GraphicContext gc) {
        if (this.steps_cursor >= 0) {
            this.steps.get(this.steps_cursor).undo(this, gc);
            --this.steps_cursor;
        }
    }

    public void redo(GraphicContext gc) {
        if (this.steps_cursor < this.steps.size() - 1) {
            ++this.steps_cursor;
            this.steps.get(this.steps_cursor).redo(this, gc);
        }
    }

    public SequenceMeter getSequenceMeter() {
        return this.sequenceMeter;
    }

    public Structure2D3D getStructure2D3D() {
        return this.structure2D3D;
    }

    public BiologicalSequence getBiologicalSequenceAt(int index) {
        return this.biologicalSequences.get(index);
    }

    public SecondaryStructure deduceNewSecondaryStructure(BiologicalSequence targetSequence) throws BiologicalSymbolException {
        StructuralFeatureFactory factory = this.mediator.getS2s().createStructuralFeatureFactory();
        RNASecondaryStructure ss = factory.createRNASecondaryStructure(new ParadiseID(), "Secondary Structure", Source.getGraphicalToolAsSource(this.mediator.getS2s().getDescription()));
        Helix newHelix = null;
        int positionInTargetSequence = -1;
        int previousPositionInTargetSequence = -1;
        int pairedPositionInTargetSequence = -1;
        int previousPairedPositionInTargetSequence = -1;
        char previousEdge1 = '?';
        char previousEdge2 = '?';
        char previousOrientation = '?';
        int previousDominant = -1;
        for (int i = 0; i < this.structure2D3D.size(); ++i) {
            StructuralSymbol structuralSymbol = (StructuralSymbol)this.structure2D3D.getSymbol(i);
            positionInTargetSequence = targetSequence.getSymbol(i).getPositionInSequence();
            for (BaseBaseInteraction bbi : structuralSymbol.getReferenceBaseBaseInteractions()) {
                StructuralSymbol pairedStructuralSymbol = structuralSymbol.getPairedSymbol(bbi);
                pairedPositionInTargetSequence = targetSequence.getSymbol(this.structure2D3D.getIndex(pairedStructuralSymbol)).getPositionInSequence();
                if (positionInTargetSequence >= pairedPositionInTargetSequence) continue;
                if (bbi.isSecondaryInteraction()) {
                    if (previousPositionInTargetSequence == positionInTargetSequence - 1 && previousPairedPositionInTargetSequence == pairedPositionInTargetSequence + 1) {
                        if (newHelix != null) {
                            factory.createBaseBaseInteraction(bbi.getEdge1(), bbi.getEdge2(), bbi.getOrientation(), bbi.getDominant(), newHelix, targetSequence.getMolecule(), new Location(new Location(positionInTargetSequence), new Location(pairedPositionInTargetSequence)));
                        } else {
                            newHelix = factory.createHelix(bbi.getParentFeatures(Helix.class).get(0).getName(), ss, targetSequence.getMolecule(), new Location(new Location(previousPositionInTargetSequence, positionInTargetSequence), new Location(pairedPositionInTargetSequence, previousPairedPositionInTargetSequence)));
                            factory.createBaseBaseInteraction(previousEdge1, previousEdge2, previousOrientation, previousDominant, newHelix, targetSequence.getMolecule(), new Location(new Location(previousPositionInTargetSequence), new Location(previousPairedPositionInTargetSequence)));
                            factory.createBaseBaseInteraction(bbi.getEdge1(), bbi.getEdge2(), bbi.getOrientation(), bbi.getDominant(), newHelix, targetSequence.getMolecule(), new Location(new Location(positionInTargetSequence), new Location(pairedPositionInTargetSequence)));
                        }
                    } else {
                        if (newHelix == null && previousDominant != -1 && previousPositionInTargetSequence != -1 && previousPairedPositionInTargetSequence != -1) {
                            factory.createBaseBaseInteraction(previousEdge1, previousEdge2, previousOrientation, previousDominant, ss, targetSequence.getMolecule(), new Location(new Location(previousPositionInTargetSequence), new Location(previousPairedPositionInTargetSequence)));
                        }
                        newHelix = null;
                    }
                    previousEdge1 = bbi.getEdge1();
                    previousEdge2 = bbi.getEdge2();
                    previousOrientation = bbi.getOrientation();
                    previousDominant = bbi.getDominant();
                    previousPositionInTargetSequence = positionInTargetSequence;
                    previousPairedPositionInTargetSequence = pairedPositionInTargetSequence;
                    continue;
                }
                if (positionInTargetSequence == -1 || pairedPositionInTargetSequence == -1) continue;
                factory.createBaseBaseInteraction(bbi.getEdge1(), bbi.getEdge2(), bbi.getOrientation(), bbi.getDominant(), ss, targetSequence.getMolecule(), new Location(new Location(positionInTargetSequence), new Location(pairedPositionInTargetSequence)));
            }
        }
        Location singleStrandsLocation = new Location(1, targetSequence.getMolecule().getLength());
        for (Helix h : ss.getHelicesWithoutPKnots()) {
            singleStrandsLocation = singleStrandsLocation.differenceOf(h.getFullLocation(targetSequence.getMolecule()));
        }
        int i = 0;
        int[] boundaries = singleStrandsLocation.getBoundaries();
        for (int j = 0; j < boundaries.length - 1; j += 2) {
            factory.createSingleStrand("SS" + i++, ss, targetSequence.getMolecule(), new Location(boundaries[j], boundaries[j + 1]));
        }
        return ss;
    }

    public int getSymbolSequenceCount() {
        return 2 + this.getBiologicalSequenceCount();
    }

    public int getBiologicalSequenceCount() {
        return this.biologicalSequences.size();
    }

    public int getLength() {
        return this.getSequenceMeter().size();
    }

    public void addBiologicalSequence(BiologicalSequence seq) {
        int more = 0;
        SymbolSequence sequence = null;
        for (int j = 0; j < this.getSymbolSequenceCount(); ++j) {
            sequence = this.getLetterSequenceAt(j);
            more = seq.size() - sequence.size();
            while (more != 0) {
                if (more > 0) {
                    sequence.increaseSize();
                    --more;
                    continue;
                }
                seq.increaseSize();
                ++more;
            }
        }
        this.biologicalSequences.add(this.biologicalSequences.size(), seq);
    }

    public SymbolSequence getLetterSequenceAt(int index) {
        switch (index) {
            case 0: {
                return this.sequenceMeter;
            }
            case 1: {
                return this.structure2D3D;
            }
        }
        return this.biologicalSequences.get(index - 2);
    }

    public int getMaxLabelSize() {
        return 1 + Integer.toString(this.biologicalSequences.size()).length() + 1;
    }

    public BiologicalSequence getBiologicalReferenceSequence() {
        return this.biologicalSequences.get(0);
    }

    public SecondaryStructure getReferenceStructure() {
        return this.structure2D3D.getReferenceSecondaryStructure();
    }

    public StructuralAlignment getStructuralAlignment() {
        return this.alignment;
    }

    public void modifyBiologicalSequence(BiologicalSequence seq, String name, String sequence) {
        ArrayList<Symbol> newSeq = new ArrayList<Symbol>();
        char[] letters = this.getAlignedSequence(sequence);
        int positionInSequence = 0;
        for (int i = 0; i < letters.length; ++i) {
            Symbol s = Symbol.getSymbol(letters[i]);
            if (letters[i] != '-') {
                s.setPositionInSequence(++positionInSequence);
            }
            newSeq.add(s);
        }
        int more = 0;
        SymbolSequence ls = null;
        for (int j = 0; j < this.getSymbolSequenceCount(); ++j) {
            ls = this.getLetterSequenceAt(j);
            more = newSeq.size() - ls.size();
            while (more != 0) {
                if (more > 0) {
                    ls.increaseSize();
                    --more;
                    continue;
                }
                newSeq.add(Symbol.createGap());
                ++more;
            }
        }
        seq.modifySequence(name, newSeq);
    }

    private char[] getAlignedSequence(String alignedSequence) {
        alignedSequence.trim();
        alignedSequence = alignedSequence.replace('.', '-');
        alignedSequence = alignedSequence.toUpperCase();
        StringBuffer alSequence = new StringBuffer();
        for (int i = 0; i < alignedSequence.length(); ++i) {
            char base = alignedSequence.charAt(i);
            if (Character.isWhitespace(base)) {
                base = '-';
            }
            if ((base < 'A' || base > 'z') && base != 45) continue;
            alSequence.append(base);
        }
        return alSequence.toString().toCharArray();
    }

    public double calculateMutualInformation(int pos1InAlignment, int pos2InAlignment) {
        BiologicalSequence seq = null;
        double A1 = 1.0;
        double A2 = 1.0;
        double U1 = 1.0;
        double U2 = 1.0;
        double G1 = 1.0;
        double G2 = 1.0;
        double C1 = 1.0;
        double C2 = 1.0;
        double gap1 = 1.0;
        double gap2 = 1.0;
        double AA = 1.0;
        double AU = 1.0;
        double AG = 1.0;
        double AC = 1.0;
        double UA = 1.0;
        double UU = 1.0;
        double UG = 1.0;
        double UC = 1.0;
        double GA = 1.0;
        double GU = 1.0;
        double GG = 1.0;
        double GC = 1.0;
        double CA = 1.0;
        double CU = 1.0;
        double CG = 1.0;
        double CC = 1.0;
        double gA = 1.0;
        double gU = 1.0;
        double gG = 1.0;
        double gC = 1.0;
        double Ag = 1.0;
        double Ug = 1.0;
        double Gg = 1.0;
        double Cg = 1.0;
        double gg = 1.0;
        block42: for (int k = 0; k < this.getBiologicalSequenceCount(); ++k) {
            seq = this.getBiologicalSequenceAt(k);
            block0 : switch (seq.getSymbol(pos1InAlignment).getSymbol()) {
                case 'A': {
                    switch (seq.getSymbol(pos2InAlignment).getSymbol()) {
                        case 'A': {
                            A1 += 1.0;
                            A2 += 1.0;
                            AA += 1.0;
                            break;
                        }
                        case 'U': {
                            A1 += 1.0;
                            U2 += 1.0;
                            AU += 1.0;
                            break;
                        }
                        case 'G': {
                            A1 += 1.0;
                            G2 += 1.0;
                            AG += 1.0;
                            break;
                        }
                        case 'C': {
                            A1 += 1.0;
                            C2 += 1.0;
                            AC += 1.0;
                            break;
                        }
                        case '-': {
                            A1 += 1.0;
                            gap2 += 1.0;
                            Ag += 1.0;
                        }
                    }
                    continue block42;
                }
                case 'U': {
                    switch (seq.getSymbol(pos2InAlignment).getSymbol()) {
                        case 'A': {
                            U1 += 1.0;
                            A2 += 1.0;
                            UA += 1.0;
                            break;
                        }
                        case 'U': {
                            U1 += 1.0;
                            U2 += 1.0;
                            UU += 1.0;
                            break;
                        }
                        case 'G': {
                            U1 += 1.0;
                            G2 += 1.0;
                            UG += 1.0;
                            break;
                        }
                        case 'C': {
                            U1 += 1.0;
                            C2 += 1.0;
                            UC += 1.0;
                            break;
                        }
                        case '-': {
                            U1 += 1.0;
                            gap2 += 1.0;
                            Ug += 1.0;
                        }
                    }
                    continue block42;
                }
                case 'G': {
                    switch (seq.getSymbol(pos2InAlignment).getSymbol()) {
                        case 'A': {
                            G1 += 1.0;
                            A2 += 1.0;
                            GA += 1.0;
                            break;
                        }
                        case 'U': {
                            G1 += 1.0;
                            U2 += 1.0;
                            GU += 1.0;
                            break;
                        }
                        case 'G': {
                            G1 += 1.0;
                            G2 += 1.0;
                            GG += 1.0;
                            break;
                        }
                        case 'C': {
                            G1 += 1.0;
                            C2 += 1.0;
                            GC += 1.0;
                            break;
                        }
                        case '-': {
                            G1 += 1.0;
                            gap2 += 1.0;
                            Gg += 1.0;
                        }
                    }
                    continue block42;
                }
                case 'C': {
                    switch (seq.getSymbol(pos2InAlignment).getSymbol()) {
                        case 'A': {
                            C1 += 1.0;
                            A2 += 1.0;
                            CA += 1.0;
                            break;
                        }
                        case 'U': {
                            C1 += 1.0;
                            U2 += 1.0;
                            CU += 1.0;
                            break;
                        }
                        case 'G': {
                            C1 += 1.0;
                            G2 += 1.0;
                            CG += 1.0;
                            break;
                        }
                        case 'C': {
                            C1 += 1.0;
                            C2 += 1.0;
                            CC += 1.0;
                            break;
                        }
                        case '-': {
                            C1 += 1.0;
                            gap2 += 1.0;
                            Cg += 1.0;
                        }
                    }
                    continue block42;
                }
                case '-': {
                    switch (seq.getSymbol(pos2InAlignment).getSymbol()) {
                        case 'A': {
                            gap1 += 1.0;
                            A2 += 1.0;
                            gA += 1.0;
                            break block0;
                        }
                        case 'U': {
                            gap1 += 1.0;
                            U2 += 1.0;
                            gU += 1.0;
                            break block0;
                        }
                        case 'G': {
                            gap1 += 1.0;
                            G2 += 1.0;
                            gG += 1.0;
                            break block0;
                        }
                        case 'C': {
                            gap1 += 1.0;
                            C2 += 1.0;
                            gC += 1.0;
                            break block0;
                        }
                        case '-': {
                            gap1 += 1.0;
                            gap2 += 1.0;
                            gg += 1.0;
                        }
                    }
                }
            }
        }
        int t = this.getBiologicalSequenceCount();
        double result = Math.log10(AA / (double)t / (A1 / (double)t * (A2 / (double)t))) + Math.log10(AU / (double)t / (A1 / (double)t * (U2 / (double)t))) + Math.log10(AG / (double)t / (A1 / (double)t * (G2 / (double)t))) + Math.log10(AC / (double)t / (A1 / (double)t * (C2 / (double)t))) + Math.log10(GG / (double)t / (G1 / (double)t * (G2 / (double)t))) + Math.log10(GU / (double)t / (G1 / (double)t * (U2 / (double)t))) + Math.log10(GA / (double)t / (G1 / (double)t * (A2 / (double)t))) + Math.log10(GC / (double)t / (G1 / (double)t * (C2 / (double)t))) + Math.log10(UU / (double)t / (U1 / (double)t * (U2 / (double)t))) + Math.log10(UA / (double)t / (U1 / (double)t * (A2 / (double)t))) + Math.log10(UG / (double)t / (U1 / (double)t * (G2 / (double)t))) + Math.log10(UC / (double)t / (U1 / (double)t * (C2 / (double)t))) + Math.log10(CC / (double)t / (C1 / (double)t * (C2 / (double)t))) + Math.log10(CU / (double)t / (C1 / (double)t * (U2 / (double)t))) + Math.log10(CG / (double)t / (C1 / (double)t * (G2 / (double)t))) + Math.log10(CA / (double)t / (C1 / (double)t * (A2 / (double)t)));
        return result;
    }

    public int[][] calculateCovariation(int pos1, int pos2) {
        int[][] m = null;
        if (pos1 != -1 && pos2 != -1) {
            int j;
            int i;
            BiologicalSequence seq = null;
            m = new int[6][6];
            block50: for (int k = 0; k < this.getBiologicalSequenceCount(); ++k) {
                seq = this.getBiologicalSequenceAt(k);
                char c2 = seq.getSymbol(pos2).getSymbol();
                block0 : switch (seq.getSymbol(pos1).getSymbol()) {
                    case 'A': {
                        switch (c2) {
                            case 'A': {
                                int[] nArray = m[0];
                                nArray[0] = nArray[0] + 1;
                                break;
                            }
                            case 'U': {
                                int[] nArray = m[0];
                                nArray[1] = nArray[1] + 1;
                                break;
                            }
                            case 'G': {
                                int[] nArray = m[0];
                                nArray[2] = nArray[2] + 1;
                                break;
                            }
                            case 'C': {
                                int[] nArray = m[0];
                                nArray[3] = nArray[3] + 1;
                                break;
                            }
                            case '-': {
                                int[] nArray = m[0];
                                nArray[4] = nArray[4] + 1;
                            }
                        }
                        continue block50;
                    }
                    case 'U': {
                        switch (c2) {
                            case 'A': {
                                int[] nArray = m[1];
                                nArray[0] = nArray[0] + 1;
                                break;
                            }
                            case 'U': {
                                int[] nArray = m[1];
                                nArray[1] = nArray[1] + 1;
                                break;
                            }
                            case 'G': {
                                int[] nArray = m[1];
                                nArray[2] = nArray[2] + 1;
                                break;
                            }
                            case 'C': {
                                int[] nArray = m[1];
                                nArray[3] = nArray[3] + 1;
                                break;
                            }
                            case '-': {
                                int[] nArray = m[1];
                                nArray[4] = nArray[4] + 1;
                            }
                        }
                        continue block50;
                    }
                    case 'G': {
                        switch (c2) {
                            case 'A': {
                                int[] nArray = m[2];
                                nArray[0] = nArray[0] + 1;
                                break;
                            }
                            case 'U': {
                                int[] nArray = m[2];
                                nArray[1] = nArray[1] + 1;
                                break;
                            }
                            case 'G': {
                                int[] nArray = m[2];
                                nArray[2] = nArray[2] + 1;
                                break;
                            }
                            case 'C': {
                                int[] nArray = m[2];
                                nArray[3] = nArray[3] + 1;
                                break;
                            }
                            case '-': {
                                int[] nArray = m[2];
                                nArray[4] = nArray[4] + 1;
                            }
                        }
                        continue block50;
                    }
                    case 'C': {
                        switch (c2) {
                            case 'A': {
                                int[] nArray = m[3];
                                nArray[0] = nArray[0] + 1;
                                break;
                            }
                            case 'U': {
                                int[] nArray = m[3];
                                nArray[1] = nArray[1] + 1;
                                break;
                            }
                            case 'G': {
                                int[] nArray = m[3];
                                nArray[2] = nArray[2] + 1;
                                break;
                            }
                            case 'C': {
                                int[] nArray = m[3];
                                nArray[3] = nArray[3] + 1;
                                break;
                            }
                            case '-': {
                                int[] nArray = m[3];
                                nArray[4] = nArray[4] + 1;
                            }
                        }
                        continue block50;
                    }
                    case '-': {
                        switch (c2) {
                            case 'A': {
                                int[] nArray = m[4];
                                nArray[0] = nArray[0] + 1;
                                break block0;
                            }
                            case 'U': {
                                int[] nArray = m[4];
                                nArray[1] = nArray[1] + 1;
                                break block0;
                            }
                            case 'G': {
                                int[] nArray = m[4];
                                nArray[2] = nArray[2] + 1;
                                break block0;
                            }
                            case 'C': {
                                int[] nArray = m[4];
                                nArray[3] = nArray[3] + 1;
                                break block0;
                            }
                            case '-': {
                                int[] nArray = m[4];
                                nArray[4] = nArray[4] + 1;
                            }
                        }
                    }
                }
            }
            for (i = 0; i < 5; ++i) {
                for (j = 0; j < 5; ++j) {
                    int[] nArray = m[i];
                    nArray[5] = nArray[5] + m[i][j];
                }
            }
            for (i = 0; i < 5; ++i) {
                for (j = 0; j < 5; ++j) {
                    int[] nArray = m[5];
                    int n = i;
                    nArray[n] = nArray[n] + m[j][i];
                }
            }
            for (i = 0; i < 5; ++i) {
                int[] nArray = m[5];
                nArray[5] = nArray[5] + m[i][5];
            }
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            System.out.println("Statistics between positions " + (pos1 + 1) + "-" + (pos2 + 1) + ":\n");
            System.out.println("\t\tPosition " + (pos2 + 1) + "\n");
            System.out.println("\tA\tU\tG\tC\t-\n");
            for (int i2 = 0; i2 < 6; ++i2) {
                int j2;
                switch (i2) {
                    case 0: {
                        System.out.print("A\t");
                        break;
                    }
                    case 1: {
                        System.out.print("U\t");
                        break;
                    }
                    case 2: {
                        System.out.print("G\t");
                        break;
                    }
                    case 3: {
                        System.out.print("C\t");
                        break;
                    }
                    case 4: {
                        System.out.print("-\t");
                        break;
                    }
                    case 5: {
                        System.out.print(" \t");
                    }
                }
                for (j2 = 0; j2 < 6; ++j2) {
                    System.out.print(m[i2][j2] + "\t");
                }
                if (i2 == 2) {
                    System.out.print("Position " + (pos1 + 1));
                }
                if (i2 != 5) {
                    System.out.println();
                    System.out.print("\t");
                    for (j2 = 0; j2 < 5; ++j2) {
                        System.out.print("(" + df.format((float)m[5][j2] * (float)m[i2][5] / (float)m[5][5]) + ")\t");
                    }
                }
                System.out.println();
                System.out.println();
            }
        }
        return m;
    }

    public void moveSequence(int newPos, BiologicalSequence seq) {
        this.biologicalSequences.remove(seq);
        this.biologicalSequences.add(newPos, seq);
    }

    public void increaseSize() {
        for (int i = 0; i < this.getSymbolSequenceCount(); ++i) {
            this.getLetterSequenceAt(i).increaseSize();
        }
    }

    public void insertGaps(int index) {
        for (int i = 0; i < this.getSymbolSequenceCount(); ++i) {
            this.getLetterSequenceAt(i).insertGap(index);
        }
    }

    public void removeBiologicalSequenceAt(int index) {
        this.biologicalSequences.remove(index);
    }

    public List<BiologicalSequence> getBiologicalSequences() {
        return new ArrayList<BiologicalSequence>(this.biologicalSequences);
    }

    public void updateConservationScores() {
        this.updateConservationScores(0, this.getLength() - 1);
    }

    public void updateConservationScores(int start, int end) {
    }

    public void updateStructuralAlignment() {
        StructuralIdentity si2;
        for (StructuralIdentity si2 : this.alignment.getStructuralIdentities(false)) {
            this.alignment.removeStructuralIdentity(si2);
        }
        for (Molecule m : this.alignment.getMolecules()) {
            m.removeFeature(this.alignment);
        }
        IdentityFeatureFactory factory = this.mediator.getS2s().createIdentityFeatureFactory();
        si2 = null;
        for (BiologicalSequence s : this.biologicalSequences) {
            Location molecularLocation = new Location();
            Location gapsLocation = new Location();
            for (int i = 0; i < s.size(); ++i) {
                Symbol symbol = s.getSymbol(i);
                if (symbol.isGap()) {
                    gapsLocation.add(i + 1);
                    continue;
                }
                molecularLocation.add(symbol.getPositionInSequence());
            }
            if (si2 == null) {
                si2 = factory.createStructuralIdentity(this.alignment, "", s.getMolecule(), molecularLocation);
            } else {
                s.getMolecule().addFeature(si2, molecularLocation);
            }
            if (!gapsLocation.isEmpty()) {
                si2.addGapsLocation(s.getMolecule(), gapsLocation);
            }
            this.alignment.setPositionInAlignment(s.getMolecule(), this.biologicalSequences.indexOf(s));
        }
        this.structure2D3D.referenceSecondaryStructure.linkStructuralAlignment(this.alignment);
    }

    public int indexOf(Molecule m) {
        return this.biologicalSequences.indexOf(m);
    }

    public class SequenceMeter
    extends SymbolSequence {
        private MeterSize size;

        public String getSequence() {
            return null;
        }

        private SequenceMeter(int length) {
            this.color = Color.DARK_GRAY;
            this.size = new MeterSize(length);
        }

        public Symbol getSymbol(int index) {
            return null;
        }

        public void drawSymbol(Alignment alignment, Graphics2D g, int currentX, int viewX, int currentY, int viewY, GraphicContext gc, int index) {
            g.setColor(Color.BLACK);
            if (index == 0 || (index + 1) % gc.getRatio() == 0) {
                String position = new StringBuffer().append(index + 1).toString();
                g.drawString(position, (float)currentX - (float)viewX - (float)(gc.getLetterWidth() * position.trim().length()) / 4.0f, (float)(currentY - gc.getLetterHeight()));
                g.drawString(new StringBuffer().append('|').toString(), currentX - viewX, currentY);
            } else {
                g.drawString(new StringBuffer().append('.').toString(), (float)currentX - (float)viewX, (float)currentY);
            }
            g.setColor(Color.BLACK);
        }

        public int size() {
            return this.size.getSize();
        }

        public void insertGap(int index) {
            this.size.increaseSize();
        }

        public boolean removeGap(int index) {
            if (this.isGap(index)) {
                this.size.decreaseSize();
                return true;
            }
            return false;
        }

        public void increaseSize() {
            this.size.increaseSize();
        }

        public boolean isGap(int index) {
            return true;
        }

        public void setSelected(boolean selected) {
            this.selected = false;
        }

        public void setSymbolAt(Symbol s, int i) {
        }

        private class MeterSize {
            private int size;

            private MeterSize(int size) {
                this.size = size;
            }

            private void setSize(int size) {
                this.size = size;
            }

            private void increaseSize() {
                ++this.size;
            }

            private void decreaseSize() {
                --this.size;
            }

            private int getSize() {
                return this.size;
            }
        }
    }
}

