/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.rnalign.features;

import fr.unistra.ibmc.paradise.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.StructuralIdentity;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.s2s.Mediator;
import fr.unistra.ibmc.s2s.rnalign.features.Alignment;
import fr.unistra.ibmc.s2s.rnalign.features.StructuralSymbol;
import fr.unistra.ibmc.s2s.rnalign.features.Symbol;
import fr.unistra.ibmc.s2s.rnalign.features.SymbolSequence;
import fr.unistra.ibmc.s2s.rnalign.graphics.AlignmentCanvas;
import fr.unistra.ibmc.s2s.rnalign.graphics.GraphicContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiologicalSequence
extends SymbolSequence {
    protected Molecule molecule;
    protected List<Integer> selectedPositions = new ArrayList<Integer>();

    public BiologicalSequence(Molecule molecule) {
        this.molecule = molecule;
        char[] characters = molecule.printSequence().toCharArray();
        int moleculePos = 1;
        for (char c : characters) {
            Symbol s = Symbol.getSymbol(c);
            s.setPositionInSequence(moleculePos++);
            this.addSymbol(s);
        }
    }

    public BiologicalSequence(Mediator mediator, String sequenceName, String gappedSequence) throws BiologicalSymbolException, URISyntaxException {
        this(mediator.getS2s().getWorkingSession().createRNA(new ParadiseID(), sequenceName, Source.getGraphicalToolAsSource(mediator.getS2s().getDescription()), ""));
        char[] characters;
        int moleculePos = 1;
        for (char c : characters = gappedSequence.toCharArray()) {
            if (c != '-') {
                Symbol s = Symbol.getSymbol(c);
                s.setPositionInSequence(moleculePos++);
                this.addSymbol(s);
                try {
                    this.molecule.addResidue("" + c);
                }
                catch (BiologicalSymbolException e) {
                    String choice = null;
                    while (choice == null || choice.length() == 0) {
                        choice = (String)JOptionPane.showInputDialog(null, "Please choose an unmodified residue", "Unknown Residue " + c, 2, null, new String[]{"A", "U", "G", "C", "?"}, "A");
                        this.molecule.addModifiedResidue("" + c, choice);
                    }
                    this.molecule.addResidue(choice);
                }
                continue;
            }
            this.addSymbol(Symbol.Gap);
        }
    }

    public BiologicalSequence(List<StructuralIdentity> identities, Molecule molecule) {
        this(molecule);
        for (StructuralIdentity identity : identities) {
            Location molecularLocation = identity.getFullLocation(molecule);
            if (molecularLocation != null) {
                Location gapsLocation = identity.getGapsLocation(molecule);
                if (gapsLocation == null) continue;
                int end = identity.getLength();
                for (int i = 0; i < end; ++i) {
                    if (!gapsLocation.hasPosition(i + 1)) continue;
                    this.symbols.add(i, Symbol.Gap);
                }
                continue;
            }
            int end = identity.getLength();
            for (int i = 0; i < end; ++i) {
                this.symbols.add(Symbol.Gap);
            }
        }
    }

    public void eraseAllSymbols() {
        this.symbols.clear();
    }

    public List<Integer> getSelectedPositions() {
        return new ArrayList<Integer>(this.selectedPositions);
    }

    public boolean isSelectedPosition(int pos) {
        for (int i : this.selectedPositions) {
            if (i != pos) continue;
            return true;
        }
        return false;
    }

    public boolean hasSelectedPositions() {
        return this.selectedPositions.size() != 0;
    }

    public void setMolecule(Molecule molecule) {
        this.molecule = molecule;
    }

    public Molecule getMolecule() {
        return this.molecule;
    }

    public Residue getResidue(int index) {
        return new Residue(index, this.molecule);
    }

    public void extenseAtEnd() {
        this.insertGap(this.symbols.size());
    }

    public void modifySequence(String label, List<Symbol> sequence) {
        this.molecule.setName(label);
        this.symbols.clear();
        this.symbols.addAll(sequence);
    }

    @Override
    public Symbol getSymbol(int index) {
        return (Symbol)this.symbols.get(index);
    }

    @Override
    public void drawSymbol(Alignment alignment, Graphics2D g, int currentX, int viewX, int currentY, int viewY, GraphicContext gc, int index) {
        Symbol s = this.getSymbol(index);
        char letter = s.getSymbol();
        boolean isSelectedPosition = this.isSelectedPosition(s.getPositionInSequence());
        if (this.getSymbol(index).isGap()) {
            if (s == Symbol.LockedGap) {
                g.setColor(Color.RED);
                Rectangle2D.Float r = null;
                if (this == alignment.getBiologicalSequenceAt(0)) {
                    r = new Rectangle2D.Float(currentX - viewX, currentY - gc.getLetterHeight() + (int)(0.25 * (double)gc.getLetterHeight()), gc.getLetterWidth(), gc.getLetterHeight());
                    g.draw(r);
                    g.drawString(new StringBuffer().append(letter).toString(), currentX - viewX, currentY);
                } else {
                    r = new Rectangle2D.Float(currentX - viewX, currentY - viewY - gc.getLetterHeight() + (int)(0.25 * (double)gc.getLetterHeight()), gc.getLetterWidth(), gc.getLetterHeight());
                    g.draw(r);
                    g.drawString(new StringBuffer().append(letter).toString(), currentX - viewX, currentY - viewY);
                }
            } else {
                g.setColor(Color.BLACK);
                if (this == alignment.getBiologicalSequenceAt(0)) {
                    g.drawString(new StringBuffer().append(letter).toString(), currentX - viewX, currentY);
                } else {
                    g.drawString(new StringBuffer().append(letter).toString(), currentX - viewX, currentY - viewY);
                }
            }
        } else {
            StructuralSymbol structuralSymbol = (StructuralSymbol)alignment.getStructure2D3D().getSymbol(index);
            char letterFromStruct = structuralSymbol.getSymbol();
            List<BaseBaseInteraction> interactions = structuralSymbol.getReferenceBaseBaseInteractions();
            if (interactions.isEmpty()) {
                if (isSelectedPosition) {
                    g.setColor(Color.RED);
                    Rectangle2D.Float r = null;
                    if (this == alignment.getBiologicalSequenceAt(0)) {
                        r = new Rectangle2D.Float(currentX - viewX, currentY - gc.getLetterHeight() + (int)(0.25 * (double)gc.getLetterHeight()), gc.getLetterWidth(), gc.getLetterHeight());
                        g.draw(r);
                        g.drawString(new StringBuffer().append(letter).toString(), currentX - viewX, currentY);
                    } else {
                        r = new Rectangle2D.Float(currentX - viewX, currentY - viewY - gc.getLetterHeight() + (int)(0.25 * (double)gc.getLetterHeight()), gc.getLetterWidth(), gc.getLetterHeight());
                        g.draw(r);
                        g.drawString(new StringBuffer().append(letter).toString(), currentX - viewX, currentY - viewY);
                    }
                } else {
                    g.setColor(s.getColor());
                    if (this == alignment.getBiologicalSequenceAt(0)) {
                        g.drawString(new StringBuffer().append(letter).toString(), currentX - viewX, currentY);
                    } else {
                        g.drawString(new StringBuffer().append(letter).toString(), currentX - viewX, currentY - viewY);
                    }
                }
            } else {
                int isostericity = -1;
                boolean unknownInteraction = false;
                for (int i = 0; i < interactions.size(); ++i) {
                    Rectangle2D.Float r;
                    BaseBaseInteraction interaction = interactions.get(i);
                    currentX += i * gc.getLetterWidth() / interactions.size();
                    StructuralSymbol pairedStructuralSymbol = structuralSymbol.getPairedSymbol(interaction);
                    char pairedLetter = this.getSymbol(alignment.getStructure2D3D().getIndex(pairedStructuralSymbol)).getSymbol();
                    isostericity = interaction.isIsosteric(letter, structuralSymbol.getResidue().getAbsolutePosition(), pairedLetter, pairedStructuralSymbol.getResidue().getAbsolutePosition());
                    if (isostericity == 2) {
                        if (isSelectedPosition) {
                            g.setColor(Color.RED);
                        } else if (interaction.isSecondaryInteraction()) {
                            g.setColor(AlignmentCanvas.SecondaryInteraction_Color.darker());
                        } else {
                            g.setColor(AlignmentCanvas.TertiaryInteraction_Color.darker());
                        }
                        if (this == alignment.getBiologicalSequenceAt(0)) {
                            r = new Rectangle2D.Float(currentX - viewX, currentY - gc.getLetterHeight() + (int)(0.25 * (double)gc.getLetterHeight()), gc.getLetterWidth() / interactions.size(), gc.getLetterHeight());
                            g.fill(r);
                            continue;
                        }
                        r = new Rectangle2D.Float(currentX - viewX, currentY - viewY - gc.getLetterHeight() + (int)(0.25 * (double)gc.getLetterHeight()), gc.getLetterWidth() / interactions.size(), gc.getLetterHeight());
                        g.fill(r);
                        continue;
                    }
                    if (isostericity == 1) {
                        if (isSelectedPosition) {
                            g.setColor(Color.ORANGE);
                        } else if (interaction.isSecondaryInteraction()) {
                            g.setColor(AlignmentCanvas.SecondaryInteraction_Color.brighter());
                        } else {
                            g.setColor(AlignmentCanvas.TertiaryInteraction_Color.brighter());
                        }
                        if (this == alignment.getBiologicalSequenceAt(0)) {
                            r = new Rectangle2D.Float(currentX - viewX, currentY - gc.getLetterHeight() + (int)(0.25 * (double)gc.getLetterHeight()), gc.getLetterWidth() / interactions.size(), gc.getLetterHeight());
                            g.fill(r);
                            continue;
                        }
                        r = new Rectangle2D.Float(currentX - viewX, currentY - viewY - gc.getLetterHeight() + (int)(0.25 * (double)gc.getLetterHeight()), gc.getLetterWidth() / interactions.size(), gc.getLetterHeight());
                        g.fill(r);
                        continue;
                    }
                    unknownInteraction = true;
                    if (!isSelectedPosition) continue;
                    g.setColor(Color.RED);
                    if (this == alignment.getBiologicalSequenceAt(0)) {
                        r = new Rectangle2D.Float(currentX - viewX, currentY - gc.getLetterHeight() + (int)(0.25 * (double)gc.getLetterHeight()), gc.getLetterWidth() / interactions.size(), gc.getLetterHeight());
                        g.draw(r);
                        continue;
                    }
                    r = new Rectangle2D.Float(currentX - viewX, currentY - viewY - gc.getLetterHeight() + (int)(0.25 * (double)gc.getLetterHeight()), gc.getLetterWidth() / interactions.size(), gc.getLetterHeight());
                    g.draw(r);
                }
                if (unknownInteraction) {
                    g.setColor(Color.BLACK);
                } else {
                    g.setColor(Color.WHITE);
                }
                if (this == alignment.getBiologicalSequenceAt(0)) {
                    g.drawString(new StringBuffer().append(letter).toString(), currentX - (interactions.size() - 1) * gc.getLetterWidth() / interactions.size() - viewX, currentY);
                } else {
                    g.drawString(new StringBuffer().append(letter).toString(), currentX - (interactions.size() - 1) * gc.getLetterWidth() / interactions.size() - viewX, currentY - viewY);
                }
            }
        }
        g.setColor(Color.BLACK);
    }

    @Override
    public int size() {
        return this.symbols.size();
    }

    @Override
    public void insertGap(int index) {
        this.symbols.add(index, Symbol.createGap());
    }

    @Override
    public boolean removeGap(int index) {
        if (this.isGap(index)) {
            this.symbols.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public void increaseSize() {
        this.insertGap(this.symbols.size());
    }

    @Override
    public boolean isGap(int index) {
        return ((Symbol)this.symbols.get(index)).isGap();
    }

    @Override
    public String getSequence() {
        StringBuffer buff = new StringBuffer(this.symbols.size());
        Iterator i = this.symbols.iterator();
        while (i.hasNext()) {
            buff.append(((Symbol)i.next()).getSymbol());
        }
        return buff.toString();
    }

    @Override
    public void setSymbolAt(Symbol s, int i) {
        this.symbols.set(i, s);
    }

    public void searchFor(String motif) {
        Pattern pattern = Pattern.compile(motif);
        Matcher matcher = pattern.matcher(this.molecule.printSequence());
        while (matcher.find()) {
            for (int i = matcher.start() + 1; i <= matcher.end(); ++i) {
                this.selectedPositions.add(i);
            }
        }
    }

    public void addSelectedPosition(int pos) {
        if (!this.selectedPositions.contains(pos)) {
            this.selectedPositions.add(pos);
            Collections.sort(this.selectedPositions);
        }
    }

    public void clearSelectedPositions() {
        this.selectedPositions.clear();
        for (Symbol s : this.symbols) {
            if (!s.isGap() || !s.isLocked()) continue;
            this.setSymbolAt(Symbol.Gap, this.getIndex(s));
        }
    }

    public void removeSelectedPosition(int pos) {
        this.selectedPositions.remove(new Integer(pos));
    }

    public void setSelectedPositions(List<Integer> positions) {
        this.selectedPositions.clear();
        this.selectedPositions.addAll(positions);
    }
}

