/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.rnalign.features;

import fr.unistra.ibmc.s2s.rnalign.features.Alignment;
import fr.unistra.ibmc.s2s.rnalign.features.Step;
import fr.unistra.ibmc.s2s.rnalign.features.SymbolSequence;
import fr.unistra.ibmc.s2s.rnalign.graphics.GraphicContext;
import java.util.ArrayList;
import java.util.List;

public class MoveStep
implements Step {
    private List<SymbolSequenceStep> symbolSequenceSteps = new ArrayList<SymbolSequenceStep>();

    public int size() {
        return this.symbolSequenceSteps.size();
    }

    public void add(SymbolSequence symbolSequence, int insertionPosition, int deletionPosition) {
        this.symbolSequenceSteps.add(new SymbolSequenceStep(symbolSequence, new Positions(insertionPosition, deletionPosition)));
    }

    public void undo(Alignment a, GraphicContext gc) {
        for (SymbolSequenceStep s : this.symbolSequenceSteps) {
            s.symbolSequence.removeGap(s.positions.insertionPosition);
            s.symbolSequence.insertGap(s.positions.deletionPosition);
            int start = s.positions.insertionPosition < s.positions.deletionPosition ? s.positions.insertionPosition : s.positions.deletionPosition;
            int end = s.positions.insertionPosition < s.positions.deletionPosition ? s.positions.deletionPosition : s.positions.insertionPosition;
            a.updateConservationScores(start, end);
        }
    }

    public void redo(Alignment a, GraphicContext gc) {
        for (SymbolSequenceStep s : this.symbolSequenceSteps) {
            s.symbolSequence.removeGap(s.positions.deletionPosition);
            s.symbolSequence.insertGap(s.positions.insertionPosition);
            int start = s.positions.insertionPosition < s.positions.deletionPosition ? s.positions.insertionPosition : s.positions.deletionPosition;
            int end = s.positions.insertionPosition < s.positions.deletionPosition ? s.positions.deletionPosition : s.positions.insertionPosition;
            a.updateConservationScores(start, end);
        }
    }

    private class Positions {
        private int insertionPosition;
        private int deletionPosition;

        public Positions(int insertionPosition, int deletionPosition) {
            this.insertionPosition = insertionPosition;
            this.deletionPosition = deletionPosition;
        }
    }

    private class SymbolSequenceStep {
        private SymbolSequence symbolSequence;
        private Positions positions;

        public SymbolSequenceStep(SymbolSequence symbolSequence, Positions positions) {
            this.symbolSequence = symbolSequence;
            this.positions = positions;
        }
    }
}

