/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.rnalign.features;

import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.s2s.rnalign.features.ConsensusBaseBaseInteraction;
import fr.unistra.ibmc.s2s.rnalign.features.Structure2D3D;
import fr.unistra.ibmc.s2s.rnalign.features.Symbol;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuralSymbol
extends Symbol {
    private Residue residue;
    protected Map<BaseBaseInteraction, StructuralSymbol> referenceStructureInteractions;
    protected Map<ConsensusBaseBaseInteraction, StructuralSymbol> consensusInteractions;
    private Structure2D3D structure2D3D;

    protected StructuralSymbol(Structure2D3D structure2D3D, char symbol) {
        super(symbol);
        this.structure2D3D = structure2D3D;
        this.referenceStructureInteractions = new HashMap<BaseBaseInteraction, StructuralSymbol>();
        this.consensusInteractions = new HashMap<ConsensusBaseBaseInteraction, StructuralSymbol>();
    }

    public StructuralSymbol(Structure2D3D structure2D3D, Residue residue) {
        this(structure2D3D, '.');
        this.residue = residue;
    }

    @Override
    public boolean isGap() {
        return this.getSymbol() == '-';
    }

    public boolean isSingleStrand() {
        return this.getSymbol() == '.';
    }

    public void addReferenceBaseBaseInteraction(BaseBaseInteraction interaction, StructuralSymbol pairedSymbol) {
        this.referenceStructureInteractions.put(interaction, pairedSymbol);
        if (interaction.isSecondaryInteraction()) {
            if (interaction.getResidue().equals(this.residue) && interaction.isCanonical()) {
                this.symbol = (char)40;
            } else if (interaction.getPartnerResidue().equals(this.residue) && interaction.isCanonical()) {
                this.symbol = (char)41;
            } else if (interaction.getResidue().equals(this.residue) && !interaction.isCanonical()) {
                this.symbol = (char)60;
            } else if (interaction.getPartnerResidue().equals(this.residue) && !interaction.isCanonical()) {
                this.symbol = (char)62;
            } else if (interaction.getResidue().equals(this.residue) && interaction.getMolecules().size() == 2) {
                this.symbol = (char)123;
            } else if (interaction.getPartnerResidue().equals(this.residue) && interaction.getMolecules().size() == 2) {
                this.symbol = (char)125;
            }
        }
        if (!pairedSymbol.referenceStructureInteractions.containsKey(interaction)) {
            pairedSymbol.addReferenceBaseBaseInteraction(interaction, this);
        }
    }

    public void addConsensusBaseBaseInteraction(ConsensusBaseBaseInteraction interaction, StructuralSymbol pairedSymbol) {
        this.consensusInteractions.put(interaction, pairedSymbol);
        this.symbol = (char)(this.structure2D3D.getIndex(this) < this.structure2D3D.getIndex(pairedSymbol) ? 40 : 41);
        if (!pairedSymbol.consensusInteractions.containsKey(interaction)) {
            pairedSymbol.addConsensusBaseBaseInteraction(interaction, this);
        }
    }

    public List<BaseBaseInteraction> getReferenceBaseBaseInteractions() {
        return new ArrayList<BaseBaseInteraction>(this.referenceStructureInteractions.keySet());
    }

    public Residue getResidue() {
        return this.residue;
    }

    public char getEdge(BaseBaseInteraction interaction) {
        if (this.referenceStructureInteractions.containsKey(interaction)) {
            if (interaction.getResidue().equals(this.residue)) {
                return interaction.getEdge1();
            }
            if (interaction.getPartnerResidue().equals(this.residue)) {
                return interaction.getEdge2();
            }
        }
        throw new RuntimeException();
    }

    public StructuralSymbol getPairedSymbol(BaseBaseInteraction interaction) {
        return this.referenceStructureInteractions.get(interaction);
    }

    public StructuralSymbol getPairedSymbol(ConsensusBaseBaseInteraction interaction) {
        return this.consensusInteractions.get(interaction);
    }

    public BaseBaseInteraction getSecondaryInteraction() {
        for (BaseBaseInteraction interaction : this.getReferenceBaseBaseInteractions()) {
            if (!interaction.isSecondaryInteraction()) continue;
            return interaction;
        }
        return null;
    }

    public List<BaseBaseInteraction> getTertiaryInteractions() {
        ArrayList<BaseBaseInteraction> interactions = new ArrayList<BaseBaseInteraction>();
        for (BaseBaseInteraction interaction : this.getReferenceBaseBaseInteractions()) {
            if (interaction.isSecondaryInteraction()) continue;
            interactions.add(interaction);
        }
        return interactions;
    }

    public void removeBaseBaseInteraction(BaseBaseInteraction interaction) {
        if (this.referenceStructureInteractions.containsKey(interaction)) {
            StructuralSymbol pairedSymbol = this.referenceStructureInteractions.get(interaction);
            pairedSymbol.referenceStructureInteractions.remove(interaction);
            this.referenceStructureInteractions.remove(interaction);
            if (interaction.isSecondaryInteraction()) {
                this.symbol = (char)46;
                pairedSymbol.symbol = (char)46;
            }
            return;
        }
    }

    @Override
    public Color getColor() {
        return Color.BLACK;
    }

    public static StructuralSymbol createGap(Structure2D3D structure2D3D) {
        return new StructuralSymbol(structure2D3D, '-');
    }
}

