/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.rnalign.features;

import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.Helix;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SingleStrand;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.s2s.rnalign.features.Alignment;
import fr.unistra.ibmc.s2s.rnalign.features.BiologicalSequence;
import fr.unistra.ibmc.s2s.rnalign.features.StructuralSymbol;
import fr.unistra.ibmc.s2s.rnalign.features.Symbol;
import fr.unistra.ibmc.s2s.rnalign.features.SymbolSequence;
import fr.unistra.ibmc.s2s.rnalign.graphics.AlignmentView;
import fr.unistra.ibmc.s2s.rnalign.graphics.GraphicContext;
import fr.unistra.ibmc.s2s.rnalign.graphics.ReversedAlignmentView;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Structure2D3D
extends SymbolSequence {
    int helixIndex;
    List<BasePair> basePairs;
    List<BasePair> pknotBasePairs;
    List<Domain> domains;
    BiologicalSequence referenceSequence;
    SecondaryStructure referenceSecondaryStructure;

    Structure2D3D(BiologicalSequence referenceSequence, SecondaryStructure referenceSecondaryStructure) {
        super(referenceSequence.size());
        this.referenceSequence = referenceSequence;
        this.referenceSecondaryStructure = referenceSecondaryStructure;
        this.domains = new ArrayList<Domain>();
        List<BaseBaseInteraction> interactions = this.referenceSecondaryStructure.getBaseBaseInteractions();
        List<Helix> helices = this.referenceSecondaryStructure.getHelices();
        List<SingleStrand> sstrands = this.referenceSecondaryStructure.getSingleStrands();
        StructuralSymbol symbol = null;
        int moleculePos = 1;
        for (int i = 0; i < referenceSequence.size(); ++i) {
            if (referenceSequence.isGap(i)) {
                symbol = StructuralSymbol.createGap(this);
            } else {
                Residue r = new Residue(moleculePos, referenceSequence.getMolecule());
                symbol = new StructuralSymbol(this, r);
                symbol.setPositionInSequence(moleculePos);
                boolean found = false;
                block1: for (Helix h : helices) {
                    if (!h.annotates(this.referenceSequence.getMolecule())) continue;
                    Residue[] _5 = h.get5PrimeEnds();
                    if (_5[0].equals(r) || _5[1].equals(r)) {
                        Domain d = new Domain(h);
                        d.start = symbol;
                        this.domains.add(d);
                        found = true;
                        break;
                    }
                    Residue[] _3 = h.get3PrimeEnds();
                    if (_3[0].equals(r)) {
                        for (Domain _d : this.domains) {
                            if (_d.structuralDomain != h || _d.start.getPositionInSequence() != h.get5PrimeEnd(_3[0]).getAbsolutePosition()) continue;
                            _d.end = symbol;
                            found = true;
                            break block1;
                        }
                        continue;
                    }
                    if (!_3[1].equals(r)) continue;
                    for (Domain _d : this.domains) {
                        if (_d.structuralDomain != h || _d.start.getPositionInSequence() != h.get5PrimeEnd(_3[1]).getAbsolutePosition()) continue;
                        _d.end = symbol;
                        found = true;
                        break block1;
                    }
                }
                if (!found) {
                    block4: for (SingleStrand ss : sstrands) {
                        if (!ss.annotates(this.referenceSequence.getMolecule())) continue;
                        if (ss.get5PrimeEnd() == moleculePos) {
                            Domain d = new Domain(ss);
                            d.start = symbol;
                            this.domains.add(d);
                            if (ss.getLength() != 1) break;
                            d.end = symbol;
                            break;
                        }
                        if (ss.get3PrimeEnd() != moleculePos) continue;
                        for (Domain _d : this.domains) {
                            if (_d.structuralDomain != ss) continue;
                            _d.end = symbol;
                            break block4;
                        }
                    }
                }
                ArrayList<BaseBaseInteraction> interactionsRegistered = new ArrayList<BaseBaseInteraction>();
                block6: for (BaseBaseInteraction interaction : interactions) {
                    if (interactionsRegistered.contains(interaction)) continue;
                    if (interaction.getResidue().equals(r)) {
                        for (Symbol s : this.symbols) {
                            if (((StructuralSymbol)s).getResidue() == null || !((StructuralSymbol)s).getResidue().equals(interaction.getPartnerResidue())) continue;
                            symbol.addReferenceBaseBaseInteraction(interaction, (StructuralSymbol)s);
                            interactionsRegistered.add(interaction);
                            continue block6;
                        }
                        continue;
                    }
                    if (!interaction.getPartnerResidue().equals(r)) continue;
                    for (Symbol s : this.symbols) {
                        if (((StructuralSymbol)s).getResidue() == null || !((StructuralSymbol)s).getResidue().equals(interaction.getResidue())) continue;
                        symbol.addReferenceBaseBaseInteraction(interaction, (StructuralSymbol)s);
                        interactionsRegistered.add(interaction);
                        continue block6;
                    }
                }
                interactions.removeAll(interactionsRegistered);
                ++moleculePos;
            }
            this.symbols.add(symbol);
        }
        Collections.sort(this.domains, new Comparator(){

            public int compare(Object o, Object o1) {
                return ((Domain)o).getStart().getPositionInSequence() - ((Domain)o1).getStart().getPositionInSequence();
            }
        });
    }

    public SecondaryStructure getReferenceSecondaryStructure() {
        return this.referenceSecondaryStructure;
    }

    public boolean removeGap(int index) {
        Symbol s = this.getSymbol(index);
        if (s.isGap()) {
            this.symbols.remove(index);
            return true;
        }
        return false;
    }

    public void insertGap(int index) {
        this.symbols.add(index, StructuralSymbol.createGap(this));
    }

    public boolean isGap(int index) {
        return this.getSymbol(index).isGap();
    }

    public void increaseSize() {
        this.symbols.add(this.symbols.size(), StructuralSymbol.createGap(this));
    }

    public Symbol getSymbol(int index) {
        return (Symbol)this.symbols.get(index);
    }

    public void drawSymbol(Alignment alignment, Graphics2D g, int currentX, int viewX, int currentY, int viewY, GraphicContext gc, int index) {
        g.setColor(((Symbol)this.symbols.get(index)).getColor());
        g.drawString(new StringBuffer().append(this.getSymbol(index).getSymbol()).toString(), currentX - viewX, currentY);
        g.setColor(Color.BLACK);
    }

    public void drawSymbol(AlignmentView view, Alignment alignment, Graphics2D g, int currentX, int viewX, int currentY, int viewY, GraphicContext gc, int index) {
        g.setColor(((Symbol)this.symbols.get(index)).getColor());
        char s = this.getSymbol(index).getSymbol();
        if (ReversedAlignmentView.class.isInstance(view)) {
            switch (s) {
                case '(': {
                    s = ')';
                    break;
                }
                case ')': {
                    s = '(';
                    break;
                }
                case '<': {
                    s = '>';
                    break;
                }
                case '>': {
                    s = '<';
                }
            }
            g.drawString(new StringBuffer().append(s).toString(), currentX - viewX, currentY);
        } else {
            g.drawString(new StringBuffer().append(s).toString(), currentX - viewX, currentY);
        }
        g.setColor(Color.BLACK);
    }

    public void setSelected(boolean selected) {
        this.selected = false;
    }

    public int size() {
        return this.symbols.size();
    }

    public String getSequence() {
        StringBuffer buff = new StringBuffer(this.symbols.size());
        Iterator i = this.symbols.iterator();
        while (i.hasNext()) {
            buff.append(((Symbol)i.next()).getSymbol());
        }
        return buff.toString();
    }

    public void setSecondaryStructure(SecondaryStructure secondaryStructure) {
    }

    public void modifySequence(String name, List sequence) {
    }

    public int getPartnerBase(int absolutePosition) {
        for (BaseBaseInteraction interaction : this.referenceSecondaryStructure.getBaseBaseInteractions()) {
            if (interaction.getResidue().getAbsolutePosition() == absolutePosition) {
                return interaction.getPartnerResidue().getAbsolutePosition();
            }
            if (interaction.getPartnerResidue().getAbsolutePosition() != absolutePosition) continue;
            return interaction.getResidue().getAbsolutePosition();
        }
        return -1;
    }

    public void setSymbolAt(Symbol s, int i) {
    }

    void calculateBasePairs() {
        this.basePairs = new ArrayList<BasePair>();
        this.pknotBasePairs = new ArrayList<BasePair>();
        this.helixIndex = 0;
        ArrayList<BasePair> tmpBasePairs = new ArrayList<BasePair>();
        ArrayList<PkBasePair> tmpPknotBasePairs = new ArrayList<PkBasePair>();
        BasePair tmpBasePair = null;
        BasePair lastBasePair = null;
        PkBasePair tmpPknotBasePair = null;
        Symbol l = null;
        int absPos = 0;
        block0: for (int i = 0; i < this.symbols.size(); ++i) {
            l = (Symbol)this.symbols.get(i);
            if (l.getSymbol() != '-') {
                ++absPos;
            }
            if (l.getSymbol() == '(' || l.getSymbol() == '<') {
                tmpBasePairs.add(new BasePair(i, absPos));
                continue;
            }
            if (l.getSymbol() == ')' || l.getSymbol() == '>') {
                if (tmpBasePairs.size() <= 0) continue;
                tmpBasePair = (BasePair)tmpBasePairs.get(tmpBasePairs.size() - 1);
                tmpBasePairs.remove(tmpBasePairs.size() - 1);
                tmpBasePair.partnerBaseAbs = i;
                tmpBasePair.partnerBaseReal = absPos;
                if (this.basePairs.size() == 0) {
                    ++this.helixIndex;
                    tmpBasePair.helixIndex = tmpBasePair.helixIndex;
                } else {
                    lastBasePair = this.basePairs.get(this.basePairs.size() - 1);
                    if (tmpBasePair.baseReal + 1 != lastBasePair.baseReal || tmpBasePair.partnerBaseReal - 1 != lastBasePair.partnerBaseReal) {
                        ++this.helixIndex;
                        tmpBasePair.helixIndex = tmpBasePair.helixIndex;
                    } else {
                        tmpBasePair.helixIndex = lastBasePair.helixIndex;
                    }
                }
                this.basePairs.add(tmpBasePair);
                continue;
            }
            if ('A' <= l.getSymbol() && l.getSymbol() <= 'Z') {
                tmpPknotBasePairs.add(new PkBasePair(i, absPos, l.getSymbol()));
                continue;
            }
            if ('a' > l.getSymbol() || l.getSymbol() > 'z' || tmpPknotBasePairs.size() <= 0) continue;
            for (int j = tmpPknotBasePairs.size() - 1; j >= 0; --j) {
                tmpPknotBasePair = (PkBasePair)tmpPknotBasePairs.get(j);
                if (tmpPknotBasePair.pkId != l.getSymbol() - 32) continue;
                tmpPknotBasePairs.remove(j);
                tmpPknotBasePair.partnerBaseAbs = i;
                tmpPknotBasePair.partnerBaseReal = absPos;
                tmpPknotBasePair.helixIndex = l.getSymbol() - 32 - 65;
                this.pknotBasePairs.add(tmpPknotBasePair);
                continue block0;
            }
        }
        tmpBasePairs = null;
        tmpPknotBasePairs = null;
    }

    public class Domain {
        private StructuralDomain structuralDomain;
        private Symbol start;
        private Symbol end;

        private Domain(StructuralDomain structuralDomain) {
            this.structuralDomain = structuralDomain;
        }

        public Symbol getEnd() {
            return this.end;
        }

        public Symbol getStart() {
            return this.start;
        }

        public StructuralDomain getStructuralDomain() {
            return this.structuralDomain;
        }
    }

    class PkBasePair
    extends BasePair {
        char pkId;

        PkBasePair(int baseAbs, int baseReal, char pkId) {
            super(baseAbs, baseReal);
            this.pkId = pkId;
        }
    }

    class BasePair {
        int baseAbs = -1;
        int baseReal = -1;
        int partnerBaseAbs = -1;
        int partnerBaseReal = -1;
        int helixIndex;
        float conservationScore = -1.0f;

        BasePair(int baseAbs, int baseReal) {
            this.baseAbs = baseAbs;
            this.baseReal = baseReal;
        }

        BasePair(int baseAbs, int baseReal, int partnerBaseAbs, int partnerBaseReal, int helixIndex) {
            this.baseAbs = baseAbs;
            this.baseReal = baseReal;
            this.partnerBaseAbs = partnerBaseAbs;
            this.partnerBaseReal = partnerBaseReal;
            this.helixIndex = helixIndex;
        }
    }
}

