/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.rnalign.features;

import fr.unistra.ibmc.s2s.rnalign.graphics.AlignmentCanvas;
import java.awt.Color;

public class Symbol {
    protected char symbol;
    protected int positionInSequence = -1;
    public static final Symbol A = new Symbol('A');
    public static final Symbol U = new Symbol('U');
    public static final Symbol T = new Symbol('T');
    public static final Symbol G = new Symbol('G');
    public static final Symbol C = new Symbol('C');
    public static final Symbol a = new Symbol('a');
    public static final Symbol u = new Symbol('u');
    public static final Symbol t = new Symbol('t');
    public static final Symbol g = new Symbol('g');
    public static final Symbol c = new Symbol('c');
    public static final Symbol Any = new Symbol('N');
    public static final Symbol Gap = new Symbol('-');
    public static final Symbol LockedGap = new Symbol('-', true);
    public static final Symbol Unknown = new Symbol('?');
    public static final Symbol rightH = new Symbol('(');
    public static final Symbol leftH = new Symbol(')');
    public static final Symbol rightInterH = new Symbol('{');
    public static final Symbol leftInterH = new Symbol('}');
    public static final Symbol rightCanonical = new Symbol('<');
    public static final Symbol leftCanonical = new Symbol('>');
    public static final Symbol rightPKnot = new Symbol('[');
    public static final Symbol leftPKnot = new Symbol(']');
    public static final Symbol dot = new Symbol('.');
    private boolean locked;

    protected Symbol() {
        this('?');
    }

    public Symbol(char symbol) {
        this.symbol = symbol;
        this.positionInSequence = -1;
    }

    protected Symbol(char symbol, boolean locked) {
        this(symbol);
        this.locked = locked;
    }

    public static Symbol createGap() {
        return Gap;
    }

    public boolean isGap() {
        return this.getSymbol() == Gap.getSymbol();
    }

    public int getPositionInSequence() {
        return this.positionInSequence;
    }

    public void setPositionInSequence(int positionInSequence) {
        this.positionInSequence = positionInSequence;
    }

    public char getSymbol() {
        return this.symbol;
    }

    public static Symbol getSymbol(char symbol) {
        switch (symbol) {
            case 'A': 
            case 'C': 
            case 'G': 
            case 'N': 
            case 'T': 
            case 'U': {
                return new Symbol(symbol);
            }
            case '-': {
                return Symbol.createGap();
            }
            case '(': {
                return rightH;
            }
            case ')': {
                return leftH;
            }
            case '{': {
                return rightInterH;
            }
            case '}': {
                return leftInterH;
            }
            case '<': {
                return rightCanonical;
            }
            case '>': {
                return leftCanonical;
            }
            case '[': {
                return rightPKnot;
            }
            case ']': {
                return leftPKnot;
            }
            case '.': {
                return dot;
            }
        }
        return new Symbol(symbol);
    }

    public void nextLetter() {
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public Color getColor() {
        switch (this.symbol) {
            case 'A': {
                return AlignmentCanvas.A_Color;
            }
            case 'U': {
                return AlignmentCanvas.U_Color;
            }
            case 'G': {
                return AlignmentCanvas.G_Color;
            }
            case 'C': {
                return AlignmentCanvas.C_Color;
            }
        }
        return Color.BLACK;
    }
}

