/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.rnalign.graphics;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.paradise.tools.ParadiseWorkingSession;
import fr.unistra.ibmc.s2s.Mediator;
import fr.unistra.ibmc.s2s.S2SConfig;
import fr.unistra.ibmc.s2s.SelectionListener;
import fr.unistra.ibmc.s2s.rnalign.features.Alignment;
import fr.unistra.ibmc.s2s.rnalign.features.BiologicalSequence;
import fr.unistra.ibmc.s2s.rnalign.features.StructuralSymbol;
import fr.unistra.ibmc.s2s.rnalign.features.Symbol;
import fr.unistra.ibmc.s2s.rnalign.graphics.AlignmentView;
import fr.unistra.ibmc.s2s.rnalign.graphics.BaseEdgeShape;
import fr.unistra.ibmc.s2s.rnalign.graphics.Circle;
import fr.unistra.ibmc.s2s.rnalign.graphics.GraphicContext;
import fr.unistra.ibmc.s2s.rnalign.graphics.Line;
import fr.unistra.ibmc.s2s.rnalign.graphics.ReversedAlignmentView;
import fr.unistra.ibmc.s2s.rnalign.graphics.Squarre;
import fr.unistra.ibmc.s2s.rnalign.graphics.Triangle;
import fr.unistra.ibmc.s2s.rnalign.utils.DrawingUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignmentCanvas
extends JPanel
implements SelectionListener,
MouseWheelListener,
ActionListener,
MouseListener,
MouseMotionListener {
    public static final char STANDARD = 's';
    public static final char INSERT = 'i';
    public static final char DELETE = 'd';
    public static final char USER_DEFINED_INTERACTIONS = 'u';
    GraphicContext gc;
    int pressedX;
    int pressedY;
    int mouseX;
    int mouseY;
    public static Color A_Color = Color.BLUE;
    public static Color U_Color = Color.MAGENTA;
    public static Color G_Color = Color.GREEN;
    public static Color C_Color = Color.GRAY;
    public static Color SecondaryInteraction_Color = new Color(192, 128, 0);
    public static Color TertiaryInteraction_Color = new Color(0, 192, 128);
    int firstUserDefinedInteractionX = -1;
    int firstUserDefinedInteractionY = -1;
    int secondUserDefinedInteractionX = -1;
    int secondUserDefinedInteractionY = -1;
    int firstPositionInAlignment = -1;
    int secondPositionInAlignment = -1;
    Alignment firstAlignment;
    Alignment secondAlignment;
    char mode = (char)115;
    public static final int MAXLABELSIZE = 20;
    private ParadiseWorkingSession workingSession;
    private AlignmentView mouseOverAlignmentView;
    int leftMarge = 1;
    int topMarge = 1;
    int bottomMarge = 0;
    private Rectangle drawingArea;
    Mediator mediator;
    private List<AlignmentView> alignmentViews;
    private AlignmentView selectedView;
    private AlignmentView pressedView;
    private Alignment mainAlignment;
    private Alignment alignmentDiff;
    private Molecule moleculeToCompare;
    private List<SelectionListener> selectionListeners;
    private JPopupMenu popupMenu;

    public AlignmentCanvas(Mediator mediator, ParadiseWorkingSession workingSession, int screenWidth, int screenHeight) {
        this.workingSession = workingSession;
        this.gc = new GraphicContext();
        this.mediator = mediator;
        this.mediator.setAlignmentCanvas(this);
        this.setPreferredSize(new Dimension((int)((double)screenWidth * 0.8), (int)((double)screenHeight * 0.8)));
        this.setBackground(Color.WHITE);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.registerKeyboardAction(this, "standard", KeyStroke.getKeyStroke('s'), 2);
        this.registerKeyboardAction(this, "insert", KeyStroke.getKeyStroke('i'), 2);
        this.registerKeyboardAction(this, "delete", KeyStroke.getKeyStroke('d'), 2);
        this.registerKeyboardAction(this, "user-defined-interactions", KeyStroke.getKeyStroke('u'), 2);
        this.registerKeyboardAction(this, "move-view-right", KeyStroke.getKeyStroke('r'), 2);
        this.registerKeyboardAction(this, "move-view-left", KeyStroke.getKeyStroke('e'), 2);
        this.registerKeyboardAction(this, "move-residues-right", KeyStroke.getKeyStroke('p'), 2);
        this.registerKeyboardAction(this, "move-residues-left", KeyStroke.getKeyStroke('o'), 2);
        this.alignmentViews = new ArrayList<AlignmentView>();
        this.selectionListeners = new ArrayList<SelectionListener>();
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(new ColorMenu("Secondary Interactions Color", 0));
        this.popupMenu.add(new ColorMenu("Tertiary Interactions Color", 2));
        JMenu residues = new JMenu("Residues Color");
        this.popupMenu.add(residues);
        residues.add(new ColorMenu("Adenine", 3));
        residues.add(new ColorMenu("Uracil", 6));
        residues.add(new ColorMenu("Guanine", 4));
        residues.add(new ColorMenu("Cytosine", 5));
        JMenuItem setAsDefault = new JMenuItem("Set Current Colors as Default");
        setAsDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                S2SConfig.saveUserColors();
                try {
                    S2SConfig.save();
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.popupMenu.add(setAsDefault);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void removeBaseBaseInteraction(BaseBaseInteraction interaction) {
        for (Symbol s : this.mainAlignment.getStructure2D3D().getSymbols()) {
            if (s.getPositionInSequence() != interaction.getResidue().getAbsolutePosition() || !((Object)this.mainAlignment.getBiologicalReferenceSequence().getMolecule()).equals(interaction.getResidue().getMolecule())) continue;
            ((StructuralSymbol)s).removeBaseBaseInteraction(interaction);
            this.repaint();
            return;
        }
    }

    public void addBaseBaseInteraction(BaseBaseInteraction interaction) {
        StructuralSymbol symbol = null;
        StructuralSymbol pairedSymbol = null;
        for (Symbol s : this.mainAlignment.getStructure2D3D().getSymbols()) {
            if (s.getPositionInSequence() == interaction.getResidue().getAbsolutePosition() && ((Object)this.mainAlignment.getBiologicalReferenceSequence().getMolecule()).equals(interaction.getResidue().getMolecule())) {
                symbol = (StructuralSymbol)s;
            } else if (s.getPositionInSequence() == interaction.getPartnerResidue().getAbsolutePosition() && ((Object)this.mainAlignment.getBiologicalReferenceSequence().getMolecule()).equals(interaction.getPartnerResidue().getMolecule())) {
                pairedSymbol = (StructuralSymbol)s;
            }
            if (symbol == null || pairedSymbol == null) continue;
            symbol.addReferenceBaseBaseInteraction(interaction, pairedSymbol);
            this.repaint();
            return;
        }
    }

    public void addSelectionListener(SelectionListener l) {
        this.selectionListeners.add(l);
    }

    public GraphicContext getGraphicContext() {
        return this.gc;
    }

    public void clearDisplay() {
        this.mainAlignment = null;
        this.selectedView = null;
        this.repaint();
    }

    public List<AlignmentView> getAlignmentViews() {
        return new ArrayList<AlignmentView>(this.alignmentViews);
    }

    public AlignmentView getSelectedView() {
        return this.selectedView;
    }

    public Alignment getMainAlignment() {
        return this.mainAlignment;
    }

    public Alignment getAlignmentDiff() {
        return this.alignmentDiff;
    }

    public void addView() {
        if (this.alignmentDiff == null) {
            this.alignmentViews.add(new AlignmentView(this, this.mainAlignment));
            this.alignmentViews.add(new ReversedAlignmentView(this, this.mainAlignment));
        } else {
            this.alignmentViews.add(new AlignmentView(this, this.alignmentDiff));
            this.alignmentViews.add(new AlignmentView(this, this.mainAlignment));
            this.alignmentViews.add(new ReversedAlignmentView(this, this.mainAlignment));
            this.alignmentViews.add(new ReversedAlignmentView(this, this.alignmentDiff));
        }
        this.repaint();
    }

    public void removeLastView() {
        if (this.alignmentDiff == null) {
            this.alignmentViews.remove(this.alignmentViews.get(this.alignmentViews.size() - 1));
            this.alignmentViews.remove(this.alignmentViews.get(this.alignmentViews.size() - 1));
        } else {
            this.alignmentViews.remove(this.alignmentViews.get(this.alignmentViews.size() - 1));
            this.alignmentViews.remove(this.alignmentViews.get(this.alignmentViews.size() - 1));
            this.alignmentViews.remove(this.alignmentViews.get(this.alignmentViews.size() - 1));
            this.alignmentViews.remove(this.alignmentViews.get(this.alignmentViews.size() - 1));
        }
        this.repaint();
    }

    void removeBiologicalSequenceAt(int index) {
        this.mainAlignment.removeBiologicalSequenceAt(index);
        this.mainAlignment.updateConservationScores();
        for (AlignmentView v : this.alignmentViews) {
            if (v.alignment != this.mainAlignment) continue;
            v.setNumberOfSequencesToDisplay(v.getNumberOfSequencesToDisplay() > this.mainAlignment.getBiologicalSequenceCount() ? this.mainAlignment.getBiologicalSequenceCount() : v.getNumberOfSequencesToDisplay());
        }
        this.repaint();
    }

    public void setMainAlignment(Alignment alignment) {
        this.mainAlignment = alignment;
        this.moleculeToCompare = this.mainAlignment.getBiologicalReferenceSequence().getMolecule();
        this.alignmentDiff = null;
        this.alignmentViews = new ArrayList<AlignmentView>();
        this.mainAlignment.updateConservationScores();
        this.addView();
        this.repaint();
    }

    public void setSecondAlignment(Alignment alignment) {
        if (this.alignmentDiff != null) {
            this.removeAlignmentDiff();
        }
        this.alignmentDiff = alignment;
        ArrayList<AlignmentView> views = new ArrayList<AlignmentView>();
        for (int i = 0; i < this.alignmentViews.size(); ++i) {
            if (!ReversedAlignmentView.class.isInstance(this.alignmentViews.get(i))) {
                views.add(new AlignmentView(this, this.alignmentDiff));
                views.add(this.alignmentViews.get(i));
                continue;
            }
            views.add(this.alignmentViews.get(i));
            views.add(new ReversedAlignmentView(this, this.alignmentDiff));
        }
        this.alignmentViews = views;
        this.alignmentDiff.updateConservationScores();
        this.repaint();
    }

    public void removeAlignmentDiff() {
        ArrayList<AlignmentView> views = new ArrayList<AlignmentView>();
        for (int i = 0; i < this.alignmentViews.size(); ++i) {
            if (this.alignmentViews.get(i).getAlignment() == this.alignmentDiff) continue;
            views.add(this.alignmentViews.get(i));
        }
        this.alignmentViews = views;
        this.alignmentDiff = null;
        this.repaint();
    }

    void setMediator(Mediator mediator) {
        this.mediator = mediator;
    }

    public void setQuickDraw(boolean quickDraw) {
        this.gc.setQuickDraw(quickDraw);
        this.repaint();
    }

    public void modifyFontSize(int level) {
        Font f = this.gc.getFont();
        this.gc.setFont(f.deriveFont((float)(f.getSize() + level)));
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.mainAlignment != null) {
            int i;
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setFont(this.gc.getFont());
            g2.setColor(Color.BLACK);
            FontMetrics fm = g2.getFontMetrics();
            int previousHorizontalAdvance = this.gc.getHorizontalAdvance();
            this.gc.setHorizontalAdvance(fm.stringWidth("A"));
            float ratio = (float)previousHorizontalAdvance / (float)this.gc.getHorizontalAdvance();
            for (AlignmentView view : this.alignmentViews) {
                view.viewX = (int)((float)view.viewX / ratio);
            }
            this.gc.setVerticalAdvance(fm.getHeight());
            this.gc.setLetterHeight(fm.getAscent() + fm.getDescent());
            this.gc.setLetterWidth(fm.charWidth('A'));
            this.gc.currentX = this.leftMarge * this.gc.getHorizontalAdvance();
            this.gc.currentY = this.topMarge * this.gc.getVerticalAdvance();
            int totalHeight = this.getTotalHeight(this.gc);
            this.setPreferredSize(new Dimension(this.getSize().width, totalHeight));
            this.revalidate();
            this.gc.currentWidth = this.getSize().width - 2 * this.leftMarge * this.gc.getHorizontalAdvance();
            this.drawingArea = new Rectangle(this.gc.currentX, this.gc.currentY, this.gc.currentWidth, this.getTotalHeight(this.gc));
            for (AlignmentView view : new ArrayList<AlignmentView>(this.alignmentViews)) {
                this.gc.currentY += view.getTopMarge() * this.gc.getVerticalAdvance();
                this.gc.currentX += view.getLeftMarge() * this.gc.getHorizontalAdvance();
                this.gc.currentWidth -= 2 * view.getLeftMarge() * this.gc.getHorizontalAdvance();
                view.draw(g2, this.gc);
                this.gc.currentY += view.getBottomMarge() * this.gc.getVerticalAdvance();
                this.gc.currentX -= view.getLeftMarge() * this.gc.getHorizontalAdvance();
                this.gc.currentWidth += 2 * view.getLeftMarge() * this.gc.getHorizontalAdvance();
            }
            this.gc.setCurrentX(this.gc.getCurrentX() - this.leftMarge * this.gc.getHorizontalAdvance());
            this.gc.setCurrentY(this.gc.getCurrentY() + this.bottomMarge * this.gc.getVerticalAdvance());
            this.gc.currentWidth += 2 * this.leftMarge * this.gc.getHorizontalAdvance();
            int alignmentViewNb = this.alignmentViews.size();
            for (i = 0; i < alignmentViewNb - 1; ++i) {
                if (this.alignmentViews.get((int)i).alignment == this.mainAlignment && this.alignmentViews.get((int)(i + 1)).alignment == this.mainAlignment) {
                    this.drawBaseBaseInteractions(g2, this.gc, this.alignmentViews.get(i), this.alignmentViews.get(i + 1));
                    continue;
                }
                if (this.alignmentViews.get((int)i).alignment != this.alignmentDiff || this.alignmentViews.get((int)(i + 1)).alignment != this.alignmentDiff) continue;
                this.drawBaseBaseInteractions(g2, this.gc, this.alignmentViews.get(i), this.alignmentViews.get(i + 1));
            }
            if (this.alignmentDiff != null) {
                for (i = 0; i < this.alignmentViews.size(); ++i) {
                    if (this.alignmentViews.get((int)i).alignment != this.alignmentDiff) continue;
                    if (i > 0 && this.alignmentViews.get((int)(i - 1)).alignment == this.mainAlignment) {
                        this.drawAlignmentsDiff(g2, this.gc, this.alignmentViews.get(i - 1), this.alignmentViews.get(i));
                    }
                    if (i >= this.alignmentViews.size() - 1 || this.alignmentViews.get((int)(i + 1)).alignment != this.mainAlignment) continue;
                    this.drawAlignmentsDiff(g2, this.gc, this.alignmentViews.get(i), this.alignmentViews.get(i + 1));
                }
            }
            if (this.mode == 'u' && this.firstUserDefinedInteractionX != -1 && this.firstUserDefinedInteractionY != -1 && this.secondUserDefinedInteractionX != -1 && this.secondUserDefinedInteractionY != -1) {
                g.drawLine(this.firstUserDefinedInteractionX, this.firstUserDefinedInteractionY, this.secondUserDefinedInteractionX, this.secondUserDefinedInteractionY);
            }
        }
    }

    private void drawAlignmentsDiff(Graphics2D g, GraphicContext gc, AlignmentView upperView, AlignmentView lowerView) {
        block23: {
            Symbol upperStructuralSymbol;
            BiologicalSequence upperSequence = null;
            BiologicalSequence lowerSequence = null;
            for (BiologicalSequence s : upperView.alignment.getBiologicalSequences()) {
                if (!s.getMolecule().getParadiseID().equals(this.moleculeToCompare.getParadiseID())) continue;
                upperSequence = s;
                break;
            }
            if (upperSequence != null) {
                for (BiologicalSequence s : lowerView.alignment.getBiologicalSequences()) {
                    if (!s.getMolecule().getParadiseID().equals(this.moleculeToCompare.getParadiseID())) continue;
                    lowerSequence = s;
                    break;
                }
            }
            if (upperSequence == null || lowerSequence == null) break block23;
            if (ReversedAlignmentView.class.isInstance(upperView)) {
                block2: for (int j = upperView.getLastPos(); j >= upperView.getFirstPos(); --j) {
                    upperStructuralSymbol = upperView.getAlignment().getStructure2D3D().getSymbol(j);
                    Symbol upperBiologicalSymbol = upperSequence.getSymbol(j);
                    if (upperBiologicalSymbol.isGap()) continue;
                    int upperPositionInSequence = upperBiologicalSymbol.getPositionInSequence();
                    for (int k = lowerView.getLastPos(); k >= lowerView.getFirstPos(); --k) {
                        int ctrl2X;
                        int ctrl1X;
                        int lowerPositionInSequence;
                        Symbol lowerStructuralSymbol = lowerView.getAlignment().getStructure2D3D().getSymbol(k);
                        Symbol lowerBiologicalSymbol = lowerSequence.getSymbol(k);
                        if (lowerBiologicalSymbol.isGap() || upperPositionInSequence != (lowerPositionInSequence = lowerBiologicalSymbol.getPositionInSequence())) continue;
                        int upperStartX = upperView.getCurrentColumnCoordinate(j);
                        int upperEndX = upperView.getCurrentColumnCoordinate(j);
                        int upperY = (int)upperView.getDrawingArea().getMaxY() + gc.getVerticalAdvance();
                        int lowerStartX = lowerView.getCurrentColumnCoordinate(k);
                        int lowerEndX = lowerView.getCurrentColumnCoordinate(k);
                        int lowerY = (int)lowerView.getDrawingArea().getMinY();
                        while (--j >= upperView.getFirstPos() && !upperSequence.getSymbol(j).isGap() && --k >= lowerView.getFirstPos() && !lowerSequence.getSymbol(k).isGap() && upperStructuralSymbol.getSymbol() == upperView.getAlignment().getStructure2D3D().getSymbol(j).getSymbol() && lowerStructuralSymbol.getSymbol() == lowerView.getAlignment().getStructure2D3D().getSymbol(k).getSymbol()) {
                            upperEndX = upperView.getCurrentColumnCoordinate(j);
                            lowerEndX = lowerView.getCurrentColumnCoordinate(k);
                            upperStructuralSymbol = upperView.getAlignment().getStructure2D3D().getSymbol(j);
                            lowerStructuralSymbol = lowerView.getAlignment().getStructure2D3D().getSymbol(k);
                        }
                        GeneralPath p = new GeneralPath();
                        p.moveTo(upperStartX - gc.getHorizontalAdvance() / 2, upperY);
                        double distance = DrawingUtils.getDistance(upperEndX + gc.getHorizontalAdvance() / 2, upperY, lowerEndX + gc.getHorizontalAdvance() / 2, upperY);
                        int middleEndX = (upperEndX + gc.getHorizontalAdvance() / 2 + lowerEndX + gc.getHorizontalAdvance() / 2) / 2;
                        int middleY = (upperY + lowerY) / 2;
                        if (upperEndX < lowerEndX) {
                            ctrl1X = middleEndX - (int)distance / 2;
                            ctrl2X = middleEndX + (int)distance / 2;
                        } else {
                            ctrl1X = middleEndX + (int)distance / 2;
                            ctrl2X = middleEndX - (int)distance / 2;
                        }
                        p.append(new CubicCurve2D.Float(upperEndX + gc.getHorizontalAdvance() / 2, upperY, ctrl1X, middleY, ctrl2X, middleY, lowerEndX + gc.getHorizontalAdvance() / 2, lowerY), true);
                        distance = DrawingUtils.getDistance(upperStartX - gc.getHorizontalAdvance() / 2, upperY, lowerStartX - gc.getHorizontalAdvance() / 2, upperY);
                        int middleStartX = (upperStartX - gc.getHorizontalAdvance() / 2 + lowerStartX - gc.getHorizontalAdvance() / 2) / 2;
                        if (upperEndX < lowerEndX) {
                            ctrl1X = middleStartX + (int)distance / 2;
                            ctrl2X = middleStartX - (int)distance / 2;
                        } else {
                            ctrl1X = middleStartX - (int)distance / 2;
                            ctrl2X = middleStartX + (int)distance / 2;
                        }
                        p.append(new CubicCurve2D.Float(lowerStartX - gc.getHorizontalAdvance() / 2, lowerY, ctrl1X, middleY, ctrl2X, middleY, upperStartX - gc.getHorizontalAdvance() / 2, upperY), true);
                        g.setPaint(new GradientPaint((upperStartX + upperEndX) / 2, upperY, this.getStructuralAlignmentRelation(upperStructuralSymbol.getSymbol()), (lowerStartX + lowerEndX) / 2, lowerY, this.getStructuralAlignmentRelation(lowerStructuralSymbol.getSymbol())));
                        g.setComposite(AlphaComposite.getInstance(3, 0.3f));
                        g.fill(p);
                        g.setColor(Color.BLACK);
                        g.draw(p);
                        if (j >= upperView.getFirstPos() && k >= lowerView.getFirstPos()) {
                            if (upperSequence.getSymbol(j).isGap()) continue block2;
                            if (lowerSequence.getSymbol(k).isGap()) {
                                ++j;
                                continue;
                            }
                            ++j;
                            ++k;
                            continue block2;
                        }
                        break block23;
                    }
                }
            } else {
                block5: for (int j = upperView.getFirstPos(); j <= upperView.getLastPos(); ++j) {
                    upperStructuralSymbol = upperView.getAlignment().getStructure2D3D().getSymbol(j);
                    Symbol upperBiologicalSymbol = upperSequence.getSymbol(j);
                    if (upperBiologicalSymbol.isGap()) continue;
                    int upperPositionInSequence = upperBiologicalSymbol.getPositionInSequence();
                    for (int k = lowerView.getFirstPos(); k <= lowerView.getLastPos(); ++k) {
                        int ctrl2X;
                        int ctrl1X;
                        int lowerPositionInSequence;
                        Symbol lowerStructuralSymbol = lowerView.getAlignment().getStructure2D3D().getSymbol(k);
                        Symbol lowerBiologicalSymbol = lowerSequence.getSymbol(k);
                        if (lowerBiologicalSymbol.isGap() || upperPositionInSequence != (lowerPositionInSequence = lowerBiologicalSymbol.getPositionInSequence())) continue;
                        int upperStartX = upperView.getCurrentColumnCoordinate(j);
                        int upperEndX = upperView.getCurrentColumnCoordinate(j);
                        int upperY = (int)upperView.getDrawingArea().getMaxY() + gc.getVerticalAdvance();
                        int lowerStartX = lowerView.getCurrentColumnCoordinate(k);
                        int lowerEndX = lowerView.getCurrentColumnCoordinate(k);
                        int lowerY = (int)lowerView.getDrawingArea().getMinY();
                        while (++j <= upperView.getLastPos() && !upperSequence.getSymbol(j).isGap() && ++k <= lowerView.getLastPos() && !lowerSequence.getSymbol(k).isGap() && upperStructuralSymbol.getSymbol() == upperView.getAlignment().getStructure2D3D().getSymbol(j).getSymbol() && lowerStructuralSymbol.getSymbol() == lowerView.getAlignment().getStructure2D3D().getSymbol(k).getSymbol()) {
                            upperEndX = upperView.getCurrentColumnCoordinate(j);
                            lowerEndX = lowerView.getCurrentColumnCoordinate(k);
                            upperStructuralSymbol = upperView.getAlignment().getStructure2D3D().getSymbol(j);
                            lowerStructuralSymbol = lowerView.getAlignment().getStructure2D3D().getSymbol(k);
                        }
                        GeneralPath p = new GeneralPath();
                        p.moveTo(upperStartX - gc.getHorizontalAdvance() / 2, upperY);
                        double distance = DrawingUtils.getDistance(upperEndX + gc.getHorizontalAdvance() / 2, upperY, lowerEndX + gc.getHorizontalAdvance() / 2, upperY);
                        int middleEndX = (upperEndX + gc.getHorizontalAdvance() / 2 + lowerEndX + gc.getHorizontalAdvance() / 2) / 2;
                        int middleY = (upperY + lowerY) / 2;
                        if (upperEndX < lowerEndX) {
                            ctrl1X = middleEndX - (int)distance / 2;
                            ctrl2X = middleEndX + (int)distance / 2;
                        } else {
                            ctrl1X = middleEndX + (int)distance / 2;
                            ctrl2X = middleEndX - (int)distance / 2;
                        }
                        p.append(new CubicCurve2D.Float(upperEndX + gc.getHorizontalAdvance() / 2, upperY, ctrl1X, middleY, ctrl2X, middleY, lowerEndX + gc.getHorizontalAdvance() / 2, lowerY), true);
                        distance = DrawingUtils.getDistance(upperStartX - gc.getHorizontalAdvance() / 2, upperY, lowerStartX - gc.getHorizontalAdvance() / 2, upperY);
                        int middleStartX = (upperStartX - gc.getHorizontalAdvance() / 2 + lowerStartX - gc.getHorizontalAdvance() / 2) / 2;
                        if (upperEndX < lowerEndX) {
                            ctrl1X = middleStartX + (int)distance / 2;
                            ctrl2X = middleStartX - (int)distance / 2;
                        } else {
                            ctrl1X = middleStartX - (int)distance / 2;
                            ctrl2X = middleStartX + (int)distance / 2;
                        }
                        p.append(new CubicCurve2D.Float(lowerStartX - gc.getHorizontalAdvance() / 2, lowerY, ctrl1X, middleY, ctrl2X, middleY, upperStartX - gc.getHorizontalAdvance() / 2, upperY), true);
                        g.setPaint(new GradientPaint((upperStartX + upperEndX) / 2, upperY, this.getStructuralAlignmentRelation(upperStructuralSymbol.getSymbol()), (lowerStartX + lowerEndX) / 2, lowerY, this.getStructuralAlignmentRelation(lowerStructuralSymbol.getSymbol())));
                        g.setComposite(AlphaComposite.getInstance(3, 0.3f));
                        g.fill(p);
                        g.setColor(Color.BLACK);
                        g.draw(p);
                        if (j <= upperView.getLastPos() && k <= lowerView.getLastPos()) {
                            if (upperSequence.getSymbol(j).isGap()) continue block5;
                            if (lowerSequence.getSymbol(k).isGap()) {
                                --j;
                                continue;
                            }
                            --j;
                            --k;
                            continue block5;
                        }
                        break block23;
                    }
                }
            }
        }
    }

    private void drawBaseBaseInteractions(Graphics2D g, GraphicContext gc, AlignmentView upperView, AlignmentView lowerView) {
        for (int j = upperView.getFirstPos(); j <= upperView.getLastPos(); ++j) {
            StructuralSymbol s;
            if (!upperView.selectedPositionsToDrawInteractions.isEmpty() && !upperView.selectedPositionsToDrawInteractions.contains(upperView.getAlignment().getBiologicalReferenceSequence().getSymbol(j).getPositionInSequence()) || (s = (StructuralSymbol)upperView.getAlignment().getStructure2D3D().getSymbol(j)).isGap()) continue;
            for (BaseBaseInteraction interaction : s.getReferenceBaseBaseInteractions()) {
                if ((!interaction.isSecondaryInteraction() || !upperView.displaySecondaryInteractions) && (interaction.isSecondaryInteraction() || !upperView.displayTertiaryInteractions)) continue;
                StructuralSymbol pairedSymbol = s.getPairedSymbol(interaction);
                int partnerPositionInAlignment = upperView.getAlignment().getStructure2D3D().getIndex(pairedSymbol);
                if (partnerPositionInAlignment < lowerView.getFirstPos() || partnerPositionInAlignment > lowerView.getLastPos()) continue;
                int x1 = upperView.getCurrentColumnCoordinate(j);
                int y1 = (int)upperView.getDrawingArea().getMaxY();
                int x2 = lowerView.getCurrentColumnCoordinate(partnerPositionInAlignment);
                int y2 = (int)lowerView.getDrawingArea().getMinY();
                Color c = interaction.isSecondaryInteraction() ? SecondaryInteraction_Color : TertiaryInteraction_Color;
                g.setColor(c.darker());
                ArrayList<BaseEdgeShape> shapes = new ArrayList<BaseEdgeShape>();
                double distance = DrawingUtils.getDistance(x1, y1, x2, y2);
                double symbolSize = 2 * gc.getVerticalAdvance();
                Point2D[] ip1 = null;
                if (distance >= symbolSize) {
                    ip1 = DrawingUtils.fit(x1, y1, x2, y2, (distance - symbolSize) / 2.0);
                }
                if (ip1 != null) {
                    String type = s.getEdge(interaction) + "" + pairedSymbol.getEdge(interaction);
                    if ("HH".equals(type)) {
                        if ((upperView.displayCisHH || interaction.getOrientation() != 'C') && (upperView.displayTransHH || interaction.getOrientation() != 'T')) {
                            shapes.add(new Line(new Point2D.Double(x1, y1), ip1[0]));
                            shapes.add(new Line(ip1[1], new Point2D.Double(x2, y2)));
                            this.drawHHSymbol(shapes, ip1[0], ip1[1], symbolSize, interaction.getOrientation());
                        }
                    } else if ("SS".equals(type)) {
                        if ((upperView.displayCisSESE || interaction.getOrientation() != 'C') && (upperView.displayTransSESE || interaction.getOrientation() != 'T')) {
                            shapes.add(new Line(new Point2D.Double(x1, y1), ip1[0]));
                            shapes.add(new Line(ip1[1], new Point2D.Double(x2, y2)));
                            this.drawSESESymbol(shapes, ip1[0], ip1[1], symbolSize, interaction.getOrientation());
                        }
                    } else if ("WW".equals(type)) {
                        if ((upperView.displayCisWCWC || interaction.getOrientation() != 'C') && (upperView.displayTransWCWC || interaction.getOrientation() != 'T')) {
                            shapes.add(new Line(new Point2D.Double(x1, y1), ip1[0]));
                            shapes.add(new Line(ip1[1], new Point2D.Double(x2, y2)));
                            this.drawWCWCSymbol(shapes, ip1[0], ip1[1], symbolSize, interaction.getOrientation());
                        }
                    } else if ("SH".equals(type) || "HS".equals(type)) {
                        if ((upperView.displayCisHSE || interaction.getOrientation() != 'C') && (upperView.displayTransHSE || interaction.getOrientation() != 'T')) {
                            shapes.add(new Line(new Point2D.Double(x1, y1), ip1[0]));
                            shapes.add(new Line(ip1[1], new Point2D.Double(x2, y2)));
                            if ("SH".equals(type)) {
                                this.drawSEHSymbol(shapes, ip1[0], ip1[1], symbolSize, interaction.getOrientation());
                            } else {
                                this.drawHSESymbol(shapes, ip1[0], ip1[1], symbolSize, interaction.getOrientation());
                            }
                        }
                    } else if ("HW".equals(type) || "WH".equals(type)) {
                        if ((upperView.displayCisHWC || interaction.getOrientation() != 'C') && (upperView.displayTransHWC || interaction.getOrientation() != 'T')) {
                            shapes.add(new Line(new Point2D.Double(x1, y1), ip1[0]));
                            shapes.add(new Line(ip1[1], new Point2D.Double(x2, y2)));
                            if ("HW".equals(type)) {
                                this.drawHWCSymbol(shapes, ip1[0], ip1[1], symbolSize, interaction.getOrientation());
                            } else {
                                this.drawWCHSymbol(shapes, ip1[0], ip1[1], symbolSize, interaction.getOrientation());
                            }
                        }
                    } else if (("WS".equals(type) || "SW".equals(type)) && (upperView.displayCisSEWC || interaction.getOrientation() != 'C') && (upperView.displayTransSEWC || interaction.getOrientation() != 'T')) {
                        shapes.add(new Line(new Point2D.Double(x1, y1), ip1[0]));
                        shapes.add(new Line(ip1[1], new Point2D.Double(x2, y2)));
                        if ("WS".equals(type)) {
                            this.drawWCSESymbol(shapes, ip1[0], ip1[1], symbolSize, interaction.getOrientation());
                        } else {
                            this.drawSEWCSymbol(shapes, ip1[0], ip1[1], symbolSize, interaction.getOrientation());
                        }
                    }
                } else {
                    shapes.add(new Line(new Point2D.Double(x1, y1), new Point2D.Double(x2, y2)));
                }
                for (BaseEdgeShape shape : shapes) {
                    shape.draw(g);
                }
            }
        }
        g.setColor(Color.BLACK);
    }

    private void drawHHSymbol(List<BaseEdgeShape> shapes, Point2D point1, Point2D point2, double distance, char orientation) {
        Point2D[] points = DrawingUtils.fit(point1.getX(), point1.getY(), point2.getX(), point2.getY(), distance / 3.0);
        shapes.add(new Line(point1, points[0]));
        shapes.add(new Line(point2, points[1]));
        shapes.add(new Squarre(point1, point2, points[0], points[1], distance, orientation));
    }

    private void drawWCWCSymbol(List<BaseEdgeShape> shapes, Point2D point1, Point2D point2, double distance, char orientation) {
        Point2D[] points = DrawingUtils.fit(point1.getX(), point1.getY(), point2.getX(), point2.getY(), distance / 3.0);
        shapes.add(new Line(point1, points[0]));
        shapes.add(new Line(point2, points[1]));
        Point2D.Double center = new Point2D.Double((point1.getX() + point2.getX()) / 2.0, (point1.getY() + point2.getY()) / 2.0);
        shapes.add(new Circle(points[0], center, orientation));
    }

    private void drawSESESymbol(List<BaseEdgeShape> shapes, Point2D point1, Point2D point2, double distance, char orientation) {
        Point2D[] points = DrawingUtils.fit(point1.getX(), point1.getY(), point2.getX(), point2.getY(), distance / 3.0);
        shapes.add(new Line(point1, points[0]));
        shapes.add(new Line(point2, points[1]));
        shapes.add(new Triangle(point1, point2, points[0], points[1], distance, orientation));
    }

    private void drawSEHSymbol(List<BaseEdgeShape> shapes, Point2D point1, Point2D point2, double distance, char orientation) {
        Point2D[] points = DrawingUtils.fit(point1.getX(), point1.getY(), point2.getX(), point2.getY(), distance / 3.0);
        shapes.add(new Triangle(point1, point2, point1, points[0], distance, orientation));
        shapes.add(new Squarre(point1, point2, points[1], point2, distance, orientation));
        shapes.add(new Line(points[0], points[1]));
    }

    private void drawHSESymbol(List<BaseEdgeShape> shapes, Point2D point1, Point2D point2, double distance, char orientation) {
        Point2D[] points = DrawingUtils.fit(point1.getX(), point1.getY(), point2.getX(), point2.getY(), distance / 3.0);
        shapes.add(new Squarre(point1, point2, point1, points[0], distance, orientation));
        shapes.add(new Triangle(point1, point2, points[1], point2, distance, orientation));
        shapes.add(new Line(points[0], points[1]));
    }

    private void drawHWCSymbol(List<BaseEdgeShape> shapes, Point2D point1, Point2D point2, double distance, char orientation) {
        Point2D[] points = DrawingUtils.fit(point1.getX(), point1.getY(), point2.getX(), point2.getY(), distance / 3.0);
        Point2D center = DrawingUtils.fit(point1.getX(), point1.getY(), point2.getX(), point2.getY(), distance / 6.0)[1];
        shapes.add(new Squarre(point1, point2, point1, points[0], distance, orientation));
        shapes.add(new Circle(point2, center, orientation));
        shapes.add(new Line(points[0], points[1]));
    }

    private void drawWCHSymbol(List<BaseEdgeShape> shapes, Point2D point1, Point2D point2, double distance, char orientation) {
        Point2D[] points = DrawingUtils.fit(point1.getX(), point1.getY(), point2.getX(), point2.getY(), distance / 3.0);
        Point2D center = DrawingUtils.fit(point1.getX(), point1.getY(), point2.getX(), point2.getY(), distance / 6.0)[0];
        shapes.add(new Circle(point1, center, orientation));
        shapes.add(new Squarre(point1, point2, point2, points[1], distance, orientation));
        shapes.add(new Line(points[0], points[1]));
    }

    private void drawWCSESymbol(List<BaseEdgeShape> shapes, Point2D point1, Point2D point2, double distance, char orientation) {
        Point2D[] points = DrawingUtils.fit(point1.getX(), point1.getY(), point2.getX(), point2.getY(), distance / 3.0);
        Point2D center = DrawingUtils.fit(point1.getX(), point1.getY(), point2.getX(), point2.getY(), distance / 6.0)[0];
        shapes.add(new Circle(point1, center, orientation));
        shapes.add(new Triangle(point1, point2, points[1], point2, distance, orientation));
        shapes.add(new Line(points[0], points[1]));
    }

    private void drawSEWCSymbol(List<BaseEdgeShape> shapes, Point2D point1, Point2D point2, double distance, char orientation) {
        Point2D[] points = DrawingUtils.fit(point1.getX(), point1.getY(), point2.getX(), point2.getY(), distance / 3.0);
        Point2D center = DrawingUtils.fit(point1.getX(), point1.getY(), point2.getX(), point2.getY(), distance / 6.0)[1];
        shapes.add(new Triangle(point1, point2, points[0], point1, distance, orientation));
        shapes.add(new Circle(point2, center, orientation));
        shapes.add(new Line(points[0], points[1]));
    }

    private Color getStructuralAlignmentRelation(char symbol) {
        switch (symbol) {
            case '.': {
                return Color.GREEN;
            }
            case '(': 
            case ')': 
            case '<': 
            case '>': 
            case '{': 
            case '}': {
                return Color.BLUE;
            }
        }
        return Color.BLACK;
    }

    private int getTotalHeight(GraphicContext gc) {
        int height = 0;
        for (AlignmentView view : this.alignmentViews) {
            height += view.getTopMarge() * gc.getVerticalAdvance();
            height += view.getHeight(gc);
            height += view.getBottomMarge() * gc.getVerticalAdvance();
        }
        height += this.topMarge * gc.getVerticalAdvance();
        return height += this.bottomMarge * gc.getVerticalAdvance();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
        this.pressedX = e.getX();
        this.pressedY = e.getY();
        for (AlignmentView v : this.alignmentViews) {
            if (!v.getDrawingArea().contains(e.getX(), e.getY())) continue;
            v.mousePressed(e);
            this.pressedView = v;
            break;
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.pressedView != null) {
            this.pressedView.mouseDragged(e);
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        for (AlignmentView v : this.alignmentViews) {
            if (v.selectionBox.contains(e.getX(), e.getY())) {
                v.setSelected(true);
                this.selectedView = v;
                this.mediator.setPreferencesPanel(v.isDisplaySecondaryInteractions(), v.isDisplayTertiaryInteractions(), v.isLinkedToNextView(), v.getNumberOfSequencesToDisplay());
                for (AlignmentView _v : this.alignmentViews) {
                    if (_v == v) continue;
                    _v.setSelected(false);
                }
                this.repaint();
                return;
            }
            if (!v.contains(e.getX(), e.getY())) continue;
            v.mouseClicked(e);
            this.repaint();
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        if (this.mode == 'u') {
            this.secondUserDefinedInteractionX = e.getX();
            this.secondUserDefinedInteractionY = e.getY();
        } else {
            this.mouseOverAlignmentView = null;
            for (AlignmentView v : this.alignmentViews) {
                if (!v.contains(e.getX(), e.getY())) continue;
                this.mouseOverAlignmentView = v;
                break;
            }
        }
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.requestFocus();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int notches = e.getWheelRotation();
        if (notches < 0) {
            if (this.mouseOverAlignmentView != null) {
                this.mouseOverAlignmentView.setViewY(this.mouseOverAlignmentView.getViewY() + e.getScrollAmount() * this.gc.getVerticalAdvance());
            }
        } else if (this.mouseOverAlignmentView != null) {
            this.mouseOverAlignmentView.setViewY(this.mouseOverAlignmentView.getViewY() - e.getScrollAmount() * this.gc.getVerticalAdvance());
        }
    }

    public BufferedImage getImage() {
        BufferedImage bufferedImage = new BufferedImage(this.getSize().width, this.getSize().height, 13);
        Graphics2D g2 = bufferedImage.createGraphics();
        this.paintComponent(g2);
        g2.dispose();
        return bufferedImage;
    }

    void unselectAllSequences() {
        for (int i = 0; i < this.mainAlignment.getBiologicalSequenceCount(); ++i) {
            this.mainAlignment.getBiologicalSequenceAt(i).setSelected(false);
        }
        this.repaint();
    }

    void setMode(char mode) {
        this.mode = mode;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if ("standard".equals(event.getActionCommand())) {
            this.setMode('s');
            if (this.mediator != null) {
                this.mediator.getS2s().printState(event.getActionCommand());
            }
        } else if ("insert".equals(event.getActionCommand())) {
            this.setMode('i');
            if (this.mediator != null) {
                this.mediator.getS2s().printState(event.getActionCommand());
            }
        } else if ("delete".equals(event.getActionCommand())) {
            this.setMode('d');
            if (this.mediator != null) {
                this.mediator.getS2s().printState(event.getActionCommand());
            }
        } else if ("user-defined-interactions".equals(event.getActionCommand())) {
            this.setMode('u');
            this.firstUserDefinedInteractionX = -1;
            this.firstUserDefinedInteractionY = -1;
            if (this.mediator != null) {
                this.mediator.getS2s().printState(event.getActionCommand());
            }
        } else if ("move-view-right".equals(event.getActionCommand())) {
            if (this.selectedView != null) {
                this.selectedView.setViewX(this.getSelectedView().getViewX() + this.mediator.getHorizontalStep() * this.gc.getHorizontalAdvance());
                this.repaint();
            }
        } else if ("move-view-left".equals(event.getActionCommand())) {
            if (this.selectedView != null) {
                this.selectedView.setViewX(this.getSelectedView().getViewX() - this.mediator.getHorizontalStep() * this.gc.getHorizontalAdvance());
                this.repaint();
            }
        } else if ("move-residues-right".equals(event.getActionCommand())) {
            if (this.selectedView != null) {
                this.selectedView.moveResidues(true);
            }
        } else if ("move-residues-left".equals(event.getActionCommand()) && this.selectedView != null) {
            this.selectedView.moveResidues(false);
        }
    }

    public void clearSelectedPositions() {
        if (this.mainAlignment != null) {
            for (BiologicalSequence s : this.mainAlignment.getBiologicalSequences()) {
                s.clearSelectedPositions();
            }
            this.repaint();
        }
    }

    public Map<BiologicalSequence, List<Integer>> getSelectedPositions() {
        HashMap<BiologicalSequence, List<Integer>> selectedPositions = new HashMap<BiologicalSequence, List<Integer>>();
        if (this.getMainAlignment() != null) {
            for (BiologicalSequence s : this.getMainAlignment().getBiologicalSequences()) {
                selectedPositions.put(s, s.getSelectedPositions());
            }
        }
        return selectedPositions;
    }

    public void undo() {
        if (this.mainAlignment != null) {
            this.mainAlignment.undo(this.gc);
            this.repaint();
        }
    }

    public void redo() {
        if (this.mainAlignment != null) {
            this.mainAlignment.redo(this.gc);
            this.repaint();
        }
    }

    public void recalculateConservationScores() {
        if (this.mainAlignment != null) {
            this.mainAlignment.updateConservationScores();
            this.repaint();
        }
    }

    public void setMoleculeToCompare(Molecule molecule) {
        this.moleculeToCompare = molecule;
    }

    @Override
    public void residuesSelected(Collection<Residue> residues, boolean isShiftDown) {
        Iterator<Residue> it = residues.iterator();
        if (!isShiftDown) {
            this.clearSelectedPositions();
        }
        while (it.hasNext()) {
            Residue r = it.next();
            for (BiologicalSequence seq : this.mainAlignment.getBiologicalSequences()) {
                if (!((Object)seq.getMolecule()).equals(r.getMolecule())) continue;
                seq.addSelectedPosition(r.getAbsolutePosition());
                break;
            }
            this.repaint();
        }
    }

    public void fireResiduesSelected(Collection<Residue> residues, boolean isShiftDown) {
        for (SelectionListener l : this.selectionListeners) {
            l.residuesSelected(residues, isShiftDown);
        }
    }

    @Override
    public void structuralDomainSelected(StructuralDomain structuralDomain, boolean isShiftDown) {
        this.residuesSelected(structuralDomain.getResidues().getResidues(), isShiftDown);
    }

    public void fireStructuralDomainSelected(StructuralDomain structuralDomain, boolean isShiftDown) {
        for (SelectionListener l : this.selectionListeners) {
            l.structuralDomainSelected(structuralDomain, isShiftDown);
        }
    }

    @Override
    public void interactionSelected(BaseBaseInteraction interaction, boolean isShiftDown) {
        this.residuesSelected(Arrays.asList(interaction.getResidue(), interaction.getPartnerResidue()), isShiftDown);
    }

    public void fireInteractionSelected(BaseBaseInteraction interaction, boolean isShiftDown) {
        for (SelectionListener l : this.selectionListeners) {
            l.interactionSelected(interaction, isShiftDown);
        }
    }

    private class ColorMenu
    extends JMenu {
        private static final int SECONDARY_INTERACTIONS = 0;
        private static final int TERTIARY_INTERACTIONS = 2;
        private static final int ADENINE = 3;
        private static final int GUANINE = 4;
        private static final int CYTOSINE = 5;
        private static final int URACIL = 6;
        protected int mode;
        protected Border unselectedBorder;
        protected Border selectedBorder;
        protected Border activeBorder;
        protected Hashtable paneTable;
        protected ColorPane colorPane;

        public ColorMenu(String name, int mode) {
            super(name);
            this.mode = mode;
            this.unselectedBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, this.getBackground()), new BevelBorder(1, Color.white, Color.gray));
            this.selectedBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, Color.red), new MatteBorder(1, 1, 1, 1, this.getBackground()));
            this.activeBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, Color.blue), new MatteBorder(1, 1, 1, 1, this.getBackground()));
            JPanel p = new JPanel();
            p.setBorder(new EmptyBorder(5, 5, 5, 5));
            p.setLayout(new GridLayout(8, 8));
            this.paneTable = new Hashtable();
            int[] values = new int[]{0, 128, 192, 255};
            for (int r = 0; r < values.length; ++r) {
                for (int g = 0; g < values.length; ++g) {
                    for (int b = 0; b < values.length; ++b) {
                        Color c = new Color(values[r], values[g], values[b]);
                        ColorPane pn = new ColorPane(c);
                        p.add(pn);
                        this.paneTable.put(c, pn);
                    }
                }
            }
            this.add(p);
        }

        public void setColor(Color c) {
            Object obj = this.paneTable.get(c);
            if (obj == null) {
                return;
            }
            if (this.colorPane != null) {
                this.colorPane.setSelected(false);
            }
            this.colorPane = (ColorPane)obj;
            this.colorPane.setSelected(true);
        }

        public Color getColor() {
            if (this.colorPane == null) {
                return null;
            }
            return this.colorPane.getColor();
        }

        public void doSelection() {
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }

        private class ColorPane
        extends JPanel
        implements MouseListener {
            protected Color color;
            protected boolean isSelected;

            public ColorPane(Color c) {
                this.color = c;
                this.setBackground(c);
                this.setBorder(ColorMenu.this.unselectedBorder);
                String msg = "R " + c.getRed() + ", G " + c.getGreen() + ", B " + c.getBlue();
                this.setToolTipText(msg);
                this.addMouseListener(this);
            }

            public Color getColor() {
                return this.color;
            }

            public Dimension getPreferredSize() {
                return new Dimension(15, 15);
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public void setSelected(boolean selected) {
                this.isSelected = selected;
                if (this.isSelected) {
                    this.setBorder(ColorMenu.this.selectedBorder);
                } else {
                    this.setBorder(ColorMenu.this.unselectedBorder);
                }
            }

            public boolean isSelected() {
                return this.isSelected;
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                switch (ColorMenu.this.mode) {
                    case 0: {
                        SecondaryInteraction_Color = this.color;
                        AlignmentCanvas.this.repaint();
                        AlignmentCanvas.this.mediator.getRna2dViewer().getSecondaryCanvas().repaint();
                        break;
                    }
                    case 2: {
                        TertiaryInteraction_Color = this.color;
                        AlignmentCanvas.this.repaint();
                        AlignmentCanvas.this.mediator.getRna2dViewer().getSecondaryCanvas().repaint();
                        break;
                    }
                    case 3: {
                        A_Color = this.color;
                        AlignmentCanvas.this.repaint();
                        AlignmentCanvas.this.mediator.getRna2dViewer().getSecondaryCanvas().repaint();
                        break;
                    }
                    case 6: {
                        U_Color = this.color;
                        AlignmentCanvas.this.repaint();
                        AlignmentCanvas.this.mediator.getRna2dViewer().getSecondaryCanvas().repaint();
                        break;
                    }
                    case 4: {
                        G_Color = this.color;
                        AlignmentCanvas.this.repaint();
                        AlignmentCanvas.this.mediator.getRna2dViewer().getSecondaryCanvas().repaint();
                        break;
                    }
                    case 5: {
                        C_Color = this.color;
                        AlignmentCanvas.this.repaint();
                        AlignmentCanvas.this.mediator.getRna2dViewer().getSecondaryCanvas().repaint();
                    }
                }
            }

            public void mouseEntered(MouseEvent e) {
                this.setBorder(ColorMenu.this.activeBorder);
            }

            public void mouseExited(MouseEvent e) {
                this.setBorder(this.isSelected ? ColorMenu.this.selectedBorder : ColorMenu.this.unselectedBorder);
            }
        }
    }
}

