/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.rnalign.graphics;

import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.s2s.rnalign.features.Alignment;
import fr.unistra.ibmc.s2s.rnalign.features.BiologicalSequence;
import fr.unistra.ibmc.s2s.rnalign.features.DeletionStep;
import fr.unistra.ibmc.s2s.rnalign.features.InsertionStep;
import fr.unistra.ibmc.s2s.rnalign.features.MoveStep;
import fr.unistra.ibmc.s2s.rnalign.features.Structure2D3D;
import fr.unistra.ibmc.s2s.rnalign.features.Symbol;
import fr.unistra.ibmc.s2s.rnalign.features.SymbolSequence;
import fr.unistra.ibmc.s2s.rnalign.graphics.AlignmentCanvas;
import fr.unistra.ibmc.s2s.rnalign.graphics.GraphicContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignmentView {
    protected int viewX;
    protected int viewY;
    protected int currentX;
    protected int currentY;
    protected int leftMarge = 1;
    protected int topMarge = 1;
    protected int bottomMarge = 3;
    protected int firstPos = -1;
    protected int lastPos = -2;
    protected int firstSeq = -1;
    protected int lastSeq = -2;
    protected Rectangle drawingArea;
    protected Rectangle selectionBox;
    protected Residue mouseOverResidueFromRefSeq;
    protected SymbolSequence mouseOverSequence;
    protected int realPositionFromMouseOverSequence;
    protected int mouseOverPositionInAlignment = -1;
    protected AlignmentCanvas canvas;
    protected Alignment alignment;
    protected int numberOfSequencesToDisplay = 1;
    protected boolean selected;
    protected Map<Integer, Integer> currentColumnCoordinates;
    protected boolean displayCisWCWC = true;
    protected boolean displayTransWCWC = true;
    protected boolean displayCisHH = true;
    protected boolean displayTransHH = true;
    protected boolean displayCisSESE = true;
    protected boolean displayTransSESE = true;
    protected boolean displayCisHSE = true;
    protected boolean displayTransHSE = true;
    protected boolean displayCisHWC = true;
    protected boolean displayTransHWC = true;
    protected boolean displayCisSEWC = true;
    protected boolean displayTransSEWC = true;
    protected boolean displayTertiaryInteractions = true;
    protected boolean displaySecondaryInteractions = false;
    protected List<Integer> selectedPositionsToDrawInteractions;
    protected AlignmentView previousView;
    protected AlignmentView nextView;

    public AlignmentView(AlignmentCanvas canvas, Alignment alignment) {
        this.canvas = canvas;
        this.alignment = alignment;
        this.selectedPositionsToDrawInteractions = new ArrayList<Integer>();
        this.currentColumnCoordinates = new HashMap<Integer, Integer>();
    }

    public List<Integer> getSelectedPositionsToDrawInteractions() {
        return this.selectedPositionsToDrawInteractions;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public AlignmentView getNextView() {
        return this.nextView;
    }

    public boolean isLinkedToNextView() {
        return this.nextView != null;
    }

    public void setNextView(AlignmentView nextView) {
        this.nextView = nextView;
    }

    public void setNumberOfSequencesToDisplay(int nb) {
        this.numberOfSequencesToDisplay = nb;
        this.canvas.repaint();
    }

    public int getNumberOfSequencesToDisplay() {
        return this.numberOfSequencesToDisplay;
    }

    public int getLeftMarge() {
        return this.leftMarge;
    }

    public int getTopMarge() {
        return this.topMarge;
    }

    public int getBottomMarge() {
        return this.bottomMarge;
    }

    public int getFirstPos() {
        return this.firstPos;
    }

    public int getLastPos() {
        return this.lastPos;
    }

    public void setViewX(int viewX) {
        this.viewX = viewX;
        if (this.viewX < 0) {
            this.viewX = 0;
        }
        if (this.nextView != null) {
            this.nextView.setViewX(viewX);
        } else {
            this.canvas.repaint();
        }
    }

    public void setViewY(int viewY) {
        this.viewY = viewY;
        if (this.viewY < 0) {
            this.viewY = 0;
        }
        this.canvas.repaint();
    }

    public int getViewX() {
        return this.viewX;
    }

    public int getViewY() {
        return this.viewY;
    }

    public void moveViewOnLeft() {
        int width;
        if (this.firstPos == 0) {
            return;
        }
        int length = this.firstPos * this.canvas.gc.getVerticalAdvance();
        if (length < (width = (int)this.getDrawingArea().getWidth())) {
            this.viewX = 0;
        } else {
            this.viewX -= width;
            if (this.viewX < 0) {
                this.viewX = 0;
            }
        }
        if (this.nextView != null) {
            this.nextView.moveViewOnLeft();
        } else {
            this.canvas.repaint();
        }
    }

    public void moveViewOnRight() {
        int width;
        if (this.lastPos == this.alignment.getLength() - 1) {
            return;
        }
        int length = (this.alignment.getLength() - this.lastPos) * this.canvas.gc.getVerticalAdvance();
        this.viewX += length < (width = (int)this.getDrawingArea().getWidth()) ? length : width;
        if (this.nextView != null) {
            this.nextView.moveViewOnRight();
        } else {
            this.canvas.repaint();
        }
    }

    public void draw(Graphics2D g2, GraphicContext gc) {
        int j;
        SymbolSequence seq = null;
        Rectangle2D.Float r = null;
        boolean found = false;
        this.currentX = 0;
        this.currentY = 0;
        this.firstPos = -1;
        this.lastPos = -2;
        this.drawingArea = new Rectangle(gc.currentX, gc.currentY, gc.currentWidth, this.getHeight(gc));
        this.selectionBox = new Rectangle(gc.currentX - this.leftMarge * gc.getHorizontalAdvance(), gc.currentY - this.leftMarge * gc.getVerticalAdvance() / 4, this.leftMarge * gc.getVerticalAdvance() / 2, this.leftMarge * gc.getVerticalAdvance() / 2);
        if (this.selected) {
            g2.setColor(Color.RED);
        }
        if (this.alignment == this.canvas.getMainAlignment()) {
            g2.fillOval((int)this.selectionBox.getMinX(), (int)this.selectionBox.getMinY(), (int)this.selectionBox.getWidth(), (int)this.selectionBox.getHeight());
        } else {
            g2.fill(this.selectionBox);
        }
        g2.setColor(Color.BLACK);
        this.currentColumnCoordinates.clear();
        this.mouseOverResidueFromRefSeq = null;
        this.mouseOverSequence = null;
        this.mouseOverPositionInAlignment = -1;
        seq = this.alignment.getSequenceMeter();
        this.currentX = this.alignment.getMaxLabelSize() * gc.getHorizontalAdvance();
        this.currentY += gc.getVerticalAdvance();
        for (j = 0; j < seq.size(); ++j) {
            if (this.currentX - this.viewX < this.alignment.getMaxLabelSize() * gc.getHorizontalAdvance()) {
                this.currentX += gc.getHorizontalAdvance();
                continue;
            }
            if (this.drawingArea.getWidth() < (double)(this.currentX - this.viewX + gc.getHorizontalAdvance())) break;
            if (this.firstPos == -1) {
                this.firstPos = j;
            }
            this.lastPos = j;
            seq.drawSymbol(this.alignment, g2, this.currentX + gc.currentX, this.viewX, this.currentY + gc.getCurrentY(), this.viewY, gc, j);
            this.currentColumnCoordinates.put(j, this.currentX + gc.currentX - this.viewX + gc.getLetterWidth() / 2);
            if (!found && (r = new Rectangle2D.Float(this.currentX + gc.currentX - this.viewX, this.currentY + gc.getCurrentY() - gc.getLetterHeight() + (int)(0.25 * (double)gc.getLetterHeight()), gc.getLetterWidth(), gc.getLetterHeight())).contains(this.canvas.mouseX, this.canvas.mouseY)) {
                found = true;
                this.mouseOverSequence = seq;
                this.mouseOverPositionInAlignment = j;
                if (!this.alignment.getBiologicalReferenceSequence().isGap(j)) {
                    this.mouseOverResidueFromRefSeq = new Residue(this.alignment.getBiologicalReferenceSequence().getSymbol(j).getPositionInSequence(), this.alignment.getBiologicalReferenceSequence().getMolecule());
                }
            }
            this.currentX += gc.getHorizontalAdvance();
        }
        seq = this.alignment.getStructure2D3D();
        this.currentY += gc.getVerticalAdvance();
        this.currentX = 0;
        this.currentX = this.alignment.getMaxLabelSize() * gc.getHorizontalAdvance() + this.firstPos * gc.getHorizontalAdvance();
        for (j = this.firstPos; j <= this.lastPos; ++j) {
            ((Structure2D3D)seq).drawSymbol(this, this.alignment, g2, this.currentX + gc.currentX, this.viewX, this.currentY + gc.getCurrentY(), this.viewY, gc, j);
            if (!found && (r = new Rectangle2D.Float(this.currentX + gc.currentX - this.viewX, this.currentY + gc.getCurrentY() - gc.getLetterHeight() + (int)(0.25 * (double)gc.getLetterHeight()), gc.getLetterWidth(), gc.getLetterHeight())).contains(this.canvas.mouseX, this.canvas.mouseY)) {
                found = true;
                this.mouseOverSequence = seq;
                this.mouseOverPositionInAlignment = j;
                if (!this.alignment.getBiologicalReferenceSequence().isGap(j)) {
                    this.mouseOverResidueFromRefSeq = new Residue(this.alignment.getBiologicalReferenceSequence().getSymbol(j).getPositionInSequence(), this.alignment.getBiologicalReferenceSequence().getMolecule());
                }
            }
            this.currentX += gc.getHorizontalAdvance();
        }
        seq = this.alignment.getBiologicalSequenceAt(0);
        this.currentY += gc.getVerticalAdvance();
        this.currentX = 0;
        g2.drawString("S1", gc.currentX, gc.currentY + this.currentY);
        this.currentX = this.alignment.getMaxLabelSize() * gc.getHorizontalAdvance() + this.firstPos * gc.getHorizontalAdvance();
        for (j = this.firstPos; j <= this.lastPos; ++j) {
            seq.drawSymbol(this.alignment, g2, this.currentX + gc.currentX, this.viewX, this.currentY + gc.getCurrentY(), this.viewY, gc, j);
            if (!found && (r = new Rectangle2D.Float(this.currentX + gc.currentX - this.viewX, this.currentY + gc.getCurrentY() - gc.getLetterHeight() + (int)(0.25 * (double)gc.getLetterHeight()), gc.getLetterWidth(), gc.getLetterHeight())).contains(this.canvas.mouseX, this.canvas.mouseY)) {
                found = true;
                this.mouseOverSequence = seq;
                this.mouseOverPositionInAlignment = j;
                if (!this.alignment.getBiologicalReferenceSequence().isGap(j)) {
                    this.mouseOverResidueFromRefSeq = new Residue(this.alignment.getBiologicalReferenceSequence().getSymbol(j).getPositionInSequence(), this.alignment.getBiologicalReferenceSequence().getMolecule());
                    this.realPositionFromMouseOverSequence = this.mouseOverSequence.getSymbol(this.mouseOverPositionInAlignment).getPositionInSequence();
                }
            }
            this.currentX += gc.getHorizontalAdvance();
            this.firstSeq = 1;
            this.lastSeq = 1;
        }
        int totalSeq = this.alignment.getBiologicalSequenceCount();
        for (int i = 1; i < totalSeq; ++i) {
            seq = this.alignment.getBiologicalSequenceAt(i);
            this.currentY += gc.getVerticalAdvance();
            if (this.currentY - this.viewY < 4 * gc.getVerticalAdvance()) continue;
            if ((this.numberOfSequencesToDisplay + 2) * gc.getVerticalAdvance() < this.currentY - this.viewY) break;
            if (this.firstSeq == 1) {
                this.firstSeq = i;
            }
            this.lastSeq = i;
            this.currentX = 0;
            g2.drawString("S" + (i + 1), gc.currentX, gc.currentY + this.currentY - this.viewY);
            this.currentX = this.alignment.getMaxLabelSize() * gc.getHorizontalAdvance() + this.firstPos * gc.getHorizontalAdvance();
            for (int j2 = this.firstPos; j2 <= this.lastPos; ++j2) {
                seq.drawSymbol(this.alignment, g2, this.currentX + gc.currentX, this.viewX, this.currentY + gc.getCurrentY(), this.viewY, gc, j2);
                if (!found && (r = new Rectangle2D.Float(this.currentX + gc.currentX - this.viewX, this.currentY + gc.getCurrentY() - this.viewY - gc.getLetterHeight() + (int)(0.25 * (double)gc.getLetterHeight()), gc.getLetterWidth(), gc.getLetterHeight())).contains(this.canvas.mouseX, this.canvas.mouseY)) {
                    found = true;
                    this.mouseOverSequence = seq;
                    this.mouseOverPositionInAlignment = j2;
                    if (!this.alignment.getBiologicalReferenceSequence().isGap(j2)) {
                        this.mouseOverResidueFromRefSeq = new Residue(this.alignment.getBiologicalReferenceSequence().getSymbol(j2).getPositionInSequence(), this.alignment.getBiologicalReferenceSequence().getMolecule());
                        this.realPositionFromMouseOverSequence = this.mouseOverSequence.getSymbol(this.mouseOverPositionInAlignment).getPositionInSequence();
                    }
                }
                this.currentX += gc.getHorizontalAdvance();
            }
        }
        gc.currentY += this.getHeight(gc);
    }

    public int getCurrentColumnCoordinate(int column) {
        return this.currentColumnCoordinates.get(column);
    }

    public int getHeight(GraphicContext gc) {
        return (this.numberOfSequencesToDisplay + 2) * gc.getVerticalAdvance();
    }

    public boolean contains(int x, int y) {
        if (this.drawingArea == null) {
            return false;
        }
        return this.drawingArea.contains(x, y);
    }

    public void mouseDragged(MouseEvent e) {
        this.translateViewX(this.canvas.pressedX - e.getX());
        this.canvas.pressedX = e.getX();
        this.canvas.pressedY = e.getY();
    }

    public void moveResidues(boolean right) {
        if (this.selected) {
            for (BiologicalSequence seq : this.canvas.getMainAlignment().getBiologicalSequences()) {
                if (!seq.hasSelectedPositions()) continue;
                for (int i = this.firstPos; i <= this.lastPos; ++i) {
                    MoveStep step;
                    int currentPosition;
                    if (!seq.isSelectedPosition(seq.getSymbol(i).getPositionInSequence())) continue;
                    int start = i;
                    if (right) {
                        for (currentPosition = i; currentPosition < this.canvas.getMainAlignment().getLength() && (seq.getSymbol(currentPosition) != Symbol.Gap || seq.getSymbol(currentPosition).isLocked()); ++currentPosition) {
                        }
                        if (currentPosition < this.canvas.getMainAlignment().getLength()) {
                            step = new MoveStep();
                            seq.removeGap(currentPosition);
                            seq.insertGap(start);
                            step.add(seq, start, currentPosition);
                            if (this.alignment.getBiologicalReferenceSequence() == seq) {
                                this.canvas.getMainAlignment().getStructure2D3D().removeGap(currentPosition);
                                this.canvas.getMainAlignment().getStructure2D3D().insertGap(start);
                                step.add(this.canvas.getMainAlignment().getStructure2D3D(), start, currentPosition);
                            }
                            this.canvas.getMainAlignment().addStep(step);
                            this.canvas.getMainAlignment().updateConservationScores(start, currentPosition);
                            this.canvas.repaint();
                        }
                        i += currentPosition;
                        continue;
                    }
                    while (currentPosition >= 0 && (seq.getSymbol(currentPosition) != Symbol.Gap || seq.getSymbol(currentPosition).isLocked())) {
                        --currentPosition;
                    }
                    if (currentPosition < 0) continue;
                    step = new MoveStep();
                    seq.removeGap(currentPosition);
                    seq.insertGap(start);
                    step.add(seq, start, currentPosition);
                    if (this.alignment.getBiologicalReferenceSequence() == seq) {
                        this.canvas.getMainAlignment().getStructure2D3D().removeGap(currentPosition);
                        this.canvas.getMainAlignment().getStructure2D3D().insertGap(start);
                        step.add(this.canvas.getMainAlignment().getStructure2D3D(), currentPosition, start);
                    }
                    this.canvas.getMainAlignment().addStep(step);
                    this.canvas.getMainAlignment().updateConservationScores(currentPosition, start);
                    this.canvas.repaint();
                }
            }
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        block20: {
            block25: {
                int posInSequence;
                block24: {
                    Symbol b;
                    block21: {
                        int i;
                        block23: {
                            block22: {
                                block18: {
                                    int i2;
                                    block19: {
                                        if (this.alignment.getSequenceMeter() != this.mouseOverSequence) break block18;
                                        if (this.canvas.mode != 'i') break block19;
                                        for (int i3 = 0; i3 < this.alignment.getSymbolSequenceCount(); ++i3) {
                                            this.alignment.getLetterSequenceAt(i3).insertGap(this.mouseOverPositionInAlignment);
                                        }
                                        this.alignment.addStep(new InsertionStep(this.mouseOverPositionInAlignment));
                                        break block20;
                                    }
                                    if (this.canvas.mode != 'd') break block20;
                                    for (i2 = 0; i2 < this.alignment.getSymbolSequenceCount(); ++i2) {
                                        if (this.alignment.getLetterSequenceAt(i2).isGap(this.mouseOverPositionInAlignment)) continue;
                                        return;
                                    }
                                    for (i2 = 0; i2 < this.alignment.getSymbolSequenceCount(); ++i2) {
                                        this.alignment.getLetterSequenceAt(i2).removeGap(this.mouseOverPositionInAlignment);
                                    }
                                    this.alignment.addStep(new DeletionStep(this.mouseOverPositionInAlignment));
                                    break block20;
                                }
                                if (this.alignment.getStructure2D3D() != this.mouseOverSequence) break block21;
                                Symbol b2 = this.mouseOverSequence.getSymbol(this.mouseOverPositionInAlignment);
                                if (!e.isShiftDown()) break block22;
                                b2.nextLetter();
                                if (b2.getSymbol() != '-') {
                                    this.alignment.getBiologicalReferenceSequence().setSymbolAt(Symbol.LockedGap, this.mouseOverPositionInAlignment);
                                } else {
                                    this.alignment.getBiologicalReferenceSequence().setSymbolAt(Symbol.Gap, this.mouseOverPositionInAlignment);
                                }
                                break block20;
                            }
                            if (this.canvas.mode != 'i') break block23;
                            for (int i4 = 0; i4 < this.alignment.getSymbolSequenceCount(); ++i4) {
                                this.alignment.getLetterSequenceAt(i4).insertGap(this.mouseOverPositionInAlignment);
                            }
                            this.alignment.addStep(new InsertionStep(this.mouseOverPositionInAlignment));
                            break block20;
                        }
                        if (this.canvas.mode != 'd') break block20;
                        for (i = 0; i < this.alignment.getSymbolSequenceCount(); ++i) {
                            if (this.alignment.getLetterSequenceAt(i).isGap(this.mouseOverPositionInAlignment)) continue;
                            return;
                        }
                        for (i = 0; i < this.alignment.getSymbolSequenceCount(); ++i) {
                            this.alignment.getLetterSequenceAt(i).removeGap(this.mouseOverPositionInAlignment);
                        }
                        this.alignment.addStep(new DeletionStep(this.mouseOverPositionInAlignment));
                        break block20;
                    }
                    if (this.mouseOverSequence == null || (b = this.mouseOverSequence.getSymbol(this.mouseOverPositionInAlignment)).isGap()) break block20;
                    ArrayList<Residue> residues = new ArrayList<Residue>();
                    posInSequence = b.getPositionInSequence();
                    if (!e.isShiftDown()) {
                        this.canvas.clearSelectedPositions();
                    }
                    if (this.alignment.getBiologicalReferenceSequence() != this.mouseOverSequence) break block24;
                    switch (this.canvas.mediator.getSelectionMode()) {
                        case 0: {
                            StructuralDomain domain = this.canvas.getMainAlignment().getReferenceStructure().getEnclosingStructuralDomain(new Residue(posInSequence, ((BiologicalSequence)this.mouseOverSequence).getMolecule()));
                            for (Residue r : domain.getResidues().getResidues()) {
                                residues.add(new Residue(r.getAbsolutePosition(), ((BiologicalSequence)this.mouseOverSequence).getMolecule()));
                                ((BiologicalSequence)this.mouseOverSequence).addSelectedPosition(r.getAbsolutePosition());
                            }
                            this.canvas.fireStructuralDomainSelected(domain, e.isShiftDown());
                            break;
                        }
                        case 1: {
                            Residue r = new Residue(posInSequence, ((BiologicalSequence)this.mouseOverSequence).getMolecule());
                            for (BaseBaseInteraction bbi : this.canvas.getMainAlignment().getReferenceStructure().getBaseBaseInteractions()) {
                                if (!bbi.getResidue().equals(r) && !bbi.getPartnerResidue().equals(r)) continue;
                                residues.add(bbi.getResidue());
                                residues.add(bbi.getPartnerResidue());
                                ((BiologicalSequence)this.mouseOverSequence).addSelectedPosition(bbi.getResidue().getAbsolutePosition());
                                ((BiologicalSequence)this.mouseOverSequence).addSelectedPosition(bbi.getPartnerResidue().getAbsolutePosition());
                                this.canvas.fireInteractionSelected(bbi, e.isShiftDown());
                            }
                            break block25;
                        }
                        case 2: {
                            Residue _r = new Residue(posInSequence, ((BiologicalSequence)this.mouseOverSequence).getMolecule());
                            residues.add(_r);
                            ((BiologicalSequence)this.mouseOverSequence).addSelectedPosition(posInSequence);
                            this.canvas.fireResiduesSelected(Arrays.asList(_r), e.isShiftDown());
                        }
                    }
                    break block25;
                }
                ((BiologicalSequence)this.mouseOverSequence).addSelectedPosition(posInSequence);
            }
            if (e.isShiftDown()) {
                for (int i = posInSequence - 1; i > 0 && !((BiologicalSequence)this.mouseOverSequence).isSelectedPosition(i); --i) {
                    ((BiologicalSequence)this.mouseOverSequence).addSelectedPosition(i);
                }
            }
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    void translateViewX(int transX) {
        this.viewX += transX;
        if (this.viewX < 0) {
            this.viewX = 0;
        }
        if (this.nextView != null) {
            this.nextView.translateViewX(transX);
        }
    }

    void translateViewY(int transY) {
        this.viewY += transY;
        if (this.viewY < 0) {
            this.viewY = 0;
        }
    }

    public Rectangle getDrawingArea() {
        return this.drawingArea;
    }

    public void setDisplayCisWCWC(Boolean display) {
        this.displayCisWCWC = display;
        this.canvas.repaint();
    }

    public boolean isDisplayCisWCWC() {
        return this.displayCisWCWC;
    }

    public void setDisplayTransWCWC(Boolean display) {
        this.displayTransWCWC = display;
        this.canvas.repaint();
    }

    public boolean isDisplayTransWCWC() {
        return this.displayTransWCWC;
    }

    public boolean isDisplayCisHH() {
        return this.displayCisHH;
    }

    public void setDisplayCisHH(Boolean displayCisHH) {
        this.displayCisHH = displayCisHH;
        this.canvas.repaint();
    }

    public boolean isDisplayTransHH() {
        return this.displayTransHH;
    }

    public void setDisplayTransHH(Boolean displayTransHH) {
        this.displayTransHH = displayTransHH;
        this.canvas.repaint();
    }

    public boolean isDisplayCisHSE() {
        return this.displayCisHSE;
    }

    public void setDisplayCisHSE(Boolean displayCisHSE) {
        this.displayCisHSE = displayCisHSE;
        this.canvas.repaint();
    }

    public boolean isDisplayTransHSE() {
        return this.displayTransHSE;
    }

    public void setDisplayTransHSE(Boolean displayTransHSE) {
        this.displayTransHSE = displayTransHSE;
        this.canvas.repaint();
    }

    public boolean isDisplayCisHWC() {
        return this.displayCisHWC;
    }

    public void setDisplayCisHWC(Boolean displayCisHWC) {
        this.displayCisHWC = displayCisHWC;
        this.canvas.repaint();
    }

    public boolean isDisplayTransHWC() {
        return this.displayTransHWC;
    }

    public void setDisplayTransHWC(Boolean displayTransHWC) {
        this.displayTransHWC = displayTransHWC;
        this.canvas.repaint();
    }

    public boolean isDisplayCisSESE() {
        return this.displayCisSESE;
    }

    public void setDisplayCisSESE(Boolean displayCisSESE) {
        this.displayCisSESE = displayCisSESE;
        this.canvas.repaint();
    }

    public boolean isDisplayTransSESE() {
        return this.displayTransSESE;
    }

    public void setDisplayTransSESE(Boolean displayTransSESE) {
        this.displayTransSESE = displayTransSESE;
        this.canvas.repaint();
    }

    public boolean isDisplayCisSEWC() {
        return this.displayCisSEWC;
    }

    public void setDisplayCisSEWC(Boolean displayCisSEWC) {
        this.displayCisSEWC = displayCisSEWC;
        this.canvas.repaint();
    }

    public boolean isDisplayTransSEWC() {
        return this.displayTransSEWC;
    }

    public void setDisplayTransSEWC(Boolean displayTransSEWC) {
        this.displayTransSEWC = displayTransSEWC;
        this.canvas.repaint();
    }

    public boolean isDisplayTertiaryInteractions() {
        return this.displayTertiaryInteractions;
    }

    public void setDisplayTertiaryInteractions(Boolean displayTertiaryInteractions) {
        this.displayTertiaryInteractions = displayTertiaryInteractions;
        this.canvas.repaint();
    }

    public boolean isDisplaySecondaryInteractions() {
        return this.displaySecondaryInteractions;
    }

    public void setDisplaySecondaryInteractions(Boolean displaySecondaryInteractions) {
        this.displaySecondaryInteractions = displaySecondaryInteractions;
        this.canvas.repaint();
    }

    public void setDisplayAllFamilies(Boolean displayAllFamilies) {
        this.displayCisHH = displayAllFamilies;
        this.displayCisHSE = displayAllFamilies;
        this.displayCisHWC = displayAllFamilies;
        this.displayCisSESE = displayAllFamilies;
        this.displayCisSEWC = displayAllFamilies;
        this.displayCisWCWC = displayAllFamilies;
        this.displayTransHH = displayAllFamilies;
        this.displayTransHSE = displayAllFamilies;
        this.displayTransHWC = displayAllFamilies;
        this.displayTransSESE = displayAllFamilies;
        this.displayTransSEWC = displayAllFamilies;
        this.displayTransWCWC = displayAllFamilies;
        this.canvas.repaint();
    }
}

