/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.rnalign.graphics;

import fr.unistra.ibmc.paradise.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.tools.ParadiseWorkingSession;
import fr.unistra.ibmc.s2s.Mediator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;

public class SequencesList
extends JXTable
implements MouseListener,
DragSourceListener,
DropTargetListener,
DragGestureListener {
    private Mediator mediator;
    private ParadiseWorkingSession workingSession;
    private DefaultTableModel model;
    private JPopupMenu popupMenu;
    private DragSource dragSource;
    private DropTarget dropTarget;
    private int startIndex = -1;
    private int overIndex = -1;
    private static DataFlavor localObjectFlavor;
    private DataFlavor[] supportedFlavors = new DataFlavor[]{localObjectFlavor};

    public SequencesList(final Mediator mediator, ParadiseWorkingSession workingSession) {
        this.setSelectionMode(2);
        this.setSortable(false);
        this.dragSource = new DragSource();
        DragGestureRecognizer dgr = this.dragSource.createDefaultDragGestureRecognizer((Component)((Object)this), 2, this);
        this.dropTarget = new DropTarget((Component)((Object)this), this);
        this.mediator = mediator;
        this.workingSession = workingSession;
        this.model = new DefaultTableModel();
        this.model.addColumn("Label");
        this.model.addColumn("Sequence Name");
        this.addMouseListener(this);
        this.setModel(this.model);
        this.popupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Create new molecules from selection");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (int i : SequencesList.this.getSelectedRows()) {
                    List<Integer> selectedPositions = mediator.getAlignmentCanvas().getMainAlignment().getBiologicalSequenceAt(i).getSelectedPositions();
                    StringBuffer newSequence = null;
                    int previousPos = -1;
                    for (int pos : selectedPositions) {
                        if (pos - 1 != previousPos) {
                            if (newSequence != null) {
                                try {
                                    mediator.getS2s().getWorkingSession().createRNA(new ParadiseID(), mediator.getAlignmentCanvas().getMainAlignment().getBiologicalSequenceAt(i).getMolecule().getName(), Source.getGraphicalToolAsSource(mediator.getS2s().getDescription()), newSequence.toString());
                                }
                                catch (BiologicalSymbolException e1) {
                                    e1.printStackTrace();
                                }
                            }
                            newSequence = new StringBuffer();
                        }
                        newSequence.append(mediator.getAlignmentCanvas().getMainAlignment().getBiologicalSequenceAt(i).getMolecule().getResidueAt(pos));
                        previousPos = pos;
                    }
                    if (newSequence == null) continue;
                    try {
                        mediator.getS2s().getWorkingSession().createRNA(new ParadiseID(), mediator.getAlignmentCanvas().getMainAlignment().getBiologicalSequenceAt(i).getMolecule().getName(), Source.getGraphicalToolAsSource(mediator.getS2s().getDescription()), newSequence.toString());
                    }
                    catch (BiologicalSymbolException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        menuItem = new JMenuItem("Remove selected sequences");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int numRows = SequencesList.this.getRowCount();
                for (int i = numRows - 1; i >= 1; --i) {
                    if (!SequencesList.this.isCellSelected(i, 1)) continue;
                    mediator.getAlignmentCanvas().removeBiologicalSequenceAt(i);
                    SequencesList.this.model.removeRow(i);
                }
            }
        });
        this.popupMenu.add(menuItem);
        menuItem = new JMenuItem("Search motif");
        menuItem.addActionListener(new ActionListener(){
            private String lastMotif = "";

            public void actionPerformed(ActionEvent e) {
                String motif = JOptionPane.showInputDialog("Enter your motif", (Object)this.lastMotif);
                if (motif != null && motif.length() != 0) {
                    for (int i : SequencesList.this.getSelectedRows()) {
                        mediator.getAlignmentCanvas().getMainAlignment().getBiologicalSequenceAt(i).clearSelectedPositions();
                        mediator.getAlignmentCanvas().getMainAlignment().getBiologicalSequenceAt(i).searchFor(motif);
                    }
                    mediator.getAlignmentCanvas().repaint();
                    this.lastMotif = motif;
                }
            }
        });
        this.popupMenu.add(menuItem);
        menuItem = new JMenuItem("Show diff");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < SequencesList.this.getRowCount(); ++i) {
                    if (!SequencesList.this.isCellSelected(i, 1)) continue;
                    mediator.getAlignmentCanvas().setMoleculeToCompare(mediator.getMoleculeAt(i));
                    mediator.getAlignmentCanvas().repaint();
                    break;
                }
            }
        });
    }

    public void addRow(Molecule m) {
        this.model.addRow(new Object[]{"", m.getName()});
    }

    public void clearList() {
        int size = this.model.getRowCount();
        for (int i = 0; i < size; ++i) {
            this.model.removeRow(0);
        }
    }

    public boolean isCellEditable(int row, int column) {
        return column == 1;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        if (row == this.overIndex && column == 1) {
            return new ReorderTableRenderer();
        }
        if (column == 0) {
            return new FirstColumnTableRenderer();
        }
        return super.getCellRenderer(row, column);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (dtde.getSource() != this.dropTarget) {
            dtde.rejectDrag();
        } else {
            dtde.acceptDrag(2);
        }
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (dtde.getSource() != this.dropTarget) {
            dtde.rejectDrag();
        } else {
            Point dragPoint = dtde.getLocation();
            int index = this.rowAtPoint(dragPoint);
            if (index == -1 || index == 0) {
                return;
            }
            this.overIndex = index;
            this.repaint();
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        if (dtde.getSource() != this.dropTarget) {
            dtde.rejectDrop();
        } else {
            if (this.overIndex == -1 || this.overIndex == 0 || this.overIndex == this.startIndex) {
                return;
            }
            dtde.acceptDrop(2);
            this.model.moveRow(this.startIndex, this.startIndex, this.overIndex);
            this.mediator.getAlignmentCanvas().getMainAlignment().moveSequence(this.overIndex, this.mediator.getAlignmentCanvas().getMainAlignment().getBiologicalSequenceAt(this.startIndex));
            this.mediator.getAlignmentCanvas().repaint();
        }
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        Point clickPoint = dge.getDragOrigin();
        int index = this.rowAtPoint(clickPoint);
        if (index == -1 || index == 0) {
            return;
        }
        this.startIndex = index;
        this.dragSource.startDrag(dge, Cursor.getDefaultCursor(), new MyTransferable(null), this);
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.startIndex = -1;
        this.overIndex = -1;
        this.repaint();
    }

    static {
        try {
            localObjectFlavor = new DataFlavor("application/x-java-jvm-local-objectref");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private class FirstColumnTableRenderer
    extends JLabel
    implements TableCellRenderer {
        private FirstColumnTableRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText("S" + (row + 1));
            return this;
        }
    }

    private class ReorderTableRenderer
    extends JLabel
    implements TableCellRenderer {
        public ReorderTableRenderer() {
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this;
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(Color.BLACK);
            g.drawLine(0, 0, this.getSize().width, 0);
        }
    }

    private class MyTransferable
    implements Transferable {
        private Object object;

        private MyTransferable(Object object) {
            this.object = object;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return SequencesList.this.supportedFlavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(localObjectFlavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(flavor)) {
                return this.object;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

