/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.rnalign.utils;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class DrawingUtils {
    public static final Color[] colors = new Color[]{new Color(0, 0, 255), new Color(210, 105, 30), new Color(0, 255, 255), new Color(135, 206, 235), new Color(165, 42, 42), new Color(255, 0, 255), new Color(238, 130, 238), new Color(64, 224, 208), new Color(255, 127, 80), new Color(192, 192, 192), new Color(255, 0, 255), new Color(218, 112, 214), new Color(144, 238, 144), new Color(160, 32, 240), new Color(255, 0, 0), new Color(0, 255, 0), Color.PINK};

    public static Color getIndexedColor(int index) {
        int cursor = 0;
        int i = 0;
        while (true) {
            if (i < colors.length) {
                if (cursor == index) {
                    return colors[i];
                }
                ++i;
                ++cursor;
                continue;
            }
            i = 0;
        }
    }

    public static double getDistance(double x1, double y1, double x2, double y2) {
        double horizontal = x1 - x2;
        double vertical = y1 - y2;
        return Math.sqrt(horizontal * horizontal + vertical * vertical);
    }

    public static Point2D[] fit(double x1, double y1, double x2, double y2, double distance) {
        double newy1;
        double newy2;
        double newx1;
        double newx2;
        Point2D[] drawingPoints = new Point2D[2];
        double angle = DrawingUtils.getAngle(DrawingUtils.getDistance(x1, y1, x1, y2), DrawingUtils.getDistance(x1, y2, x2, y2));
        if (x1 >= x2) {
            newx2 = x2 + DrawingUtils.getAdjacentSide(angle, distance);
            newx1 = x1 - DrawingUtils.getAdjacentSide(angle, distance);
        } else {
            newx2 = x2 - DrawingUtils.getAdjacentSide(angle, distance);
            newx1 = x1 + DrawingUtils.getAdjacentSide(angle, distance);
        }
        if (y1 >= y2) {
            newy2 = y2 + DrawingUtils.getOppositeSide(angle, distance);
            newy1 = y1 - DrawingUtils.getOppositeSide(angle, distance);
        } else {
            newy2 = y2 - DrawingUtils.getOppositeSide(angle, distance);
            newy1 = y1 + DrawingUtils.getOppositeSide(angle, distance);
        }
        drawingPoints[0] = new Point2D.Double(newx1, newy1);
        drawingPoints[1] = new Point2D.Double(newx2, newy2);
        return drawingPoints;
    }

    public static double getAdjacentSide(double angle, double hypothenuse) {
        return Math.cos(angle) * hypothenuse;
    }

    public static double getAngle(double oppositeSide, double adjacentSide) {
        return Math.atan(oppositeSide / adjacentSide);
    }

    public static double getOppositeSide(double angle, double hypothenuse) {
        return Math.sin(angle) * hypothenuse;
    }

    public static Point2D[] getPerpendicular(Point2D p0, Point2D p1, Point2D p2, double distance) {
        Point2D[] pp = new Point2D[]{(Point2D)p0.clone(), (Point2D)p0.clone()};
        double angle = DrawingUtils.getAngle(p1.getY() - p2.getY(), p1.getX() - p2.getX());
        pp[0].setLocation(pp[0].getX() + DrawingUtils.getOppositeSide(angle, distance), pp[0].getY() - DrawingUtils.getAdjacentSide(angle, distance));
        pp[1].setLocation(pp[1].getX() - DrawingUtils.getOppositeSide(angle, distance), pp[1].getY() + DrawingUtils.getAdjacentSide(angle, distance));
        return pp;
    }

    public static Point2D getRotatedPoint(Point2D p, double a, Point2D c) {
        if (a != 0.0) {
            AffineTransform rot = new AffineTransform();
            rot.setToRotation(a, c.getX(), c.getY());
            Point2D pointRot = rot.transform(p, null);
            return new Point2D.Double(pointRot.getX(), pointRot.getY());
        }
        return p;
    }
}

