/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.ssviewer.features;

import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.s2s.Mediator;
import fr.unistra.ibmc.s2s.rnalign.graphics.AlignmentCanvas;
import fr.unistra.ibmc.s2s.ssviewer.features.AUWC;
import fr.unistra.ibmc.s2s.ssviewer.features.GCWC;
import fr.unistra.ibmc.s2s.ssviewer.features.HH;
import fr.unistra.ibmc.s2s.ssviewer.features.HSE;
import fr.unistra.ibmc.s2s.ssviewer.features.HWC;
import fr.unistra.ibmc.s2s.ssviewer.features.Interaction2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Line;
import fr.unistra.ibmc.s2s.ssviewer.features.Residue2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Residues2DRepository;
import fr.unistra.ibmc.s2s.ssviewer.features.SEH;
import fr.unistra.ibmc.s2s.ssviewer.features.SESE;
import fr.unistra.ibmc.s2s.ssviewer.features.SEWC;
import fr.unistra.ibmc.s2s.ssviewer.features.Unknown;
import fr.unistra.ibmc.s2s.ssviewer.features.WCH;
import fr.unistra.ibmc.s2s.ssviewer.features.WCSE;
import fr.unistra.ibmc.s2s.ssviewer.features.WCWC;
import fr.unistra.ibmc.s2s.ssviewer.features.Wobble;
import fr.unistra.ibmc.s2s.ssviewer.graphics.GraphicContext;
import fr.unistra.ibmc.s2s.ssviewer.utils.DrawingUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public abstract class BaseBaseInteraction2D
extends Interaction2D {
    protected BaseBaseInteraction interaction;

    public static BaseBaseInteraction2D getInteraction(BaseBaseInteraction i, Residues2DRepository repository, Mediator mediator, GraphicContext gc) {
        if (i.getFamily().equals("CWW")) {
            Residue b = i.getResidue();
            Residue partnerBase = i.getPartnerResidue();
            if (b != null && partnerBase != null && (b.getSymbol() == 'G' && partnerBase.getSymbol() == 'U' || b.getSymbol() == 'U' && partnerBase.getSymbol() == 'G')) {
                return new Wobble(i, repository, mediator, gc);
            }
            if (b != null && partnerBase != null && (b.getSymbol() == 'A' && partnerBase.getSymbol() == 'U' || b.getSymbol() == 'U' && partnerBase.getSymbol() == 'A')) {
                return new AUWC(i, repository, mediator, gc);
            }
            if (b != null && partnerBase != null && (b.getSymbol() == 'G' && partnerBase.getSymbol() == 'C' || b.getSymbol() == 'C' && partnerBase.getSymbol() == 'G')) {
                return new GCWC(i, repository, mediator, gc);
            }
            return new WCWC(i, repository, mediator, gc);
        }
        if (i.getFamily().equals("TWW")) {
            return new WCWC(i, repository, mediator, gc);
        }
        if (i.getFamily().equals("CHH")) {
            return new HH(i, repository, mediator, gc);
        }
        if (i.getFamily().equals("THH")) {
            return new HH(i, repository, mediator, gc);
        }
        if (i.getFamily().equals("CSs")) {
            return new SESE(i, repository, 'S', 's', mediator, gc);
        }
        if (i.getFamily().equals("TSs")) {
            return new SESE(i, repository, 'S', 's', mediator, gc);
        }
        if (i.getFamily().equals("CsS")) {
            return new SESE(i, repository, 's', 'S', mediator, gc);
        }
        if (i.getFamily().equals("TsS")) {
            return new SESE(i, repository, 's', 'S', mediator, gc);
        }
        if (i.getFamily().equals("CSS")) {
            return new SESE(i, repository, 'S', 'S', mediator, gc);
        }
        if (i.getFamily().equals("TSS")) {
            return new SESE(i, repository, 'S', 'S', mediator, gc);
        }
        if (i.getFamily().equals("CWH")) {
            return new WCH(i, repository, mediator, gc);
        }
        if (i.getFamily().equals("CHW")) {
            return new HWC(i, repository, mediator, gc);
        }
        if (i.getFamily().equals("TWH")) {
            return new WCH(i, repository, mediator, gc);
        }
        if (i.getFamily().equals("THW")) {
            return new HWC(i, repository, mediator, gc);
        }
        if (i.getFamily().equals("CHS")) {
            return new HSE(i, repository, mediator, gc);
        }
        if (i.getFamily().equals("CSH")) {
            return new SEH(i, repository, mediator, gc);
        }
        if (i.getFamily().equals("THS")) {
            return new HSE(i, repository, mediator, gc);
        }
        if (i.getFamily().equals("TSH")) {
            return new SEH(i, repository, mediator, gc);
        }
        if (i.getFamily().equals("CWS")) {
            return new WCSE(i, repository, mediator, gc);
        }
        if (i.getFamily().equals("CSW")) {
            return new SEWC(i, repository, mediator, gc);
        }
        if (i.getFamily().equals("TWS")) {
            return new WCSE(i, repository, mediator, gc);
        }
        if (i.getFamily().equals("TSW")) {
            return new SEWC(i, repository, mediator, gc);
        }
        System.out.println("Unknow interaction found : " + i.getFamily());
        return new Unknown(i, repository, mediator, gc);
    }

    BaseBaseInteraction2D(BaseBaseInteraction interaction, Residues2DRepository repository, Mediator mediator, GraphicContext gc) {
        super(repository, interaction.getResidue(), interaction.getPartnerResidue(), mediator, gc);
        this.interaction = interaction;
        this.defaultSymbol = new Interaction2D.SymbolsArray(this);
        this.realSymbol = new Interaction2D.SymbolsArray(this);
        this.color = interaction.isSecondaryInteraction() ? Interaction2D.DEFAULT_SECONDARY_INTERACTION_COLOR : Interaction2D.DEFAULT_TERTIARY_INTERACTION_COLOR;
        this.updated = true;
        this.getResidue().addInteraction(this);
        this.getPartnerResidue().addInteraction(this);
    }

    public boolean isDisplayed() {
        if (this.interaction.isSecondaryInteraction()) {
            return super.isDisplayed();
        }
        return this.gc.containFamily(this.interaction.getFamily()) && super.isDisplayed();
    }

    public BaseBaseInteraction getBaseBaseInteractionFeature() {
        return this.interaction;
    }

    public boolean isTemporaryDisplayed() {
        return this.gc.containFamily(this.interaction.getFamily());
    }

    public void draw(Graphics2D g2) {
        block9: {
            Interaction2D.SymbolsArray.Iterator sc;
            block10: {
                if (this.interaction.getResidue() == null || this.interaction.getPartnerResidue() == null || !this.interaction.isSecondaryInteraction() && !this.gc.isTertiaryInteractionsDisplayed() || !this.isDisplayed() || !this.isInsideDrawingArea()) break block9;
                if (this.updated) {
                    this.setOutsidePoints();
                    this.updated = false;
                }
                if (this.real_op != null) {
                    this.op = new Point2D[2];
                    this.op[0] = new Point2D.Double(this.real_op[0].getX() * this.gc.getFinalZoomLevel() + this.gc.getViewX(), this.real_op[0].getY() * this.gc.getFinalZoomLevel() + this.gc.getViewY());
                    this.op[1] = new Point2D.Double(this.real_op[1].getX() * this.gc.getFinalZoomLevel() + this.gc.getViewX(), this.real_op[1].getY() * this.gc.getFinalZoomLevel() + this.gc.getViewY());
                } else {
                    this.op = null;
                }
                if (this.isSelected()) {
                    g2.setColor(Color.red);
                } else if (this.interaction.isSecondaryInteraction()) {
                    g2.setColor(AlignmentCanvas.SecondaryInteraction_Color);
                } else {
                    g2.setColor(AlignmentCanvas.TertiaryInteraction_Color);
                }
                sc = null;
                if (!this.drawRealSymbol() && !this.gc.containFamily(this.interaction.getFamily()) || this.getRealSymbol() == null) break block10;
                this.setRealSymbol();
                sc = this.getRealSymbol().iterator();
                while (sc.hasNext()) {
                    sc.next().draw(g2);
                }
                break block9;
            }
            if (this.drawRealSymbol() || this.getDefaultSymbol() == null) break block9;
            this.setDefaultSymbol();
            sc = this.getDefaultSymbol().iterator();
            while (sc.hasNext()) {
                sc.next().draw(g2);
            }
        }
    }

    protected void setOutsidePoints() {
        Residue2D residue = this.repository.getResidue(this.residue1);
        Residue2D partnerResidue = this.repository.getResidue(this.residue2);
        if (this.interaction.isSecondaryInteraction() || residue.isDisplayed() && partnerResidue.isDisplayed()) {
            double dist = DrawingUtils.getDistance(residue.getRealX(), residue.getRealY(), partnerResidue.getRealX(), partnerResidue.getRealY());
            this.real_op = dist >= this.gc.getRealHalf() * 2.0 ? DrawingUtils.fit(residue.getRealCenterX(), residue.getRealCenterY(), partnerResidue.getRealCenterX(), partnerResidue.getRealCenterY(), this.gc.getRealHalf()) : null;
        } else if (!residue.isDisplayed() && partnerResidue.isDisplayed()) {
            this.real_op = DrawingUtils.fit(residue.getRealCenterX(), residue.getRealCenterY(), partnerResidue.getRealCenterX(), partnerResidue.getRealCenterY(), this.gc.getRealHalf());
            this.real_op[0] = residue.getRealCenter();
        } else if (!partnerResidue.isDisplayed() && residue.isDisplayed()) {
            this.real_op = DrawingUtils.fit(residue.getRealCenterX(), residue.getRealCenterY(), partnerResidue.getRealCenterX(), partnerResidue.getRealCenterY(), this.gc.getRealHalf());
            this.real_op[1] = partnerResidue.getRealCenter();
        } else {
            this.real_op = new Point2D[2];
            this.real_op[0] = residue.getRealCenter();
            this.real_op[1] = partnerResidue.getRealCenter();
        }
    }

    protected void setRealSymbol() {
        this.realSymbol.clear();
        if (this.op != null) {
            if (this.interaction.isSecondaryInteraction()) {
                this.setRealSymbol(this.op[0], this.op[1], this.gc.getCurrentSymbolSize());
            } else {
                double distance = DrawingUtils.getDistance(this.op[0], this.op[1]);
                Point2D[] ip1 = null;
                if (distance >= this.gc.getCurrentSymbolSize()) {
                    ip1 = DrawingUtils.fit(this.op[0].getX(), this.op[0].getY(), this.op[1].getX(), this.op[1].getY(), (distance - this.gc.getCurrentSymbolSize()) / 2.0);
                }
                if (ip1 != null) {
                    this.realSymbol.addSymbol(new Line(this.op[0], (Point2D)ip1[0], this.gc));
                    this.realSymbol.addSymbol(new Line((Point2D)ip1[1], this.op[1], this.gc));
                    this.setRealSymbol(ip1[0], ip1[1], this.gc.getCurrentSymbolSize());
                } else {
                    this.realSymbol.addSymbol(new Line(this.op[0], this.op[1], this.gc));
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        BaseBaseInteraction2D inter = (BaseBaseInteraction2D)obj;
        return this.interaction.getOrientation() == inter.interaction.getOrientation() && (this.interaction.getResidue().equals(inter.interaction.getResidue()) && this.interaction.getPartnerResidue().equals(inter.interaction.getPartnerResidue()) && this.interaction.getEdge1() == inter.interaction.getEdge1() && this.interaction.getEdge2() == inter.interaction.getEdge2() || this.interaction.getResidue().equals(inter.interaction.getPartnerResidue()) && this.interaction.getPartnerResidue().equals(inter.interaction.getResidue()) && this.interaction.getEdge2() == inter.interaction.getEdge1() && this.interaction.getEdge1() == inter.interaction.getEdge2());
    }
}

