/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.ssviewer.features;

import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SingleStrand;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.s2s.Mediator;
import fr.unistra.ibmc.s2s.ssviewer.features.Residue2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Residues2DRepository;
import fr.unistra.ibmc.s2s.ssviewer.features.Rna2D;
import fr.unistra.ibmc.s2s.ssviewer.features.StructuralDomain2D;
import fr.unistra.ibmc.s2s.ssviewer.graphics.GraphicContext;
import fr.unistra.ibmc.s2s.ssviewer.utils.DrawingUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Point2D;

public class Sstrand2D
extends StructuralDomain2D {
    static final int VERSE = 0;
    public static final int REVERSE = 1;
    private boolean linear;
    int orientation = 0;
    private double crossProduct;
    Point2D centerPoint;
    private double rayon;
    private double midX;
    private double midY;
    protected boolean flipped;
    private double dragX;
    private double dragY;
    private Rna2D rna;
    double rotationAngle;
    private Residue crossProductResidue;
    boolean reverse;
    boolean automaticCoordinates = true;
    public static final Color DEFAULT_COLOR = Color.BLACK;
    private SecondaryStructure secondaryStructure;

    public Sstrand2D(Rna2D rna, SecondaryStructure secondaryStructure, SingleStrand ss, Residues2DRepository repository, Mediator mediator, GraphicContext gc) {
        super(ss, repository, mediator, gc);
        this.rna = rna;
        this.secondaryStructure = secondaryStructure;
        this.setColor(DEFAULT_COLOR);
        if (ss.getLength() != this.rna.getRnaMolecule().getLength()) {
            this.setCrossProductResidue();
        }
        for (Residue2D r : this.getResidues()) {
            r.setStructuralDomain(this);
        }
    }

    public Rna2D getRna() {
        return this.rna;
    }

    public SingleStrand getSingleStrandFeature() {
        return (SingleStrand)this.structuralDomain;
    }

    protected double getRotationAngle() {
        return this.rotationAngle;
    }

    public boolean getReverse() {
        return this.reverse;
    }

    protected Residue2D getMoreExternalBase5() {
        Molecule m = this.structuralDomain.getMolecules().iterator().next();
        return this.repository.getResidue(new Residue(this.structuralDomain.getFullLocation(m).getStart(), m).getPreviousResidue().getPreviousResidue());
    }

    protected Residue2D getMoreExternalBase3() {
        Molecule m = this.structuralDomain.getMolecules().iterator().next();
        return this.repository.getResidue(new Residue(this.structuralDomain.getFullLocation(m).getEnd(), m).getNextResidue().getNextResidue());
    }

    public Residue2D getExternalBase5() {
        Molecule m = this.structuralDomain.getMolecules().iterator().next();
        return this.repository.getResidue(new Residue(this.structuralDomain.getFullLocation(m).getStart(), m).getPreviousResidue());
    }

    public Residue2D getExternalBase3() {
        Molecule m = this.structuralDomain.getMolecules().iterator().next();
        return this.repository.getResidue(new Residue(this.structuralDomain.getFullLocation(m).getEnd(), m).getNextResidue());
    }

    public int getBase5Id() {
        return this.structuralDomain.getFullLocation(this.structuralDomain.getMolecules().iterator().next()).getStart();
    }

    public int getExternalBase5Id() {
        return this.structuralDomain.getFullLocation(this.structuralDomain.getMolecules().iterator().next()).getStart() - 1;
    }

    public int getBase3Id() {
        return this.structuralDomain.getFullLocation(this.structuralDomain.getMolecules().iterator().next()).getEnd();
    }

    public int getExternalBase3Id() {
        return this.structuralDomain.getFullLocation(this.structuralDomain.getMolecules().iterator().next()).getEnd() + 1;
    }

    public ParadiseID getMoleculeId() {
        return this.structuralDomain.getMolecules().iterator().next().getParadiseID();
    }

    void setCenterPoint(double x, double y) {
        this.centerPoint = new Point2D.Double(x, y);
    }

    protected void setAngle(double angle) {
        this.rotationAngle = angle;
    }

    public Residue2D getBase5() {
        Molecule m = this.structuralDomain.getMolecules().iterator().next();
        return this.repository.getResidue(new Residue(this.structuralDomain.getFullLocation(m).getStart(), m));
    }

    public Residue2D getBase3() {
        Molecule m = this.structuralDomain.getMolecules().iterator().next();
        return this.repository.getResidue(new Residue(this.structuralDomain.getFullLocation(m).getEnd(), m));
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    private void setCrossProductResidue() {
        this.crossProductResidue = this.getExternalBase3() != null ? this.structuralDomain.getParentFeatures(SecondaryStructure.class).iterator().next().getPairedResidueInSecondaryInteraction(this.getExternalBase3().getResidue2DFeature().getResidues().iterator().next()) : this.structuralDomain.getParentFeatures(SecondaryStructure.class).iterator().next().getPairedResidueInSecondaryInteraction(this.getExternalBase5().getResidue2DFeature().getResidues().iterator().next());
    }

    public void setCoordinates() {
        block11: {
            block13: {
                Residue r2;
                Residue r1;
                block12: {
                    block10: {
                        if (this.getLength() != this.rna.getRnaMolecule().getLength()) break block10;
                        double x = this.gc.getDrawingArea().getCenterX();
                        double y = this.gc.getDrawingArea().getCenterY();
                        double circonference = (double)this.getLength() * this.gc.getRealHeight() + 2.0;
                        double rayon = circonference / Math.PI / 2.0;
                        Point2D.Double startPoint = new Point2D.Double(x, y + rayon);
                        int j = 0;
                        double angle = Math.PI * 2 / (double)(this.getLength() + 2);
                        for (Residue2D base5 = this.getBase5(); base5 != null && base5.getAbsolutePosition() <= this.getBase3Id(); base5 = base5.getNextResidue()) {
                            base5.setRealCoordinates(DrawingUtils.getRotatedPoint(startPoint, angle * (double)(++j), new Point2D.Double(x, y)));
                        }
                        break block11;
                    }
                    this.setCrossProductResidue();
                    Molecule m = this.structuralDomain.getMolecules().iterator().next();
                    Location l = this.structuralDomain.getFullLocation(m);
                    r1 = new Residue(l.getStart(), m).getPreviousResidue();
                    r2 = new Residue(l.getEnd(), m).getNextResidue();
                    if (r1 != null && r2 != null) break block12;
                    if (this.getExternalBase5Id() != 0) {
                        this.setDragDistances(this.getMoreExternalBase5(), this.getExternalBase5());
                        for (Residue2D base5 = this.getBase5(); base5 != null && base5.getAbsolutePosition() <= this.getBase3Id(); base5 = base5.getNextResidue()) {
                            base5.setRealCoordinates(base5.getPreviousResidue().getRealX() + this.dragX, base5.getPreviousResidue().getRealY() + this.dragY);
                        }
                    } else {
                        this.setDragDistances(this.getExternalBase3(), this.getMoreExternalBase3());
                        for (Residue2D base3 = this.getBase3(); base3 != null && base3.getAbsolutePosition() >= this.getBase5Id(); base3 = base3.getPreviousResidue()) {
                            base3.setRealCoordinates(base3.getNextResidue().getRealX() + this.dragX, base3.getNextResidue().getRealY() + this.dragY);
                        }
                    }
                    break block11;
                }
                if (r1 == null || r2 == null) break block11;
                StructuralDomain sd1 = this.secondaryStructure.getEnclosingStructuralDomain(r1);
                StructuralDomain sd2 = this.secondaryStructure.getEnclosingStructuralDomain(r2);
                if (sd1 == null || sd2 == null || sd1 != sd2) break block13;
                this.midX = (this.getExternalBase5().getRealX() + this.getExternalBase3().getRealX()) / 2.0;
                this.midY = (this.getExternalBase5().getRealY() + this.getExternalBase3().getRealY()) / 2.0;
                double trX = this.getExternalBase5().getRealX() - this.getMoreExternalBase5().getRealX();
                double trY = this.getExternalBase5().getRealY() - this.getMoreExternalBase5().getRealY();
                this.setCenterPoint(this.midX + trX * (double)this.getLength() / 4.0, this.midY + trY * (double)this.getLength() / 4.0);
                double angle = DrawingUtils.getAngle(DrawingUtils.getDistance(this.centerPoint.getX(), this.centerPoint.getY(), this.midX, this.midY), DrawingUtils.getDistance(this.midX, this.midY, this.getExternalBase5().getRealX(), this.getExternalBase5().getRealY()));
                double crossProduct = DrawingUtils.crossProduct(this.getExternalBase5().getRealCoordinates(), this.centerPoint, new Point2D.Double(this.midX, this.midY));
                this.rotationAngle = crossProduct <= 0.0 ? (Math.PI + 2.0 * angle) / (double)(this.getLength() + 1) : -(Math.PI + 2.0 * angle) / (double)(this.getLength() + 1);
                int j = 0;
                for (Residue2D base5 = this.getBase5(); base5 != null && base5.getAbsolutePosition() <= this.getBase3Id(); base5 = base5.getNextResidue()) {
                    base5.setRealCoordinates(this.setRotatedCoordinates((double)(++j) * this.rotationAngle));
                }
                break block11;
            }
            if (!this.automaticCoordinates) break block11;
            Residue2D base5 = this.getExternalBase5();
            Residue2D base3 = this.getExternalBase3();
            double[] basePosition = new double[]{base5.getRealX(), base5.getRealY()};
            int basesNb = this.getLength();
            double horizontal = base5.getRealX() - base3.getRealX();
            double vertical = base5.getRealY() - base3.getRealY();
            if (this.linear) {
                int i = this.getBase5Id();
                int j = 1;
                while (i <= this.getBase3Id()) {
                    basePosition[0] = basePosition[0] - (double)j * horizontal / (double)(basesNb + 1);
                    basePosition[1] = basePosition[1] - (double)j * vertical / (double)(basesNb + 1);
                    this.repository.getResidue(this.structuralDomain.getMolecules().iterator().next().getParadiseID(), i).setRealCoordinates(basePosition[0], basePosition[1]);
                    ++i;
                    ++j;
                }
            } else {
                double boundariesDistance = Math.sqrt(horizontal * horizontal + vertical * vertical);
                this.setCenterPoint(boundariesDistance, horizontal, vertical);
                int i = this.getBase5Id();
                int j = 1;
                while (i <= this.getBase3Id()) {
                    this.repository.getResidue(this.structuralDomain.getMolecules().iterator().next().getParadiseID(), i).setRealCoordinates(this.setRotatedCoordinates((double)j * this.rotationAngle));
                    ++i;
                    ++j;
                }
            }
        }
    }

    private void setDragDistances(Residue2D base1, Residue2D base2) {
        if (this.getExternalBase5Id() != 0) {
            if (this.orientation == 0) {
                this.dragX = base2.getRealX() - base1.getRealX();
                this.dragY = base2.getRealY() - base1.getRealY();
            }
        } else if (this.orientation == 0) {
            this.dragX = base1.getRealX() - base2.getRealX();
            this.dragY = base1.getRealY() - base2.getRealY();
        }
    }

    private void setCenterPoint(double boundariesDistance, double horizontal, double vertical) {
        Residue2D base5 = this.getExternalBase5();
        Residue2D base3 = this.getExternalBase3();
        double angle = 1.0471975511965976;
        this.crossProduct = DrawingUtils.crossProduct(base5.getRealCoordinates(), base3.getRealCoordinates(), this.repository.getResidue(this.crossProductResidue).getRealCoordinates());
        this.rotationAngle = (Math.PI - 2.0 * angle) / (double)(this.getLength() + 1);
        if (this.crossProduct >= 0.0) {
            this.rotationAngle = -this.rotationAngle;
        }
        if (this.reverse) {
            this.rotationAngle = -this.rotationAngle;
        }
        if (this.crossProduct >= 0.0) {
            angle = -angle;
        }
        if (this.reverse) {
            this.rotationAngle = -this.rotationAngle;
        }
        this.centerPoint = boundariesDistance == 0.0 ? new Point2D.Double(base5.getRealX(), base5.getRealY()) : (base5.getRealX() <= base3.getRealX() ? new Point2D.Double(base5.getRealX() + Math.sin(1.5707963267948966 + angle + Math.asin(vertical / boundariesDistance)) * boundariesDistance / (2.0 * Math.cos(-angle)), base5.getRealY() + Math.cos(1.5707963267948966 + angle + Math.asin(vertical / boundariesDistance)) * boundariesDistance / (2.0 * Math.cos(-angle))) : new Point2D.Double(base5.getRealX() - Math.sin(1.5707963267948966 - angle + Math.asin(vertical / boundariesDistance)) * boundariesDistance / (2.0 * Math.cos(angle)), base5.getRealY() + Math.cos(1.5707963267948966 - angle + Math.asin(vertical / boundariesDistance)) * boundariesDistance / (2.0 * Math.cos(angle))));
    }

    Point2D setRotatedCoordinates(double angle) {
        Point2D.Double translatedPoint = new Point2D.Double();
        translatedPoint.setLocation(this.getExternalBase5().getRealX() - this.centerPoint.getX(), this.getExternalBase5().getRealY() - this.centerPoint.getY());
        double newX = translatedPoint.getX() * Math.cos(-angle) - translatedPoint.getY() * Math.sin(-angle);
        double newY = translatedPoint.getX() * Math.sin(-angle) + translatedPoint.getY() * Math.cos(-angle);
        return new Point2D.Double(newX += this.centerPoint.getX(), newY += this.centerPoint.getY());
    }

    public String toSVG() {
        StringBuffer svg = new StringBuffer();
        for (Residue2D r : this.getResidues()) {
            svg.append(r.toSVG());
        }
        return svg.toString();
    }

    public void draw(Graphics2D g2) {
        if (this.structuralDomain != null && this.structuralDomain.getMolecules().size() > 0 && this.isInsideDrawingArea()) {
            if (this.isSelected()) {
                g2.setColor(Color.red);
            } else {
                g2.setColor(this.color);
            }
            for (Residue2D r : this.getResidues()) {
                r.draw(g2);
            }
        }
    }

    public boolean isInsideDrawingArea() {
        Residue2D base;
        Residue2D previousR = base.getPreviousResidue();
        Residue2D nextR = base.getNextResidue();
        for (base = this.getBase5(); base != null && base.getAbsolutePosition() <= this.getBase3Id(); base = base.getNextResidue()) {
            if (!base.isInsideDrawingArea()) continue;
            return true;
        }
        if (nextR != null && nextR.isInsideDrawingArea()) {
            return true;
        }
        return previousR != null && previousR.isInsideDrawingArea();
    }

    public void flipEnds(Point2D center) {
    }

    public void rotateEnds(Point2D centerPoint, double angle) {
    }

    public void translateEnds(double dragX, double dragY) {
    }

    public boolean contains(double x, double y) {
        boolean hit = false;
        for (Residue2D base = this.getBase5(); base != null && base.getAbsolutePosition() <= this.getBase3Id() && !(hit = base.contains(x, y)); base = base.getNextResidue()) {
        }
        return hit;
    }

    public Area getArea() {
        Area area = null;
        for (Residue2D r : this.getResidues()) {
            if (area == null) {
                area = r.getArea();
                continue;
            }
            area.add(r.getArea());
        }
        return area;
    }

    public void isAutomaticCoordinates(boolean automaticCoordinates) {
        this.automaticCoordinates = automaticCoordinates;
    }

    public boolean isAutomaticCoordinates() {
        return this.automaticCoordinates;
    }

    public void setColor(Color color) {
        super.setColor(color);
        for (Residue2D r : this.getResidues()) {
            r.setColor(color);
        }
    }

    public void extend(Location l) {
        Molecule m = this.structuralDomain.getMolecules().iterator().next();
        this.structuralDomain.addToLocation(l, m);
        for (int i = l.getStart(); i <= l.getEnd(); ++i) {
            this.repository.getResidue(m.getParadiseID(), i).setStructuralDomain(this);
        }
    }

    public void reduce(Location l) {
        Molecule m = this.structuralDomain.getMolecules().iterator().next();
        this.structuralDomain.removeFromLocation(l, m);
        for (int i = l.getStart(); i <= l.getEnd(); ++i) {
            this.repository.getResidue(m.getParadiseID(), i).setStructuralDomain(null);
        }
    }
}

