/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.ssviewer.features;

import fr.unistra.ibmc.s2s.ssviewer.features.Residue2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Symbol;
import fr.unistra.ibmc.s2s.ssviewer.graphics.GraphicContext;
import fr.unistra.ibmc.s2s.ssviewer.utils.DrawingUtils;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

class Triangle
extends Symbol {
    private Point2D[] startPoints;
    private Point2D endPoint;

    Triangle(Point2D startPoint, Point2D endPoint, Residue2D base5, Residue2D base3, double distance, char orientation, GraphicContext gc) {
        super(orientation, gc);
        this.shape = new GeneralPath();
        this.endPoint = endPoint;
        this.startPoints = DrawingUtils.getPerpendicular(startPoint, base5.getRealCoordinates(), base3.getRealCoordinates(), distance / 6.0);
        ((GeneralPath)this.shape).moveTo((float)this.startPoints[0].getX(), (float)this.startPoints[0].getY());
        ((GeneralPath)this.shape).lineTo((float)this.startPoints[1].getX(), (float)this.startPoints[1].getY());
        ((GeneralPath)this.shape).lineTo((float)endPoint.getX(), (float)endPoint.getY());
        ((GeneralPath)this.shape).lineTo((float)this.startPoints[0].getX(), (float)this.startPoints[0].getY());
        ((GeneralPath)this.shape).closePath();
    }

    public String toSVG() {
        StringBuffer svg = new StringBuffer();
        svg.append("<polygon " + super.getSVGStyle(this.getSVGColor()) + " points=\"" + (this.startPoints[1].getX() - this.gc.getViewX()) / this.gc.getFinalZoomLevel() + "," + (this.startPoints[1].getY() - this.gc.getViewY()) / this.gc.getFinalZoomLevel() + " " + (this.endPoint.getX() - this.gc.getViewX()) / this.gc.getFinalZoomLevel() + "," + (this.endPoint.getY() - this.gc.getViewY()) / this.gc.getFinalZoomLevel() + " " + (this.startPoints[0].getX() - this.gc.getViewX()) / this.gc.getFinalZoomLevel() + "," + (this.startPoints[0].getY() - this.gc.getViewY()) / this.gc.getFinalZoomLevel() + "\"/>\n");
        return svg.toString();
    }

    public String toString() {
        return "Triangle";
    }
}

