/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.ssviewer.graphics;

import fr.unistra.ibmc.s2s.ssviewer.features.Helix2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Residue2D;
import fr.unistra.ibmc.s2s.ssviewer.graphics.SecondaryCanvas;
import fr.unistra.ibmc.s2s.ssviewer.utils.DrawingUtils;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class GraphicContext {
    static final byte BASECOLOR = 0;
    static final byte STRUCTURECOLOR = 1;
    static final byte SEQUENCECOLOR = 2;
    static final byte INTERACTIONCOLOR = 3;
    private byte colorMode = 1;
    private Font f;
    double viewX;
    double viewY;
    double finalZoomLevel = 1.0;
    private List<String> families2show;
    private boolean showFamily;
    private boolean displayFiveToThreeOrientation = true;
    private boolean displayLabels = true;
    private Point2D gravityPoint;
    private Rectangle drawingArea;
    private double width;
    private double height;
    private double half = Math.sqrt(this.width * this.width + this.height * this.height) / 2.0;
    private double symbolsize = 4.0 * this.width - 2.0 * this.half;
    private SecondaryCanvas canvas;

    GraphicContext(SecondaryCanvas canvas) {
        this(6.0, 9.0, canvas);
    }

    GraphicContext(double width, double height, SecondaryCanvas canvas) {
        this.width = width;
        this.height = height;
        this.half = Math.sqrt(width * width + height * height) / 2.0;
        this.symbolsize = 4.0 * width - 2.0 * this.half;
        this.canvas = canvas;
    }

    public void initialize() {
        for (Helix2D h2D : this.canvas.getModel2D().getHelices()) {
            this.intializeHelixCurrentContext(h2D);
        }
        this.families2show = new ArrayList<String>();
        this.addFamily("CWW");
        this.addFamily("TWW");
        this.addFamily("CHH");
        this.addFamily("THH");
        this.addFamily("CSS");
        this.addFamily("TSS");
        this.addFamily("CHW");
        this.addFamily("CWH");
        this.addFamily("THW");
        this.addFamily("TWH");
        this.addFamily("CHS");
        this.addFamily("CSH");
        this.addFamily("THS");
        this.addFamily("TSH");
        this.addFamily("CSW");
        this.addFamily("CWS");
        this.addFamily("TSW");
        this.addFamily("TWS");
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public void intializeHelixCurrentContext(Helix2D h2D) {
        Residue2D[] _5PrimEnds = h2D.get5PrimeEnds();
        Residue2D _5PrimeEnd1 = _5PrimEnds[0];
        Residue2D _5PrimeEnd2 = _5PrimEnds[1];
        double length = DrawingUtils.getDistance(_5PrimeEnd1.getRealCoordinates(), h2D.get3PrimeEnd(_5PrimeEnd1).getRealCoordinates());
        Point2D[] _5 = DrawingUtils.fit(_5PrimeEnd1.getRealCoordinates(), h2D.get3PrimeEnd(_5PrimeEnd1).getRealCoordinates(), (length - this.height * (double)(h2D.getLength() - 1)) / 2.0);
        Point2D[] _3 = DrawingUtils.fit(_5PrimeEnd2.getRealCoordinates(), h2D.get3PrimeEnd(_5PrimeEnd2).getRealCoordinates(), (length - this.height * (double)(h2D.getLength() - 1)) / 2.0);
        h2D.setEnds(_5PrimeEnd1, _5[0], h2D.get3PrimeEnd(_5PrimeEnd1), _5[1], _5PrimeEnd2, _3[0], h2D.get3PrimeEnd(_5PrimeEnd2), _3[1]);
        double _width = DrawingUtils.getDistance(_5PrimeEnd1.getRealCoordinates(), h2D.getPairedResidue(_5PrimeEnd1).getRealCoordinates());
        _5 = DrawingUtils.fit(_5PrimeEnd1.getRealCoordinates(), h2D.getPairedResidue(_5PrimeEnd1).getRealCoordinates(), (_width - this.width * 4.0) / 2.0);
        _3 = DrawingUtils.fit(_5PrimeEnd2.getRealCoordinates(), h2D.getPairedResidue(_5PrimeEnd2).getRealCoordinates(), (_width - this.width * 4.0) / 2.0);
        h2D.setEnds(_5PrimeEnd1, _5[0], h2D.getPairedResidue(_5PrimeEnd1), _5[1], _5PrimeEnd2, _3[0], h2D.getPairedResidue(_5PrimeEnd2), _3[1]);
    }

    void moveView(double transX, double transY) {
        this.viewX += transX;
        this.viewY += transY;
    }

    void zoomParameters(double zoomFactor) {
        this.finalZoomLevel *= zoomFactor;
    }

    public double getCurrentWidth() {
        return this.width * this.finalZoomLevel;
    }

    public double getRealWidth() {
        return this.width;
    }

    public double getCurrentHeight() {
        return this.height * this.finalZoomLevel;
    }

    public double getRealHeight() {
        return this.height;
    }

    public double getCurrentSymbolSize() {
        return this.symbolsize * this.finalZoomLevel;
    }

    public double getRealSymbolSize() {
        return this.symbolsize;
    }

    public double getCurrentHalf() {
        return this.half * this.finalZoomLevel;
    }

    public double getRealHalf() {
        return this.half;
    }

    public Font getFont() {
        return new Font("Helvetica", 0, (int)this.getCurrentHeight());
    }

    public double getViewX() {
        return this.viewX;
    }

    public double getViewY() {
        return this.viewY;
    }

    Point2D getGravityPoint() {
        return this.gravityPoint;
    }

    public double getFinalZoomLevel() {
        return this.finalZoomLevel;
    }

    public boolean containFamily(String family) {
        for (String f : this.families2show) {
            if (!f.equals(family)) continue;
            return true;
        }
        return false;
    }

    void addFamily(String family) {
        if (this.containFamily(family)) {
            this.families2show.remove(family);
        } else {
            this.families2show.add(family);
        }
    }

    public void increaseFontSize() {
        this.width *= 1.5;
        this.height *= 1.5;
        this.half = Math.sqrt(this.width * this.width + this.height * this.height) / 2.0;
        this.symbolsize = 4.0 * this.width - 2.0 * this.half;
        for (Helix2D h2D : this.canvas.getModel2D().getHelices()) {
            this.intializeHelixCurrentContext(h2D);
        }
    }

    public void decreaseFontSize() {
        this.width /= 1.5;
        this.height /= 1.5;
        this.half = Math.sqrt(this.width * this.width + this.height * this.height) / 2.0;
        this.symbolsize = 4.0 * this.width - 2.0 * this.half;
        for (Helix2D h2D : this.canvas.getModel2D().getHelices()) {
            this.intializeHelixCurrentContext(h2D);
        }
    }

    private void clearFamilies() {
        this.families2show.clear();
    }

    void setFiveToThreeOrientationDisplay(boolean display) {
        this.displayFiveToThreeOrientation = display;
    }

    public boolean isFiveToThreeOrientationDisplayed() {
        return this.displayFiveToThreeOrientation;
    }

    boolean isShowFamily() {
        return this.showFamily;
    }

    void setShowFamily(boolean showFamily) {
        this.showFamily = showFamily;
    }

    void setGravityPoint(Point2D gravityPoint) {
        this.gravityPoint = gravityPoint;
    }

    void translateGravityPoint(double transX, double transY) {
        if (this.gravityPoint != null) {
            this.gravityPoint.setLocation(this.gravityPoint.getX() + transX, this.gravityPoint.getY() + transY);
        }
    }

    void zoomGravityPoint(double zoomLevel) {
        if (this.gravityPoint != null) {
            this.gravityPoint.setLocation(this.gravityPoint.getX() * zoomLevel, this.gravityPoint.getY() * zoomLevel);
        }
    }

    void setColorMode(byte colorMode) {
        this.colorMode = colorMode;
    }

    void setDrawingArea(Rectangle drawingArea) {
        this.drawingArea = drawingArea;
    }

    public Rectangle getDrawingArea() {
        return this.drawingArea;
    }

    public boolean isLabelsDisplayed() {
        return this.displayLabels;
    }

    public void setDisplayLabels(boolean displayLabels) {
        this.displayLabels = displayLabels;
    }

    public boolean isTertiaryInteractionsDisplayed() {
        return true;
    }
}

