/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.ssviewer.graphics;

import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.s2s.Mediator;
import fr.unistra.ibmc.s2s.ssviewer.features.BaseBaseInteraction2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Helix2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Interaction2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Model2D;
import fr.unistra.ibmc.s2s.ssviewer.features.PhosphodiesterBond2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Residue2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Rna2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Rna2DElement;
import fr.unistra.ibmc.s2s.ssviewer.graphics.SecondaryCanvas;
import fr.unistra.ibmc.s2s.ssviewer.graphics.SelectState;
import java.awt.event.MouseEvent;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InteractionSelect
extends SelectState {
    InteractionSelect(Mediator mediator) {
        super(mediator);
    }

    @Override
    void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        BaseBaseInteraction2D interSelect = null;
        Model2D model2D = this.mediator.getCurrentModel2D();
        if (model2D != null && e.getClickCount() == 1) {
            for (BaseBaseInteraction2D interaction : model2D.getInterMolecularTertiaryInteractions()) {
                if (!interaction.isDrawn() || !interaction.contains(e.getX(), e.getY())) continue;
                interSelect = interaction;
                break;
            }
            if (interSelect == null) {
                block1: for (Helix2D h : model2D.getInterMolecularHelices()) {
                    for (BaseBaseInteraction2D interaction : h.getSecondaryInteractions()) {
                        if (!interaction.isDrawn() || !interaction.contains(e.getX(), e.getY())) continue;
                        interSelect = interaction;
                        break block1;
                    }
                }
            }
            if (interSelect == null) {
                block3: for (Rna2D rna : model2D.getRnas()) {
                    for (BaseBaseInteraction2D interaction : rna.getTertiaryInteractions()) {
                        if (!interaction.isDrawn() || !interaction.contains(e.getX(), e.getY())) continue;
                        interSelect = interaction;
                        break block3;
                    }
                    for (Helix2D h : rna.getHelices()) {
                        for (BaseBaseInteraction2D interaction : h.getSecondaryInteractions()) {
                            if (!interaction.isDrawn() || !interaction.contains(e.getX(), e.getY())) continue;
                            interSelect = interaction;
                            break block3;
                        }
                    }
                }
            }
            if (interSelect != null) {
                if (e.isShiftDown()) {
                    this.mediator.getSecondaryCanvas().addShiftCurrentInteraction(interSelect);
                } else if (e.isControlDown()) {
                    this.mediator.getSecondaryCanvas().addCtrlCurrentInteraction(interSelect);
                } else {
                    this.mediator.getSecondaryCanvas().addCurrentInteraction(interSelect);
                }
                this.mediator.getSecondaryCanvas().updateGravityPoint();
                if (BaseBaseInteraction2D.class.isInstance(interSelect)) {
                    this.mediator.getRna2dViewer().fireInteractionSelected(interSelect.getBaseBaseInteractionFeature(), e.isShiftDown());
                }
            }
        }
    }

    @Override
    Rna2DElement getWrapper(Residue residue) {
        if (this.mediator.getSecondaryCanvas() != null) {
            for (Rna2D rna : this.mediator.getSecondaryCanvas().getModel2D().getRnas()) {
                List<Interaction2D> interactions;
                if (!residue.getMoleculeId().equals(rna.getRnaMolecule().getParadiseID()) || (interactions = this.mediator.getSecondaryCanvas().getModel2D().getInteractions(residue.getMoleculeId(), residue.getAbsolutePosition())).size() <= 0) continue;
                return interactions.get(0);
            }
        }
        return null;
    }

    @Override
    public void select(SecondaryCanvas canvas, List<Residue2D> residues) {
        canvas.clearAllSelections();
        for (Residue2D r2D : residues) {
            for (Interaction2D int2D : r2D.getInteractions()) {
                if (PhosphodiesterBond2D.class.isInstance(int2D)) continue;
                canvas.addShiftCurrentInteraction(int2D);
            }
        }
    }
}

