/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.ssviewer.graphics;

import fr.unistra.ibmc.paradise.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.Paradise;
import fr.unistra.ibmc.paradise.core.MainParadiseFeature;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.RNA;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.io.CTFileIO;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.paradise.tools.AbstractParadiseToolAgent;
import fr.unistra.ibmc.paradise.tools.ParadiseTool;
import fr.unistra.ibmc.paradise.tools.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.utils.GeneralUtils;
import fr.unistra.ibmc.paradise.utils.VTextIcon;
import fr.unistra.ibmc.s2s.Mediator;
import fr.unistra.ibmc.s2s.SelectionListener;
import fr.unistra.ibmc.s2s.behaviours.HelixReorganizationRequestAnswerBehaviour;
import fr.unistra.ibmc.s2s.rnalign.utils.RessourcesUtils;
import fr.unistra.ibmc.s2s.ssviewer.features.BaseBaseInteraction2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Helix2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Interaction2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Model2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Residue2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Rna2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Sstrand2D;
import fr.unistra.ibmc.s2s.ssviewer.features.StructuralDomain2D;
import fr.unistra.ibmc.s2s.ssviewer.graphics.ClearZoomState;
import fr.unistra.ibmc.s2s.ssviewer.graphics.MagnusZoomState;
import fr.unistra.ibmc.s2s.ssviewer.graphics.MinusZoomState;
import fr.unistra.ibmc.s2s.ssviewer.graphics.MoveViewState;
import fr.unistra.ibmc.s2s.ssviewer.graphics.RotationState;
import fr.unistra.ibmc.s2s.ssviewer.graphics.SecondaryCanvas;
import fr.unistra.ibmc.s2s.ssviewer.graphics.SelectState;
import fr.unistra.ibmc.s2s.ssviewer.graphics.State;
import jade.gui.GuiEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rna2DViewer
extends JPanel
implements SelectionListener {
    private Mediator mediator;
    private Rna2DViewerToolBar toolbar;
    private JButton lastClicked;
    private SelectButton selectButton;
    public static Cursor selectCursor;
    public static Cursor magnifyCursor;
    public static Cursor magnifyPlusCursor;
    public static Cursor magnifyMinusCursor;
    public static Cursor moveviewCursor;
    public static Cursor rotateCursor;
    private Cursor currentCursor;
    public static final int TERTIARY_STRUCTURE_ANNOTATION = 0;
    public static final int TERTIARY_STRUCTURE_PREDICTION = 1;
    public static final int SECONDARY_STRUCTURE_PREDICTION = 3;
    public static final int SECONDARY_STRUCTURE_DRAWING = 4;
    public static final int HELICES_REORGANIZATION = 5;
    private SelectState currentSelectionMode;
    private List<SelectionListener> selectionListeners;
    private SecondaryCanvas canvas;

    public Rna2DViewer(Mediator mediator, ParadiseWorkingSession workingSession) {
        this.mediator = mediator;
        this.mediator.setRna2DViewer(this);
        this.toolbar = new Rna2DViewerToolBar();
        this.setLayout(new BorderLayout());
        this.canvas = new SecondaryCanvas(workingSession, this.mediator);
        this.add((Component)this.canvas, "Center");
        this.currentCursor = selectCursor;
        this.selectionListeners = new ArrayList<SelectionListener>();
    }

    public Rna2DViewerToolBar getToolbar() {
        return this.toolbar;
    }

    public void addSelectionListener(SelectionListener l) {
        this.selectionListeners.add(l);
    }

    public Mediator getMediator() {
        return this.mediator;
    }

    public MainParadiseFeature getCurrentFeature() {
        if (this.mediator == null || this.mediator.getSecondaryCanvas() == null || this.mediator.getSecondaryCanvas().getModel2D() == null) {
            return null;
        }
        return this.mediator.getSecondaryCanvas().getModel2D().getSecondaryStructure();
    }

    public void clearDisplay() {
        if (this.mediator.getSecondaryCanvas() != null) {
            this.mediator.getSecondaryCanvas().clearDisplay();
        }
    }

    private void setCursorForCanvas(Cursor cursor) {
        this.canvas.setCursor(cursor);
    }

    public Cursor getCurrentCursor() {
        return this.currentCursor;
    }

    public void loadRNASecondaryStructure(SecondaryStructure ss) {
    }

    public SecondaryCanvas getSecondaryCanvas() {
        return this.canvas;
    }

    void doClickOnSelectButton() {
        if (this.getSecondaryCanvas() != null) {
            if (this.lastClicked != null) {
                this.lastClicked.setEnabled(true);
            }
            this.currentCursor = selectCursor;
            this.setCursorForCanvas(selectCursor);
            this.lastClicked = this.selectButton;
        }
    }

    public void reorganizeHelices() {
        GuiEvent ev = new GuiEvent((Object)this, 5);
        if (this.getSecondaryCanvas() != null && this.getSecondaryCanvas().getModel2D() != null) {
            SecondaryStructure ss = this.getSecondaryCanvas().getModel2D().getSecondaryStructure();
            ArrayList<Molecule> molecules = new ArrayList<Molecule>();
            for (Molecule m : ss.getMolecules()) {
                m.removeAllSelectedFeatures();
                m.addSelectedFeature(ss);
                molecules.add(m);
            }
            ev.addParameter(molecules);
            ev.addParameter(new ArrayList());
        }
    }

    @Override
    public void residuesSelected(Collection<Residue> residues, boolean isShiftDown) {
        if (!isShiftDown) {
            this.getSecondaryCanvas().clearAllSelections();
        }
        Iterator<Residue> it = residues.iterator();
        while (it.hasNext()) {
            Residue2D r = this.getSecondaryCanvas().seekResidue2D(it.next());
            if (r == null) continue;
            this.getSecondaryCanvas().addShiftCurrentResidue(r);
        }
    }

    public void fireResiduesSelected(Collection<Residue> residues, boolean isShiftDown) {
        for (SelectionListener l : this.selectionListeners) {
            l.residuesSelected(residues, isShiftDown);
        }
    }

    @Override
    public void structuralDomainSelected(StructuralDomain structuralDomain, boolean isShiftDown) {
        if (!isShiftDown) {
            this.getSecondaryCanvas().clearAllSelections();
        }
        this.getSecondaryCanvas().addShiftCurrentStructure((StructuralDomain2D)this.getSecondaryCanvas().seekRna2DNode(structuralDomain));
    }

    public void fireStructuralDomainSelected(StructuralDomain structuralDomain, boolean isShiftDown) {
        for (SelectionListener l : this.selectionListeners) {
            l.structuralDomainSelected(structuralDomain, isShiftDown);
        }
    }

    @Override
    public void interactionSelected(BaseBaseInteraction interaction, boolean isShiftDown) {
        if (!isShiftDown) {
            this.getSecondaryCanvas().clearAllSelections();
        }
        this.getSecondaryCanvas().addShiftCurrentInteraction((Interaction2D)this.getSecondaryCanvas().seekRna2DNode(interaction));
    }

    public void fireInteractionSelected(BaseBaseInteraction interaction, boolean isShiftDown) {
        for (SelectionListener l : this.selectionListeners) {
            l.interactionSelected(interaction, isShiftDown);
        }
    }

    public void residuesSelected(ParadiseTool source, Collection<Residue> residues) {
        if (source == this || !this.mediator.isLinked()) {
            return;
        }
        SecondaryCanvas canvas = this.getSecondaryCanvas();
        if (canvas != null && canvas.getModel2D() != null) {
            ArrayList<Residue2D> _residues = new ArrayList<Residue2D>();
            for (Rna2D rna2D : canvas.getModel2D().getRnas()) {
                for (Residue r : residues) {
                    if (!rna2D.getRnaMolecule().equals(r.getMolecule())) continue;
                    for (Residue2D r2D : rna2D.getResidues()) {
                        if (r.getAbsolutePosition() != r2D.getAbsolutePosition()) continue;
                        _residues.add(r2D);
                    }
                }
            }
            this.currentSelectionMode.select(canvas, _residues);
        }
    }

    static {
        Toolkit tk = Toolkit.getDefaultToolkit();
        selectCursor = tk.createCustomCursor(RessourcesUtils.getImage("select-cursor.gif"), new Point(0, 0), "select");
        magnifyCursor = tk.createCustomCursor(RessourcesUtils.getImage("magnify-cursor.gif"), new Point(0, 0), "magnify");
        magnifyPlusCursor = tk.createCustomCursor(RessourcesUtils.getImage("magnify-plus-cursor.gif"), new Point(0, 0), "mplus");
        magnifyMinusCursor = tk.createCustomCursor(RessourcesUtils.getImage("magnify-minus-cursor.gif"), new Point(0, 0), "mminus");
        moveviewCursor = tk.createCustomCursor(RessourcesUtils.getImage("move-view-cursor.gif"), new Point(0, 0), "move view");
        rotateCursor = tk.createCustomCursor(RessourcesUtils.getImage("rotate-cursor.gif"), new Point(0, 0), "rotate");
    }

    private class InteractionSelector
    extends JDialog {
        private JButton ok = new JButton("Ok");
        private JButton cancel = new JButton("Cancel");
        private JRadioButton w1 = new JRadioButton("Watson Crick");
        private JRadioButton h1 = new JRadioButton("Hoogsteen");
        private JRadioButton s1 = new JRadioButton("Sugar Edge");
        private JRadioButton w2 = new JRadioButton("Watson Crick");
        private JRadioButton h2 = new JRadioButton("Hoogsteen");
        private JRadioButton s2 = new JRadioButton("Sugar Edge");
        private JRadioButton cis = new JRadioButton("Cis");
        private JRadioButton trans = new JRadioButton("Trans");
        private JRadioButton r1;
        private JRadioButton r2;
        private Residue2D residue1;
        private Residue2D residue2;
        private Molecule m1;
        private Molecule m2;
        private int pos1;
        private int pos2;
        private boolean generateTertiaryInteraction;

        private InteractionSelector(Residue2D residue1, Residue2D residue2) {
            this.residue1 = residue1;
            this.residue2 = residue2;
            this.pos1 = residue1.getAbsolutePosition();
            this.pos2 = residue2.getAbsolutePosition();
            this.m1 = residue1.getResidue2DFeature().getMolecules().iterator().next();
            this.m2 = residue2.getResidue2DFeature().getMolecules().iterator().next();
            this.r1 = new JRadioButton(this.m1.getResidueAt(this.pos1) + " " + this.pos1 + " (" + this.m1.getName() + ")");
            this.r2 = new JRadioButton(this.m2.getResidueAt(this.pos2) + " " + this.pos2 + " (" + this.m2.getName() + ")");
            ButtonGroup be1 = new ButtonGroup();
            ButtonGroup be2 = new ButtonGroup();
            ButtonGroup bo = new ButtonGroup();
            ButtonGroup br = new ButtonGroup();
            be1.add(this.w1);
            be1.add(this.h1);
            be1.add(this.s1);
            be2.add(this.w2);
            be2.add(this.h2);
            be2.add(this.s2);
            bo.add(this.cis);
            bo.add(this.trans);
            br.add(this.r1);
            br.add(this.r2);
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
            JPanel ed1 = new JPanel();
            ed1.setLayout(new BoxLayout(ed1, 2));
            JPanel ed2 = new JPanel();
            ed2.setLayout(new BoxLayout(ed2, 2));
            JPanel or = new JPanel();
            or.setLayout(new BoxLayout(or, 2));
            JPanel re = new JPanel();
            re.setLayout(new BoxLayout(re, 2));
            JPanel but = new JPanel();
            but.setLayout(new BoxLayout(but, 2));
            ed1.add(new JLabel("Edge for " + this.m1.getResidueAt(this.pos1) + " " + this.pos1));
            ed1.add(this.w1);
            ed1.add(this.h1);
            ed1.add(this.s1);
            ed2.add(new JLabel("Edge for " + this.m2.getResidueAt(this.pos2) + " " + this.pos2));
            ed2.add(this.w2);
            ed2.add(this.h2);
            ed2.add(this.s2);
            or.add(new JLabel("Orientation of the Interaction"));
            or.add(this.cis);
            or.add(this.trans);
            re.add(new JLabel("Dominant Residue (if applicable)"));
            re.add(this.r1);
            re.add(this.r2);
            but.add(this.ok);
            but.add(this.cancel);
            this.setTitle("Describe the Interaction");
            this.getContentPane().add(ed1);
            this.getContentPane().add(ed2);
            this.getContentPane().add(or);
            this.getContentPane().add(re);
            this.getContentPane().add(but);
            this.cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InteractionSelector.this.dispose();
                }
            });
            this.pack();
            this.setResizable(false);
            GeneralUtils.centerOnScreen(this);
            this.setVisible(true);
        }

        public InteractionSelector(final BaseBaseInteraction2D interaction) {
            this(interaction.getResidue(), interaction.getPartnerResidue());
            switch (interaction.getBaseBaseInteractionFeature().getOrientation()) {
                case 'C': {
                    this.cis.setSelected(true);
                    break;
                }
                case 'T': {
                    this.trans.setSelected(true);
                }
            }
            switch (interaction.getBaseBaseInteractionFeature().getEdge1()) {
                case 'W': {
                    this.w1.setSelected(true);
                    break;
                }
                case 'H': {
                    this.h1.setSelected(true);
                    break;
                }
                case 'S': {
                    this.s1.setSelected(true);
                }
            }
            switch (interaction.getBaseBaseInteractionFeature().getEdge2()) {
                case 'W': {
                    this.w2.setSelected(true);
                    break;
                }
                case 'H': {
                    this.h2.setSelected(true);
                    break;
                }
                case 'S': {
                    this.s2.setSelected(true);
                }
            }
            this.ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    char edge1 = 'W';
                    char edge2 = 'W';
                    char orientation = 'C';
                    int dominant = 1;
                    if (InteractionSelector.this.h1.isSelected()) {
                        edge1 = 'H';
                    }
                    if (InteractionSelector.this.s1.isSelected()) {
                        edge1 = 'S';
                    }
                    if (InteractionSelector.this.h2.isSelected()) {
                        edge2 = 'H';
                    }
                    if (InteractionSelector.this.s2.isSelected()) {
                        edge2 = 'S';
                    }
                    if (InteractionSelector.this.trans.isSelected()) {
                        orientation = 'T';
                    }
                    if (InteractionSelector.this.r2.isSelected()) {
                        dominant = 2;
                    }
                    Rna2DViewer.this.mediator.getCurrentModel2D().modifyInteractionType(interaction, InteractionSelector.this.residue1, edge1, InteractionSelector.this.residue2, edge2, orientation, dominant);
                    Rna2DViewer.this.mediator.getSecondaryCanvas().repaint();
                    InteractionSelector.this.dispose();
                    Rna2DViewer.this.mediator.getSecondaryCanvas().clearAllSelections();
                }
            });
        }

        public InteractionSelector(final Residue2D residue1, final Residue2D residue2, boolean generateTertiaryInteraction) {
            this(residue1, residue2);
            this.w1.setSelected(true);
            this.w2.setSelected(true);
            this.cis.setSelected(true);
            this.r1.setSelected(true);
            this.generateTertiaryInteraction = generateTertiaryInteraction;
            this.ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == InteractionSelector.this.ok) {
                        char edge1 = 'W';
                        char edge2 = 'W';
                        char orientation = 'C';
                        int dominant = 1;
                        if (InteractionSelector.this.h1.isSelected()) {
                            edge1 = 'H';
                        }
                        if (InteractionSelector.this.s1.isSelected()) {
                            edge1 = 'S';
                        }
                        if (InteractionSelector.this.h2.isSelected()) {
                            edge2 = 'H';
                        }
                        if (InteractionSelector.this.s2.isSelected()) {
                            edge2 = 'S';
                        }
                        if (InteractionSelector.this.trans.isSelected()) {
                            orientation = 'T';
                        }
                        if (InteractionSelector.this.r2.isSelected()) {
                            dominant = 2;
                        }
                        Rna2DViewer.this.mediator.getCurrentModel2D().createTertiaryInteraction(residue1, edge1, residue2, edge2, orientation, dominant);
                        Rna2DViewer.this.mediator.getSecondaryCanvas().repaint();
                        InteractionSelector.this.dispose();
                        Rna2DViewer.this.mediator.getSecondaryCanvas().clearAllSelections();
                    }
                }
            });
        }
    }

    private class Rna2DMenu
    extends JMenuBar
    implements ActionListener {
        static final int FILE_MENU = 0;
        static final int CLOSE_MENU = 1;
        static final int ABOUT_MENU = 2;
        private static final int EDIT_MENU = 3;
        private static final int TOOLS_MENU = 6;
        private static final int SELECTION_MENU = 7;
        private JMenu[] jmenus = new JMenu[11];
        private JMenuItem itemFile;

        Rna2DMenu() {
            this.jmenus[0] = new JMenu("File");
            this.itemFile = new JMenuItem("Export as CT file"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Rna2DViewer.this.mediator.getCurrentModel2D() != null && Rna2DViewer.this.mediator.getSecondaryCanvas().getCurrentResidues().size() > 0);
                    super.paintComponent(graphics);
                }
            };
            this.itemFile.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                    fileChooser.setFileHidingEnabled(true);
                    if (fileChooser.showSaveDialog(null) == 0) {
                        File file = fileChooser.getSelectedFile();
                        try {
                            if (!file.exists()) {
                                file.createNewFile();
                            }
                            ArrayList<Residue> residues = new ArrayList<Residue>();
                            HashSet<BaseBaseInteraction> interactions = new HashSet<BaseBaseInteraction>();
                            for (Residue2D r2D : Rna2DViewer.this.mediator.getSecondaryCanvas().getCurrentResidues()) {
                                residues.add(r2D.getResidue2DFeature().getResidues().iterator().next());
                                for (Interaction2D interaction : r2D.getInteractions()) {
                                    if (!BaseBaseInteraction2D.class.isInstance(interaction) || !((BaseBaseInteraction2D)interaction).getBaseBaseInteractionFeature().isSecondaryInteraction()) continue;
                                    interactions.add(((BaseBaseInteraction2D)interaction).getBaseBaseInteractionFeature());
                                }
                            }
                            Collections.sort(residues, new Comparator(){

                                public int compare(Object o1, Object o2) {
                                    return ((Residue)o1).getAbsolutePosition() - ((Residue)o2).getAbsolutePosition();
                                }
                            });
                            CTFileIO.writeCTFile(residues, new ArrayList<BaseBaseInteraction>(interactions), file);
                        }
                        catch (FileNotFoundException ex) {
                            ex.printStackTrace();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            this.jmenus[3] = new JMenu("Edit");
            this.itemFile = new JMenuItem("Reorganize helices"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Rna2DViewer.this.mediator.getCurrentModel2D() != null);
                    super.paintComponent(graphics);
                }
            };
            this.itemFile.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Rna2DViewer.this.reorganizeHelices();
                }
            });
            this.jmenus[3].add(this.itemFile);
            this.itemFile = new JMenuItem("Hide unselected residues"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Rna2DViewer.this.mediator.getCurrentModel2D() != null);
                    super.paintComponent(graphics);
                }
            };
            this.itemFile.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (Residue2D r2D : Rna2DViewer.this.mediator.getCurrentModel2D().getResidues()) {
                        if (r2D.isSelected()) continue;
                        r2D.isDisplayed(false);
                    }
                    Rna2DViewer.this.mediator.getSecondaryCanvas().repaint();
                }
            });
            this.add(this.jmenus[3]);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!actionEvent.getActionCommand().equals("loadLayout") && !actionEvent.getActionCommand().equals("saveLayout")) {
                if ("displayLabels".equals(actionEvent.getActionCommand())) {
                    if (Rna2DViewer.this.mediator.getSecondaryCanvas() != null) {
                        Rna2DViewer.this.mediator.getSecondaryCanvas().setDisplayLabels(true);
                        Rna2DViewer.this.mediator.getSecondaryCanvas().repaint();
                    }
                } else if ("hideLabels".equals(actionEvent.getActionCommand())) {
                    if (Rna2DViewer.this.mediator.getSecondaryCanvas() != null) {
                        Rna2DViewer.this.mediator.getSecondaryCanvas().setDisplayLabels(false);
                        Rna2DViewer.this.mediator.getSecondaryCanvas().repaint();
                    }
                } else if ("structurecol".equals(actionEvent.getActionCommand())) {
                    if (Rna2DViewer.this.mediator.getSecondaryCanvas() != null) {
                        Rna2DViewer.this.mediator.getSecondaryCanvas().setColorMode((byte)1);
                        Rna2DViewer.this.mediator.getSecondaryCanvas().repaint();
                    }
                } else if ("intercol".equals(actionEvent.getActionCommand())) {
                    if (Rna2DViewer.this.mediator.getSecondaryCanvas() != null) {
                        Rna2DViewer.this.mediator.getSecondaryCanvas().setColorMode((byte)3);
                        Rna2DViewer.this.mediator.getSecondaryCanvas().repaint();
                    }
                } else if ("basecol".equals(actionEvent.getActionCommand())) {
                    if (Rna2DViewer.this.mediator.getSecondaryCanvas() != null) {
                        Rna2DViewer.this.mediator.getSecondaryCanvas().setColorMode((byte)0);
                        Rna2DViewer.this.mediator.getSecondaryCanvas().repaint();
                    }
                } else if ("sequencecol".equals(actionEvent.getActionCommand()) && Rna2DViewer.this.mediator.getSecondaryCanvas() != null) {
                    Rna2DViewer.this.mediator.getSecondaryCanvas().setColorMode((byte)2);
                    Rna2DViewer.this.mediator.getSecondaryCanvas().repaint();
                }
            }
        }

        void setEnableMenus(boolean enable) {
            this.jmenus[0].setEnabled(enable);
            this.jmenus[3].setEnabled(enable);
            this.jmenus[6].setEnabled(enable);
        }

        public void activate() {
            this.jmenus[0].setEnabled(true);
            this.jmenus[3].setEnabled(true);
        }
    }

    private class ColorChooser
    extends JFrame {
        private JColorChooser jcc;

        ColorChooser(ChangeListener listener) {
            super("Color Chooser");
            this.jcc = new JColorChooser();
            this.getContentPane().add(this.jcc);
            this.jcc.getSelectionModel().addChangeListener(listener);
            this.pack();
            GeneralUtils.centerOnScreen(this);
        }

        public void toForeground() {
            this.setVisible(true);
            this.toFront();
        }

        public Color getColor() {
            return this.jcc.getColor();
        }
    }

    class SelectButton
    extends JButton
    implements ActionListener,
    MouseListener {
        private SelectButton(String name, Icon image) {
            super(name, image);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorderPainted(false);
            this.setBackground(Color.white);
            this.addActionListener(this);
            this.addMouseListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            if (Rna2DViewer.this.lastClicked != null) {
                Rna2DViewer.this.lastClicked.setEnabled(true);
            }
            Rna2DViewer.this.lastClicked = this;
            if (Rna2DViewer.this.getSecondaryCanvas().getModel2D() != null) {
                Rna2DViewer.this.getSecondaryCanvas().setState(Rna2DViewer.this.mediator.getSelectionMode());
            }
            Rna2DViewer.this.setCursorForCanvas(selectCursor);
            Rna2DViewer.this.currentCursor = selectCursor;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.setBackground(Color.lightGray);
            this.setBorderPainted(true);
        }

        public void mouseExited(MouseEvent e) {
            this.setBackground(Color.white);
            this.setBorderPainted(false);
        }
    }

    private class Rna2DViewerToolBar
    extends JToolBar {
        private JLabel label;
        private StateButton zoomPlusButton;
        private StateButton zoomMinusButton;
        private StateButton noZoomButton;
        private StateButton rotButton;
        private StateButton moveView;
        private ActionButton addHelix;
        private ActionButton removeHelix;
        private ActionButton addTertiaryInteraction;
        private ActionButton removeTertiaryInteraction;
        private ActionButton modifyInteractionType;
        private ActionButton[] actions = new ActionButton[15];
        private BackboneSpinner backboneSpinner;

        private Rna2DViewerToolBar() {
            this.setFloatable(false);
            this.setBackground(Color.white);
            this.backboneSpinner = new BackboneSpinner();
            int height = new ImageIcon(RessourcesUtils.getImage("flip.png")).getIconHeight();
            this.actions[0] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("flip.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Rna2DViewer.this.getSecondaryCanvas() != null) {
                        Rna2DViewer.this.getSecondaryCanvas().flipSelection();
                    }
                }
            });
            this.actions[0].setToolTipText("Flip selection");
            this.actions[1] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("lock.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                }
            });
            this.actions[1].setToolTipText("Lock interaction display");
            this.actions[2] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("unlock.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                }
            });
            this.actions[2].setToolTipText("Unlock interaction display");
            this.actions[3] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("show-symbol.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Rna2DViewer.this.getSecondaryCanvas() != null) {
                        Iterator<Interaction2D> ic = Rna2DViewer.this.getSecondaryCanvas().getCurrentInteractions().iterator();
                        while (ic.hasNext()) {
                            ic.next().drawRealSymbol(true);
                        }
                        Rna2DViewer.this.getSecondaryCanvas().repaint();
                    }
                }
            });
            this.actions[3].setToolTipText("Display LW symbol");
            this.actions[4] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("hide-symbol.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Rna2DViewer.this.getSecondaryCanvas() != null) {
                        Iterator<Interaction2D> ic = Rna2DViewer.this.getSecondaryCanvas().getCurrentInteractions().iterator();
                        while (ic.hasNext()) {
                            ic.next().drawRealSymbol(false);
                        }
                        Rna2DViewer.this.getSecondaryCanvas().repaint();
                    }
                }
            });
            this.actions[4].setToolTipText("Hide LW symbol");
            this.actions[5] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("center-view.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Rna2DViewer.this.getSecondaryCanvas() != null) {
                        Rna2DViewer.this.getSecondaryCanvas().centerView();
                    }
                }
            });
            this.actions[5].setToolTipText("Center view on 2D structure");
            this.actions[8] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("plus.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Rna2DViewer.this.getSecondaryCanvas() != null) {
                        Rna2DViewer.this.getSecondaryCanvas().increaseFontSize();
                    }
                }
            });
            this.actions[8].setToolTipText("Increase font");
            this.actions[9] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("minus.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Rna2DViewer.this.getSecondaryCanvas() != null) {
                        Rna2DViewer.this.getSecondaryCanvas().decreaseFontSize();
                    }
                }
            });
            this.actions[9].setToolTipText("Decrease font");
            this.actions[12] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("ellipse.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Rna2DViewer.this.getSecondaryCanvas() != null) {
                        List<StructuralDomain2D> strs = Rna2DViewer.this.getSecondaryCanvas().getCurrentStructures();
                        StructuralDomain2D str2 = null;
                        for (StructuralDomain2D str2 : strs) {
                            if (!(str2 instanceof Sstrand2D)) continue;
                            ((Sstrand2D)str2).isAutomaticCoordinates(true);
                        }
                        Rna2DViewer.this.getSecondaryCanvas().repaint();
                    }
                }
            });
            this.actions[12].setToolTipText("Single-strand automatic drawing mode");
            this.actions[13] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("polygon.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Rna2DViewer.this.getSecondaryCanvas() != null) {
                        List<StructuralDomain2D> strs = Rna2DViewer.this.getSecondaryCanvas().getCurrentStructures();
                        StructuralDomain2D str2 = null;
                        for (StructuralDomain2D str2 : strs) {
                            if (!(str2 instanceof Sstrand2D)) continue;
                            ((Sstrand2D)str2).isAutomaticCoordinates(false);
                        }
                        Rna2DViewer.this.getSecondaryCanvas().repaint();
                    }
                }
            });
            this.actions[13].setToolTipText("Single-strand user-defined drawing mode");
            this.actions[14] = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("clear.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Rna2DViewer.this.mediator.getSecondaryCanvas() != null) {
                        Rna2DViewer.this.mediator.getSecondaryCanvas().clearTertiaries();
                    }
                }
            });
            this.actions[14].setToolTipText("Clear tertiary interactions");
            Rna2DViewer.this.selectButton = new SelectButton(null, new ImageIcon(RessourcesUtils.getImage("select.png")));
            Rna2DViewer.this.selectButton.setToolTipText("Select/Translate selection");
            this.zoomPlusButton = new StateButton(null, new ImageIcon(RessourcesUtils.getImage("plus.png")), new MagnusZoomState(Rna2DViewer.this.mediator), magnifyPlusCursor);
            this.zoomPlusButton.setToolTipText("Zoom in");
            this.zoomMinusButton = new StateButton(null, new ImageIcon(RessourcesUtils.getImage("minus.png")), new MinusZoomState(Rna2DViewer.this.mediator), magnifyMinusCursor);
            this.zoomMinusButton.setToolTipText("Zoom out");
            this.noZoomButton = new StateButton(null, new ImageIcon(RessourcesUtils.getImage("zoom.png")), new ClearZoomState(Rna2DViewer.this.mediator), magnifyCursor);
            this.noZoomButton.setToolTipText("1:1");
            this.rotButton = new StateButton(null, new ImageIcon(RessourcesUtils.getImage("rotate.png")), new RotationState(Rna2DViewer.this.mediator), rotateCursor);
            this.rotButton.setToolTipText("Rotate selection");
            this.moveView = new StateButton(null, new ImageIcon(RessourcesUtils.getImage("move-view.png")), new MoveViewState(Rna2DViewer.this.mediator), moveviewCursor);
            this.moveView.setToolTipText("Move view");
            this.addHelix = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("new-secondary.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SecondaryCanvas canvas = Rna2DViewer.this.mediator.getSecondaryCanvas();
                    Model2D model2D = canvas.getModel2D();
                    if (model2D != null && canvas.getCurrentResidues().size() == 4) {
                        Iterator<Residue2D> it = canvas.getCurrentResidues().iterator();
                        Residue2D r1 = it.next();
                        Residue2D r2 = it.next();
                        Residue2D r3 = it.next();
                        Residue2D r4 = it.next();
                        ParadiseID id1 = r1.getMoleculeId();
                        ParadiseID id2 = r2.getMoleculeId();
                        ParadiseID id3 = r3.getMoleculeId();
                        ParadiseID id4 = r4.getMoleculeId();
                        ArrayList<Residue2D> sortedResidues = new ArrayList<Residue2D>(4);
                        if (id1 == id2 && id3 == id4) {
                            if (r1.getAbsolutePosition() < r2.getAbsolutePosition()) {
                                sortedResidues.add(r1);
                                sortedResidues.add(r2);
                            } else {
                                sortedResidues.add(r2);
                                sortedResidues.add(r1);
                            }
                            if (r3.getAbsolutePosition() < r4.getAbsolutePosition()) {
                                sortedResidues.add(r3);
                                sortedResidues.add(r4);
                            } else {
                                sortedResidues.add(r4);
                                sortedResidues.add(r3);
                            }
                        } else if (id1 == id3 && id2 == id4) {
                            if (r1.getAbsolutePosition() < r3.getAbsolutePosition()) {
                                sortedResidues.add(r1);
                                sortedResidues.add(r3);
                            } else {
                                sortedResidues.add(r3);
                                sortedResidues.add(r1);
                            }
                            if (r2.getAbsolutePosition() < r4.getAbsolutePosition()) {
                                sortedResidues.add(r2);
                                sortedResidues.add(r4);
                            } else {
                                sortedResidues.add(r4);
                                sortedResidues.add(r2);
                            }
                        } else if (id1 == id4 && id2 == id3) {
                            if (r1.getAbsolutePosition() < r4.getAbsolutePosition()) {
                                sortedResidues.add(r1);
                                sortedResidues.add(r4);
                            } else {
                                sortedResidues.add(r4);
                                sortedResidues.add(r1);
                            }
                            if (r2.getAbsolutePosition() < r3.getAbsolutePosition()) {
                                sortedResidues.add(r2);
                                sortedResidues.add(r3);
                            } else {
                                sortedResidues.add(r3);
                                sortedResidues.add(r2);
                            }
                        }
                        it = sortedResidues.iterator();
                        try {
                            model2D.createHelix(it.next(), it.next(), it.next(), it.next());
                            Rna2DViewer.this.mediator.getSecondaryCanvas().clearAllSelections();
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(Rna2DViewer.this, ex.getMessage(), "Cannot create Helix", 0);
                        }
                        Rna2DViewer.this.mediator.getSecondaryCanvas().repaint();
                    } else {
                        JOptionPane.showMessageDialog(Rna2DViewer.this, "Select exactly four residues to use this option", "Cannot create Helix", 0);
                    }
                }
            });
            this.addHelix.setToolTipText("Create new helix");
            this.removeHelix = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("delete-interaction.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int transformAsTertiaryInteractions = JOptionPane.showConfirmDialog(Rna2DViewer.this, "Do you want to keep the secondary interactions as tertiary ones?");
                    if (transformAsTertiaryInteractions == 2) {
                        return;
                    }
                    Model2D model2D = Rna2DViewer.this.mediator.getSecondaryCanvas().getModel2D();
                    if (model2D != null) {
                        ArrayList<StructuralDomain2D> domains = new ArrayList<StructuralDomain2D>(Rna2DViewer.this.mediator.getSecondaryCanvas().getCurrentStructures());
                        for (StructuralDomain2D sd : domains) {
                            if (!Helix2D.class.isInstance(sd)) continue;
                            Rna2DViewer.this.mediator.getSecondaryCanvas().removeCurrentStructure(sd);
                            try {
                                model2D.removeHelix((Helix2D)sd, transformAsTertiaryInteractions == 0);
                            }
                            catch (BiologicalSymbolException e1) {
                                JOptionPane.showMessageDialog(Rna2DViewer.this, e1.getMessage(), "Cannot remove Helix", 0);
                                return;
                            }
                        }
                    }
                    Rna2DViewer.this.mediator.getSecondaryCanvas().repaint();
                }
            });
            this.removeHelix.setToolTipText("Remove helix");
            this.addTertiaryInteraction = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("new-tertiary.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    List<Residue2D> residues = Rna2DViewer.this.mediator.getSecondaryCanvas().getCurrentResidues();
                    if (residues.size() == 2) {
                        new InteractionSelector(residues.get(0), residues.get(1), true);
                        Rna2DViewer.this.mediator.getSecondaryCanvas().repaint();
                    } else {
                        JOptionPane.showMessageDialog(Rna2DViewer.this, "You have to select two residues to create a new tertiary interaction", "No residues selected!!", 0);
                    }
                }
            });
            this.addTertiaryInteraction.setToolTipText("Create new tertiary interaction");
            this.removeTertiaryInteraction = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("delete-interaction.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    List<Interaction2D> interactions = Rna2DViewer.this.mediator.getSecondaryCanvas().getCurrentInteractions();
                    if (interactions.isEmpty()) {
                        JOptionPane.showMessageDialog(Rna2DViewer.this, "No interactions selected !!");
                    } else {
                        ArrayList<BaseBaseInteraction> interactionsRemoved = new ArrayList<BaseBaseInteraction>();
                        Rna2DViewer.this.mediator.getSecondaryCanvas().clearAllSelections();
                        for (Interaction2D i : interactions) {
                            if (!BaseBaseInteraction2D.class.isInstance(i) || ((BaseBaseInteraction2D)i).getBaseBaseInteractionFeature().isSecondaryInteraction() || ((BaseBaseInteraction2D)i).getBaseBaseInteractionFeature().getMolecules().size() != 1) continue;
                            Rna2DViewer.this.mediator.getSecondaryCanvas().getModel2D().removeTertiaryInteraction((BaseBaseInteraction2D)i);
                            interactionsRemoved.add(((BaseBaseInteraction2D)i).getBaseBaseInteractionFeature());
                        }
                        Rna2DViewer.this.mediator.getSecondaryCanvas().repaint();
                    }
                }
            });
            this.removeTertiaryInteraction.setToolTipText("Remove tertiary interactions");
            this.modifyInteractionType = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("modify-interaction.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    List<Interaction2D> interactions = Rna2DViewer.this.mediator.getSecondaryCanvas().getCurrentInteractions();
                    if (interactions.size() == 1 && BaseBaseInteraction2D.class.isInstance(interactions.get(0))) {
                        new InteractionSelector((BaseBaseInteraction2D)interactions.get(0));
                        Rna2DViewer.this.mediator.getSecondaryCanvas().repaint();
                    } else {
                        JOptionPane.showMessageDialog(Rna2DViewer.this, "You have to select a single interaction!!");
                    }
                }
            });
            this.modifyInteractionType.setToolTipText("Modify interaction's type");
            JLabel toolBarName = new JLabel();
            toolBarName.setIcon(new VTextIcon(toolBarName, "2D", 2));
            this.add(toolBarName);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.moveView);
            this.add(Rna2DViewer.this.selectButton);
            this.add(this.rotButton);
            ActionButton reorganizeHelices = new ActionButton(null, new ImageIcon(RessourcesUtils.getImage("magic.png")), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GuiEvent ev = new GuiEvent((Object)this, 4);
                    ArrayList<Molecule> molecules = new ArrayList<Molecule>();
                    if (Rna2DViewer.this.getSecondaryCanvas().getModel2D() != null) {
                        SecondaryStructure ss = Rna2DViewer.this.getSecondaryCanvas().getModel2D().getSecondaryStructure();
                        for (Molecule m : ss.getMolecules()) {
                            if (!RNA.class.isInstance(m)) continue;
                            m.removeAllSelectedFeatures();
                            molecules.add(m);
                            m.addSelectedFeature(ss);
                        }
                        ev.addParameter((Object)new HelixReorganizationRequestAnswerBehaviour(molecules, new Parameters()));
                        ((AbstractParadiseToolAgent)Rna2DViewer.this.mediator.getS2s().getAgent()).postGuiEvent(ev);
                    }
                }
            });
            if (!Rna2DViewer.this.mediator.getS2s().isConnected()) {
                reorganizeHelices.setToolTipText("Reorganize helices (need connection)");
                reorganizeHelices.setEnabled(false);
            } else {
                reorganizeHelices.setToolTipText("Reorganize helices");
            }
            this.add(reorganizeHelices);
            JSeparator separator = new JSeparator(1);
            separator.setBackground(Color.GRAY);
            separator.setMaximumSize(new Dimension(1, height));
            this.add(Box.createHorizontalStrut(5));
            this.add(separator);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.actions[5]);
            this.add(this.actions[0]);
            separator = new JSeparator(1);
            separator.setBackground(Color.GRAY);
            separator.setMaximumSize(new Dimension(1, height));
            this.add(Box.createHorizontalStrut(5));
            this.add(separator);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.addHelix);
            this.add(this.removeHelix);
            this.add(this.addTertiaryInteraction);
            this.add(this.removeTertiaryInteraction);
            this.add(this.modifyInteractionType);
            separator = new JSeparator(1);
            separator.setBackground(Color.GRAY);
            separator.setMaximumSize(new Dimension(1, height));
            this.add(Box.createHorizontalStrut(5));
            this.add(separator);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.zoomPlusButton);
            this.add(this.noZoomButton);
            this.add(this.zoomMinusButton);
            separator = new JSeparator(1);
            separator.setBackground(Color.GRAY);
            separator.setMaximumSize(new Dimension(1, height));
            this.add(Box.createHorizontalStrut(5));
            this.add(separator);
            this.add(Box.createHorizontalStrut(5));
            this.add(new CaptureViewButton());
        }

        private class BackboneButton
        extends JButton
        implements ActionListener,
        MouseListener {
            private BackboneButton() {
                super(null, new ImageIcon(RessourcesUtils.getImage("backbone.png")));
                this.setMargin(new Insets(0, 0, 0, 0));
                this.setBackground(Color.WHITE);
                this.setBorderPainted(false);
                this.addActionListener(this);
                this.addMouseListener(this);
                this.setToolTipText("Follow the backbone");
            }

            public void actionPerformed(ActionEvent e) {
                int _steps;
                int steps = (Integer)Rna2DViewerToolBar.this.backboneSpinner.getModel().getValue();
                if (steps >= 0 && Rna2DViewer.this.getSecondaryCanvas() != null) {
                    for (Residue2D r2D : Rna2DViewer.this.getSecondaryCanvas().getCurrentResidues()) {
                        for (_steps = steps; _steps > 0 && r2D.getNextResidue() != null && !r2D.getNextResidue().isSelected(); --_steps) {
                            r2D = r2D.getNextResidue();
                            r2D.isDisplayed(true);
                        }
                        for (r2D = r2D.getNextResidue(); r2D != null && r2D.isDisplayed() && !r2D.isSelected(); r2D = r2D.getNextResidue()) {
                            r2D.isDisplayed(false);
                        }
                    }
                    Rna2DViewer.this.getSecondaryCanvas().repaint();
                }
                if (steps <= 0 && Rna2DViewer.this.getSecondaryCanvas() != null) {
                    for (Residue2D r2D : Rna2DViewer.this.getSecondaryCanvas().getCurrentResidues()) {
                        for (_steps = steps; _steps < 0 && r2D.getPreviousResidue() != null && !r2D.getPreviousResidue().isSelected(); ++_steps) {
                            r2D = r2D.getPreviousResidue();
                            r2D.isDisplayed(true);
                        }
                        for (r2D = r2D.getPreviousResidue(); r2D != null && r2D.isDisplayed() && !r2D.isSelected(); r2D = r2D.getPreviousResidue()) {
                            r2D.isDisplayed(false);
                        }
                    }
                    Rna2DViewer.this.getSecondaryCanvas().repaint();
                }
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                this.setBackground(Color.lightGray);
                this.setBorderPainted(true);
            }

            public void mouseExited(MouseEvent e) {
                this.setBackground(Color.white);
                this.setBorderPainted(false);
            }
        }

        private class BackboneSpinner
        extends JSpinner
        implements ChangeListener {
            private BackboneSpinner() {
                this.setModel(new SpinnerNumberModel(0, Integer.MIN_VALUE, Integer.MAX_VALUE, 1));
                this.addChangeListener(this);
                this.setMinimumSize(new Dimension(50, 20));
                this.setPreferredSize(new Dimension(50, 20));
                this.setMaximumSize(new Dimension(50, 20));
            }

            public void stateChanged(ChangeEvent event) {
                int _steps;
                int steps = (Integer)this.getModel().getValue();
                if (steps >= 0 && Rna2DViewer.this.getSecondaryCanvas() != null) {
                    for (Residue2D r2D : Rna2DViewer.this.getSecondaryCanvas().getCurrentResidues()) {
                        for (_steps = steps; _steps > 0 && r2D.getNextResidue() != null && !r2D.getNextResidue().isSelected(); --_steps) {
                            r2D = r2D.getNextResidue();
                            r2D.isDisplayed(true);
                        }
                        for (r2D = r2D.getNextResidue(); r2D != null && r2D.isDisplayed() && !r2D.isSelected(); r2D = r2D.getNextResidue()) {
                            r2D.isDisplayed(false);
                        }
                    }
                    Rna2DViewer.this.getSecondaryCanvas().repaint();
                }
                if (steps <= 0 && Rna2DViewer.this.getSecondaryCanvas() != null) {
                    for (Residue2D r2D : Rna2DViewer.this.getSecondaryCanvas().getCurrentResidues()) {
                        for (_steps = steps; _steps < 0 && r2D.getPreviousResidue() != null && !r2D.getPreviousResidue().isSelected(); ++_steps) {
                            r2D = r2D.getPreviousResidue();
                            r2D.isDisplayed(true);
                        }
                        for (r2D = r2D.getPreviousResidue(); r2D != null && r2D.isDisplayed() && !r2D.isSelected(); r2D = r2D.getPreviousResidue()) {
                            r2D.isDisplayed(false);
                        }
                    }
                    Rna2DViewer.this.getSecondaryCanvas().repaint();
                }
            }
        }

        private class CaptureViewButton
        extends JButton
        implements MouseListener {
            private CaptureViewButton() {
                super(new ImageIcon(RessourcesUtils.getImage("capture.png")));
                this.setToolTipText("Capture the 2D view");
                this.setBackground(Color.white);
                this.setBorderPainted(false);
                this.addMouseListener(this);
                this.addActionListener(new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void actionPerformed(ActionEvent e) {
                        if (Rna2DViewer.this.mediator.getCurrentModel2D() != null) {
                            JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                            fileChooser.setFileFilter(new FileFilter(){

                                public boolean accept(File f) {
                                    return f.isDirectory() || f.getName().endsWith("svg");
                                }

                                public String getDescription() {
                                    return "PNG file";
                                }
                            });
                            if (fileChooser.showSaveDialog(Rna2DViewer.this) == 0) {
                                File file = null;
                                PrintWriter pw = null;
                                try {
                                    file = fileChooser.getSelectedFile();
                                    file.createNewFile();
                                    Paradise.setWorkingDirectory(file.getAbsolutePath());
                                    ImageIO.write((RenderedImage)Rna2DViewer.this.mediator.getSecondaryCanvas().getImage(), "png", file);
                                    JOptionPane.showMessageDialog(Rna2DViewer.this, "Saving successful");
                                }
                                catch (FileNotFoundException fnfe) {
                                    System.out.println("I cannot find the file : " + file.getPath());
                                    return;
                                }
                                catch (IOException ioe) {
                                    System.out.println("Problem to save data in the file : " + file.getPath());
                                    return;
                                }
                                finally {
                                    if (pw != null) {
                                        pw.close();
                                    }
                                }
                            }
                        }
                    }
                });
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                this.setBackground(Color.lightGray);
                this.setBorderPainted(true);
            }

            public void mouseExited(MouseEvent e) {
                this.setBackground(Color.white);
                this.setBorderPainted(false);
            }
        }

        private class DisplayButton
        extends JButton
        implements MouseListener {
            private DisplayButton() {
                super(new ImageIcon(RessourcesUtils.getImage("display-unlocked.png")));
                this.setToolTipText("Lock/Unlock the display");
                this.setBackground(Color.white);
                this.setBorderPainted(false);
                this.addMouseListener(this);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Rna2DViewer.this.mediator.isLinked(!Rna2DViewer.this.mediator.isLinked());
                        if (Rna2DViewer.this.mediator.isLinked()) {
                            DisplayButton.this.setIcon(new ImageIcon(RessourcesUtils.getImage("display-unlocked.png")));
                        } else {
                            DisplayButton.this.setIcon(new ImageIcon(RessourcesUtils.getImage("display-locked.png")));
                        }
                    }
                });
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                this.setBackground(Color.lightGray);
                this.setBorderPainted(true);
            }

            public void mouseExited(MouseEvent e) {
                this.setBackground(Color.white);
                this.setBorderPainted(false);
            }
        }

        private class StateButton
        extends JButton
        implements ActionListener,
        MouseListener {
            private State state;
            private Cursor cursor;

            private StateButton(String name, Icon image, State state, Cursor cursor) {
                super(name, image);
                this.setMargin(new Insets(0, 0, 0, 0));
                this.setBorderPainted(false);
                this.setBackground(Color.white);
                this.addActionListener(this);
                this.addMouseListener(this);
                this.state = state;
                this.cursor = cursor;
            }

            public void actionPerformed(ActionEvent e) {
                if (Rna2DViewer.this.lastClicked != null) {
                    Rna2DViewer.this.lastClicked.setEnabled(true);
                }
                Rna2DViewer.this.lastClicked = this;
                if (Rna2DViewer.this.getSecondaryCanvas().getModel2D() != null) {
                    Rna2DViewer.this.getSecondaryCanvas().setState(this.state);
                }
                Rna2DViewer.this.setCursorForCanvas(this.cursor);
                Rna2DViewer.this.currentCursor = this.cursor;
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                this.setBackground(Color.lightGray);
                this.setBorderPainted(true);
            }

            public void mouseExited(MouseEvent e) {
                this.setBackground(Color.white);
                this.setBorderPainted(false);
            }
        }

        private class ActionButton
        extends JButton
        implements MouseListener {
            private ActionButton(String name, Icon image, ActionListener listener) {
                super(name, image);
                this.addActionListener(listener);
                this.addMouseListener(this);
                this.setMargin(new Insets(0, 0, 0, 0));
                this.setBorderPainted(false);
                this.setBackground(Color.white);
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                this.setBackground(Color.lightGray);
                this.setBorderPainted(true);
            }

            public void mouseExited(MouseEvent e) {
                this.setBackground(Color.white);
                this.setBorderPainted(false);
            }
        }
    }

    private class ColorsBar
    extends JToolBar {
        private static final int size = 20;
        private int counter;
        private ColorChooser cc;

        ColorsBar() {
            this.setOrientation(0);
            this.setFloatable(false);
            this.setBackground(Color.WHITE);
            this.add(new ColorButton(Color.GREEN));
            this.add(new ColorButton(Color.ORANGE));
            this.add(new ColorButton(Color.PINK));
            this.add(new ColorButton(Color.YELLOW));
            this.add(new ColorButton(Color.BLUE));
            this.add(new ColorButton(Color.CYAN));
            this.add(new ColorButton(Color.RED));
            this.add(new ColorButton(Color.GRAY));
            for (int i = this.counter = 8; i < 20; ++i) {
                this.add(new ColorButton());
            }
        }

        void registerColor(Color c) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                if (((ColorButton)this.getComponent(i)).getColor().getRGB() != c.getRGB()) continue;
                return;
            }
            if (this.counter == 20) {
                this.counter = 0;
            }
            ((ColorButton)this.getComponent(this.counter)).setColor(c);
            ++this.counter;
        }

        private class ColorIcon
        implements Icon {
            private int height = 15;
            private int width = 15;
            private Color color;

            public ColorIcon(Color color) {
                this.color = color;
            }

            public int getIconHeight() {
                return this.height;
            }

            public int getIconWidth() {
                return this.width;
            }

            public void setColor(Color newValue) {
                this.color = newValue;
            }

            public Color getColor() {
                return this.color;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setColor(this.color);
                g.fillRect(x, y, this.width, this.height);
            }
        }

        private class ColorButton
        extends JButton
        implements ActionListener,
        MouseListener {
            private ColorIcon icon;

            public ColorButton(Color c) {
                this();
                this.setColor(c);
            }

            public ColorButton() {
                this.icon = new ColorIcon(Color.LIGHT_GRAY);
                this.setMargin(new Insets(0, 0, 0, 0));
                this.setBorderPainted(false);
                this.setBackground(Color.WHITE);
                this.setIcon(this.icon);
                this.addActionListener(this);
                this.addMouseListener(this);
            }

            public void actionPerformed(ActionEvent event) {
                if (this.icon.getColor().getRGB() == Color.LIGHT_GRAY.getRGB()) {
                    if (ColorsBar.this.cc == null) {
                        ColorsBar.this.cc = new ColorChooser(new ChangeListener(){

                            public void stateChanged(ChangeEvent e) {
                                Rna2DViewer.this.getSecondaryCanvas().setColor(ColorsBar.this.cc.getColor());
                                ColorsBar.this.cc.dispose();
                            }
                        });
                    }
                    ColorsBar.this.cc.toForeground();
                } else if (Rna2DViewer.this.getSecondaryCanvas() != null) {
                    Rna2DViewer.this.getSecondaryCanvas().setColor(this.icon.getColor());
                }
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                this.setBackground(Color.lightGray);
                this.setBorderPainted(true);
            }

            public void mouseExited(MouseEvent e) {
                this.setBackground(Color.white);
                this.setBorderPainted(false);
            }

            private void setColor(Color c) {
                this.icon.setColor(c);
                this.repaint();
            }

            private Color getColor() {
                return this.icon.getColor();
            }
        }
    }
}

