/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.ssviewer.graphics;

import fr.unistra.ibmc.s2s.Mediator;
import fr.unistra.ibmc.s2s.ssviewer.features.Residue2D;
import fr.unistra.ibmc.s2s.ssviewer.graphics.State;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;

class RotationState
extends State {
    private Point2D pickingCenter;
    private Point2D centerofRotation;

    RotationState(Mediator mediator) {
        super(mediator);
    }

    void mouseDragged(MouseEvent e) {
        this.mediator.getSecondaryCanvas().rotateSelection(e.isShiftDown() ? 5.0 : ((double)e.getX() - this.pickingCenter.getX() + (double)e.getY() - this.pickingCenter.getY()) / 10.0, this.centerofRotation);
    }

    void mousePressed(MouseEvent e) {
        this.pickingCenter = new Point2D.Double(e.getPoint().getX(), e.getPoint().getY());
        double centerX = 0.0;
        double centerY = 0.0;
        List<Residue2D> residues = this.mediator.getSecondaryCanvas().getCurrentResidues();
        for (Residue2D r : residues) {
            centerX += r.getCurrentCenterX();
            centerY += r.getCurrentCenterY();
        }
        this.centerofRotation = new Point2D.Double(centerX /= (double)residues.size(), centerY /= (double)residues.size());
    }
}

