/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.ssviewer.graphics;

import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructureDisplay;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.paradise.tools.ParadiseWorkingSession;
import fr.unistra.ibmc.s2s.Mediator;
import fr.unistra.ibmc.s2s.ssviewer.features.BaseBaseInteraction2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Helix2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Interaction2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Model2D;
import fr.unistra.ibmc.s2s.ssviewer.features.PhosphodiesterBond2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Residue2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Rna2D;
import fr.unistra.ibmc.s2s.ssviewer.features.Rna2DElement;
import fr.unistra.ibmc.s2s.ssviewer.features.SingleHBond;
import fr.unistra.ibmc.s2s.ssviewer.features.Sstrand2D;
import fr.unistra.ibmc.s2s.ssviewer.features.StructuralDomain2D;
import fr.unistra.ibmc.s2s.ssviewer.features.TextAnnotation;
import fr.unistra.ibmc.s2s.ssviewer.graphics.GraphicContext;
import fr.unistra.ibmc.s2s.ssviewer.graphics.InteractionSelect;
import fr.unistra.ibmc.s2s.ssviewer.graphics.ResidueSelect;
import fr.unistra.ibmc.s2s.ssviewer.graphics.Rna2DViewer;
import fr.unistra.ibmc.s2s.ssviewer.graphics.State;
import fr.unistra.ibmc.s2s.ssviewer.graphics.StructSelect;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.jdesktop.swingworker.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecondaryCanvas
extends JPanel
implements MouseWheelListener,
MouseListener,
MouseMotionListener {
    protected static final byte UPDATE = 99;
    protected static final byte TRANSLATION = 100;
    protected static final byte ROTATION = 101;
    protected static final byte ZOOM = 102;
    protected static final byte NEW_STATE = 103;
    protected static final byte INTERACTION_DISPLAY = 106;
    protected static final byte FLIP = 107;
    protected static final byte CLOSE = 108;
    protected GraphicContext gc;
    protected State state;
    protected Model2D model;
    protected Image offScreenBuffer;
    private List<StructuralDomain2D> currentStructures;
    private List<Residue2D> currentResidues;
    private List<Interaction2D> currentInteractions;
    protected Point2D gravityPoint;
    protected Mediator mediator;
    protected Rectangle2D selectionRectangle;
    private List<TextAnnotation> textAnnotations;
    private ParadiseWorkingSession workingSession;

    SecondaryCanvas(ParadiseWorkingSession workingSession, Mediator mediator) {
        this.workingSession = workingSession;
        this.currentResidues = new ArrayList<Residue2D>();
        this.currentInteractions = new ArrayList<Interaction2D>();
        this.currentStructures = new ArrayList<StructuralDomain2D>();
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(Color.white);
        this.textAnnotations = new ArrayList<TextAnnotation>();
        this.textAnnotations.add(new TextAnnotation());
        this.setCursor(Rna2DViewer.selectCursor);
        this.mediator = mediator;
        this.setState(mediator.getSelectionMode());
    }

    public void setState(byte mode) {
        switch (mode) {
            case 0: {
                this.state = new StructSelect(this.mediator);
                break;
            }
            case 1: {
                this.state = new InteractionSelect(this.mediator);
                break;
            }
            case 2: {
                this.state = new ResidueSelect(this.mediator);
            }
        }
    }

    public void clearDisplay() {
        this.model = null;
        this.gc = null;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.model != null && this.gc != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setBackground(Color.white);
            g2.setFont(this.gc.getFont());
            g2.setColor(Color.BLACK);
            g2.fillOval((int)(this.gc.getViewX() - 5.0 * this.gc.getFinalZoomLevel()), (int)(this.gc.getViewY() - 5.0 * this.gc.getFinalZoomLevel()), (int)(10.0 * this.gc.getFinalZoomLevel()), (int)(10.0 * this.gc.getFinalZoomLevel()));
            g2.drawLine((int)(this.gc.getViewX() - 10.0 * this.gc.getFinalZoomLevel()), (int)this.gc.getViewY(), (int)(this.gc.getViewX() + 20.0 * this.gc.getFinalZoomLevel()), (int)this.gc.getViewY());
            g2.drawLine((int)this.gc.getViewX(), (int)(this.gc.getViewY() - 10.0 * this.gc.getFinalZoomLevel()), (int)this.gc.getViewX(), (int)(this.gc.getViewY() + 20.0 * this.gc.getFinalZoomLevel()));
            if (this.selectionRectangle != null) {
                g2.setColor(Color.LIGHT_GRAY);
                g2.fill(this.selectionRectangle);
                g2.setColor(Color.BLACK);
            }
            this.gc.setDrawingArea(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            this.model.draw(g2);
        }
    }

    public Model2D getModel2D() {
        return this.model;
    }

    public GraphicContext getGraphicContext() {
        return this.gc;
    }

    public void addFamily(String family) {
        this.gc.addFamily(family);
        this.repaint();
    }

    public boolean displayFamily(String family) {
        return this.gc.containFamily(family);
    }

    public void setFiveToThreeOrientationDisplay(boolean display) {
        this.gc.setFiveToThreeOrientationDisplay(display);
        this.repaint();
    }

    public boolean isFiveToThreeOrientationDisplayed() {
        return this.gc.isFiveToThreeOrientationDisplayed();
    }

    void setColorMode(byte colorMode) {
        this.gc.setColorMode(colorMode);
    }

    void setColor(Color color) {
        Iterator<Rna2DElement> i = this.getCurrentResidues().iterator();
        while (i.hasNext()) {
            ((Rna2DElement)i.next()).setColor(color);
        }
        i = this.getCurrentStructures().iterator();
        while (i.hasNext()) {
            i.next().setColor(color);
        }
        i = this.getCurrentInteractions().iterator();
        while (i.hasNext()) {
            i.next().setColor(color);
        }
        ArrayList<Residue> residues = new ArrayList<Residue>(this.getCurrentResidues().size());
        for (Residue2D r2D : this.getCurrentResidues()) {
            residues.add(r2D.getResidue2DFeature().getResidues().iterator().next());
        }
        this.repaint();
    }

    @Override
    public void update(Graphics g) {
        if (this.offScreenBuffer == null || this.offScreenBuffer.getWidth(this) != this.getSize().width || this.offScreenBuffer.getHeight(this) != this.getSize().height) {
            this.offScreenBuffer = this.createImage(this.getSize().width, this.getSize().height);
        }
        Graphics2D gr = (Graphics2D)this.offScreenBuffer.getGraphics();
        this.paintComponent(gr);
        g.drawImage(this.offScreenBuffer, 0, 0, this);
    }

    void showInteractionsFrom(Residue r) {
        List<Interaction2D> interactions = this.model.getInteractions(r.getMoleculeId(), r.getAbsolutePosition());
        Interaction2D inter2 = null;
        for (Interaction2D inter2 : interactions) {
            inter2.drawRealSymbol(true);
            inter2.isDisplayed(true);
        }
        if (interactions.size() > 0) {
            this.repaint();
        }
    }

    public List<Residue2D> getCurrentResidues() {
        ArrayList<Residue2D> residues = new ArrayList<Residue2D>(this.currentResidues);
        for (StructuralDomain2D s2D : this.currentStructures) {
            residues.addAll(s2D.getResidues());
        }
        for (Interaction2D interaction : this.currentInteractions) {
            residues.addAll(interaction.getResidues());
        }
        Collections.sort(residues);
        return residues;
    }

    public List<StructuralDomain2D> getCurrentStructures() {
        return this.currentStructures;
    }

    public List<Interaction2D> getCurrentInteractions() {
        ArrayList<Interaction2D> interactions = new ArrayList<Interaction2D>(this.currentInteractions);
        for (StructuralDomain2D s2D : this.currentStructures) {
            if (!Helix2D.class.isInstance(s2D)) continue;
            interactions.addAll(((Helix2D)s2D).getSecondaryInteractions());
        }
        return interactions;
    }

    State getState() {
        return this.state;
    }

    public double getViewX() {
        return this.gc.getViewX();
    }

    public double getViewY() {
        return this.gc.getViewY();
    }

    public double getFinalZoomLevel() {
        return this.gc.getFinalZoomLevel();
    }

    Point2D getGravityPoint() {
        return this.gc.getGravityPoint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String label;
        if (this.model != null) {
            this.state.mouseClicked(e);
        }
        if (e.getClickCount() == 2 && this.currentStructures.size() > 0 && (label = JOptionPane.showInputDialog(this, "Set Label", this.currentStructures.iterator().next().getLabel())) != null && label.length() > 0) {
            this.currentStructures.iterator().next().setLabel(label);
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.model != null) {
            this.state.mousePressed(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.model != null) {
            this.state.mouseReleased(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.model != null) {
            this.state.mouseDragged(e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.model != null) {
            this.state.mouseMoved(e);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int notches = e.getWheelRotation();
        Point2D.Double zoomCenter = new Point2D.Double((double)e.getX() * this.getFinalZoomLevel() + this.getViewX(), (double)e.getY() * this.getFinalZoomLevel() + this.getViewY());
        Point2D.Double newDisplayZoomCenter = null;
        if (notches < 0) {
            this.zoomView(1.5);
        } else {
            this.zoomView(0.6666666666666666);
        }
        newDisplayZoomCenter = new Point2D.Double((double)e.getX() * this.getFinalZoomLevel() + this.getViewX(), (double)e.getY() * this.getFinalZoomLevel() + this.getViewY());
        this.translateView(((Point2D)zoomCenter).getX() - ((Point2D)newDisplayZoomCenter).getX(), ((Point2D)zoomCenter).getY() - ((Point2D)newDisplayZoomCenter).getY());
    }

    void updateGravityPoint() {
        RectangularShape r = null;
        for (Residue2D b : this.getCurrentResidues()) {
            if (!b.isInsideHelix()) continue;
            if (r == null) {
                r = b.getArea().getBounds2D();
                continue;
            }
            ((Rectangle2D)r).add(b.getArea().getBounds2D());
        }
        if (r != null) {
            this.gc.setGravityPoint(new Point2D.Double(r.getCenterX(), r.getCenterY()));
        } else {
            this.gc.setGravityPoint(null);
        }
    }

    void centerView() {
        if (this.model != null) {
            double centerX = 0.0;
            double centerY = 0.0;
            List<Residue2D> residues = this.model.getResidues();
            for (Residue2D r : residues) {
                centerX += r.getCurrentCenterX();
                centerY += r.getCurrentCenterY();
            }
            this.translateView((double)(this.getWidth() / 2) - (centerX /= (double)residues.size()), (double)(this.getHeight() / 2) - (centerY /= (double)residues.size()));
            this.repaint();
        }
    }

    public Residue2D seekResidue2D(Residue r) {
        for (Residue2D r2D : this.model.getResidues()) {
            if (r2D.getAbsolutePosition() != r.getAbsolutePosition() || !r2D.getMoleculeId().equals(r.getMoleculeId())) continue;
            return r2D;
        }
        return null;
    }

    public Rna2DElement seekRna2DNode(ParadiseFeature feature) {
        for (BaseBaseInteraction2D interaction : this.model.getInterMolecularTertiaryInteractions()) {
            if (feature != interaction.getBaseBaseInteractionFeature()) continue;
            return interaction;
        }
        for (Helix2D h : this.model.getInterMolecularHelices()) {
            if (feature == h.getHelixFeature()) {
                return h;
            }
            for (BaseBaseInteraction2D interaction : h.getSecondaryInteractions()) {
                if (feature != interaction.getBaseBaseInteractionFeature()) continue;
                return interaction;
            }
            for (Residue2D r : h.getResidues()) {
                if (r.getResidue2DFeature().getResidues().iterator().next() != feature) continue;
                return r;
            }
        }
        for (Rna2D rna : this.model.getRnas()) {
            for (BaseBaseInteraction2D interaction : rna.getTertiaryInteractions()) {
                if (feature != interaction.getBaseBaseInteractionFeature()) continue;
                return interaction;
            }
            for (Helix2D h : rna.getHelices()) {
                if (feature == h.getHelixFeature()) {
                    return h;
                }
                for (BaseBaseInteraction2D interaction : h.getSecondaryInteractions()) {
                    if (feature != interaction.getBaseBaseInteractionFeature()) continue;
                    return interaction;
                }
                for (Residue2D r : h.getResidues()) {
                    if (r.getResidue2DFeature().getResidues().iterator().next() != feature) continue;
                    return r;
                }
            }
            for (Sstrand2D ss : rna.getStrands()) {
                if (feature == ss.getSingleStrandFeature()) {
                    return ss;
                }
                for (Residue2D r : ss.getResidues()) {
                    if (r.getResidue2DFeature().getResidues().iterator().next() != feature) continue;
                    return r;
                }
            }
        }
        return null;
    }

    public List<Rna2DElement> getSecondaryElementByLabel(String label) {
        ArrayList<Rna2DElement> elements = new ArrayList<Rna2DElement>();
        for (BaseBaseInteraction2D interaction : this.model.getInterMolecularTertiaryInteractions()) {
            if (!label.equals(interaction.getLabel())) continue;
            elements.add(interaction);
        }
        for (Helix2D h : this.model.getInterMolecularHelices()) {
            if (label.equals(h.getLabel())) {
                elements.add(h);
            }
            for (BaseBaseInteraction2D interaction : h.getSecondaryInteractions()) {
                if (!label.equals(interaction.getLabel())) continue;
                elements.add(interaction);
            }
            for (Residue2D r : h.getResidues()) {
                if (!label.equals(r.getLabel())) continue;
                elements.add(r);
            }
        }
        for (Rna2D rna : this.model.getRnas()) {
            for (BaseBaseInteraction2D interaction : rna.getTertiaryInteractions()) {
                if (!label.equals(interaction.getLabel())) continue;
                elements.add(interaction);
            }
            for (Helix2D h : rna.getHelices()) {
                if (label.equals(h.getLabel())) {
                    elements.add(h);
                }
                for (BaseBaseInteraction2D interaction : h.getSecondaryInteractions()) {
                    if (!label.equals(interaction.getLabel())) continue;
                    elements.add(interaction);
                }
                for (Residue2D r : h.getResidues()) {
                    if (!label.equals(r.getLabel())) continue;
                    elements.add(r);
                }
            }
            for (Sstrand2D ss : rna.getStrands()) {
                if (label.equals(ss.getLabel())) {
                    elements.add(ss);
                }
                for (Residue2D r : ss.getResidues()) {
                    if (!label.equals(r.getLabel())) continue;
                    elements.add(r);
                }
            }
        }
        return elements;
    }

    public void setState(State state) {
        this.state = state;
    }

    public String toSVG() {
        StringBuffer svg = new StringBuffer();
        svg.append("<?xml version=\"1.0\"?>\n");
        svg.append("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.0//EN\" \"http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd\">\n");
        svg.append("<svg width=\"");
        svg.append(this.gc.getCurrentWidth());
        svg.append("\" height=\"");
        svg.append(this.gc.getCurrentHeight());
        svg.append("\">\n");
        if (this.model != null) {
            svg.append(this.model.toSVG());
        }
        svg.append("</svg>");
        return svg.toString();
    }

    Interaction2D addCtrlCurrentInteraction(Interaction2D inter) {
        if (this.currentInteractions.contains(inter)) {
            this.removeCurrentInteraction(inter);
            return inter;
        }
        this.addInteraction(inter);
        return null;
    }

    void addShiftCurrentInteraction(Interaction2D inter) {
        if (this.currentInteractions.contains(inter)) {
            return;
        }
        this.addInteraction(inter);
    }

    void addCurrentInteraction(Interaction2D inter) {
        this.clearAllSelections();
        this.addInteraction(inter);
    }

    private void addInteraction(Interaction2D inter) {
        this.currentInteractions.add(inter);
        inter.isSelected(true);
        inter.drawRealSymbol(true);
        inter.isDisplayed(true);
        ArrayList<Residue> selectedResidues = new ArrayList<Residue>();
        selectedResidues.add(inter.getResidue().getResidue2DFeature().getResidues().iterator().next());
        selectedResidues.add(inter.getPartnerResidue().getResidue2DFeature().getResidues().iterator().next());
        this.repaint();
    }

    private void removeCurrentInteraction(Interaction2D inter) {
        inter.isSelected(false);
        this.currentInteractions.remove(inter);
        this.repaint();
    }

    Residue2D addCtrlCurrentResidue(Residue2D residue2D) {
        if (this.currentResidues.contains(residue2D)) {
            this.removeCurrentResidue(residue2D);
            return residue2D;
        }
        this.addResidue(residue2D);
        return null;
    }

    void addShiftCurrentResidue(Residue2D residue2D) {
        if (this.currentResidues.contains(residue2D)) {
            return;
        }
        this.addResidue(residue2D);
    }

    void addCurrentResidue(Residue2D residue) {
        this.clearAllSelections();
        this.addResidue(residue);
    }

    private void addResidue(Residue2D residue) {
        this.currentResidues.add(residue);
        residue.isSelected(true);
        residue.isDisplayed(true);
        ArrayList<Residue> selectedResidues = new ArrayList<Residue>();
        selectedResidues.add(residue.getResidue2DFeature().getResidues().iterator().next());
        this.repaint();
    }

    private void removeCurrentResidue(Residue2D base) {
        base.isSelected(false);
        this.currentResidues.remove(base);
        this.repaint();
    }

    void addCurrentStructure(StructuralDomain2D structure) {
        this.clearAllSelections();
        this.addStructure(structure);
    }

    StructuralDomain2D addCtrlCurrentStructure(StructuralDomain2D structure) {
        if (this.currentStructures.contains(structure)) {
            this.removeCurrentStructure(structure);
            return structure;
        }
        this.addStructure(structure);
        return null;
    }

    void addShiftCurrentStructure(StructuralDomain2D structure) {
        if (this.currentStructures.contains(structure)) {
            return;
        }
        this.addStructure(structure);
    }

    private void addStructure(StructuralDomain2D structure) {
        structure.isSelected(true);
        structure.isDisplayed(true);
        this.currentStructures.add(structure);
        ArrayList<Residue> selectedResidues = new ArrayList<Residue>();
        for (Residue2D r : structure.getResidues()) {
            selectedResidues.add(r.getResidue2DFeature().getResidues().iterator().next());
        }
        this.repaint();
    }

    public void removeCurrentStructure(StructuralDomain2D structure) {
        structure.isSelected(false);
        this.currentStructures.remove(structure);
        this.repaint();
    }

    public void clearAllSelections() {
        for (Residue2D r : this.currentResidues) {
            r.isSelected(false);
        }
        this.currentResidues.clear();
        for (StructuralDomain2D sd : this.currentStructures) {
            sd.isSelected(false);
        }
        this.currentStructures.clear();
        for (Interaction2D i : this.currentInteractions) {
            i.isSelected(false);
        }
        this.currentInteractions.clear();
        this.repaint();
    }

    public void clearTertiaries() {
        Object r = null;
        for (BaseBaseInteraction2D interaction : this.model.getInterMolecularTertiaryInteractions()) {
            interaction.isDisplayed(false);
            interaction.drawRealSymbol(false);
        }
        for (Rna2D rna : this.model.getRnas()) {
            for (BaseBaseInteraction2D interaction : rna.getTertiaryInteractions()) {
                interaction.isDisplayed(false);
                interaction.drawRealSymbol(false);
            }
        }
        this.repaint();
    }

    public void translateView(double transX, double transY) {
        this.gc.moveView(transX, transY);
        this.repaint();
    }

    public void zoomView(double zoomLevel) {
        this.gc.zoomParameters(zoomLevel);
        this.repaint();
    }

    void translateSelection(double transX, double transY) {
        this.updateGravityPoint();
        Residue2D r2 = null;
        for (Residue2D r2 : this.getCurrentResidues()) {
            if (r2.isInsideHelix() || ((Sstrand2D)r2.getStructuralDomain()).isAutomaticCoordinates()) continue;
            r2.translate(transX, transY);
        }
        Iterator<Rna2DElement> sc = this.getCurrentStructures().iterator();
        while (sc.hasNext()) {
            ((StructuralDomain2D)sc.next()).translateEnds(transX, transY);
        }
        this.repaint();
    }

    void rotateSelection(double angle, Point2D centerOfRotation) {
        Iterator<StructuralDomain2D> sc = this.getCurrentStructures().iterator();
        while (sc.hasNext()) {
            sc.next().rotateEnds(centerOfRotation, Math.toRadians(angle));
        }
        this.repaint();
    }

    void flipSelection() {
        this.updateGravityPoint();
        Residue2D r2 = null;
        for (Residue2D r2 : this.getCurrentResidues()) {
            if (r2.isInsideHelix() || ((Sstrand2D)r2.getStructuralDomain()).isAutomaticCoordinates()) continue;
            r2.flip(this.getGravityPoint());
        }
        Iterator<Rna2DElement> sc = this.getCurrentStructures().iterator();
        while (sc.hasNext()) {
            ((StructuralDomain2D)sc.next()).flipEnds(this.getGravityPoint());
        }
        this.repaint();
    }

    public void showAll(boolean show) {
        List<Sstrand2D> sstrands = this.model.getSstrands();
        List<Helix2D> helices = this.model.getHelices();
        Object ss = null;
        Object h = null;
        Iterator<StructuralDomain2D> sc = sstrands.iterator();
        while (sc.hasNext()) {
            sc.next().isDisplayed(show);
        }
        sc = helices.iterator();
        while (sc.hasNext()) {
            ((Helix2D)sc.next()).isDisplayed(show);
        }
        this.repaint();
    }

    void showFamily(boolean show) {
        this.gc.setShowFamily(show);
    }

    public void showPeers() {
        for (Residue2D r : this.getCurrentResidues()) {
            for (Interaction2D inter : r.getInteractions()) {
                if (SingleHBond.class.isInstance(inter) || PhosphodiesterBond2D.class.isInstance(inter)) continue;
                inter.isDisplayed(true);
                inter.getResidue().getStructuralDomain().isDisplayed(true);
                inter.getPartnerResidue().getStructuralDomain().isDisplayed(true);
            }
        }
        this.repaint();
    }

    public BufferedImage getImage() {
        BufferedImage bufferedImage = new BufferedImage(this.getSize().width, this.getSize().height, 13);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.setColor(Color.WHITE);
        g2.fill(new Rectangle(0, 0, this.getSize().width, this.getSize().height));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setBackground(Color.white);
        g2.setFont(this.gc.getFont());
        this.setFont(this.gc.getFont());
        g2.setColor(Color.BLACK);
        if (this.model != null) {
            this.gc.setDrawingArea(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            this.model.draw(g2);
        }
        g2.dispose();
        return bufferedImage;
    }

    public void setSelectionRectangle(Rectangle2D rectangle) {
        this.selectionRectangle = rectangle;
    }

    public void increaseFontSize() {
        this.gc.increaseFontSize();
        this.repaint();
    }

    public void decreaseFontSize() {
        this.gc.decreaseFontSize();
        this.repaint();
    }

    public boolean isLabelsDisplayed() {
        return this.gc.isLabelsDisplayed();
    }

    public void setDisplayLabels(boolean display) {
        this.gc.setDisplayLabels(display);
        this.repaint();
    }

    public void setModel2D(SecondaryStructure ss, SecondaryStructureDisplay ssd) {
        this.gc = new GraphicContext(this);
        this.model = new Model2D(ss, ssd, this.mediator, this.gc);
        this.gc.initialize();
        this.repaint();
    }

    private class ForceDirectedLayout
    extends SwingWorker
    implements ActionListener {
        private ForceDirectedLayout() {
        }

        protected Object doInBackground() throws Exception {
            class MyTimer
            extends Timer {
                public MyTimer(ActionListener actionListener) {
                    super(100, actionListener);
                }
            }
            MyTimer timer = new MyTimer((ActionListener)this);
            timer.start();
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HashSet<Helix2D> helicesToMove = new HashSet<Helix2D>();
            for (Helix2D h : SecondaryCanvas.this.model.getHelices()) {
                double f;
                double len;
                double vy;
                double vx;
                Point2D _c;
                Helix2D _h;
                double dx = 0.0;
                double dy = 0.0;
                Point2D c = h.getCenter();
                for (Residue2D r2D : h.get5PrimeEnds()) {
                    if (r2D.getPreviousResidue() == null || !Helix2D.class.isInstance(r2D.getPreviousResidue().getStructuralDomain())) continue;
                    _h = (Helix2D)r2D.getPreviousResidue().getStructuralDomain();
                    _c = _h.getCenter();
                    vx = _c.getX() - c.getX();
                    len = Math.sqrt(vx * vx + (vy = _c.getY() - c.getY()) * vy);
                    len = len == 0.0 ? 1.0E-4 : len;
                    f = (100.0 - len) / (len * 3.0);
                    dx = f * vx;
                    dy = f * vy;
                    _h.dx += dx;
                    _h.dy += dy;
                    h.dx += -dx;
                    h.dy += -dy;
                }
                for (Residue2D r2D : h.get3PrimeEnds()) {
                    if (r2D.getNextResidue() == null || !Helix2D.class.isInstance(r2D.getNextResidue().getStructuralDomain())) continue;
                    _h = (Helix2D)r2D.getNextResidue().getStructuralDomain();
                    _c = _h.getCenter();
                    vx = _c.getX() - c.getX();
                    len = Math.sqrt(vx * vx + (vy = _c.getY() - c.getY()) * vy);
                    len = len == 0.0 ? 1.0E-4 : len;
                    f = (50.0 - len) / (len * 3.0);
                    dx = f * vx;
                    dy = f * vy;
                    _h.dx += dx;
                    _h.dy += dy;
                    h.dx += -dx;
                    h.dy += -dy;
                }
                dx = 0.0;
                dy = 0.0;
                for (Helix2D _h2 : SecondaryCanvas.this.model.getHelices()) {
                    double vy2;
                    if (h == _h2) continue;
                    Point2D _c2 = _h2.getCenter();
                    double vx2 = c.getX() - _c2.getX();
                    double len2 = vx2 * vx2 + (vy2 = c.getY() - _c2.getY()) * vy2;
                    if (len2 == 0.0) {
                        dx += Math.random();
                        dy += Math.random();
                        continue;
                    }
                    if (!h.getArea().intersects(_h2.getArea().getBounds2D())) continue;
                    dx += vx2 / len2;
                    dy += vy2 / len2;
                }
                double dlen = dx * dx + dy * dy;
                if (dlen > 0.0) {
                    dlen = Math.sqrt(dlen) / 2.0;
                    h.dx += dx / dlen;
                    h.dx *= 2.0;
                    h.dy += dy / dlen;
                    h.dy *= 2.0;
                }
                if (!(h.isSelected() || h.dx == 0.0 && h.dy == 0.0)) {
                    helicesToMove.add(h);
                }
                if (!h.isSelected()) continue;
                h.dx = 0.0;
                h.dy = 0.0;
            }
            boolean repaint = false;
            for (Helix2D h : helicesToMove) {
                double transX = Math.max(-20.0, Math.min(20.0, h.dx));
                double transY = Math.max(-20.0, Math.min(20.0, h.dy));
                transX *= 10.0;
                transX = Math.floor(transX + 0.5);
                transY *= 10.0;
                transY = Math.floor(transY + 0.5);
                if ((transX /= 10.0) == 0.0 || (transY /= 10.0) == 0.0) continue;
                h.translateEnds(transX, transY);
                h.dx /= 2.0;
                h.dy /= 2.0;
                repaint = true;
            }
            if (repaint) {
                SecondaryCanvas.this.repaint();
            }
        }
    }
}

