/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.tertiaryviewers;

import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.s2s.Mediator;
import fr.unistra.ibmc.s2s.SelectionListener;
import fr.unistra.ibmc.s2s.tertiaryviewers.OnHangApplicationDriver;
import fr.unistra.ibmc.s2s.tertiaryviewers.TertiaryViewerDriver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTertiaryViewerDriver
extends OnHangApplicationDriver
implements TertiaryViewerDriver {
    protected Map<Molecule, Location> molecules;
    protected List<TertiaryStructure> tertiaryStructuresDisplayed;
    protected Mediator mediator;
    private List<SelectionListener> selectionListeners;
    protected int currentState;
    protected List<Residue> previousResidues;

    public AbstractTertiaryViewerDriver(Mediator mediator, String tertiaryViewerCommand) {
        super(tertiaryViewerCommand);
        this.mediator = mediator;
        this.molecules = new HashMap<Molecule, Location>();
        this.tertiaryStructuresDisplayed = new ArrayList<TertiaryStructure>();
        this.previousResidues = new ArrayList<Residue>();
    }

    @Override
    public void addSelectionListener(SelectionListener l) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList<SelectionListener>();
        }
        this.selectionListeners.add(l);
    }

    @Override
    public List<TertiaryStructure> getTertiaryStructuresDisplayed() {
        return new ArrayList<TertiaryStructure>(this.tertiaryStructuresDisplayed);
    }

    @Override
    public void addTertiaryStructureDisplayed(TertiaryStructure ts) {
        this.tertiaryStructuresDisplayed.add(ts);
    }

    @Override
    public void setCurrentState(int state) {
        this.currentState = state;
    }

    @Override
    public void close() {
        this.process.destroy();
    }

    protected void addResidue(Residue r) {
        Location location = this.molecules.get(r.getMolecule());
        if (location == null) {
            location = new Location();
        }
        this.molecules.put(r.getMolecule(), location.unionOf(new Location(r.getAbsolutePosition())));
    }

    @Override
    public void residuesSelected(Collection<Residue> residues, boolean isShiftDown) {
        if (!isShiftDown) {
            this.previousResidues.clear();
        }
        this.previousResidues.addAll(residues);
        switch (this.currentState) {
            case 0: {
                this.select(this.previousResidues);
                break;
            }
            case 2: {
                this.zoomSelection(this.previousResidues);
                break;
            }
            case 4: {
                this.hideSelection(this.previousResidues);
                break;
            }
            case 1: {
                this.centerSelection(this.previousResidues);
                break;
            }
            case 3: {
                this.showSelection(this.previousResidues);
            }
        }
    }

    @Override
    public void structuralDomainSelected(StructuralDomain structuralDomain, boolean isShiftDown) {
        this.residuesSelected(structuralDomain.getResidues().getResidues(), isShiftDown);
    }

    @Override
    public void interactionSelected(BaseBaseInteraction interaction, boolean isShiftDown) {
        this.residuesSelected(Arrays.asList(interaction.getResidue(), interaction.getPartnerResidue()), isShiftDown);
    }
}

