/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.s2s.tertiaryviewers;

import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.s2s.Mediator;
import fr.unistra.ibmc.s2s.S2SConfig;
import fr.unistra.ibmc.s2s.tertiaryviewers.AbstractTertiaryViewerDriver;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyMOLDriver
extends AbstractTertiaryViewerDriver {
    public PyMOLDriver(Mediator mediator) {
        super(mediator, S2SConfig.getPyMOLPath());
        this.run(new String[]{"-px"}, null, null);
    }

    @Override
    public void select(Collection<Residue> residues) {
        Iterator<Residue> it = residues.iterator();
        if (it.hasNext()) {
            Residue r = residues.iterator().next();
            ArrayList<TertiaryStructure> selectedTS = new ArrayList<TertiaryStructure>();
            for (TertiaryStructure ts : this.tertiaryStructuresDisplayed) {
                if (!ts.annotates(r.getMolecule())) continue;
                selectedTS.add(ts);
            }
            StringBuffer command = new StringBuffer();
            for (Residue residue : residues) {
                this.addResidue(residue);
            }
            for (Map.Entry entry : this.molecules.entrySet()) {
                int[] ends;
                String moleculeLabel = "?";
                for (TertiaryStructure ts : this.tertiaryStructuresDisplayed) {
                    if (!ts.annotates((Molecule)entry.getKey())) continue;
                    moleculeLabel = ts.getMoleculeLabel((Molecule)entry.getKey());
                    break;
                }
                if ((ends = ((Location)entry.getValue()).getBoundaries()).length < 2) continue;
                for (int i = 0; i < ends.length; i += 2) {
                    if (command.length() != 0) {
                        command.append(" or ");
                    }
                    command.append("resi ");
                    command.append(ends[i] + "-" + ends[i + 1]);
                    command.append(" and chain " + moleculeLabel);
                }
                this.evaluate(new StringBuffer("select s2s, ").append(command).toString());
            }
            this.molecules.clear();
        }
    }

    @Override
    public void showSelection(Collection<Residue> residues) {
        this.select(residues);
        this.evaluate("show lines, (s2s)");
    }

    @Override
    public void hideSelection(Collection<Residue> residues) {
        this.select(residues);
        this.evaluate("hide (s2s)");
    }

    @Override
    public void zoomSelection(Collection<Residue> residues) {
        this.select(residues);
        this.evaluate("show lines, (s2s)");
        this.evaluate("zoom (s2s)");
    }

    @Override
    public void centerSelection(Collection<Residue> residues) {
        this.select(residues);
        this.evaluate("show lines, (s2s)");
        this.evaluate("center (s2s)");
    }

    @Override
    public void clearDisplay() {
        this.evaluate("delete all");
    }

    @Override
    public void loadTertiaryStructure(File f) {
        this.evaluate("load " + f.getAbsolutePath());
    }
}

